/*
 * Decompiled with CFR 0.152.
 */
package structures;

import helpers.CombatHeuristics;
import io.CombatControl;
import io.CombatState;
import java.awt.geom.Point2D;
import objects.Saucer;
import objects.Ship;
import objects.TargetObject;
import structures.TargetInformation;
import utils.Utils;

public class TargetConfiguration {
    public Ship ship;
    public TargetObject object = null;
    public TargetInformation info = new TargetInformation();
    public TargetInformation preCalc = new TargetInformation();
    public int angleIndex = 0;
    public int turnTime = 0;
    public int preWaitTime = 0;
    public int postWaitTime = 0;
    public int shootTime = 0;
    public int collisionTime = Integer.MAX_VALUE;
    public boolean isValid = true;
    public boolean isDifficult = false;
    public double prioritization = 1.0;

    public void preCalculate(int time, CombatState state, CombatControl control, boolean calcAngleDif) {
        double realDist;
        double moveX = this.ship.getMovementX();
        double moveY = this.ship.getMovementY();
        if (!state.isMovementPhase()) {
            if (control.isAccelerating()) {
                moveX = Math.floor(this.ship.getSpeedX() + Utils.TABLES.astCos(this.ship.getAngleIndex()) / 128.0) / 8.0;
                moveY = Math.floor(this.ship.getSpeedY() + Utils.TABLES.astSin(this.ship.getAngleIndex()) / 128.0) / 8.0;
            } else {
                double vX = this.ship.getSpeedX();
                double vY = this.ship.getSpeedY();
                if (vX > 0.0) {
                    vX = Math.max(0.0, vX - Math.floor(vX) / 128.0 - 0.00390625);
                } else if (vX < 0.0) {
                    vX = Math.min(0.0, vX - Math.floor(vX) / 128.0);
                }
                if (vY > 0.0) {
                    vY = Math.max(0.0, vY - Math.floor(vY) / 128.0 - 0.00390625);
                } else if (vY < 0.0) {
                    vY = Math.min(0.0, vY - Math.floor(vY) / 128.0);
                }
                moveX = Math.floor(vX) / 8.0;
                moveY = Math.floor(vY) / 8.0;
            }
        }
        Point2D.Double shotOffset = Utils.TABLES.getShotOffset(this.angleIndex);
        int shipX = this.ship.getPosX() + (int)Math.round(moveX * (double)time);
        int shipY = this.ship.getPosY() + (int)Math.round(moveY * (double)time);
        int objectX = this.object.getPosX() + (int)Math.round(this.object.getMovementX() * (double)time);
        int objectY = this.object.getPosY() + (int)Math.round(this.object.getMovementY() * (double)time);
        this.preCalc.difX = Utils.getXDif(shipX + (int)shotOffset.x, objectX);
        this.preCalc.difY = Utils.getYDif(shipY + (int)shotOffset.y, objectY);
        this.preCalc.distance = Utils.TABLES.dist(this.preCalc.difX, this.preCalc.difY);
        this.preCalc.angle = Utils.TABLES.atan2(this.preCalc.difY, this.preCalc.difX);
        if (calcAngleDif) {
            int index = this.ship.getAngleIndex();
            if (control.isTurningLeft()) {
                index = Utils.incByteAngle(index);
            } else if (control.isTurningRight()) {
                index = Utils.decByteAngle(index);
            }
            this.preCalc.angleDif = Utils.getAngleDif(Utils.TABLES.getAngle(index), this.preCalc.angle);
        }
        this.isValid = (realDist = Utils.TABLES.dist(Utils.getXDif(shipX, objectX), Utils.getYDif(shipY, objectY))) > (double)(this.ship.getRadius() + this.object.getRadius() + 2) && this.preCalc.distance < Utils.TABLES.getShotSpeed(this.angleIndex) * 68.0;
    }

    public void calculate(Ship ship, TargetObject object) {
        this.ship = ship;
        this.object = object;
        this.turnTime = 0;
        this.preWaitTime = 0;
        this.postWaitTime = 0;
        this.shootTime = 0;
        this.collisionTime = Integer.MAX_VALUE;
        this.isDifficult = false;
        this.isValid = true;
        this.info.setInfo(ship, object);
    }

    public void reCalculate() {
        this.info.setInfo(this.ship, this.object);
    }

    public void setConfig(TargetConfiguration other) {
        this.ship = other.ship;
        this.object = other.object;
        this.turnTime = other.turnTime;
        this.preWaitTime = other.preWaitTime;
        this.postWaitTime = other.postWaitTime;
        this.shootTime = other.shootTime;
        this.collisionTime = other.collisionTime;
        this.isDifficult = other.isDifficult;
        this.isValid = other.isValid;
        this.prioritization = other.prioritization;
        this.info.setInfo(other.info);
    }

    public void passTime(int time) {
        if (this.preWaitTime > 0) {
            this.preWaitTime = Math.max(0, this.preWaitTime - time);
        }
        this.collisionTime = Math.max(0, this.collisionTime - time);
    }

    public boolean isReadyToFire(CombatState state) {
        boolean saucerCamp = CombatHeuristics.isSaucerCampingReasonable(state, this);
        if (saucerCamp) {
            return this.object instanceof Saucer && Math.max(this.getWaitTime(), this.turnTime) < 2 && this.object.getID() > -1;
        }
        return Math.max(this.getWaitTime(), this.turnTime) < 2 && this.object.getID() > -1;
    }

    public boolean isBetterThan(double otherRating) {
        if (Math.max(this.getWaitTime(), this.turnTime) + 2 < this.collisionTime) {
            return this.getRating() < otherRating;
        }
        return false;
    }

    public boolean isWorseThan(int otherRating) {
        if (Math.max(this.getWaitTime(), this.turnTime) + 2 < this.collisionTime) {
            return this.getRating() > (double)otherRating;
        }
        return true;
    }

    public double getRating() {
        return (double)(Math.max(0, Math.max(this.preWaitTime, this.turnTime) - this.ship.getTimeToNextTorpedo()) + this.shootTime) * this.prioritization;
    }

    public int getWaitTime() {
        return this.preWaitTime + this.postWaitTime;
    }

    public int getFinalTimeTaken() {
        return Math.max(this.ship.getTimeToNextTorpedo(), Math.max(this.getWaitTime(), this.turnTime)) + this.shootTime;
    }

    public int getTimeTaken() {
        return Math.max(this.getWaitTime(), this.turnTime) + this.shootTime;
    }
}

