package gui;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;

import javax.swing.JFrame;
import javax.swing.JPanel;

public class MainFrame extends JFrame {
	
	private static final long serialVersionUID = 1L;

	public MainFrame(String iconPath, String title, JPanel content) {
		// Parent constructor
		super();
		// Set icon
		Image img = Toolkit.getDefaultToolkit().getImage(getClass().getResource(iconPath));
		setIconImage(img);		
		// Set title
		setTitle(title);
		// Set content
		setContentPane(content);		
		// Set default close operation
		setDefaultCloseOperation(EXIT_ON_CLOSE);
		// Semi-Static layout
		setResizable(false);
	}

	public void centerOnScreen()
	{
		Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
		setLocation((screen.width - getWidth()) / 2, (screen.height - getHeight()) / 2);
	}
}