package helpers;

import gui.CombatEventPanel;

import java.awt.Toolkit;
import java.util.LinkedList;

import javax.swing.ImageIcon;

public class CombatMessages {
	
	public static final String[] MESSAGES = {
		"The sector has been cleaned",
		"Spotted a new group of asteroids",
		"Flying saucer in sight",
		"Opening fire on enemy",
		"Taking enemy fire",
		"Flying saucer destroyed",
		"Lost contact to ship",
		"Replacement ship arrived",
		"Engaging asteroids",
		"Performed emergency jump"
	};
	
	public static final ImageIcon[] IMAGES = new ImageIcon[10];

	public static final int SECTOR_CLEAN = 0;
	
	public static final int SECTOR_NEW = 1;
	
	public static final int SAUCER_DETECT = 2;
	
	public static final int SAUCER_FIRE = 3;
	
	public static final int SAUCER_TAKE_FIRE = 4;
	
	public static final int SAUCER_DESTROYED = 5;
	
	public static final int SHIP_LOST = 6;
	
	public static final int SHIP_NEW = 7;
	
	public static final int ASTEROIDS = 8;
	
	public static final int EMERGENCY = 9;
	
	private static int LAST_MESSAGE = -1;
	
	private static CombatEventPanel GUI_OUT = null;
	
	private static LinkedList<String> log = new LinkedList<String>();
	
	public static void setGUIOutput(CombatEventPanel guiOut)
	{
		GUI_OUT = guiOut;
		IMAGES[SECTOR_CLEAN] = new ImageIcon(Toolkit.getDefaultToolkit().getImage(guiOut.getClass().getResource("/img/SECTOR_CLEAN.gif")));
		IMAGES[SECTOR_NEW] = new ImageIcon(Toolkit.getDefaultToolkit().getImage(guiOut.getClass().getResource("/img/SECTOR_NEW.gif")));
		IMAGES[SAUCER_DETECT] = new ImageIcon(Toolkit.getDefaultToolkit().getImage(guiOut.getClass().getResource("/img/SAUCER_DETECT.gif")));
		IMAGES[SAUCER_FIRE] = new ImageIcon(Toolkit.getDefaultToolkit().getImage(guiOut.getClass().getResource("/img/SAUCER_FIRE.gif")));
		IMAGES[SAUCER_TAKE_FIRE] = new ImageIcon(Toolkit.getDefaultToolkit().getImage(guiOut.getClass().getResource("/img/SAUCER_TAKE_FIRE.gif")));
		IMAGES[SAUCER_DESTROYED] = new ImageIcon(Toolkit.getDefaultToolkit().getImage(guiOut.getClass().getResource("/img/SAUCER_DESTROYED.gif")));
		IMAGES[SHIP_LOST] = new ImageIcon(Toolkit.getDefaultToolkit().getImage(guiOut.getClass().getResource("/img/SHIP_LOST.gif")));
		IMAGES[SHIP_NEW] = new ImageIcon(Toolkit.getDefaultToolkit().getImage(guiOut.getClass().getResource("/img/SHIP_NEW.gif")));
		IMAGES[ASTEROIDS] = new ImageIcon(Toolkit.getDefaultToolkit().getImage(guiOut.getClass().getResource("/img/ASTEROIDS.gif")));
		IMAGES[EMERGENCY] = new ImageIcon(Toolkit.getDefaultToolkit().getImage(guiOut.getClass().getResource("/img/EMERGENCY.gif")));
	}
	
	public static void reset()
	{
		log.clear();
	}
	
	public static void verbose(int msg)
	{
		if(msg != LAST_MESSAGE)
		{
			if(GUI_OUT == null)
			{
				System.out.println(CombatStatistics.TIME+": " + MESSAGES[msg]);
			} else {
				GUI_OUT.updateCombatEventList(CombatStatistics.TIME, msg);
			}
			LAST_MESSAGE = msg;
		}
	}
}
