package objects;

public class PreShot implements Shootable {

	protected int triggerTime = 0;
	
	protected boolean isAlive;
	
	public PreShot(int triggerTime)	{
		this.triggerTime = triggerTime;
		isAlive = true;
	}
	
	public PreShot(int triggerTime, boolean alive) {
		this.triggerTime = triggerTime;
		isAlive = alive;
	}
	
	public void destroy() {
		isAlive = false;
		triggerTime = 0;
	}
	
	public boolean isAlive() {
		return isAlive;
	}

	public int getTimeToDestination() {
		return triggerTime;
	}

	public void setTimeToDestination(int time) {
		triggerTime = time;	
	}	
}
