package objects;

import utils.Utils;

public class Saucer extends TargetObject {
	
	public Saucer(int x, int y, int scale) {
		super(x, y);
		this.scale = scale;
		switch(scale)
		{
		case 15:
			width = 40;
			height = 24;
			break;
		case 14:
			width = 20;
			height = 12;
			break;
		}
		if(x < Utils.COMBAT_FIELD_CENTER_X)
		{
			moveX = 2.0;
		} else {
			moveX = -2.0;
		}
		moveY = 0;
		movePrecision = 0;
		isMovementPrecise = true;
	}
	
	public void reMatch(int newX, int newY, int frameDif)
	{		
		onMissed(null);
		if(newY > posY + 1)
		{
			moveY = 2.0;
		} else if(newY < posY - 1) {
			moveY = -2.0;
		} else {
			moveY = 0.0;
		}
		pos0X = newX;
		pos0Y = newY;
		posX = newX;
		posY = newY;
		movePrecision = 0;
		isMovementPrecise = true;
	}
	
	public String toString()
	{
		String result = "Saucer #%d {%d, %d / %.3f, %.3f / %d, %b}";
		return String.format(result, id, posX, posY, moveX, moveY, scale, numTargeted);
	}
	
	public int getMaximumSpeed()
	{
		return 2;
	}
}
