package utils;

import java.awt.Rectangle;

import objects.CombatObject;

public class Utils
{	
	public static final int COMBAT_FIELD_OFFSET_Y = 128; 
	
	public static final int COMBAT_FIELD_WIDTH = 1024; 
	
	public static final int COMBAT_FIELD_HEIGHT = 768; 
	
	public static final int COMBAT_FIELD_CENTER_X = 512;
	
	public static final int COMBAT_FIELD_CENTER_Y = 384;
	
	public static final double POS_INACCURACY = 7.0 / 16.0;
	
	public static final double PHOTON_TORPEDO_SPEED =  7.875;
	
	public static final int PHOTON_TORPEDO_MIN_ALIVE_TIME = 68;
	
	public static final int VICINITY_RANGE = 50;
	
	public static final int SHIP_SPAWN_X = 524;
	
	public static final int SHIP_SPAWN_Y = 524;
	
	public static final double SHIP_MAX_SPEED = 7 + 7 / 8.0;
	
	public static final double SHIP_ACCELERATION = 1 / 8.0;
	
	public static final double SHIP_DECELERATION = 255 / 256.0;
	
	public static final int EVASION_MIN_TIME = 60;
	
	public static final double EVASION_MIN_ANGLE_ASTEROID =  Math.PI / 2.2;
	
	public static final double EVASION_OPTIMUM_ANGLE_SHOT =  Math.PI / 2;
	
	public static final double EVASION_MAX_DEVIATION_SHOT =  Math.PI / 3;
	
	public static final int MIN_BYTE_TURN = 3;	
	
	public static final int MAX_MOVE_PRECISION = 8;
	
	public static final int MAX_TURN_ANGLES = 256;
	
	public static final double AVERAGE_TURN_ANGLE = 2 * Math.PI / MAX_TURN_ANGLES * MIN_BYTE_TURN;
	
	public static final int MAX_SIMULTANEOUS_SHOTS = 4;
	
	public static final int MAX_SAUCER_CAMP_TIME = 60;
	
	public static final int TIME_LIMIT = 18000;
	
	public static final int EXPLOSION_DELAY = 37;
	
	public static final int HYPERSPACE_DELAY = 47;
	
	public static final Tables TABLES = new Tables();
	
	public static void init()
	{
		// Just call to force table construction
	}
	
	public static int willCollideWithin(CombatObject object1, CombatObject object2, int maxTime)
	{
		int difX = getXDif(object1.getPosX(), object2.getPosX());
		int difY = getYDif(object1.getPosY(), object2.getPosY());
		boolean xCollision = false;
		boolean yCollision = false;
		if(difX < 0)
		{
			difX += (object1.getWidth() + object2.getWidth()) / 2;
			if(difX >= 0)
			{
				xCollision = true;
			}
		} else {
			difX -= (object1.getWidth() + object2.getWidth()) / 2;
			if(difX <= 0)
			{
				xCollision = true;
			}
		}
		if(difY < 0)
		{
			difY += (object1.getHeight() + object2.getHeight()) / 2;
			if(difY >= 0)
			{
				yCollision = true;
			}
		} else {
			difY -= (object1.getHeight() + object2.getHeight()) / 2;
			if(difY <= 0)
			{
				yCollision = true;
			}
		}	
		if(xCollision && yCollision)
		{
			return 0;
		} else {
			double difMoveX = object2.getMovementX() - object1.getMovementX();
			double difMoveY = object2.getMovementY() - object1.getMovementY();
			boolean signMatchX = (difX >= 0 && difMoveX <= 0) || (difX <= 0 && difMoveX >= 0);
			boolean signMatchY = (difY >= 0 && difMoveY <= 0) || (difY <= 0 && difMoveY >= 0);			
			if(signMatchX && signMatchY
				&& Math.abs(difMoveX * maxTime) > Math.abs(difX)
				&& Math.abs(difMoveY * maxTime) > Math.abs(difY))
			{
				int iX = 0;
				if(difMoveX != 0)
				{
					iX = (int)Math.floor(Math.abs(difX / difMoveX));
				}
				int iY = 0;
				if(difMoveY != 0)
				{
					iY = (int)Math.floor(Math.abs(difY / difMoveY));
				}
				int i = Math.min(iX, iY);
				for(; i < maxTime; i++)
				{
					if(willCollideIn(object1, object2, i))
					{
						return i;
					}
				}
			}
		}
		return Integer.MAX_VALUE;
	}
	
	public static boolean willCollideIn(CombatObject object1, CombatObject object2, int time)
	{
		Rectangle rect1 = object1.getBounds();
		Rectangle rect2 = object2.getBounds();
		double moveX = time * object1.getMovementX();
		double moveY = time * object1.getMovementY();
		if(moveX < 0) {
			moveX = Math.floor(moveX);
		} else {
			moveX = Math.ceil(moveX);
		}
		if(moveY < 0) {
			moveY = Math.floor(moveY);
		} else {
			moveY = Math.ceil(moveY);
		}
		rect1.translate((int)moveX, (int)moveY);
		moveX = time * object2.getMovementX();
		moveY = time * object2.getMovementY();
		if(moveX < 0) {
			moveX = Math.floor(moveX);
		} else {
			moveX = Math.ceil(moveX);
		}
		if(moveY < 0) {
			moveY = Math.floor(moveY);
		} else {
			moveY = Math.ceil(moveY);
		}		
		rect2.translate((int)moveX, (int)moveY);
		Rectangle result = rect1.intersection(rect2);
		switch(object2.getScale())
		{
		case CombatObject.LARGE_SCALE: return result.width + result.height > 13;
		case CombatObject.MEDIUM_SCALE: return result.width + result.height > 7;
		case CombatObject.SMALL_SCALE: return result.width + result.height > 4;
		default: return !result.isEmpty();
		}
	}
	
	public static int decByteAngle(int angle)
	{
		angle -= MIN_BYTE_TURN;
		if(angle < 0)
		{
			angle += MAX_TURN_ANGLES;
		}
		return angle;
	}
	
	public static int incByteAngle(int angle)
	{
		angle += MIN_BYTE_TURN;
		if(angle >= MAX_TURN_ANGLES)
		{
			angle -= MAX_TURN_ANGLES;
		}
		return angle;
	}
	
	public static double getCounterAngle(double angle)
	{
		double counterAngle = angle + Math.PI;
		if(counterAngle > 2 * Math.PI)
		{
			counterAngle -= 2 * Math.PI;
		}
		return counterAngle;
	}
	
	public static int getAngleIndexDif(int angle1, int angle2)
	{
		int angleIndexDif = angle2 - angle1;
		if(angleIndexDif < -MAX_TURN_ANGLES / 2)
		{
			angleIndexDif += MAX_TURN_ANGLES;
		} else if(angleIndexDif > MAX_TURN_ANGLES / 2)
		{
			angleIndexDif -= MAX_TURN_ANGLES;
		}	
		return angleIndexDif;
	}
	
	public static double getAngleDif(double angle1, double angle2)
	{
		double angleDif = angle2 - angle1;
		if(angleDif < -Math.PI)
		{
			angleDif += 2 * Math.PI;
		} else if(angleDif > Math.PI)
		{
			angleDif -= 2 * Math.PI;
		}	
		return angleDif;
	}
	
	public static boolean isAngleReachedCCW(double curAngle, double targetAngle)
	{
		return (curAngle > targetAngle) 
		|| (curAngle < 0 && targetAngle > 0);
	}
	
	public static boolean isAngleReachedCW(double curAngle, double targetAngle)
	{
		return (curAngle < targetAngle) 
		|| (curAngle > 0 && targetAngle < 0);
	}
	
	public static double getXDist(double x1, double x2)
	{
		double xDist = x2 - x1;
		while(xDist > COMBAT_FIELD_CENTER_X)
		{
			xDist -= COMBAT_FIELD_WIDTH;
		}
		while(xDist < -COMBAT_FIELD_CENTER_X) {
			xDist += COMBAT_FIELD_WIDTH;
		}
		return Math.abs(xDist);
	}
	
	public static double getYDist(double y1, double y2)
	{
		double yDist = y2 - y1;
		while(yDist > COMBAT_FIELD_CENTER_Y)
		{
			yDist -= COMBAT_FIELD_HEIGHT;
		}
		while(yDist < -COMBAT_FIELD_CENTER_Y) {
			yDist += COMBAT_FIELD_HEIGHT;
		}
		return Math.abs(yDist);
	}
	
	public static int getXDif(int x1, int x2)
	{
		int xDif = x2 - x1;
		while(xDif > COMBAT_FIELD_CENTER_X)
		{
			xDif -= COMBAT_FIELD_WIDTH;
		}
		while(xDif < -COMBAT_FIELD_CENTER_X) {
			xDif += COMBAT_FIELD_WIDTH;
		}
		return xDif;
	}
	
	public static int getYDif(int y1, int y2)
	{
		int yDif = y2 - y1;
		while(yDif > COMBAT_FIELD_CENTER_Y)
		{
			yDif -= COMBAT_FIELD_HEIGHT;
		}
		while(yDif < -COMBAT_FIELD_CENTER_Y) {
			yDif += COMBAT_FIELD_HEIGHT;
		}
		return yDif;
	}
	
	public static double getDistSquare(double x1, double y1, double x2, double y2)
	{
		double xDist = Math.abs(x2 - x1);
		double yDist = Math.abs(y2 - y1);
		while(xDist > COMBAT_FIELD_WIDTH / 2)
		{
			xDist = COMBAT_FIELD_WIDTH - xDist;
		}
		while(yDist > COMBAT_FIELD_HEIGHT / 2)
		{
			yDist = COMBAT_FIELD_HEIGHT - yDist;
		}
		return xDist * xDist + yDist * yDist;
	}
}
