#include <stdio.h>
#include "connection.h"
#include "game.h"
#include "player.h"




int main(int argc, const char* argv[])
{
	if(argc != 2)
	{
		printf("Asteroid 127.0.0.1");
		return 0;
	}
	
	printf("\n    _        _                 _     _ ____                     _ ");
	printf("\n   / \\   ___| |_ ___ _ __ ___ (_) __| / ___| _ __ ___  __ _ ___| |__   ___ _ _");
	printf("\n  / _ \\ / __| __/ _ \\ '__/ _ \\| |/ _` \\___ \\| '_ ` _ \\/ _` / __| '_ \\ / _ \\ '_|");
	printf("\n / ___ \\\\__ \\ ||  __/ | | (_) | | (_| |___) | | | | || (_| \\__ \\ | | |  __/ |");
	printf("\n/_/   \\_\\___/\\__\\___|_|  \\___/|_|\\__,_|____/|_| |_| |_\\__,_|___/_| |_|\\___|_|");
	    
	printf("\nAuthor: Eduard Heidt (edu.h@gmx.de)");
	printf("\n\n");

	const char* ip = argv[1];
 
 	try
	{  
	
		for(int i = 0;; i++)
		{
			Connection con(ip);
			Player player;
			Game game(con, player);
	
			try
			{
			  game.Run();
			}
			catch (...)
			{}
		   
			game.End();
			
			Sleep(2000);
		}
   	}
	catch (connection_error &ce)
	{
	  fprintf(stderr,"\n");
	  fprintf(stderr,ce.what());
	}
	   

   return 0;
}
