/*****************************************************************************************
 
	A S T E R O I D S

******************************************************************************************
	
	This is an exact Java port of the arcade game Asteroids, which was originally
	written by Ed Logg of Atari in 1979.

	The Java version was created by translating the Asteroids program code,
	originally written for the 6502 CPU of the Asteroids machine, to Java.
	This translation was made by a static binary recompilation program, which generates
	corresponding Java program code for each 6502 instruction and applies some
	optimization techniques to the generated program (e.g., removal of redundant
	flag calculations).

	Norbert Kehrer        http://web.utanet.at/nkehrer/

	Austria, September 2005.


******************************************************************************************

	Credits:
	The coin dropping sound is from Peter Hirschberg's Vector Dream emulator.

	Restrictions:
	This software may not be used for any commercial purposes and may not
	be placed on any commercial web site.
	If you improve, port, or modify this program, please refer to me in your version
	and let me know of your efforts. You will find my email address on my 
	website http://web.utanet.at/nkehrer/. 
	If you place the applet on your (non-commercial) web site, please mention
	me as the author and provide a link to my site http://web.utanet.at/nkehrer/.

******************************************************************************************/

static int mem6800[] = {
	0x4c, 0xf3, 0x7c, 0x20, 0xfa, 0x6e, 0x20, 0xd8, 0x6e, 0x20, 0x68, 0x71, 0xad, 0x7, 0x20, 0x30, 
	0xfe, 0x46, 0x5b, 0x90, 0xf7, 0xad, 0x2, 0x20, 0x30, 0xfb, 0xad, 0x1, 0x40, 0x49, 0x2, 0x8d, 
	0x1, 0x40, 0x8d, 0x0, 0x30, 0x8d, 0x0, 0x34, 0xe6, 0x5c, 0xd0, 0x2, 0xe6, 0x5d, 0xa2, 0x40, 
	0x29, 0x2, 0xd0, 0x2, 0xa2, 0x44, 0xa9, 0x2, 0x85, 0x2, 0x86, 0x3, 0x20, 0x85, 0x68, 0xb0, 
	0xc2, 0x20, 0x5c, 0x76, 0x20, 0x90, 0x6d, 0x10, 0x1b, 0x20, 0xc4, 0x73, 0xb0, 0x16, 0xa5, 0x5a, 
	0xd0, 0xc, 0x20, 0xd7, 0x6c, 0x20, 0x74, 0x6e, 0x20, 0x3f, 0x70, 0x20, 0x93, 0x6b, 0x20, 0x57, 
	0x6f, 0x20, 0xf0, 0x69, 0x20, 0x4f, 0x72, 0x20, 0x55, 0x75, 0xa9, 0x7f, 0xaa, 0x20, 0x3, 0x7c, 
	0x20, 0xb5, 0x77, 0x20, 0xc0, 0x7b, 0xad, 0xfb, 0x2, 0xf0, 0x3, 0xce, 0xfb, 0x2, 0xd, 0xf6, 
	0x2, 0xd0, 0x89, 0xf0, 0x84, 0xa5, 0x1c, 0xf0, 0x14, 0xa5, 0x5a, 0xd0, 0x3, 0x4c, 0x60, 0x69, 
	0xc6, 0x5a, 0x20, 0xe2, 0x69, 0x18, 0x60, 0xa9, 0x2, 0x85, 0x70, 0xd0, 0x13, 0xa5, 0x71, 0x29, 
	0x3, 0xf0, 0xf4, 0x18, 0x69, 0x7, 0xa8, 0xa5, 0x32, 0x25, 0x33, 0x10, 0x3, 0x20, 0xf6, 0x77, 
	0xa4, 0x70, 0xf0, 0xe1, 0xa2, 0x1, 0xad, 0x3, 0x24, 0x30, 0x23, 0xc0, 0x2, 0x90, 0x7c, 0xad, 
	0x4, 0x24, 0x10, 0x77, 0xa5, 0x6f, 0x9, 0x4, 0x85, 0x6f, 0x8d, 0x0, 0x32, 0x20, 0xd8, 0x6e, 
	0x20, 0x68, 0x71, 0x20, 0xe8, 0x71, 0xa5, 0x56, 0x85, 0x58, 0xa2, 0x2, 0xc6, 0x70, 0x86, 0x1c, 
	0xc6, 0x70, 0xa5, 0x6f, 0x29, 0xf8, 0x45, 0x1c, 0x85, 0x6f, 0x8d, 0x0, 0x32, 0x20, 0xe8, 0x71, 
	0xa9, 0x1, 0x8d, 0xfa, 0x2, 0x8d, 0xfa, 0x3, 0xa9, 0x92, 0x8d, 0xf8, 0x2, 0x8d, 0xf8, 0x3, 
	0x8d, 0xf7, 0x3, 0x8d, 0xf7, 0x2, 0xa9, 0x7f, 0x8d, 0xfb, 0x2, 0x8d, 0xfb, 0x3, 0xa9, 0x5, 
	0x8d, 0xfd, 0x2, 0x8d, 0xfd, 0x3, 0xa9, 0xff, 0x85, 0x32, 0x85, 0x33, 0xa9, 0x80, 0x85, 0x5a, 
	0xa, 0x85, 0x18, 0x85, 0x19, 0xa5, 0x56, 0x85, 0x57, 0xa9, 0x4, 0x85, 0x6c, 0x85, 0x6e, 0xa9, 
	0x30, 0x8d, 0xfc, 0x2, 0x8d, 0xfc, 0x3, 0x8d, 0x0, 0x3e, 0x60, 0xa5, 0x32, 0x25, 0x32, 0x10, 
	0xb, 0xa5, 0x5c, 0x29, 0x20, 0xd0, 0x5, 0xa0, 0x6, 0x20, 0xf6, 0x77, 0xa5, 0x5c, 0x29, 0xf, 
	0xd0, 0xc, 0xa9, 0x1, 0xc5, 0x70, 0x69, 0x1, 0x49, 0x1, 0x45, 0x6f, 0x85, 0x6f, 0x18, 0x60, 
	0xa5, 0x5c, 0x29, 0x3f, 0xd0, 0xa, 0xad, 0xfc, 0x2, 0xc9, 0x8, 0xf0, 0x3, 0xce, 0xfc, 0x2, 
	0xa6, 0x18, 0xb5, 0x57, 0xd0, 0x1c, 0xad, 0x1f, 0x2, 0xd, 0x20, 0x2, 0xd, 0x21, 0x2, 0xd, 
	0x22, 0x2, 0xd0, 0xe, 0xa0, 0x7, 0x20, 0xf6, 0x77, 0xa5, 0x1c, 0xc9, 0x2, 0x90, 0x3, 0x20, 
	0xe2, 0x69, 0xad, 0x1b, 0x2, 0xd0, 0x36, 0xad, 0xfa, 0x2, 0xc9, 0x80, 0xd0, 0x2f, 0xa9, 0x10, 
	0x8d, 0xfa, 0x2, 0xa6, 0x1c, 0xa5, 0x57, 0x5, 0x58, 0xf0, 0x24, 0x20, 0x2d, 0x70, 0xca, 0xf0, 
	0x1c, 0xa9, 0x80, 0x85, 0x5a, 0xa5, 0x18, 0x49, 0x1, 0xaa, 0xb5, 0x57, 0xf0, 0xf, 0x86, 0x18, 
	0xa9, 0x4, 0x45, 0x6f, 0x85, 0x6f, 0x8d, 0x0, 0x32, 0x8a, 0xa, 0x85, 0x19, 0x18, 0x60, 0x86, 
	0x1a, 0xa9, 0xff, 0x85, 0x1c, 0x20, 0xfa, 0x6e, 0xa5, 0x6f, 0x29, 0xf8, 0x9, 0x3, 0x85, 0x6f, 
	0x18, 0x60, 0xa0, 0x1, 0x20, 0xf6, 0x77, 0xa4, 0x18, 0xc8, 0x98, 0x20, 0xd1, 0x7b, 0x60, 0x71, 
	0xa2, 0x7, 0xbd, 0x1b, 0x2, 0xf0, 0x2, 0x10, 0x4, 0xca, 0x10, 0xf6, 0x60, 0xa0, 0x1c, 0xe0, 
	0x4, 0xb0, 0x7, 0x88, 0x8a, 0xd0, 0x3, 0x88, 0x30, 0xef, 0xb9, 0x0, 0x2, 0xf0, 0xf8, 0x30, 
	0xf6, 0x85, 0xb, 0xb9, 0xaf, 0x2, 0x38, 0xfd, 0xca, 0x2, 0x85, 0x8, 0xb9, 0x69, 0x2, 0xfd, 
	0x84, 0x2, 0x4a, 0x66, 0x8, 0xa, 0xf0, 0xc, 0x10, 0x6d, 0x49, 0xfe, 0xd0, 0x69, 0xa5, 0x8, 
	0x49, 0xff, 0x85, 0x8, 0xb9, 0xd2, 0x2, 0x38, 0xfd, 0xed, 0x2, 0x85, 0x9, 0xb9, 0x8c, 0x2, 
	0xfd, 0xa7, 0x2, 0x4a, 0x66, 0x9, 0xa, 0xf0, 0xc, 0x10, 0x4c, 0x49, 0xfe, 0xd0, 0x48, 0xa5, 
	0x9, 0x49, 0xff, 0x85, 0x9, 0xa9, 0x2a, 0x46, 0xb, 0xb0, 0x8, 0xa9, 0x48, 0x46, 0xb, 0xb0, 
	0x2, 0xa9, 0x84, 0xe0, 0x1, 0xb0, 0x2, 0x69, 0x1c, 0xd0, 0xc, 0x69, 0x12, 0xae, 0x1c, 0x2, 
	0xca, 0xf0, 0x2, 0x69, 0x12, 0xa2, 0x1, 0xc5, 0x8, 0x90, 0x1c, 0xc5, 0x9, 0x90, 0x18, 0x85, 
	0xb, 0x4a, 0x18, 0x65, 0xb, 0x85, 0xb, 0xa5, 0x9, 0x65, 0x8, 0xb0, 0xa, 0xc5, 0xb, 0xb0, 
	0x6, 0x20, 0xf, 0x6b, 0x4c, 0xf9, 0x69, 0x88, 0x30, 0xfa, 0x4c, 0xa, 0x6a, 0xb9, 0x0, 0x2, 
	0x29, 0x7, 0x85, 0x8, 0x20, 0xb5, 0x77, 0x29, 0x18, 0x5, 0x8, 0x9d, 0x0, 0x2, 0xb9, 0xaf, 
	0x2, 0x9d, 0xaf, 0x2, 0xb9, 0x69, 0x2, 0x9d, 0x69, 0x2, 0xb9, 0xd2, 0x2, 0x9d, 0xd2, 0x2, 
	0xb9, 0x8c, 0x2, 0x9d, 0x8c, 0x2, 0xb9, 0x23, 0x2, 0x9d, 0x23, 0x2, 0xb9, 0x46, 0x2, 0x9d, 
	0x46, 0x2, 0x60, 0x85, 0xb, 0x86, 0xc, 0xa0, 0x0, 0xc8, 0xb1, 0xb, 0x45, 0x9, 0x91, 0x2, 
	0x88, 0xc9, 0xf0, 0xb0, 0x1e, 0xc9, 0xa0, 0xb0, 0x16, 0xb1, 0xb, 0x91, 0x2, 0xc8, 0xc8, 0xb1, 
	0xb, 0x91, 0x2, 0xc8, 0xb1, 0xb, 0x45, 0x8, 0x65, 0x17, 0x91, 0x2, 0xc8, 0xd0, 0xda, 0x88, 
	0x4c, 0x39, 0x7c, 0xb1, 0xb, 0x45, 0x8, 0x18, 0x65, 0x17, 0x91, 0x2, 0xc8, 0xd0, 0xed, 0xe0, 
	0x1, 0xd0, 0x8, 0xc0, 0x1b, 0xd0, 0x12, 0xa2, 0x0, 0xa0, 0x1c, 0x8a, 0xd0, 0x1e, 0xa9, 0x81, 
	0x8d, 0xfa, 0x2, 0xa6, 0x18, 0xd6, 0x57, 0xa2, 0x0, 0xa9, 0xa0, 0x9d, 0x1b, 0x2, 0xa9, 0x0, 
	0x9d, 0x3e, 0x2, 0x9d, 0x61, 0x2, 0xc0, 0x1b, 0x90, 0xd, 0xb0, 0x37, 0xa9, 0x0, 0x9d, 0x1b, 
	0x2, 0xc0, 0x1b, 0xf0, 0x21, 0xb0, 0x2c, 0x20, 0xec, 0x75, 0xb9, 0x0, 0x2, 0x29, 0x3, 0x49, 
	0x2, 0x4a, 0x6a, 0x6a, 0x9, 0x3f, 0x85, 0x69, 0xa9, 0xa0, 0x99, 0x0, 0x2, 0xa9, 0x0, 0x99, 
	0x23, 0x2, 0x99, 0x46, 0x2, 0x60, 0x8a, 0xa6, 0x18, 0xd6, 0x57, 0xaa, 0xa9, 0x81, 0x8d, 0xfa, 
	0x2, 0xd0, 0xd7, 0xad, 0xf8, 0x2, 0x8d, 0xf7, 0x2, 0xa5, 0x1c, 0xf0, 0xcd, 0x86, 0xd, 0xa6, 
	0x19, 0xad, 0x1c, 0x2, 0x4a, 0xa9, 0x99, 0xb0, 0x2, 0xa9, 0x20, 0x20, 0x97, 0x73, 0xa6, 0xd, 
	0x4c, 0x4a, 0x6b, 0xa5, 0x5c, 0x29, 0x3, 0xf0, 0x1, 0x60, 0xad, 0x1c, 0x2, 0x30, 0xfa, 0xf0, 
	0x3, 0x4c, 0x34, 0x6c, 0xa5, 0x1c, 0xf0, 0x7, 0xad, 0x1b, 0x2, 0xf0, 0xec, 0x30, 0xea, 0xad, 
	0xf9, 0x2, 0xf0, 0x3, 0xce, 0xf9, 0x2, 0xce, 0xf7, 0x2, 0xd0, 0xdd, 0xa9, 0x12, 0x8d, 0xf7, 
	0x2, 0xad, 0xf9, 0x2, 0xf0, 0xa, 0xad, 0xf6, 0x2, 0xf0, 0xce, 0xcd, 0xfd, 0x2, 0xb0, 0xc9, 
	0xad, 0xf8, 0x2, 0x38, 0xe9, 0x6, 0xc9, 0x20, 0x90, 0x3, 0x8d, 0xf8, 0x2, 0xa9, 0x0, 0x8d, 
	0xcb, 0x2, 0x8d, 0x85, 0x2, 0x20, 0xb5, 0x77, 0x4a, 0x6e, 0xee, 0x2, 0x4a, 0x6e, 0xee, 0x2, 
	0x4a, 0x6e, 0xee, 0x2, 0xc9, 0x18, 0x90, 0x2, 0x29, 0x17, 0x8d, 0xa8, 0x2, 0xa2, 0x10, 0x24, 
	0x60, 0x70, 0xc, 0xa9, 0x1f, 0x8d, 0x85, 0x2, 0xa9, 0xff, 0x8d, 0xcb, 0x2, 0xa2, 0xf0, 0x8e, 
	0x3f, 0x2, 0xa2, 0x2, 0xad, 0xf8, 0x2, 0x30, 0x17, 0xa4, 0x19, 0xb9, 0x53, 0x0, 0xc9, 0x30, 
	0xb0, 0xd, 0x20, 0xb5, 0x77, 0x85, 0x8, 0xad, 0xf8, 0x2, 0x4a, 0xc5, 0x8, 0xb0, 0x1, 0xca, 
	0x8e, 0x1c, 0x2, 0x60, 0xa5, 0x5c, 0xa, 0xd0, 0xc, 0x20, 0xb5, 0x77, 0x29, 0x3, 0xaa, 0xbd, 
	0xd3, 0x6c, 0x8d, 0x62, 0x2, 0xa5, 0x1c, 0xf0, 0x5, 0xad, 0xfa, 0x2, 0xd0, 0x5, 0xce, 0xf7, 
	0x2, 0xf0, 0x1, 0x60, 0xa9, 0xa, 0x8d, 0xf7, 0x2, 0xad, 0x1c, 0x2, 0x4a, 0xf0, 0x6, 0x20, 
	0xb5, 0x77, 0x4c, 0xc4, 0x6c, 0xad, 0x3f, 0x2, 0xc9, 0x80, 0x6a, 0x85, 0xc, 0xad, 0xca, 0x2, 
	0x38, 0xed, 0xcb, 0x2, 0x85, 0xb, 0xad, 0x84, 0x2, 0xed, 0x85, 0x2, 0x6, 0xb, 0x2a, 0x6, 
	0xb, 0x2a, 0x38, 0xe5, 0xc, 0xaa, 0xad, 0x62, 0x2, 0xc9, 0x80, 0x6a, 0x85, 0xc, 0xad, 0xed, 
	0x2, 0x38, 0xed, 0xee, 0x2, 0x85, 0xb, 0xad, 0xa7, 0x2, 0xed, 0xa8, 0x2, 0x6, 0xb, 0x2a, 
	0x6, 0xb, 0x2a, 0x38, 0xe5, 0xc, 0xa8, 0x20, 0xf0, 0x76, 0x85, 0x62, 0x20, 0xb5, 0x77, 0xa6, 
	0x19, 0xb4, 0x53, 0xc0, 0x35, 0xa2, 0x0, 0x90, 0x1, 0xe8, 0x3d, 0xcf, 0x6c, 0x10, 0x3, 0x1d, 
	0xd1, 0x6c, 0x65, 0x62, 0x85, 0x62, 0xa0, 0x3, 0xa2, 0x1, 0x86, 0xe, 0x4c, 0xf2, 0x6c, 0x8f, 
	0x87, 0x70, 0x78, 0xf0, 0x0, 0x0, 0x10, 0xa5, 0x1c, 0xf0, 0x21, 0xe, 0x4, 0x20, 0x66, 0x63, 
	0x24, 0x63, 0x10, 0x18, 0x70, 0x16, 0xad, 0xfa, 0x2, 0xd0, 0x11, 0xaa, 0xa9, 0x3, 0x85, 0xe, 
	0xa0, 0x7, 0xb9, 0x1b, 0x2, 0xf0, 0x6, 0x88, 0xc4, 0xe, 0xd0, 0xf6, 0x60, 0x86, 0xd, 0xa9, 
	0x12, 0x99, 0x1b, 0x2, 0xb5, 0x61, 0x20, 0xd2, 0x77, 0xa6, 0xd, 0xc9, 0x80, 0x6a, 0x85, 0x9, 
	0x18, 0x7d, 0x3e, 0x2, 0x30, 0x8, 0xc9, 0x70, 0x90, 0xa, 0xa9, 0x6f, 0xd0, 0x6, 0xc9, 0x91, 
	0xb0, 0x2, 0xa9, 0x91, 0x99, 0x3e, 0x2, 0xb5, 0x61, 0x20, 0xd5, 0x77, 0xa6, 0xd, 0xc9, 0x80, 
	0x6a, 0x85, 0xc, 0x18, 0x7d, 0x61, 0x2, 0x30, 0x8, 0xc9, 0x70, 0x90, 0xa, 0xa9, 0x6f, 0xd0, 
	0x6, 0xc9, 0x91, 0xb0, 0x2, 0xa9, 0x91, 0x99, 0x61, 0x2, 0xa2, 0x0, 0xa5, 0x9, 0x10, 0x1, 
	0xca, 0x86, 0x8, 0xa6, 0xd, 0xc9, 0x80, 0x6a, 0x18, 0x65, 0x9, 0x18, 0x7d, 0xca, 0x2, 0x99, 
	0xca, 0x2, 0xa5, 0x8, 0x7d, 0x84, 0x2, 0x99, 0x84, 0x2, 0xa2, 0x0, 0xa5, 0xc, 0x10, 0x1, 
	0xca, 0x86, 0xb, 0xa6, 0xd, 0xc9, 0x80, 0x6a, 0x18, 0x65, 0xc, 0x18, 0x7d, 0xed, 0x2, 0x99, 
	0xed, 0x2, 0xa5, 0xb, 0x7d, 0xa7, 0x2, 0x99, 0xa7, 0x2, 0xa9, 0x80, 0x95, 0x66, 0x60, 0xd8, 
	0xa5, 0x32, 0x25, 0x33, 0x10, 0x1, 0x60, 0xa5, 0x1a, 0x4a, 0xf0, 0x18, 0xa0, 0x1, 0x20, 0xf6, 
	0x77, 0xa0, 0x2, 0xa6, 0x33, 0x10, 0x1, 0x88, 0x84, 0x18, 0xa5, 0x5c, 0x29, 0x10, 0xd0, 0x4, 
	0x98, 0x20, 0xd1, 0x7b, 0x46, 0x18, 0x20, 0xb2, 0x73, 0xa0, 0x2, 0x20, 0xf6, 0x77, 0xa0, 0x3, 
	0x20, 0xf6, 0x77, 0xa0, 0x4, 0x20, 0xf6, 0x77, 0xa0, 0x5, 0x20, 0xf6, 0x77, 0xa9, 0x20, 0x85, 
	0x0, 0xa9, 0x64, 0xa2, 0x39, 0x20, 0x3, 0x7c, 0xa9, 0x70, 0x20, 0xde, 0x7c, 0xa6, 0x18, 0xb4, 
	0x32, 0x84, 0xb, 0x98, 0x18, 0x65, 0x31, 0x85, 0xc, 0x20, 0x1a, 0x6f, 0xa4, 0xb, 0xc8, 0x20, 
	0x1a, 0x6f, 0xa4, 0xb, 0xc8, 0xc8, 0x20, 0x1a, 0x6f, 0xad, 0x3, 0x20, 0x2a, 0x26, 0x63, 0xa5, 
	0x63, 0x29, 0x1f, 0xc9, 0x7, 0xd0, 0x27, 0xe6, 0x31, 0xa5, 0x31, 0xc9, 0x3, 0x90, 0x13, 0xa6, 
	0x18, 0xa9, 0xff, 0x95, 0x32, 0xa2, 0x0, 0x86, 0x18, 0x86, 0x31, 0xa2, 0xf0, 0x86, 0x5d, 0x4c, 
	0xb2, 0x73, 0xe6, 0xc, 0xa6, 0xc, 0xa9, 0xf4, 0x85, 0x5d, 0xa9, 0xb, 0x95, 0x34, 0xa5, 0x5d, 
	0xd0, 0x8, 0xa9, 0xff, 0x85, 0x32, 0x85, 0x33, 0x30, 0xdb, 0xa5, 0x5c, 0x29, 0x7, 0xd0, 0x31, 
	0xad, 0x7, 0x24, 0x10, 0x4, 0xa9, 0x1, 0xd0, 0x7, 0xad, 0x6, 0x24, 0x10, 0x23, 0xa9, 0xff, 
	0xa6, 0xc, 0x18, 0x75, 0x34, 0x30, 0x10, 0xc9, 0xb, 0xb0, 0xe, 0xc9, 0x1, 0xf0, 0x4, 0xa9, 
	0x0, 0xf0, 0xc, 0xa9, 0xb, 0xd0, 0x8, 0xa9, 0x24, 0xc9, 0x25, 0x90, 0x2, 0xa9, 0x0, 0x95, 
	0x34, 0xa9, 0x0, 0x60, 0xa5, 0x1c, 0xf0, 0x5f, 0xad, 0x1b, 0x2, 0x30, 0x5a, 0xad, 0xfa, 0x2, 
	0xd0, 0x55, 0xad, 0x3, 0x20, 0x10, 0x50, 0xa9, 0x0, 0x8d, 0x1b, 0x2, 0x8d, 0x3e, 0x2, 0x8d, 
	0x61, 0x2, 0xa9, 0x30, 0x8d, 0xfa, 0x2, 0x20, 0xb5, 0x77, 0x29, 0x1f, 0xc9, 0x1d, 0x90, 0x2, 
	0xa9, 0x1c, 0xc9, 0x3, 0xb0, 0x2, 0xa9, 0x3, 0x8d, 0x84, 0x2, 0xa2, 0x5, 0x20, 0xb5, 0x77, 
	0xca, 0xd0, 0xfa, 0x29, 0x1f, 0xe8, 0xc9, 0x18, 0x90, 0xc, 0x29, 0x7, 0xa, 0x69, 0x4, 0xcd, 
	0xf6, 0x2, 0x90, 0x2, 0xa2, 0x80, 0xc9, 0x15, 0x90, 0x2, 0xa9, 0x14, 0xc9, 0x3, 0xb0, 0x2, 
	0xa9, 0x3, 0x8d, 0xa7, 0x2, 0x86, 0x59, 0x60, 0xa9, 0x2, 0x8d, 0xf5, 0x2, 0xa2, 0x3, 0x4e, 
	0x2, 0x28, 0xb0, 0x1, 0xe8, 0x86, 0x56, 0xa9, 0x0, 0xa2, 0x4, 0x9d, 0x1b, 0x2, 0x9d, 0x1f, 
	0x2, 0x95, 0x51, 0xca, 0x10, 0xf5, 0x8d, 0xf6, 0x2, 0x60, 0xa9, 0x0, 0x8d, 0x0, 0x36, 0x8d, 
	0x0, 0x3a, 0x8d, 0x0, 0x3c, 0x8d, 0x1, 0x3c, 0x8d, 0x3, 0x3c, 0x8d, 0x4, 0x3c, 0x8d, 0x5, 
	0x3c, 0x85, 0x69, 0x85, 0x66, 0x85, 0x67, 0x85, 0x68, 0x60, 0xb9, 0x34, 0x0, 0xa, 0xa8, 0xd0, 
	0x14, 0xa5, 0x32, 0x25, 0x33, 0x30, 0xe, 0xa9, 0x72, 0xa2, 0xf8, 0x20, 0x45, 0x7d, 0xa9, 0x1, 
	0xa2, 0xf8, 0x4c, 0x45, 0x7d, 0xbe, 0xd5, 0x56, 0xb9, 0xd4, 0x56, 0x4c, 0x45, 0x7d, 0xf0, 0x16, 
	0x84, 0x8, 0xa2, 0xd5, 0xa0, 0xe0, 0x84, 0x0, 0x20, 0x3, 0x7c, 0xa2, 0xda, 0xa9, 0x54, 0x20, 
	0xfc, 0x7b, 0xc6, 0x8, 0xd0, 0xf5, 0x60, 0xa2, 0x22, 0xbd, 0x0, 0x2, 0xd0, 0x4, 0xca, 0x10, 
	0xf8, 0x60, 0x10, 0x63, 0x20, 0x8, 0x77, 0x4a, 0x4a, 0x4a, 0x4a, 0xe0, 0x1b, 0xd0, 0x7, 0xa5, 
	0x5c, 0x29, 0x1, 0x4a, 0xf0, 0x1, 0x38, 0x7d, 0x0, 0x2, 0x30, 0x25, 0xe0, 0x1b, 0xf0, 0x13, 
	0xb0, 0x17, 0xce, 0xf6, 0x2, 0xd0, 0x5, 0xa0, 0x7f, 0x8c, 0xfb, 0x2, 0xa9, 0x0, 0x9d, 0x0, 
	0x2, 0xf0, 0xcb, 0x20, 0xe8, 0x71, 0x4c, 0x8c, 0x6f, 0xad, 0xf8, 0x2, 0x8d, 0xf7, 0x2, 0xd0, 
	0xeb, 0x9d, 0x0, 0x2, 0x29, 0xf0, 0x18, 0x69, 0x10, 0xe0, 0x1b, 0xd0, 0x2, 0xa9, 0x0, 0xa8, 
	0xbd, 0xaf, 0x2, 0x85, 0x4, 0xbd, 0x69, 0x2, 0x85, 0x5, 0xbd, 0xd2, 0x2, 0x85, 0x6, 0xbd, 
	0x8c, 0x2, 0x85, 0x7, 0x4c, 0x27, 0x70, 0x18, 0xa0, 0x0, 0xbd, 0x23, 0x2, 0x10, 0x1, 0x88, 
	0x7d, 0xaf, 0x2, 0x9d, 0xaf, 0x2, 0x85, 0x4, 0x98, 0x7d, 0x69, 0x2, 0xc9, 0x20, 0x90, 0xc, 
	0x29, 0x1f, 0xe0, 0x1c, 0xd0, 0x6, 0x20, 0x2d, 0x70, 0x4c, 0x5e, 0x6f, 0x9d, 0x69, 0x2, 0x85, 
	0x5, 0x18, 0xa0, 0x0, 0xbd, 0x46, 0x2, 0x10, 0x2, 0xa0, 0xff, 0x7d, 0xd2, 0x2, 0x9d, 0xd2, 
	0x2, 0x85, 0x6, 0x98, 0x7d, 0x8c, 0x2, 0xc9, 0x18, 0x90, 0x8, 0xf0, 0x4, 0xa9, 0x17, 0xd0, 
	0x2, 0xa9, 0x0, 0x9d, 0x8c, 0x2, 0x85, 0x7, 0xbd, 0x0, 0x2, 0xa0, 0xe0, 0x4a, 0xb0, 0x7, 
	0xa0, 0xf0, 0x4a, 0xb0, 0x2, 0xa0, 0x0, 0x20, 0xfe, 0x72, 0x4c, 0x5e, 0x6f, 0xad, 0xf8, 0x2, 
	0x8d, 0xf7, 0x2, 0xa9, 0x0, 0x8d, 0x1c, 0x2, 0x8d, 0x3f, 0x2, 0x8d, 0x62, 0x2, 0x60, 0xa5, 
	0x1c, 0xf0, 0x42, 0xad, 0x1b, 0x2, 0x30, 0x3d, 0xad, 0xfa, 0x2, 0xf0, 0x39, 0xce, 0xfa, 0x2, 
	0xd0, 0x33, 0xa4, 0x59, 0x30, 0x19, 0xd0, 0x10, 0x20, 0x39, 0x71, 0xd0, 0x24, 0xac, 0x1c, 0x2, 
	0xf0, 0x6, 0xa0, 0x2, 0x8c, 0xfa, 0x2, 0x60, 0xa9, 0x1, 0x8d, 0x1b, 0x2, 0xd0, 0x12, 0xa9, 
	0xa0, 0x8d, 0x1b, 0x2, 0xa2, 0x3e, 0x86, 0x69, 0xa6, 0x18, 0xd6, 0x57, 0xa9, 0x81, 0x8d, 0xfa, 
	0x2, 0xa9, 0x0, 0x85, 0x59, 0x60, 0xad, 0x7, 0x24, 0x10, 0x4, 0xa9, 0x3, 0xd0, 0x7, 0xad, 
	0x6, 0x24, 0x10, 0x7, 0xa9, 0xfd, 0x18, 0x65, 0x61, 0x85, 0x61, 0xa5, 0x5c, 0x4a, 0xb0, 0xe5, 
	0xad, 0x5, 0x24, 0x10, 0x3c, 0xa9, 0x80, 0x8d, 0x3, 0x3c, 0xa0, 0x0, 0xa5, 0x61, 0x20, 0xd2, 
	0x77, 0x10, 0x1, 0x88, 0xa, 0x18, 0x65, 0x64, 0xaa, 0x98, 0x6d, 0x3e, 0x2, 0x20, 0x25, 0x71, 
	0x8d, 0x3e, 0x2, 0x86, 0x64, 0xa0, 0x0, 0xa5, 0x61, 0x20, 0xd5, 0x77, 0x10, 0x1, 0x88, 0xa, 
	0x18, 0x65, 0x65, 0xaa, 0x98, 0x6d, 0x61, 0x2, 0x20, 0x25, 0x71, 0x8d, 0x61, 0x2, 0x86, 0x65, 
	0x60, 0xa9, 0x0, 0x8d, 0x3, 0x3c, 0xad, 0x3e, 0x2, 0x5, 0x64, 0xf0, 0x18, 0xad, 0x3e, 0x2, 
	0xa, 0xa2, 0xff, 0x18, 0x49, 0xff, 0x30, 0x2, 0xe8, 0x38, 0x65, 0x64, 0x85, 0x64, 0x8a, 0x6d, 
	0x3e, 0x2, 0x8d, 0x3e, 0x2, 0xa5, 0x65, 0xd, 0x61, 0x2, 0xf0, 0x18, 0xad, 0x61, 0x2, 0xa, 
	0xa2, 0xff, 0x18, 0x49, 0xff, 0x30, 0x2, 0x38, 0xe8, 0x65, 0x65, 0x85, 0x65, 0x8a, 0x6d, 0x61, 
	0x2, 0x8d, 0x61, 0x2, 0x60, 0x30, 0x9, 0xc9, 0x40, 0x90, 0xd, 0xa2, 0xff, 0xa9, 0x3f, 0x60, 
	0xc9, 0xc0, 0xb0, 0x4, 0xa2, 0x1, 0xa9, 0xc0, 0x60, 0xa2, 0x1c, 0xbd, 0x0, 0x2, 0xf0, 0x1e, 
	0xbd, 0x69, 0x2, 0x38, 0xed, 0x84, 0x2, 0xc9, 0x4, 0x90, 0x4, 0xc9, 0xfc, 0x90, 0xf, 0xbd, 
	0x8c, 0x2, 0x38, 0xed, 0xa7, 0x2, 0xc9, 0x4, 0x90, 0x9, 0xc9, 0xfc, 0xb0, 0x5, 0xca, 0x10, 
	0xda, 0xe8, 0x60, 0xee, 0xfa, 0x2, 0x60, 0x90, 0xa2, 0x1a, 0xad, 0xfb, 0x2, 0xd0, 0x70, 0xad, 
	0x1c, 0x2, 0xd0, 0x73, 0x8d, 0x3f, 0x2, 0x8d, 0x62, 0x2, 0xee, 0xfd, 0x2, 0xad, 0xfd, 0x2, 
	0xc9, 0xb, 0x90, 0x3, 0xce, 0xfd, 0x2, 0xad, 0xf5, 0x2, 0x18, 0x69, 0x2, 0xc9, 0xb, 0x90, 
	0x2, 0xa9, 0xb, 0x8d, 0xf6, 0x2, 0x8d, 0xf5, 0x2, 0x85, 0x8, 0xa0, 0x1c, 0x20, 0xb5, 0x77, 
	0x29, 0x18, 0x9, 0x4, 0x9d, 0x0, 0x2, 0x20, 0x3, 0x72, 0x20, 0xb5, 0x77, 0x4a, 0x29, 0x1f, 
	0x90, 0x13, 0xc9, 0x18, 0x90, 0x2, 0x29, 0x17, 0x9d, 0x8c, 0x2, 0xa9, 0x0, 0x9d, 0x69, 0x2, 
	0x9d, 0xaf, 0x2, 0xf0, 0xb, 0x9d, 0x69, 0x2, 0xa9, 0x0, 0x9d, 0x8c, 0x2, 0x9d, 0xd2, 0x2, 
	0xca, 0xc6, 0x8, 0xd0, 0xc8, 0xa9, 0x7f, 0x8d, 0xf7, 0x2, 0xa9, 0x30, 0x8d, 0xfc, 0x2, 0xa9, 
	0x0, 0x9d, 0x0, 0x2, 0xca, 0x10, 0xfa, 0x60, 0xa9, 0x60, 0x8d, 0xca, 0x2, 0x8d, 0xed, 0x2, 
	0xa9, 0x0, 0x8d, 0x3e, 0x2, 0x8d, 0x61, 0x2, 0xa9, 0x10, 0x8d, 0x84, 0x2, 0xa9, 0xc, 0x8d, 
	0xa7, 0x2, 0x60, 0x20, 0xb5, 0x77, 0x29, 0x8f, 0x10, 0x2, 0x9, 0xf0, 0x18, 0x79, 0x23, 0x2, 
	0x20, 0x33, 0x72, 0x9d, 0x23, 0x2, 0x20, 0xb5, 0x77, 0x20, 0xb5, 0x77, 0x20, 0xb5, 0x77, 0x20, 
	0xb5, 0x77, 0x29, 0x8f, 0x10, 0x2, 0x9, 0xf0, 0x18, 0x79, 0x46, 0x2, 0x20, 0x33, 0x72, 0x9d, 
	0x46, 0x2, 0x60, 0x10, 0xd, 0xc9, 0xe1, 0xb0, 0x2, 0xa9, 0xe1, 0xc9, 0xfb, 0x90, 0xf, 0xa9, 
	0xfa, 0x60, 0xc9, 0x6, 0xb0, 0x2, 0xa9, 0x6, 0xc9, 0x20, 0x90, 0x2, 0xa9, 0x1f, 0x60, 0xa9, 
	0x10, 0x85, 0x0, 0xa9, 0x50, 0xa2, 0xa4, 0x20, 0xfc, 0x7b, 0xa9, 0x19, 0xa2, 0xdb, 0x20, 0x3, 
	0x7c, 0xa9, 0x70, 0x20, 0xde, 0x7c, 0xa2, 0x0, 0xa5, 0x1c, 0xc9, 0x2, 0xd0, 0x18, 0xa5, 0x18, 
	0xd0, 0x14, 0xa2, 0x20, 0xad, 0x1b, 0x2, 0x5, 0x59, 0xd0, 0xb, 0xad, 0xfa, 0x2, 0x30, 0x6, 
	0xa5, 0x5c, 0x29, 0x10, 0xf0, 0xd, 0xa9, 0x52, 0xa0, 0x2, 0x38, 0x20, 0x3f, 0x77, 0xa9, 0x0, 
	0x20, 0x8b, 0x77, 0xa9, 0x28, 0xa4, 0x57, 0x20, 0x3e, 0x6f, 0xa9, 0x0, 0x85, 0x0, 0xa9, 0x78, 
	0xa2, 0xdb, 0x20, 0x3, 0x7c, 0xa9, 0x50, 0x20, 0xde, 0x7c, 0xa9, 0x1d, 0xa0, 0x2, 0x38, 0x20, 
	0x3f, 0x77, 0xa9, 0x0, 0x20, 0xd1, 0x7b, 0xa9, 0x10, 0x85, 0x0, 0xa9, 0xc0, 0xa2, 0xdb, 0x20, 
	0x3, 0x7c, 0xa9, 0x50, 0x20, 0xde, 0x7c, 0xa2, 0x0, 0xa5, 0x1c, 0xc9, 0x1, 0xf0, 0x2e, 0x90, 
	0x18, 0xa5, 0x18, 0xf0, 0x14, 0xa2, 0x20, 0xad, 0x1b, 0x2, 0x5, 0x59, 0xd0, 0xb, 0xad, 0xfa, 
	0x2, 0x30, 0x6, 0xa5, 0x5c, 0x29, 0x10, 0xf0, 0xd, 0xa9, 0x54, 0xa0, 0x2, 0x38, 0x20, 0x3f, 
	0x77, 0xa9, 0x0, 0x20, 0x8b, 0x77, 0xa9, 0xcf, 0xa4, 0x58, 0x4c, 0x3e, 0x6f, 0x60, 0x84, 0x0, 
	0x86, 0xd, 0xa5, 0x5, 0x4a, 0x66, 0x4, 0x4a, 0x66, 0x4, 0x4a, 0x66, 0x4, 0x85, 0x5, 0xa5, 
	0x7, 0x18, 0x69, 0x4, 0x4a, 0x66, 0x6, 0x4a, 0x66, 0x6, 0x4a, 0x66, 0x6, 0x85, 0x7, 0xa2, 
	0x4, 0x20, 0x1c, 0x7c, 0xa9, 0x70, 0x38, 0xe5, 0x0, 0xc9, 0xa0, 0x90, 0xe, 0x48, 0xa9, 0x90, 
	0x20, 0xde, 0x7c, 0x68, 0x38, 0xe9, 0x10, 0xc9, 0xa0, 0xb0, 0xf2, 0x20, 0xde, 0x7c, 0xa6, 0xd, 
	0xbd, 0x0, 0x2, 0x10, 0x16, 0xe0, 0x1b, 0xf0, 0xc, 0x29, 0xc, 0x4a, 0xa8, 0xb9, 0xf8, 0x50, 
	0xbe, 0xf9, 0x50, 0xd0, 0x1b, 0x20, 0x65, 0x74, 0xa6, 0xd, 0x60, 0xe0, 0x1b, 0xf0, 0x17, 0xe0, 
	0x1c, 0xf0, 0x19, 0xb0, 0x1f, 0x29, 0x18, 0x4a, 0x4a, 0xa8, 0xb9, 0xde, 0x51, 0xbe, 0xdf, 0x51, 
	0x20, 0x45, 0x7d, 0xa6, 0xd, 0x60, 0x20, 0xb, 0x75, 0xa6, 0xd, 0x60, 0xad, 0x50, 0x52, 0xae, 
	0x51, 0x52, 0xd0, 0xec, 0xa9, 0x70, 0xa2, 0xf0, 0x20, 0xe0, 0x7c, 0xa6, 0xd, 0xa5, 0x5c, 0x29, 
	0x3, 0xd0, 0x3, 0xde, 0x0, 0x2, 0x60, 0xf8, 0x75, 0x52, 0x95, 0x52, 0x90, 0x12, 0xb5, 0x53, 
	0x69, 0x0, 0x95, 0x53, 0x29, 0xf, 0xd0, 0x8, 0xa9, 0xb0, 0x85, 0x68, 0xa6, 0x18, 0xf6, 0x57, 
	0xd8, 0x60, 0xa5, 0x18, 0xa, 0xa, 0x85, 0x8, 0xa5, 0x6f, 0x29, 0xfb, 0x5, 0x8, 0x85, 0x6f, 
	0x8d, 0x0, 0x32, 0x60, 0xa5, 0x1c, 0xf0, 0x2, 0x18, 0x60, 0xa5, 0x5d, 0x29, 0x4, 0xd0, 0xf8, 
	0xa5, 0x1d, 0x5, 0x1e, 0xf0, 0xf2, 0xa0, 0x0, 0x20, 0xf6, 0x77, 0xa2, 0x0, 0x86, 0x10, 0xa9, 
	0x1, 0x85, 0x0, 0xa9, 0xa7, 0x85, 0xe, 0xa9, 0x10, 0x85, 0x0, 0xb5, 0x1d, 0x15, 0x1e, 0xf0, 
	0x67, 0x86, 0xf, 0xa9, 0x5f, 0xa6, 0xe, 0x20, 0x3, 0x7c, 0xa9, 0x40, 0x20, 0xde, 0x7c, 0xa5, 
	0xf, 0x4a, 0xf8, 0x69, 0x1, 0xd8, 0x85, 0xd, 0xa9, 0xd, 0x38, 0xa0, 0x1, 0xa2, 0x0, 0x20, 
	0x3f, 0x77, 0xa9, 0x40, 0xaa, 0x20, 0xe0, 0x7c, 0xa0, 0x0, 0x20, 0x35, 0x6f, 0xa5, 0xf, 0x18, 
	0x69, 0x1d, 0xa0, 0x2, 0x38, 0xa2, 0x0, 0x20, 0x3f, 0x77, 0xa9, 0x0, 0x20, 0xd1, 0x7b, 0xa0, 
	0x0, 0x20, 0x35, 0x6f, 0xa4, 0x10, 0x20, 0x1a, 0x6f, 0xe6, 0x10, 0xa4, 0x10, 0x20, 0x1a, 0x6f, 
	0xe6, 0x10, 0xa4, 0x10, 0x20, 0x1a, 0x6f, 0xe6, 0x10, 0xa5, 0xe, 0x38, 0xe9, 0x8, 0x85, 0xe, 
	0xa6, 0xf, 0xe8, 0xe8, 0xe0, 0x14, 0x90, 0x93, 0x38, 0x60, 0xa2, 0x1a, 0xbd, 0x0, 0x2, 0xf0, 
	0x3, 0xca, 0x10, 0xf8, 0x60, 0xad, 0x1b, 0x2, 0xc9, 0xa2, 0xb0, 0x22, 0xa2, 0xa, 0xbd, 0xec, 
	0x50, 0x4a, 0x4a, 0x4a, 0x4a, 0x18, 0x69, 0xf8, 0x49, 0xf8, 0x95, 0x7e, 0xbd, 0xed, 0x50, 0x4a, 
	0x4a, 0x4a, 0x4a, 0x18, 0x69, 0xf8, 0x49, 0xf8, 0x95, 0x8a, 0xca, 0xca, 0x10, 0xe0, 0xad, 0x1b, 
	0x2, 0x49, 0xff, 0x29, 0x70, 0x4a, 0x4a, 0x4a, 0xaa, 0x86, 0x9, 0xa0, 0x0, 0xbd, 0xec, 0x50, 
	0x10, 0x1, 0x88, 0x18, 0x75, 0x7d, 0x95, 0x7d, 0x98, 0x75, 0x7e, 0x95, 0x7e, 0x85, 0x4, 0x84, 
	0x5, 0xa0, 0x0, 0xbd, 0xed, 0x50, 0x10, 0x1, 0x88, 0x18, 0x75, 0x89, 0x95, 0x89, 0x98, 0x75, 
	0x8a, 0x95, 0x8a, 0x85, 0x6, 0x84, 0x7, 0xa5, 0x2, 0x85, 0xb, 0xa5, 0x3, 0x85, 0xc, 0x20, 
	0x49, 0x7c, 0xa4, 0x9, 0xb9, 0xe0, 0x50, 0xbe, 0xe1, 0x50, 0x20, 0x45, 0x7d, 0xa4, 0x9, 0xb9, 
	0xe1, 0x50, 0x49, 0x4, 0xaa, 0xb9, 0xe0, 0x50, 0x29, 0xf, 0x49, 0x4, 0x20, 0x45, 0x7d, 0xa0, 
	0xff, 0xc8, 0xb1, 0xb, 0x91, 0x2, 0xc8, 0xb1, 0xb, 0x49, 0x4, 0x91, 0x2, 0xc0, 0x3, 0x90, 
	0xf0, 0x20, 0x39, 0x7c, 0xa6, 0x9, 0xca, 0xca, 0x10, 0x8f, 0x60, 0xa2, 0x0, 0x86, 0x17, 0xa0, 
	0x0, 0xa5, 0x61, 0x10, 0x6, 0xa0, 0x4, 0x8a, 0x38, 0xe5, 0x61, 0x85, 0x8, 0x24, 0x8, 0x30, 
	0x2, 0x50, 0x7, 0xa2, 0x4, 0xa9, 0x80, 0x38, 0xe5, 0x8, 0x86, 0x8, 0x84, 0x9, 0x4a, 0x29, 
	0xfe, 0xa8, 0xb9, 0x6e, 0x52, 0xbe, 0x6f, 0x52, 0x20, 0xd3, 0x6a, 0xad, 0x5, 0x24, 0x10, 0x14, 
	0xa5, 0x5c, 0x29, 0x4, 0xf0, 0xe, 0xc8, 0xc8, 0x38, 0xa6, 0xc, 0x98, 0x65, 0xb, 0x90, 0x1, 
	0xe8, 0x20, 0xd3, 0x6a, 0x60, 0xa5, 0x1c, 0xd0, 0x1, 0x60, 0xa2, 0x0, 0xad, 0x1c, 0x2, 0x30, 
	0xa, 0xf0, 0x8, 0x6a, 0x6a, 0x6a, 0x8d, 0x2, 0x3c, 0xa2, 0x80, 0x8e, 0x0, 0x3c, 0xa2, 0x1, 
	0x20, 0xcd, 0x75, 0x8d, 0x1, 0x3c, 0xca, 0x20, 0xcd, 0x75, 0x8d, 0x4, 0x3c, 0xad, 0x1b, 0x2, 
	0xc9, 0x1, 0xf0, 0x4, 0x8a, 0x8d, 0x3, 0x3c, 0xad, 0xf6, 0x2, 0xf0, 0x11, 0xad, 0x1b, 0x2, 
	0x30, 0xc, 0x5, 0x59, 0xf0, 0x8, 0xa5, 0x6d, 0xf0, 0x14, 0xc6, 0x6d, 0xd0, 0x21, 0xa5, 0x6c, 
	0x29, 0xf, 0x85, 0x6c, 0x8d, 0x0, 0x3a, 0xad, 0xfc, 0x2, 0x85, 0x6e, 0x10, 0x11, 0xc6, 0x6e, 
	0xd0, 0xd, 0xa9, 0x4, 0x85, 0x6d, 0xa5, 0x6c, 0x49, 0x14, 0x85, 0x6c, 0x8d, 0x0, 0x3a, 0xa5, 
	0x69, 0xaa, 0x29, 0x3f, 0xf0, 0x1, 0xca, 0x86, 0x69, 0x8e, 0x0, 0x36, 0x60, 0xb5, 0x6a, 0x30, 
	0xc, 0xb5, 0x66, 0x10, 0x12, 0xa9, 0x10, 0x95, 0x66, 0xa9, 0x80, 0x30, 0xc, 0xb5, 0x66, 0xf0, 
	0x6, 0x30, 0x4, 0xd6, 0x66, 0xd0, 0xf2, 0xa9, 0x0, 0x95, 0x6a, 0x60, 0x86, 0xd, 0xa9, 0x50, 
	0x8d, 0xf9, 0x2, 0xb9, 0x0, 0x2, 0x29, 0x78, 0x85, 0xe, 0xb9, 0x0, 0x2, 0x29, 0x7, 0x4a, 
	0xaa, 0xf0, 0x2, 0x5, 0xe, 0x99, 0x0, 0x2, 0xa5, 0x1c, 0xf0, 0x11, 0xa5, 0xd, 0xf0, 0x4, 
	0xc9, 0x4, 0x90, 0x9, 0xbd, 0x59, 0x76, 0xa6, 0x19, 0x18, 0x20, 0x97, 0x73, 0xbe, 0x0, 0x2, 
	0xf0, 0x34, 0x20, 0x5a, 0x74, 0x30, 0x2f, 0xee, 0xf6, 0x2, 0x20, 0x9d, 0x6a, 0x20, 0x3, 0x72, 
	0xbd, 0x23, 0x2, 0x29, 0x1f, 0xa, 0x5d, 0xaf, 0x2, 0x9d, 0xaf, 0x2, 0x20, 0x5c, 0x74, 0x30, 
	0x15, 0xee, 0xf6, 0x2, 0x20, 0x9d, 0x6a, 0x20, 0x3, 0x72, 0xbd, 0x46, 0x2, 0x29, 0x1f, 0xa, 
	0x5d, 0xd2, 0x2, 0x9d, 0xd2, 0x2, 0xa6, 0xd, 0x60, 0x10, 0x5, 0x2, 0xa5, 0x1c, 0x10, 0x38, 
	0xa2, 0x2, 0x85, 0x5d, 0x85, 0x32, 0x85, 0x33, 0xa0, 0x0, 0xb9, 0x1d, 0x0, 0xd5, 0x52, 0xb9, 
	0x1e, 0x0, 0xf5, 0x53, 0x90, 0x23, 0xc8, 0xc8, 0xc0, 0x14, 0x90, 0xee, 0xca, 0xca, 0x10, 0xe8, 
	0xa5, 0x33, 0x30, 0xe, 0xc5, 0x32, 0x90, 0xa, 0x69, 0x2, 0xc9, 0x1e, 0x90, 0x2, 0xa9, 0xff, 
	0x85, 0x33, 0xa9, 0x0, 0x85, 0x1c, 0x85, 0x31, 0x60, 0x86, 0xb, 0x84, 0xc, 0x8a, 0x4a, 0xaa, 
	0x98, 0x4a, 0x65, 0xc, 0x85, 0xd, 0x95, 0x32, 0xa2, 0x1b, 0xa0, 0x12, 0xe4, 0xd, 0xf0, 0x1f, 
	0xb5, 0x31, 0x95, 0x34, 0xb5, 0x32, 0x95, 0x35, 0xb5, 0x33, 0x95, 0x36, 0xb9, 0x1b, 0x0, 0x99, 
	0x1d, 0x0, 0xb9, 0x1c, 0x0, 0x99, 0x1e, 0x0, 0x88, 0x88, 0xca, 0xca, 0xca, 0xd0, 0xdd, 0xa9, 
	0xb, 0x95, 0x34, 0xa9, 0x0, 0x95, 0x35, 0x95, 0x36, 0xa9, 0xf0, 0x85, 0x5d, 0xa6, 0xb, 0xa4, 
	0xc, 0xb5, 0x53, 0x99, 0x1e, 0x0, 0xb5, 0x52, 0x99, 0x1d, 0x0, 0xa0, 0x0, 0xf0, 0x8d, 0xdf, 
	0x98, 0x10, 0x9, 0x20, 0x8, 0x77, 0x20, 0xfc, 0x76, 0x4c, 0x8, 0x77, 0xa8, 0x8a, 0x10, 0xe, 
	0x20, 0x8, 0x77, 0x20, 0xe, 0x77, 0x49, 0x80, 0x49, 0xff, 0x18, 0x69, 0x1, 0x60, 0x85, 0xc, 
	0x98, 0xc5, 0xc, 0xf0, 0x10, 0x90, 0x11, 0xa4, 0xc, 0x85, 0xc, 0x98, 0x20, 0x28, 0x77, 0x38, 
	0xe9, 0x40, 0x4c, 0x8, 0x77, 0xa9, 0x20, 0x60, 0x20, 0x6c, 0x77, 0xbd, 0x2f, 0x77, 0x60, 0x0, 
	0x2, 0x5, 0x7, 0xa, 0xc, 0xf, 0x11, 0x13, 0x15, 0x17, 0x19, 0x1a, 0x1c, 0x1d, 0x1f, 0x8, 
	0x86, 0x17, 0x88, 0x84, 0x16, 0x18, 0x65, 0x16, 0x85, 0x15, 0x28, 0xaa, 0x8, 0xb5, 0x0, 0x4a, 
	0x4a, 0x4a, 0x4a, 0x28, 0x20, 0x85, 0x77, 0xa5, 0x16, 0xd0, 0x1, 0x18, 0xa6, 0x15, 0xb5, 0x0, 
	0x20, 0x85, 0x77, 0xc6, 0x15, 0xa6, 0x15, 0xc6, 0x16, 0x10, 0xe1, 0x60, 0xa0, 0x0, 0x84, 0xb, 
	0xa0, 0x4, 0x26, 0xb, 0x2a, 0xc5, 0xc, 0x90, 0x2, 0xe5, 0xc, 0x88, 0xd0, 0xf4, 0xa5, 0xb, 
	0x2a, 0x29, 0xf, 0xaa, 0x60, 0x90, 0x4, 0x29, 0xf, 0xf0, 0x27, 0xa6, 0x17, 0xf0, 0x23, 0x29, 
	0xf, 0x18, 0x69, 0x1, 0x8, 0xa, 0xa8, 0xb9, 0xd4, 0x56, 0xa, 0x85, 0xb, 0xb9, 0xd5, 0x56, 
	0x2a, 0x29, 0x1f, 0x9, 0x40, 0x85, 0xc, 0xa9, 0x0, 0x85, 0x8, 0x85, 0x9, 0x20, 0xd7, 0x6a, 
	0x28, 0x60, 0x4c, 0xcb, 0x7b, 0x6, 0x5f, 0x26, 0x60, 0x10, 0x2, 0xe6, 0x5f, 0xa5, 0x5f, 0x2c, 
	0xd1, 0x77, 0xf0, 0x4, 0x49, 0x1, 0x85, 0x5f, 0x5, 0x60, 0xd0, 0x2, 0xe6, 0x5f, 0xa5, 0x5f, 
	0x60, 0x2, 0x18, 0x69, 0x40, 0x10, 0x8, 0x29, 0x7f, 0x20, 0xdf, 0x77, 0x4c, 0x8, 0x77, 0xc9, 
	0x41, 0x90, 0x4, 0x49, 0x7f, 0x69, 0x0, 0xaa, 0xbd, 0xb9, 0x57, 0x60, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xad, 0x3, 0x28, 0x29, 0x3, 0xa, 0xaa, 0xa9, 0x10, 0x85, 
	0x0, 0xbd, 0x88, 0x78, 0x85, 0x9, 0xbd, 0x87, 0x78, 0x85, 0x8, 0x71, 0x8, 0x85, 0x8, 0x90, 
	0x2, 0xe6, 0x9, 0x98, 0xa, 0xa8, 0xb9, 0x71, 0x78, 0xbe, 0x72, 0x78, 0x20, 0x3, 0x7c, 0xa9, 
	0x70, 0x20, 0xde, 0x7c, 0xa0, 0x0, 0xa2, 0x0, 0xa1, 0x8, 0x85, 0xb, 0x4a, 0x4a, 0x20, 0x4d, 
	0x78, 0xa1, 0x8, 0x2a, 0x26, 0xb, 0x2a, 0xa5, 0xb, 0x2a, 0xa, 0x20, 0x53, 0x78, 0xa1, 0x8, 
	0x85, 0xb, 0x20, 0x4d, 0x78, 0x46, 0xb, 0x90, 0xdf, 0x88, 0x4c, 0x39, 0x7c, 0xe6, 0x8, 0xd0, 
	0x2, 0xe6, 0x9, 0x29, 0x3e, 0xd0, 0x4, 0x68, 0x68, 0xd0, 0xee, 0xc9, 0xa, 0x90, 0x2, 0x69, 
	0xd, 0xaa, 0xbd, 0xd2, 0x56, 0x91, 0x2, 0xc8, 0xbd, 0xd3, 0x56, 0x91, 0x2, 0xc8, 0xa2, 0x0, 
	0x60, 0x64, 0xb6, 0x64, 0xb6, 0xc, 0xaa, 0xc, 0xa2, 0xc, 0x9a, 0xc, 0x92, 0x64, 0xc6, 0x64, 
	0x9d, 0x50, 0x39, 0x50, 0x39, 0x50, 0x39, 0x1e, 0x57, 0x8f, 0x78, 0x46, 0x79, 0xf3, 0x79, 0xb, 
	0x15, 0x1b, 0x35, 0x4d, 0x65, 0x7f, 0x8d, 0x93, 0x9f, 0xab, 0x64, 0xd2, 0x3b, 0x2e, 0xc2, 0x6c, 
	0x5a, 0x4c, 0x93, 0x6f, 0xbd, 0x1a, 0x4c, 0x12, 0xb0, 0x40, 0x6b, 0x2c, 0xa, 0x6c, 0x5a, 0x4c, 
	0x93, 0x6e, 0xb, 0x6e, 0xc0, 0x52, 0x6c, 0x92, 0xb8, 0x50, 0x4d, 0x82, 0xf2, 0x58, 0x90, 0x4c, 
	0x4d, 0xf0, 0x4c, 0x80, 0x33, 0x70, 0xc2, 0x42, 0x5a, 0x4c, 0x4c, 0x82, 0xbb, 0x52, 0xb, 0x58, 
	0xb2, 0x42, 0x6c, 0x9a, 0xc3, 0x4a, 0x82, 0x64, 0xa, 0x5a, 0x90, 0x0, 0xf6, 0x6c, 0x9, 0xb2, 
	0x3b, 0x2e, 0xc1, 0x4c, 0x4c, 0xb6, 0x2b, 0x20, 0xd, 0xa6, 0xc1, 0x70, 0x48, 0x50, 0xb6, 0x52, 
	0x3b, 0xd2, 0x90, 0x0, 0xda, 0x64, 0x90, 0x4c, 0xc9, 0xd8, 0xbe, 0xa, 0x32, 0x42, 0x9b, 0xc2, 
	0x67, 0x68, 0x4d, 0xae, 0xa1, 0x4e, 0x48, 0x50, 0xb6, 0x52, 0x3b, 0xd2, 0x90, 0x0, 0xbe, 0xa, 
	0xb6, 0x1e, 0x94, 0xd2, 0xa2, 0x92, 0xa, 0x2c, 0xca, 0x4e, 0x7a, 0x65, 0xbd, 0x1a, 0x4c, 0x12, 
	0x92, 0x13, 0x18, 0x62, 0xca, 0x64, 0xf2, 0x42, 0x20, 0x6e, 0xa3, 0x52, 0x82, 0x40, 0x18, 0x62, 
	0xca, 0x64, 0xf2, 0x42, 0x18, 0x6e, 0xa3, 0x52, 0x80, 0x0, 0x20, 0x62, 0xca, 0x64, 0xf2, 0x64, 
	0x8, 0xc2, 0xbd, 0x1a, 0x4c, 0x0, 0xb, 0x15, 0x19, 0x31, 0x41, 0x57, 0x73, 0x7f, 0x89, 0x95, 
	0xa1, 0x8a, 0x5a, 0x84, 0x12, 0xcd, 0x82, 0xb9, 0xe6, 0xb2, 0x40, 0x74, 0xf2, 0x4d, 0x83, 0xd4, 
	0xf0, 0xb2, 0x42, 0xb9, 0xe6, 0xb2, 0x42, 0x4d, 0xf0, 0xe, 0x64, 0xa, 0x12, 0xb8, 0x46, 0x10, 
	0x62, 0x4b, 0x60, 0x82, 0x72, 0xb5, 0xc0, 0xbe, 0xa8, 0xa, 0x64, 0xc5, 0x92, 0xf0, 0x74, 0x9d, 
	0xc2, 0x6c, 0x9a, 0xc3, 0x4a, 0x82, 0x6f, 0xa4, 0xf2, 0xbd, 0xd2, 0xf0, 0x6c, 0x9e, 0xa, 0xc2, 
	0x42, 0xa4, 0xf2, 0xb0, 0x74, 0x9d, 0xc2, 0x6c, 0x9a, 0xc3, 0x4a, 0x82, 0x6f, 0xa4, 0xf2, 0xbd, 
	0xd2, 0xf0, 0x58, 0xed, 0x12, 0xb5, 0xe8, 0x29, 0xd2, 0xd, 0x72, 0x2c, 0x90, 0xc, 0x12, 0xc6, 
	0x2c, 0x48, 0x4e, 0x9d, 0xac, 0x49, 0xf0, 0x48, 0x0, 0x2d, 0x28, 0xcf, 0x52, 0xb0, 0x6e, 0xcd, 
	0x82, 0xbe, 0xa, 0xb6, 0x0, 0x53, 0x64, 0xa, 0x12, 0xd, 0xa, 0xb6, 0x1a, 0x48, 0x0, 0x18, 
	0x68, 0x6a, 0x4e, 0x48, 0x48, 0xb, 0xa6, 0xca, 0x72, 0xb5, 0xc0, 0x18, 0x68, 0x6a, 0x4e, 0x48, 
	0x46, 0xb, 0xa6, 0xca, 0x72, 0xb0, 0x0, 0x20, 0x68, 0x6a, 0x4e, 0x4d, 0xc2, 0x18, 0x5c, 0x9e, 
	0x52, 0xcd, 0x80, 0xb, 0x11, 0x17, 0x31, 0x45, 0x5f, 0x6b, 0x73, 0x7d, 0x89, 0x93, 0xb2, 0x4e, 
	0x9d, 0x90, 0xb8, 0x0, 0x76, 0x56, 0x2a, 0x26, 0xb0, 0x40, 0xbe, 0x42, 0xa6, 0x64, 0xc1, 0x5c, 
	0x48, 0x52, 0xbe, 0xa, 0xa, 0x64, 0xc5, 0x92, 0xc, 0x26, 0xb8, 0x50, 0x6a, 0x7c, 0xc, 0x52, 
	0x74, 0xec, 0x4d, 0xc0, 0xa4, 0xec, 0xa, 0x8a, 0xd4, 0xec, 0xa, 0x64, 0xc5, 0x92, 0xd, 0xf2, 
	0xb8, 0x5a, 0x93, 0x4e, 0x69, 0x60, 0x4d, 0xc0, 0x9d, 0x2c, 0x6c, 0x4a, 0xd, 0xa6, 0xc1, 0x70, 
	0x48, 0x68, 0x2d, 0x8a, 0xd, 0xd2, 0x82, 0x4e, 0x3b, 0x66, 0x91, 0x6c, 0xc, 0xa, 0xc, 0x12, 
	0xc5, 0x8b, 0x9d, 0x2c, 0x6c, 0x4a, 0xb, 0x3a, 0xa2, 0x6c, 0xbd, 0xa, 0x3a, 0x40, 0xa6, 0x60, 
	0xb9, 0x6c, 0xd, 0xf0, 0x2d, 0xb1, 0x76, 0x52, 0x5c, 0xc2, 0xc2, 0x6c, 0x8b, 0x64, 0x2a, 0x27, 
	0x18, 0x54, 0x69, 0xd8, 0x28, 0x48, 0xb, 0xb2, 0x4a, 0xe6, 0xb8, 0x0, 0x18, 0x54, 0x69, 0xd8, 
	0x28, 0x46, 0xb, 0xb2, 0x4a, 0xe7, 0x20, 0x54, 0x69, 0xd8, 0x2d, 0xc2, 0x18, 0x5c, 0xca, 0x56, 
	0x98, 0x0, 0x52, 0xa2, 0x2, 0xbd, 0x0, 0x24, 0xa, 0xb5, 0x7a, 0x29, 0x1f, 0x90, 0x37, 0xf0, 
	0x10, 0xc9, 0x1b, 0xb0, 0xa, 0xa8, 0xa5, 0x5e, 0x29, 0x7, 0xc9, 0x7, 0x98, 0x90, 0x2, 0xe9, 
	0x1, 0x95, 0x7a, 0xad, 0x6, 0x20, 0x29, 0x80, 0xf0, 0x4, 0xa9, 0xf0, 0x85, 0x72, 0xa5, 0x72, 
	0xf0, 0x8, 0xc6, 0x72, 0xa9, 0x0, 0x95, 0x7a, 0x95, 0x77, 0x18, 0xb5, 0x77, 0xf0, 0x23, 0xd6, 
	0x77, 0xd0, 0x1f, 0x38, 0xb0, 0x1c, 0xc9, 0x1b, 0xb0, 0x9, 0xb5, 0x7a, 0x69, 0x20, 0x90, 0xd1, 
	0xf0, 0x1, 0x18, 0xa9, 0x1f, 0xb0, 0xca, 0x95, 0x7a, 0xb5, 0x77, 0xf0, 0x1, 0x38, 0xa9, 0x78, 
	0x95, 0x77, 0x90, 0x23, 0xa9, 0x0, 0xe0, 0x1, 0x90, 0x16, 0xf0, 0xc, 0xa5, 0x71, 0x29, 0xc, 
	0x4a, 0x4a, 0xf0, 0xc, 0x69, 0x2, 0xd0, 0x8, 0xa5, 0x71, 0x29, 0x10, 0xf0, 0x2, 0xa9, 0x1, 
	0x38, 0x65, 0x73, 0x85, 0x73, 0xf6, 0x74, 0xca, 0x30, 0x3, 0x4c, 0x95, 0x7a, 0xa5, 0x71, 0x29, 
	0x3, 0xa8, 0xf0, 0x12, 0x4a, 0x69, 0x0, 0x49, 0xff, 0x38, 0x65, 0x73, 0x90, 0xa, 0xc0, 0x2, 
	0xb0, 0x2, 0xe6, 0x70, 0xe6, 0x70, 0x85, 0x73, 0xa5, 0x5e, 0x4a, 0xb0, 0x27, 0xa0, 0x0, 0xa2, 
	0x2, 0xb5, 0x74, 0xf0, 0x9, 0xc9, 0x10, 0x90, 0x5, 0x69, 0xef, 0xc8, 0x95, 0x74, 0xca, 0x10, 
	0xf0, 0x98, 0xd0, 0x10, 0xa2, 0x2, 0xb5, 0x74, 0xf0, 0x7, 0x18, 0x69, 0xef, 0x95, 0x74, 0x30, 
	0x3, 0xca, 0x10, 0xf2, 0x60, 0x48, 0x98, 0x48, 0x8a, 0x48, 0xd8, 0xad, 0xff, 0x1, 0xd, 0xd0, 
	0x1, 0xd0, 0xfe, 0xe6, 0x5e, 0xa5, 0x5e, 0x29, 0x3, 0xd0, 0x8, 0xe6, 0x5b, 0xa5, 0x5b, 0xc9, 
	0x4, 0xb0, 0xfe, 0x20, 0x93, 0x7a, 0xa5, 0x6f, 0x29, 0xc7, 0x24, 0x74, 0x10, 0x2, 0x9, 0x8, 
	0x24, 0x75, 0x10, 0x2, 0x9, 0x10, 0x24, 0x76, 0x10, 0x2, 0x9, 0x20, 0x85, 0x6f, 0x8d, 0x0, 
	0x32, 0xa5, 0x72, 0xf0, 0x4, 0xa9, 0x80, 0xd0, 0xe, 0xa5, 0x68, 0xf0, 0xa, 0xa5, 0x5c, 0x6a, 
	0x90, 0x2, 0xc6, 0x68, 0x6a, 0x6a, 0x6a, 0x8d, 0x5, 0x3c, 0x68, 0xaa, 0x68, 0xa8, 0x68, 0x40, 
	0xa9, 0xb0, 0xa0, 0x0, 0x91, 0x2, 0xc8, 0x91, 0x2, 0xd0, 0x6e, 0x90, 0x4, 0x29, 0xf, 0xf0, 
	0x5, 0x29, 0xf, 0x18, 0x69, 0x1, 0x8, 0xa, 0xa0, 0x0, 0xaa, 0xbd, 0xd4, 0x56, 0x91, 0x2, 
	0xbd, 0xd5, 0x56, 0xc8, 0x91, 0x2, 0x20, 0x39, 0x7c, 0x28, 0x60, 0x4a, 0x29, 0xf, 0x9, 0xe0, 
	0xa0, 0x1, 0x91, 0x2, 0x88, 0x8a, 0x6a, 0x91, 0x2, 0xc8, 0xd0, 0x3d, 0x4a, 0x29, 0xf, 0x9, 
	0xc0, 0xd0, 0xed, 0xa0, 0x0, 0x84, 0x5, 0x84, 0x7, 0xa, 0x26, 0x5, 0xa, 0x26, 0x5, 0x85, 
	0x4, 0x8a, 0xa, 0x26, 0x7, 0xa, 0x26, 0x7, 0x85, 0x6, 0xa2, 0x4, 0xb5, 0x2, 0xa0, 0x0, 
	0x91, 0x2, 0xb5, 0x3, 0x29, 0xf, 0x9, 0xa0, 0xc8, 0x91, 0x2, 0xb5, 0x0, 0xc8, 0x91, 0x2, 
	0xb5, 0x1, 0x29, 0xf, 0x5, 0x0, 0xc8, 0x91, 0x2, 0x98, 0x38, 0x65, 0x2, 0x85, 0x2, 0x90, 
	0x2, 0xe6, 0x3, 0x60, 0xa9, 0xd0, 0x4c, 0xc2, 0x7b, 0xa5, 0x5, 0xc9, 0x80, 0x90, 0x11, 0x49, 
	0xff, 0x85, 0x5, 0xa5, 0x4, 0x49, 0xff, 0x69, 0x0, 0x85, 0x4, 0x90, 0x2, 0xe6, 0x5, 0x38, 
	0x26, 0x8, 0xa5, 0x7, 0xc9, 0x80, 0x90, 0x11, 0x49, 0xff, 0x85, 0x7, 0xa5, 0x6, 0x49, 0xff, 
	0x69, 0x0, 0x85, 0x6, 0x90, 0x2, 0xe6, 0x7, 0x38, 0x26, 0x8, 0xa5, 0x5, 0x5, 0x7, 0xf0, 
	0xa, 0xa2, 0x0, 0xc9, 0x2, 0xb0, 0x24, 0xa0, 0x1, 0xd0, 0x10, 0xa0, 0x2, 0xa2, 0x9, 0xa5, 
	0x4, 0x5, 0x6, 0xf0, 0x16, 0x30, 0x4, 0xc8, 0xa, 0x10, 0xfc, 0x98, 0xaa, 0xa5, 0x5, 0x6, 
	0x4, 0x2a, 0x6, 0x6, 0x26, 0x7, 0x88, 0xd0, 0xf6, 0x85, 0x5, 0x8a, 0x38, 0xe9, 0xa, 0x49, 
	0xff, 0xa, 0x66, 0x8, 0x2a, 0x66, 0x8, 0x2a, 0xa, 0x85, 0x8, 0xa0, 0x0, 0xa5, 0x6, 0x91, 
	0x2, 0xa5, 0x8, 0x29, 0xf4, 0x5, 0x7, 0xc8, 0x91, 0x2, 0xa5, 0x4, 0xc8, 0x91, 0x2, 0xa5, 
	0x8, 0x29, 0x2, 0xa, 0x5, 0x1, 0x5, 0x5, 0xc8, 0x91, 0x2, 0x4c, 0x39, 0x7c, 0xa2, 0x0, 
	0xa0, 0x1, 0x91, 0x2, 0x88, 0x98, 0x91, 0x2, 0xc8, 0xc8, 0x91, 0x2, 0xc8, 0x8a, 0x91, 0x2, 
	0x4c, 0x39, 0x7c, 0xa2, 0xfe, 0x9a, 0xd8, 0xa9, 0x0, 0xaa, 0xca, 0x9d, 0x0, 0x3, 0x9d, 0x0, 
	0x2, 0x9d, 0x0, 0x1, 0x95, 0x0, 0xd0, 0xf2, 0xac, 0x7, 0x20, 0x30, 0x43, 0xe8, 0x8e, 0x0, 
	0x40, 0xa9, 0xe2, 0x8d, 0x1, 0x40, 0xa9, 0xb0, 0x8d, 0x3, 0x40, 0x85, 0x32, 0x85, 0x33, 0xa9, 
	0x3, 0x85, 0x6f, 0x8d, 0x0, 0x32, 0x2d, 0x0, 0x28, 0x85, 0x71, 0xad, 0x1, 0x28, 0x29, 0x3, 
	0xa, 0xa, 0x5, 0x71, 0x85, 0x71, 0xad, 0x2, 0x28, 0x29, 0x2, 0xa, 0xa, 0xa, 0x5, 0x71, 
	0x85, 0x71, 0x4c, 0x3, 0x68, 0xa0, 0x0, 0x91, 0x2, 0xc8, 0x8a, 0x91, 0x2, 0x4c, 0x39, 0x7c, 
	0x9d, 0x0, 0x40, 0x9d, 0x0, 0x41, 0x9d, 0x0, 0x42, 0x9d, 0x0, 0x43, 0x9d, 0x0, 0x44, 0x9d, 
	0x0, 0x45, 0x9d, 0x0, 0x46, 0x9d, 0x0, 0x47, 0xe8, 0xd0, 0xe5, 0x8d, 0x0, 0x34, 0xa2, 0x0, 
	0xb5, 0x0, 0xd0, 0x47, 0xa9, 0x11, 0x95, 0x0, 0xa8, 0x55, 0x0, 0xd0, 0x3e, 0x98, 0xa, 0x90, 
	0xf5, 0xe8, 0xd0, 0xec, 0x8d, 0x0, 0x34, 0x8a, 0x85, 0x0, 0x2a, 0x85, 0x1, 0xa0, 0x0, 0xa2, 
	0x11, 0xb1, 0x0, 0xd0, 0x2a, 0x8a, 0x91, 0x0, 0x51, 0x0, 0xd0, 0x23, 0x8a, 0xa, 0xaa, 0x90, 
	0xf4, 0xc8, 0xd0, 0xeb, 0x8d, 0x0, 0x34, 0xe6, 0x1, 0xa6, 0x1, 0xe0, 0x4, 0x90, 0xe0, 0xa9, 
	0x40, 0xe0, 0x40, 0x90, 0xd6, 0xe0, 0x48, 0x90, 0xd6, 0xb0, 0x69, 0xa0, 0x0, 0xf0, 0xe, 0xa0, 
	0x0, 0xa6, 0x1, 0xe0, 0x4, 0x90, 0x6, 0xc8, 0xe0, 0x44, 0x90, 0x1, 0xc8, 0xc9, 0x10, 0x2a, 
	0x29, 0x1f, 0xc9, 0x2, 0x2a, 0x29, 0x3, 0x88, 0x30, 0x4, 0xa, 0xa, 0x90, 0xf9, 0x4a, 0xa2, 
	0x14, 0x90, 0x2, 0xa2, 0x1d, 0x8e, 0x0, 0x3a, 0xa2, 0x0, 0xa0, 0x8, 0x2c, 0x1, 0x20, 0x10, 
	0xfb, 0x2c, 0x1, 0x20, 0x30, 0xfb, 0xca, 0x8d, 0x0, 0x34, 0xd0, 0xf0, 0x88, 0xd0, 0xed, 0x8e, 
	0x0, 0x3a, 0xa0, 0x8, 0x2c, 0x1, 0x20, 0x10, 0xfb, 0x2c, 0x1, 0x20, 0x30, 0xfb, 0xca, 0x8d, 
	0x0, 0x34, 0xd0, 0xf0, 0x88, 0xd0, 0xed, 0xaa, 0xd0, 0xc4, 0x8d, 0x0, 0x34, 0xad, 0x7, 0x20, 
	0x30, 0xf8, 0x10, 0xfe, 0xa9, 0x0, 0xa8, 0xaa, 0x85, 0x8, 0xa9, 0x50, 0x85, 0x9, 0xa9, 0x4, 
	0x85, 0xb, 0xa9, 0xff, 0x51, 0x8, 0xc8, 0xd0, 0xfb, 0xe6, 0x9, 0xc6, 0xb, 0xd0, 0xf5, 0x95, 
	0xd, 0xe8, 0x8d, 0x0, 0x34, 0xa5, 0x9, 0xc9, 0x58, 0x90, 0xe1, 0xd0, 0x2, 0xa9, 0x68, 0xc9, 
	0x80, 0x90, 0xd9, 0x8d, 0x0, 0x3, 0xa2, 0x4, 0x8e, 0x0, 0x32, 0x86, 0x15, 0xa2, 0x0, 0xcd, 
	0x0, 0x2, 0xf0, 0x1, 0xe8, 0xad, 0x0, 0x3, 0xc9, 0x88, 0xf0, 0x1, 0xe8, 0x86, 0x16, 0xa9, 
	0x10, 0x85, 0x0, 0xa2, 0x24, 0xad, 0x1, 0x20, 0x10, 0xfb, 0xad, 0x1, 0x20, 0x30, 0xfb, 0xca, 
	0x10, 0xf3, 0x2c, 0x2, 0x20, 0x30, 0xfb, 0x8d, 0x0, 0x34, 0xa9, 0x0, 0x85, 0x2, 0xa9, 0x40, 
	0x85, 0x3, 0xad, 0x5, 0x20, 0x10, 0x5b, 0xa6, 0x15, 0xad, 0x3, 0x20, 0x10, 0xa, 0x4d, 0x9, 
	0x0, 0x10, 0x5, 0xca, 0xf0, 0x2, 0x86, 0x15, 0xbc, 0xbb, 0x7e, 0xa9, 0xb0, 0x91, 0x2, 0x88, 
	0x88, 0xb9, 0xc0, 0x7e, 0x91, 0x2, 0x88, 0x10, 0xf8, 0x4c, 0x9d, 0x7f, 0x33, 0x1d, 0x17, 0xd, 
	0x80, 0xa0, 0x0, 0x0, 0x0, 0x70, 0x0, 0x0, 0xff, 0x92, 0xff, 0x73, 0xd0, 0xa1, 0x30, 0x2, 
	0x0, 0x70, 0x0, 0x0, 0x7f, 0xfb, 0xd, 0xe0, 0x0, 0xb0, 0x7e, 0xfa, 0x11, 0xc0, 0x78, 0xfe, 
	0x0, 0xb0, 0x13, 0xc0, 0x0, 0xd0, 0x15, 0xc0, 0x0, 0xd0, 0x17, 0xc0, 0x0, 0xd0, 0x7a, 0xf8, 
	0x0, 0xd0, 0xa9, 0x50, 0xa2, 0x0, 0x20, 0xfc, 0x7b, 0xa9, 0x69, 0xa2, 0x93, 0x20, 0x3, 0x7c, 
	0xa9, 0x30, 0x20, 0xde, 0x7c, 0xa2, 0x3, 0xbd, 0x0, 0x28, 0x29, 0x1, 0x86, 0xb, 0x20, 0xd1, 
	0x7b, 0xa6, 0xb, 0xbd, 0x0, 0x28, 0x29, 0x2, 0x4a, 0x20, 0xd1, 0x7b, 0xa6, 0xb, 0xca, 0x10, 
	0xe6, 0xa9, 0x7a, 0xa2, 0x9d, 0x20, 0x3, 0x7c, 0xa9, 0x10, 0x20, 0xde, 0x7c, 0xad, 0x2, 0x28, 
	0x29, 0x2, 0x4a, 0x69, 0x1, 0x20, 0xd1, 0x7b, 0xad, 0x1, 0x28, 0x29, 0x3, 0xaa, 0xbd, 0xf5, 
	0x7f, 0x20, 0xd1, 0x7b, 0xa5, 0x16, 0xf0, 0x7, 0xa2, 0x88, 0xa9, 0x50, 0x20, 0xfc, 0x7b, 0xa2, 
	0x96, 0x8e, 0xc, 0x0, 0xa2, 0x7, 0xb5, 0xd, 0xf0, 0x37, 0x48, 0x8e, 0xb, 0x0, 0xae, 0xc, 
	0x0, 0x8a, 0x38, 0xe9, 0x8, 0x8d, 0xc, 0x0, 0xa9, 0x20, 0x20, 0x3, 0x7c, 0xa9, 0x70, 0x20, 
	0xde, 0x7c, 0xad, 0xb, 0x0, 0x20, 0xd1, 0x7b, 0xad, 0xd4, 0x56, 0xae, 0xd5, 0x56, 0x20, 0x45, 
	0x7d, 0x68, 0x48, 0x4a, 0x4a, 0x4a, 0x4a, 0x20, 0xd1, 0x7b, 0x68, 0x20, 0xd1, 0x7b, 0xae, 0xb, 
	0x0, 0xca, 0x10, 0xc2, 0xa9, 0x7f, 0xaa, 0x20, 0x3, 0x7c, 0x20, 0xc0, 0x7b, 0xa9, 0x0, 0xa2, 
	0x4, 0x3e, 0x3, 0x20, 0x6a, 0xca, 0x10, 0xf9, 0xa8, 0xa2, 0x7, 0x3e, 0x0, 0x24, 0x2a, 0xca, 
	0x10, 0xf9, 0xaa, 0x45, 0x8, 0x86, 0x8, 0x8, 0xa9, 0x4, 0x8d, 0x0, 0x32, 0x2e, 0x3, 0x20, 
	0x2a, 0x2e, 0x4, 0x20, 0x2a, 0x2e, 0x7, 0x24, 0x2a, 0x2e, 0x6, 0x24, 0x2a, 0x2e, 0x5, 0x24, 
	0x2a, 0xaa, 0x28, 0xd0, 0x9, 0x45, 0xa, 0xd0, 0x5, 0x98, 0x45, 0x9, 0xf0, 0x2, 0xa9, 0x80, 
	0x8d, 0x5, 0x3c, 0x8d, 0x0, 0x32, 0x8d, 0x0, 0x30, 0x86, 0xa, 0x84, 0x9, 0xad, 0x7, 0x20, 
	0x10, 0xfe, 0x4c, 0x73, 0x7e, 0x1, 0x4, 0x5, 0x6, 0x4e, 0x65, 0x7b, 0xf3, 0x7c, 0xf3, 0x7c
};


static const int mem5000[] = {
	0x80, 0xa0, 0x0, 0x0, 0x0, 0x70, 0x0, 0x0, 0x0, 0x90, 0xff, 0x73, 0xff, 0x92, 0x0, 0x70, 
	0x0, 0x90, 0xff, 0x77, 0xff, 0x96, 0x0, 0x70, 0xff, 0x92, 0xff, 0x72, 0x0, 0x86, 0x0, 0x72, 
	0xfe, 0x87, 0xfe, 0x77, 0x0, 0x92, 0x0, 0x76, 0xfe, 0x81, 0x0, 0x72, 0xff, 0x96, 0xff, 0x72, 
	0x7f, 0xa3, 0xff, 0x3, 0x0, 0x70, 0x0, 0x0, 0xff, 0x96, 0xff, 0x76, 0xfe, 0x81, 0x0, 0x76, 
	0x0, 0x92, 0x0, 0x72, 0xfe, 0x87, 0xfe, 0x73, 0x0, 0x86, 0x0, 0x76, 0xff, 0x92, 0xff, 0x76, 
	0xfc, 0xa1, 0xf4, 0x1, 0x0, 0x70, 0x0, 0x0, 0xdb, 0xf0, 0x0, 0xf9, 0xcf, 0xf0, 0x0, 0xf9, 
	0xbb, 0xf0, 0x0, 0xf9, 0xaf, 0xf0, 0x0, 0xf9, 0x9b, 0xf0, 0x0, 0xf9, 0x8f, 0xf0, 0x0, 0xf9, 
	0x7b, 0xf0, 0x0, 0xf9, 0x6f, 0xf0, 0x0, 0xf9, 0x5b, 0xf0, 0x0, 0xf9, 0x4f, 0xf0, 0x0, 0xf9, 
	0x3b, 0xf0, 0x0, 0xf9, 0x2f, 0xf0, 0x7c, 0xd0, 0xe4, 0xa0, 0x5e, 0x11, 0x0, 0x70, 0x0, 0x0, 
	0x80, 0xca, 0x78, 0xca, 0xd8, 0xca, 0xc7, 0xca, 0x2c, 0xcb, 0x9b, 0xca, 0xf3, 0xca, 0xf3, 0xca, 
	0xdd, 0xca, 0xf3, 0xea, 0x80, 0xa0, 0x90, 0x1, 0x0, 0x70, 0x0, 0x0, 0x73, 0xf5, 0x73, 0xf1, 
	0x78, 0xf1, 0x77, 0xf1, 0x77, 0xf5, 0x78, 0xf5, 0x80, 0x31, 0x0, 0x2, 0x75, 0xf8, 0x70, 0xfd, 
	0x71, 0xf8, 0x2, 0xfd, 0x2e, 0xcb, 0x63, 0xcb, 0x56, 0xcb, 0x63, 0xcb, 0x2c, 0xcb, 0x78, 0xca, 
	0x2, 0xcb, 0x78, 0xca, 0xf3, 0xca, 0xba, 0xca, 0x2c, 0xcb, 0xba, 0xca, 0xd8, 0xca, 0x8d, 0xea, 
	0xc6, 0xff, 0xc1, 0xfe, 0xc3, 0xf1, 0xcd, 0xf1, 0xc7, 0xf1, 0xc1, 0xfd, 0xd8, 0x1e, 0x32, 0xec, 
	0x0, 0xc4, 0x3c, 0x14, 0xa, 0x46, 0xd8, 0xd8, 0xd0, 0xc8, 0xb5, 0xc8, 0x96, 0xc8, 0x80, 0xc8, 
	0xd, 0xf8, 0x78, 0xf8, 0xd, 0xfd, 0x78, 0xf8, 0x9, 0xfd, 0x78, 0xf8, 0xb, 0xf1, 0x78, 0xf8, 
	0xa, 0xf5, 0x78, 0xf8, 0x8, 0xf9, 0x78, 0xf8, 0x9, 0xf3, 0x78, 0xf8, 0xd, 0xf3, 0x78, 0xf8, 
	0x80, 0x54, 0x0, 0x6, 0x78, 0xf8, 0xf, 0xf1, 0x78, 0xf8, 0x0, 0xd0, 0x0, 0x30, 0x80, 0x7, 
	0x78, 0xf8, 0x80, 0x37, 0x80, 0x7, 0x78, 0xf8, 0x80, 0x37, 0x80, 0x3, 0x78, 0xf8, 0xe0, 0x40, 
	0xa0, 0x2, 0x78, 0xf8, 0xc0, 0x35, 0x80, 0x3, 0x78, 0xf8, 0x80, 0x33, 0x0, 0x0, 0x78, 0xf8, 
	0xa0, 0x42, 0xe0, 0x0, 0x78, 0xf8, 0xa0, 0x42, 0xe0, 0x4, 0x78, 0xf8, 0xe0, 0x44, 0x80, 0x7, 
	0x78, 0xf8, 0xe0, 0x40, 0xa0, 0x6, 0x78, 0xf8, 0x0, 0xd0, 0x7, 0xf8, 0x78, 0xf8, 0x7, 0xff, 
	0x78, 0xf8, 0x3, 0xff, 0x78, 0xf8, 0xc0, 0x40, 0x40, 0x2, 0x78, 0xf8, 0x80, 0x35, 0x0, 0x3, 
	0x78, 0xf8, 0x0, 0xfb, 0x78, 0xf8, 0x40, 0x42, 0xc0, 0x0, 0x78, 0xf8, 0x40, 0x42, 0xc0, 0x4, 
	0x78, 0xf8, 0xc0, 0x44, 0x0, 0x7, 0x78, 0xf8, 0xc0, 0x40, 0x40, 0x6, 0x78, 0xf8, 0x0, 0xd0, 
	0x0, 0x30, 0x80, 0x6, 0x78, 0xf8, 0x80, 0x36, 0x80, 0x6, 0x78, 0xf8, 0x80, 0x36, 0x80, 0x2, 
	0x78, 0xf8, 0x40, 0x31, 0xc0, 0x3, 0x78, 0xf8, 0x40, 0x35, 0x80, 0x2, 0x78, 0xf8, 0x80, 0x32, 
	0x0, 0x0, 0x78, 0xf8, 0xc0, 0x33, 0x40, 0x1, 0x78, 0xf8, 0xc0, 0x33, 0x40, 0x5, 0x78, 0xf8, 
	0xa0, 0x44, 0x80, 0x6, 0x78, 0xf8, 0x40, 0x31, 0xc0, 0x7, 0x78, 0xf8, 0x0, 0xd0, 0xf3, 0xc8, 
	0xff, 0xc8, 0xd, 0xc9, 0x1a, 0xc9, 0x8, 0xf9, 0x79, 0xf9, 0x79, 0xfd, 0x7d, 0xf6, 0x79, 0xf6, 
	0x8f, 0xf6, 0x8f, 0xf0, 0x7d, 0xf9, 0x78, 0xfa, 0x79, 0xf9, 0x79, 0xfd, 0x0, 0xd0, 0xa, 0xf1, 
	0x7a, 0xf1, 0x7d, 0xf9, 0x7e, 0xf5, 0x7e, 0xf1, 0x7d, 0xfd, 0x79, 0xf6, 0x7d, 0xf6, 0x79, 0xfd, 
	0x79, 0xf1, 0x8b, 0xf5, 0x8a, 0xf3, 0x7d, 0xf9, 0x0, 0xd0, 0xd, 0xf8, 0x7e, 0xf5, 0x7a, 0xf7, 
	0x7a, 0xf3, 0x78, 0xf7, 0x79, 0xf8, 0x7a, 0xf3, 0x78, 0xf9, 0x7e, 0xf3, 0x7f, 0xf0, 0x7f, 0xf7, 
	0x7a, 0xf5, 0x0, 0xd0, 0x9, 0xf0, 0x7b, 0xf1, 0x68, 0xf1, 0x7f, 0xf2, 0x7f, 0xf0, 0x69, 0xf6, 
	0x7f, 0xf0, 0x78, 0xf7, 0x7a, 0xf7, 0x7b, 0xf1, 0x69, 0xf5, 0x69, 0xf9, 0x7f, 0xf2, 0x0, 0xd0, 
	0x29, 0xc9, 0xe, 0xf1, 0xca, 0xf8, 0xb, 0xf6, 0x0, 0x60, 0x80, 0xd6, 0xdb, 0xf6, 0xca, 0xf8, 
	0xdb, 0xf2, 0xdf, 0xf2, 0xcd, 0xf2, 0xcd, 0xf8, 0xcd, 0xf6, 0xdf, 0xf6, 0x0, 0xd0, 0x90, 0x52, 
	0xa8, 0x52, 0xcc, 0x52, 0xf0, 0x52, 0x14, 0x53, 0x36, 0x53, 0x5a, 0x53, 0x7e, 0x53, 0xa2, 0x53, 
	0xc6, 0x53, 0xea, 0x53, 0xe, 0x54, 0x32, 0x54, 0x56, 0x54, 0x7a, 0x54, 0x9e, 0x54, 0xc2, 0x54, 
	0xf, 0xf6, 0xc8, 0xfa, 0xbd, 0xf9, 0x0, 0x65, 0x0, 0xc3, 0x0, 0x65, 0x0, 0xc7, 0xb9, 0xf9, 
	0x0, 0xd0, 0xce, 0xf9, 0xca, 0xf9, 0x0, 0xd0, 0x40, 0x46, 0xc0, 0x6, 0x0, 0x52, 0x30, 0xc4, 
	0xc0, 0x41, 0x20, 0xc6, 0xb0, 0x64, 0x18, 0xc3, 0x48, 0x65, 0xe0, 0xc6, 0x20, 0x42, 0xc0, 0xc1, 
	0x0, 0xd0, 0xd0, 0x50, 0x10, 0xc6, 0x60, 0x42, 0xc0, 0xc3, 0x0, 0xd0, 0x80, 0x46, 0x80, 0x6, 
	0xe0, 0x43, 0xc0, 0xc4, 0xa0, 0x41, 0x60, 0xc6, 0x68, 0x64, 0x20, 0xc3, 0x90, 0x65, 0xc0, 0xc6, 
	0x60, 0x42, 0xa0, 0xc1, 0x0, 0xd0, 0x90, 0x50, 0x30, 0xc6, 0xc0, 0x42, 0x80, 0xc3, 0x0, 0xd0, 
	0xc0, 0x46, 0x40, 0x6, 0xe0, 0x43, 0x20, 0xc5, 0x60, 0x41, 0x80, 0xc6, 0x18, 0x64, 0x28, 0xc3, 
	0xd0, 0x65, 0x98, 0xc6, 0x80, 0x42, 0x60, 0xc1, 0x0, 0xd0, 0x60, 0x50, 0x30, 0xc6, 0x20, 0x43, 
	0x40, 0xc3, 0x0, 0xd0, 0xe, 0xf7, 0xc0, 0x43, 0x80, 0xc5, 0x20, 0x41, 0xa0, 0xc6, 0x38, 0x60, 
	0x28, 0xc3, 0x10, 0x66, 0x60, 0xc6, 0xa0, 0x42, 0x20, 0xc1, 0x0, 0xd0, 0x30, 0x50, 0x40, 0xc6, 
	0x60, 0x43, 0xe0, 0xc2, 0x0, 0xd0, 0x20, 0x47, 0xc0, 0x5, 0x80, 0x43, 0xe0, 0xc5, 0xe0, 0x40, 
	0xc0, 0xc6, 0x88, 0x60, 0x20, 0xc3, 0x48, 0x66, 0x30, 0xc6, 0xc0, 0x42, 0xe0, 0xc0, 0x0, 0xd0, 
	0x10, 0x54, 0x40, 0xc6, 0xa0, 0x43, 0xa0, 0xc2, 0x0, 0xd0, 0x60, 0x47, 0x60, 0x5, 0x60, 0x43, 
	0x40, 0xc6, 0x80, 0x40, 0xc0, 0xc6, 0xd8, 0x60, 0x10, 0xc3, 0x80, 0x66, 0xf0, 0xc5, 0xc0, 0x42, 
	0x80, 0xc0, 0x0, 0xd0, 0x40, 0x54, 0x30, 0xc6, 0xe0, 0x43, 0x40, 0xc2, 0x0, 0xd0, 0x80, 0x47, 
	0x0, 0x5, 0x20, 0x43, 0x80, 0xc6, 0x40, 0x40, 0xe0, 0xc6, 0x20, 0x61, 0xf8, 0xc2, 0xb0, 0x66, 
	0xb0, 0xc5, 0xe0, 0x42, 0x40, 0xc0, 0x0, 0xd0, 0x80, 0x54, 0x30, 0xc6, 0x10, 0x52, 0xf0, 0xc0, 
	0x0, 0xd0, 0x80, 0x47, 0xc0, 0x4, 0xe0, 0x42, 0xe0, 0xc6, 0x0, 0x40, 0xe0, 0xc6, 0x68, 0x61, 
	0xd8, 0xc2, 0xd8, 0x66, 0x68, 0xc5, 0xe0, 0x42, 0x0, 0xc0, 0x0, 0xd0, 0xb0, 0x54, 0x20, 0xc6, 
	0x20, 0x52, 0xb0, 0xc0, 0x0, 0xd0, 0xa0, 0x47, 0x60, 0x4, 0x80, 0x42, 0x20, 0xc7, 0x40, 0x44, 
	0xe0, 0xc6, 0xb0, 0x61, 0xb0, 0xc2, 0xf8, 0x66, 0x20, 0xc5, 0xe0, 0x42, 0x40, 0xc4, 0x0, 0xd0, 
	0xf0, 0x54, 0x10, 0xc6, 0x30, 0x52, 0x80, 0xc0, 0x0, 0xd0, 0xa0, 0x47, 0x0, 0x0, 0x40, 0x42, 
	0x60, 0xc7, 0x80, 0x44, 0xc0, 0xc6, 0xf0, 0x61, 0x80, 0xc2, 0x10, 0x67, 0xd8, 0xc4, 0xc0, 0x42, 
	0x80, 0xc4, 0x0, 0xd0, 0x40, 0x46, 0xe0, 0xc7, 0x30, 0x52, 0x40, 0xc0, 0x0, 0xd0, 0xa0, 0x47, 
	0x60, 0x0, 0xe0, 0x41, 0x80, 0xc7, 0xe0, 0x44, 0xc0, 0xc6, 0x30, 0x62, 0x48, 0xc2, 0x20, 0x67, 
	0x88, 0xc4, 0xc0, 0x42, 0xe0, 0xc4, 0x0, 0xd0, 0xa0, 0x46, 0xa0, 0xc7, 0x40, 0x52, 0x10, 0xc0, 
	0x0, 0xd0, 0x80, 0x47, 0xc0, 0x0, 0x80, 0x41, 0xc0, 0xc7, 0x20, 0x45, 0xa0, 0xc6, 0x60, 0x62, 
	0x10, 0xc2, 0x28, 0x67, 0x38, 0xc4, 0xa0, 0x42, 0x20, 0xc5, 0x0, 0xd0, 0xe0, 0x46, 0x60, 0xc7, 
	0x40, 0x52, 0x30, 0xc4, 0x0, 0xd0, 0x80, 0x47, 0x0, 0x1, 0x20, 0x41, 0xe0, 0xc7, 0x60, 0x45, 
	0x80, 0xc6, 0x98, 0x62, 0xd0, 0xc1, 0x28, 0x67, 0x18, 0xc0, 0x80, 0x42, 0x60, 0xc5, 0x0, 0xd0, 
	0x40, 0x47, 0x20, 0xc7, 0x30, 0x52, 0x60, 0xc4, 0x0, 0xd0, 0x60, 0x47, 0x60, 0x1, 0xc0, 0x40, 
	0xe0, 0xc7, 0xa0, 0x45, 0x60, 0xc6, 0xc0, 0x62, 0x90, 0xc1, 0x20, 0x67, 0x68, 0xc0, 0x60, 0x42, 
	0xa0, 0xc5, 0x0, 0xd0, 0x80, 0x47, 0xc0, 0xc6, 0x30, 0x52, 0x90, 0xc4, 0x0, 0xd0, 0x20, 0x47, 
	0xc0, 0x1, 0x30, 0x50, 0x0, 0xc6, 0xc0, 0x45, 0x20, 0xc6, 0xe0, 0x62, 0x48, 0xc1, 0x18, 0x67, 
	0xb0, 0xc0, 0x20, 0x42, 0xc0, 0xc5, 0x0, 0xd0, 0xc0, 0x47, 0x60, 0xc6, 0x10, 0x52, 0xd0, 0xc4, 
	0x0, 0xd0, 0xa, 0xf7, 0xce, 0xf8, 0xcd, 0xfd, 0x0, 0x63, 0x0, 0xc1, 0x0, 0x67, 0x0, 0xc1, 
	0xcd, 0xf9, 0x0, 0xd0, 0xcd, 0xfe, 0xcd, 0xfa, 0x0, 0xd0, 0xe, 0xf7, 0x7a, 0xf8, 0x79, 0xfd, 
	0x0, 0x63, 0x0, 0x75, 0x0, 0x67, 0x0, 0x75, 0x79, 0xf9, 0xc0, 0x60, 0x80, 0x2, 0x9f, 0xd0, 
	0x70, 0xfa, 0x72, 0xf2, 0x72, 0xf6, 0x70, 0xfe, 0x6, 0xf9, 0x72, 0xf8, 0x2, 0xf6, 0x0, 0xd0, 
	0x70, 0xfb, 0x73, 0xf0, 0x71, 0xf5, 0x70, 0xf5, 0x75, 0xf5, 0x77, 0xf0, 0x3, 0xf0, 0x71, 0xf5, 
	0x70, 0xf5, 0x75, 0xf5, 0x77, 0xf0, 0x3, 0xf8, 0x0, 0xd0, 0x70, 0xfb, 0x72, 0xf8, 0x6, 0xff, 
	0x72, 0xf8, 0x2, 0xf0, 0x0, 0xd0, 0x70, 0xfb, 0x72, 0xf0, 0x72, 0xf6, 0x70, 0xf6, 0x76, 0xf6, 
	0x76, 0xf0, 0x3, 0xf8, 0x0, 0xd0, 0x70, 0xfb, 0x72, 0xf8, 0x5, 0xf7, 0x77, 0xf0, 0x0, 0xf7, 
	0x72, 0xf8, 0x2, 0xf0, 0x0, 0xd0, 0x70, 0xfb, 0x72, 0xf8, 0x5, 0xf7, 0x77, 0xf0, 0x0, 0xf7, 
	0x3, 0xf8, 0x0, 0xd0, 0x70, 0xfb, 0x72, 0xf8, 0x70, 0xf6, 0x6, 0xf6, 0x72, 0xf0, 0x70, 0xf6, 
	0x76, 0xf8, 0x3, 0xf8, 0x0, 0xd0, 0x70, 0xfb, 0x0, 0xf7, 0x72, 0xf8, 0x0, 0xf3, 0x70, 0xff, 
	0x2, 0xf0, 0x0, 0xd0, 0x72, 0xf8, 0x6, 0xf0, 0x70, 0xfb, 0x2, 0xf0, 0x76, 0xf8, 0x3, 0xff, 
	0x0, 0xd0, 0x0, 0xf2, 0x72, 0xf6, 0x72, 0xf0, 0x70, 0xfb, 0x1, 0xff, 0x0, 0xd0, 0x70, 0xfb, 
	0x3, 0xf0, 0x77, 0xf7, 0x73, 0xf7, 0x3, 0xf0, 0x0, 0xd0, 0x0, 0xfb, 0x70, 0xff, 0x72, 0xf8, 
	0x2, 0xf0, 0x0, 0xd0, 0x70, 0xfb, 0x72, 0xf6, 0x72, 0xf2, 0x70, 0xff, 0x2, 0xf0, 0x0, 0xd0, 
	0x70, 0xfb, 0x72, 0xff, 0x70, 0xfb, 0x1, 0xff, 0x0, 0xd0, 0x70, 0xfb, 0x72, 0xf8, 0x70, 0xff, 
	0x76, 0xf8, 0x3, 0xf8, 0x0, 0xd0, 0x70, 0xfb, 0x72, 0xf8, 0x70, 0xf7, 0x76, 0xf8, 0x3, 0xf7, 
	0x3, 0xf0, 0x0, 0xd0, 0x70, 0xfb, 0x72, 0xf8, 0x70, 0xfe, 0x76, 0xf6, 0x76, 0xf0, 0x2, 0xf2, 
	0x72, 0xf6, 0x2, 0xf0, 0x0, 0xd0, 0x70, 0xfb, 0x72, 0xf8, 0x70, 0xf7, 0x76, 0xf8, 0x1, 0xf0, 
	0x73, 0xf7, 0x2, 0xf0, 0x0, 0xd0, 0x72, 0xf8, 0x70, 0xf3, 0x76, 0xf8, 0x70, 0xf3, 0x72, 0xf8, 
	0x1, 0xff, 0x0, 0xd0, 0x2, 0xf0, 0x70, 0xfb, 0x6, 0xf0, 0x72, 0xf8, 0x1, 0xff, 0x0, 0xd0, 
	0x0, 0xfb, 0x70, 0xff, 0x72, 0xf8, 0x70, 0xfb, 0x1, 0xff, 0x0, 0xd0, 0x0, 0xfb, 0x71, 0xff, 
	0x71, 0xfb, 0x1, 0xff, 0x0, 0xd0, 0x0, 0xfb, 0x70, 0xff, 0x72, 0xf2, 0x72, 0xf6, 0x70, 0xfb, 
	0x1, 0xff, 0x0, 0xd0, 0x72, 0xfb, 0x6, 0xf8, 0x72, 0xff, 0x2, 0xf0, 0x0, 0xd0, 0x2, 0xf0, 
	0x70, 0xfa, 0x76, 0xf2, 0x2, 0xf8, 0x76, 0xf6, 0x2, 0xfe, 0x0, 0xd0, 0x0, 0xfb, 0x72, 0xf8, 
	0x76, 0xff, 0x72, 0xf8, 0x2, 0xf0, 0x0, 0xd0, 0x3, 0xf8, 0x0, 0xd0, 0x2, 0xf0, 0x70, 0xfb, 
	0x2, 0xff, 0x0, 0xd0, 0x0, 0xfb, 0x72, 0xf8, 0x70, 0xf7, 0x76, 0xf8, 0x70, 0xf7, 0x72, 0xf8, 
	0x2, 0xf0, 0x0, 0xd0, 0x72, 0xf8, 0x70, 0xfb, 0x76, 0xf8, 0x0, 0xf7, 0x72, 0xf8, 0x2, 0xf7, 
	0x0, 0xd0, 0x0, 0xfb, 0x70, 0xf7, 0x72, 0xf8, 0x0, 0xf3, 0x70, 0xff, 0x2, 0xf0, 0x0, 0xd0, 
	0x72, 0xf8, 0x70, 0xf3, 0x76, 0xf8, 0x70, 0xf3, 0x72, 0xf8, 0x1, 0xff, 0x0, 0xd0, 0x0, 0xf3, 
	0x72, 0xf8, 0x70, 0xf7, 0x76, 0xf8, 0x70, 0xfb, 0x3, 0xff, 0x0, 0xd0, 0x0, 0xfb, 0x72, 0xf8, 
	0x70, 0xff, 0x2, 0xf0, 0x0, 0xd0, 0x72, 0xf8, 0x70, 0xfb, 0x76, 0xf8, 0x70, 0xff, 0x0, 0xf3, 
	0x72, 0xf8, 0x2, 0xf7, 0x0, 0xd0, 0x2, 0xf8, 0x70, 0xfb, 0x76, 0xf8, 0x70, 0xf7, 0x72, 0xf8, 
	0x2, 0xf7, 0x0, 0xd0, 0x2c, 0xcb, 0xdd, 0xca, 0x2e, 0xcb, 0x32, 0xcb, 0x3a, 0xcb, 0x41, 0xcb, 
	0x48, 0xcb, 0x4f, 0xcb, 0x56, 0xcb, 0x5b, 0xcb, 0x63, 0xcb, 0x78, 0xca, 0x80, 0xca, 0x8d, 0xca, 
	0x93, 0xca, 0x9b, 0xca, 0xa3, 0xca, 0xaa, 0xca, 0xb3, 0xca, 0xba, 0xca, 0xc1, 0xca, 0xc7, 0xca, 
	0xcd, 0xca, 0xd2, 0xca, 0xd8, 0xca, 0xdd, 0xca, 0xe3, 0xca, 0xea, 0xca, 0xf3, 0xca, 0xfb, 0xca, 
	0x2, 0xcb, 0x8, 0xcb, 0xe, 0xcb, 0x13, 0xcb, 0x1a, 0xcb, 0x1f, 0xcb, 0x26, 0xcb, 0xb, 0x13, 
	0x19, 0x2f, 0x41, 0x55, 0x6f, 0x77, 0x7d, 0x87, 0x91, 0x63, 0x56, 0x60, 0x6e, 0x3c, 0xec, 0x4d, 
	0xc0, 0xa4, 0xa, 0xea, 0x6c, 0x8, 0x0, 0xec, 0xf2, 0xb0, 0x6e, 0x3c, 0xec, 0x48, 0x5a, 0xb8, 
	0x66, 0x92, 0x42, 0x9a, 0x82, 0xc3, 0x12, 0xe, 0x12, 0x90, 0x4c, 0x4d, 0xf1, 0xa4, 0x12, 0x2d, 
	0xd2, 0xa, 0x64, 0xc2, 0x6c, 0xf, 0x66, 0xcd, 0x82, 0x6c, 0x9a, 0xc3, 0x4a, 0x85, 0xc0, 0xa6, 
	0x6e, 0x60, 0x6c, 0x9e, 0xa, 0xc2, 0x42, 0xc4, 0xc2, 0xba, 0x60, 0x49, 0xf0, 0xc, 0x12, 0xc6, 
	0x12, 0xb0, 0x0, 0xa6, 0x6e, 0x60, 0x58, 0xed, 0x12, 0xb5, 0xe8, 0x29, 0xd2, 0xe, 0xd8, 0x4c, 
	0x82, 0x82, 0x70, 0xc2, 0x6c, 0xb, 0x6e, 0x9, 0xe6, 0xb5, 0x92, 0x3e, 0x0, 0xa6, 0x6e, 0x60, 
	0x6e, 0xc1, 0x6c, 0xc0, 0x0, 0x59, 0x62, 0x48, 0x66, 0xd2, 0x6d, 0x18, 0x4e, 0x9b, 0x64, 0x9, 
	0x2, 0xa4, 0xa, 0xed, 0xc0, 0x18, 0x4e, 0x9b, 0x64, 0x8, 0xc2, 0xa4, 0xa, 0xe8, 0x0, 0x20, 
	0x4e, 0x9b, 0x64, 0xb8, 0x46, 0xd, 0x20, 0x2f, 0x40, 0x0, 0x3, 0x6, 0x9, 0xc, 0x10, 0x13, 
	0x16, 0x19, 0x1c, 0x1f, 0x22, 0x25, 0x28, 0x2b, 0x2e, 0x31, 0x33, 0x36, 0x39, 0x3c, 0x3f, 0x41, 
	0x44, 0x47, 0x49, 0x4c, 0x4e, 0x51, 0x53, 0x55, 0x58, 0x5a, 0x5c, 0x5e, 0x60, 0x62, 0x64, 0x66, 
	0x68, 0x6a, 0x6b, 0x6d, 0x6f, 0x70, 0x71, 0x73, 0x74, 0x75, 0x76, 0x78, 0x79, 0x7a, 0x7a, 0x7b, 
	0x7c, 0x7d, 0x7d, 0x7e, 0x7e, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};
