///////////////////////////////////////////////////////////////////////////////
// @ Eduard Heidt                                                            //
///////////////////////////////////////////////////////////////////////////////


#pragma once

#include <windows.h>

class FPSCounter
{
private:
	__int64	timerFreq, startTime, endTime;  // Start and ends times
	float	m_fps;
	int 	m_id;
public:
	FPSCounter(int id = 0):m_fps(0),m_id(id)
	{
		Start();
	}
	~FPSCounter()
	{
		Stop();
		print();
	}
	inline void Start()
	{
		QueryPerformanceFrequency((LARGE_INTEGER *)&timerFreq);
		QueryPerformanceCounter((LARGE_INTEGER *)&startTime);
	}

	inline void Stop()
	{
		QueryPerformanceCounter((LARGE_INTEGER *)&endTime);
		m_fps = (float)((double)timerFreq / ((double)(endTime - startTime)));
	}

	inline void print(){printf("\n%d FPS: %f T:%f \n", m_id, GetFPS(), 1.f/GetFPS());}
	inline float GetFPS(){return m_fps;}
};

