///////////////////////////////////////////////////////////////////////////////
// @ Eduard Heidt                                                            //
///////////////////////////////////////////////////////////////////////////////


#pragma once
#include "..\GL\glut.h"

void drawCircle(const Vector& p, VDC rad, bool filled = 0)
{
	static int circle = 0;
	static int circle_filed = 0;
	if(circle == 0)
	{
		circle = glGenLists(1);
		glNewList(circle, GL_COMPILE); 

		glBegin(GL_LINE_LOOP);
		for(VDC r = 0; r < 2*PI; r+=PI/4)
			glVertex2f(cos(r),sin(r));
		glEnd();
		glEndList();
	}
	if(circle_filed == 0)
	{
		circle_filed = glGenLists(1);
		glNewList(circle_filed, GL_COMPILE); 

		glBegin(GL_POLYGON);
		for(VDC r = 0; r < 2*PI; r+=PI/4)
			glVertex2f(cos(r),sin(r));
		glEnd();
		glEndList();
	}
	
	glPushMatrix();
	glTranslatef(p.x,p.y,0);
	glScalef(rad, rad, 1);
	glCallList(filled?circle_filed:circle);		
	glPopMatrix();
}

void drawText(const Vector& pos, const char * message)
{
	glPushMatrix();

	glColor3f(1,1,1);
	glRasterPos2f(pos.x, pos.y);

	while (*message) {
		glutBitmapCharacter(GLUT_BITMAP_HELVETICA_12, *message++);
		//glutStrokeCharacter(GLUT_STROKE_ROMAN,*message++);
	}

	glPopMatrix();
}

void draw_ufo()
{
	GameStatus &s = *Game::GetState();
	if(s.saucer.IsPresent())
	{
		glColor3f(1,0,0);
		drawCircle(s.saucer.GetRelativePos(), s.saucer.GetRad(), true);
	}
}

void draw_shots()
{
	GameStatus &s = *Game::GetState();

	for(int n = 0; n < s.nshots; n++)
	{
		Shot& S = s.shots[n];

		CString txt; txt.Format("%i", S.ufo);
		drawText(S.GetRelativePos(), txt);

		if(S.GetDir().SqLen()>70)
			glColor3f(1,0,0);
		else
			glColor3f(0,1,0);
		drawCircle(S.GetRelativePos(), 2, true);

		glPushMatrix();

		glBegin(GL_POINTS);
		for(unsigned t = 0; t <= S.ts; t++)
		{	
			Vector p = S.GetRelativePos(t);
			glVertex2f(p.x, p.y);
		}	
		glEnd();
	
		glPopMatrix();
	}
}

void draw_asteroids()
{
	GameStatus &s = *Game::GetState();

	for(int n = 0; n < s.nObjects; n++)
	{
		if(s.pObjects[n]->is_ufo)
			continue;

		Object* A = s.pObjects[n];

		CString txt; txt.Format("%d", A->old);
		drawText(A->GetRelativePos(), txt);

		if(A->hit)
			glColor3f(1,1,1);
		else
			glColor3f(1,0,0);

		drawCircle(A->GetRelativePos(), A->GetRad(), false);

		glPushMatrix();
		
		glColor3f(0.2,0.2,0.2);
		glBegin(GL_POINTS);
		for(int t = 0; t < 70; t++)
		{	
			Vector p = A->GetRelativePos(t);
			glVertex2f(p.x, p.y);
		}	
		glEnd();
	
		glPopMatrix();
	}
}

void draw_ship()
{
	GameStatus &s = *Game::GetState();

	if(s.ship.IsPresent())
	{
		glPushMatrix();

		Vector p = s.ship.GetRelativePos();
		glTranslatef(p.x,p.y,0);

		//VDC deg = RAD2DEG(PI/128*s.ship.deg);
		VDC deg = Vector(s.ship.dx, s.ship.dy).DegreeBetween360(Vector(100,0)); 
		glRotatef(deg, 0,0,1);

		glColor3f(0,0,1);//Change color to red

		glBegin(GL_POLYGON);//Start drawing a polygon
		glVertex2f(-18,12);//first vertex
		glVertex2f(18,0);//second vertex
		glVertex2f(-18,-12);//third vertex
		glEnd();//Stop drawing our polygon

		glBegin(GL_LINE_STRIP);
		glVertex2f(0,0);
		glVertex2f(8*70.,0);
		glEnd();

		glPopMatrix();

		drawCircle(p, s.ship.GetRad());

		glPushMatrix();
		
		glColor3f(0.2,0.2,0.2);
		glBegin(GL_POINTS);
		for(int t = 0; t < 70; t++)
		{	
			Vector p = s.ship.GetRelativePos(t);
			glVertex2f(p.x, p.y);
		}	
		glEnd();
	
		glPopMatrix();
	}
}

void redraw(void)
{
	glClear(GL_COLOR_BUFFER_BIT);

	try
	{
		if(Game::GetState()->t > 18000)
			Game::GetState()->t = 18000;

	//static CString txt; 
	//txt.Format("%d(%d) Score %d(%f) Lifes: %d Asteroids:%d Shooted:%d", 
	//				  Game::GetState()->t/60, 
	//				  Game::GetState()->t, 
	//				  Game::GetState()->score,
	//				  (float)Game::GetState()->score/Game::GetState()->t*18000,
	//				  Game::GetState()->lifes,
	//				  Game::GetState()->nAsteroids,
	//				  Player::stat.nShooted);

	//drawText(Vector(-500, 340), txt);

	glPopMatrix();

	draw_ship();
	draw_asteroids();
	draw_shots();
	draw_ufo();

	}
	catch(...)
	{

	}
	
	glFlush();//Draw everything to the screen
	glutSwapBuffers();

}

void key(unsigned char key, int x, int y){}
void mouse(int button, int state, int x, int y){}
void  motion(int x, int y){}
void special(int key, int x, int y){}

void refresh(int val)
{
	glutPostRedisplay();
	glutTimerFunc( val, refresh, val );
}
void init_gl(int argc, char** argv)
{
	glutInit(&argc, argv);
	glutInitWindowSize(512, 384);
	glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGB);
	glutCreateWindow("spock10");
	
	glutKeyboardFunc(key);
	glutMouseFunc(mouse);
	glutSpecialFunc(special);
	glutMotionFunc(motion);
	glutTimerFunc(20, refresh, 0);

	glClearColor(0,0,0,0);//Define our background color
	gluOrtho2D(-512., 512., -384., 384.);

	glutDisplayFunc(redraw);

}

static int _argc;
static char ** _argv;
static DWORD WINAPI glOutProc(LPVOID param)
{
	init_gl(_argc, _argv);
	glutMainLoop();
	return 0;
}