///////////////////////////////////////////////////////////////////////////////
// @ Eduard Heidt                                                            //
///////////////////////////////////////////////////////////////////////////////


#ifndef OBJECTH
#define OBJECTH

#include "math2d.h"
#include "player.h"

static const int F = 1;
static const int MIN_X =    0*F;
static const int MAX_X = 1024*F;
static const int MAX_Y =  896*F;
static const int MIN_Y =  128*F;
static const int RAN_Y = MAX_Y-MIN_Y;

static const int PRET = 256;
static const int STEP = 2;

class GameStatus;


class Object
{
public:
	int id;
	bool is_ufo;

	unsigned s_start;
	int old;
	int kill;
	unsigned collide;
	VDC collide_dis;
	int hit;
	unsigned mask;

	float rad;		// Radius

	Vector pos;    // Koordinaten des Mittelpunkts
	Vector dir;

	Vector mem[8];
	int mc;

	virtual void Reset();
	virtual void set(int xx, int yy);

	Turn CalculateTurn(byte curr_deg, unsigned t_offset);

	Vector GetShootPos(int t = 0);

	bool CT(const Vector& p, const Vector& d, VDC rad, unsigned* ts) const
	{
		if(p*d > 0) 
			return false;  // kleiner 90 -> Optimal Engegengesetzt = 180

		VDC dis = fabs(d.Cross(Vector(0,0)-p))/d.Len();
		if(dis < rad)
		{
			if(ts)
			{
				VDC t1, t2;
				if(Ray(p, d).GetIntersectionWithCircle(Vector(0,0), rad, t1, t2))
				{
					if(ts) *ts = (int)t1;
					return true;
				}
				else
				{	if(ts) *ts = INT_MAX;
					return false;
				}
		}
			return true;
		}
		return false;
	}

	bool WillCollide(const Object &o, int t_offset = 0, VDC* pDis = NULL, unsigned* ts = 0) const
	{
		Vector d = o.GetDir()-GetDir();
		Vector p = (o.GetRelativePos(t_offset)-GetRelativePos()).GetMod(Vector(-512,-384), Vector(512, 384));

		unsigned tts = INT_MAX;
		Vector tmp = p;
		for(int i = 0; i < 9; i++)
		{
			switch(i)
			{
			case 0: p = tmp.Translated(     0,     0); break;
			case 1: p = tmp.Translated(     0,-RAN_Y); break;
			case 2: p = tmp.Translated(     0, RAN_Y); break;
			case 3: p = tmp.Translated(-MAX_X,     0); break;
			case 4: p = tmp.Translated(-MAX_X,-RAN_Y); break;
			case 5: p = tmp.Translated(-MAX_X, RAN_Y); break;
			case 6: p = tmp.Translated( MAX_X,     0); break;
			case 7: p = tmp.Translated( MAX_X,-RAN_Y); break;
			case 8: p = tmp.Translated( MAX_X, RAN_Y); break;
			}

			unsigned t = 0;
			if(CT(p, d, (GetRad()+o.GetRad()), &t) && t < tts)
				tts = t;
		}

		if(ts)
			*ts = tts;

		return tts < INT_MAX;
	}

	unsigned GetCollideTime(const Object &o, int t_offset = 0, VDC* pDis = NULL) const
	{
		unsigned ts;
		if(WillCollide(o, t_offset, pDis, &ts))
			return ts;
		else
			return INT_MAX;
	}

public:
	Object():rad(1),hit(false){Reset();}
	Object(const Vector& pos, const Vector& dir, const VDC rad)
		:pos(pos), dir(dir), rad(rad), old(0)
	{}
	virtual ~Object(){}

	bool SameObject(int xx, int yy);

	Vector GetRelativePos(int t = 0) const;
	Vector GetAbsolutePos(int t = 0) const;

	virtual float GetRad() const  { return rad; } 
	virtual float GetSqRad() const {return (GetRad()*GetRad());} 
	virtual Vector GetDir(int t = 0) const { return dir;}
};

#endif

