///////////////////////////////////////////////////////////////////////////////
// @ Eduard Heidt                                                            //
///////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "player.h"
#include "game.h"

static KeysPacket turned[3];

static const bool print = 0;
static int AMAX = 23;

static unsigned t_latenz = 2;
static unsigned TSMAX = 69;


unsigned Player::GetTimeToNextShot(GameStatus& s)
{
	unsigned ret = TSMAX;
	int sc = 0;
	for(int i = 0; i < s.nshots; i++)
		if(s.shots[i].ufo == false)
		{	
			sc++;
			if(s.shots[i].ts < ret)
				ret = s.shots[i].ts;
		}

	if(sc < 4)
		return 0;
	else
		return ret;

}

int Player::NavigateTo(GameStatus &s, Vector& pos, bool away)
{
	int ret = 1;

	if(away)
		ret = -1;

	if (Vector(s.ship.dx, s.ship.dy).Cross((pos-s.ship.pos).GetMod(Vector(-512,-384), Vector(+512, 384))) < 0)
		return ret;
	else
		return -ret;
}

bool Player::CanShootAt(GameStatus&s, Object& o)
{
		Asteroid* A = dynamic_cast<Asteroid*>(&o);

		//if(A && A->IsUnReal())
		//	return true;

		//if(A && A->IsBig() && A->GetRelativePos().Len() > 400)
		//	return false;

		if(o.old < 8 && o.GetRelativePos().Len()>100)
			return false;
/*
		if(A && A->IsUnReal() && A->GetRelativePos(0).Len() < 100)
			return false;

		if(A && s.nAsteroids > 18 && A->IsUnReal())
			return false;
*/
		if(A && s.nAsteroids > AMAX && (A->IsBig() || A->IsMiddle()))
			return false;

		if(A && (A->IsBig()) && o.s_start+6 > s.t)
			return true;

		if(A && (A->IsMiddle()) && o.s_start+4 > s.t)
			return true;

		if(o.hit)
			return false;

		if(o.s_start+10 > s.t)
			return false;

		return true;
}

int Player::CanFlayAway(GameStatus&s, Object& o)
{
		Asteroid* A = dynamic_cast<Asteroid*>(&o);

		if(o.GetDir().DegreeBetween180(o.GetRelativePos()) < 20)
			return 0;

		
		o.collide  = o.GetCollideTime(s.ship);

		if(A)
		{
			if(o.collide > 140)
				return 0;
			else if(o.GetRelativePos(0).Len() < s.ship.GetRad()+o.GetRad()+o.GetDir().Len())
				return -1;	//HYPERSPACE
		}
		else
		{
			if(o.collide > 70)
				return 0;
			else if(o.GetRelativePos(0).Len() < s.ship.GetRad()+o.GetRad()+o.GetDir().Len()*3)
				return -1;	//HYPERSPACE
		}

		float dir = o.GetDir().DegreeBetween180(s.ship.GetShot().GetDir());
		if(dir < 90)
			return 1;	// THRUST

		return 0;
}

void Player::MakeTurn(GameStatus& s, KeysPacket &t)
{
	//fps.Stop();
	//if(fps.GetFPS()<50)
	//	fps.print();
	//fps.Start();

	static bool ship_is_present = false;

	//printf("\n%d %d %d", time_to_shoot, s.nshots, s.nObjects);

	t_latenz = abs(t.ping-s.ping);
	if(t_latenz > 200)
		t_latenz = 2;


	///////////////////////////////////////////////////

	if (s.ship.IsPresent())
   {
		ship_is_present = true;

		for(int o = 0; o < s.nObjects; o++)
			s.pObjects[o]->hit = 0;

		for(int i = 0; i < s.nshots; i++)
		{
			s.shots[i].tar = NULL;
			s.shots[i].ts =  TSMAX;
			for(int o = 0; o < s.nObjects; o++)
			{
				int maxhit = 0;
				Asteroid* A = dynamic_cast<Asteroid*>(s.pObjects[o]);
				if(A && A->IsBig())
					maxhit = 2;
				if(A && A->IsMiddle())
					maxhit = 2;


				if(s.pObjects[o]->hit > maxhit)
					continue;

				unsigned ts = s.shots[i].GetCollideTime(*s.pObjects[o]);
				if(ts < s.shots[i].ts)
				{
					s.shots[i].tar = s.pObjects[o];
					s.shots[i].ts = ts;
				}
			}

			if(s.shots[i].tar)
				s.shots[i].tar->hit++;

			switch(CanFlayAway(s, s.shots[i]))
			{
			case  1: t.thrust(true); break;
			case -1: t.hyperspace(s.saucer.IsPresent() || s.shots[i].ufo); break;
			default: break;
			}
		}

		unsigned time_to_shoot = GetTimeToNextShot(s); //kann erst hier richtig funktionieren
		//////////////

		for(int i = 0; i < s.nObjects; i++)
		{
				switch(CanFlayAway(s, *s.pObjects[i]))
				{
				case  1: t.thrust(true); break;
				case -1: t.hyperspace(true); break;
				default: break;
				}
		}



		int oc = 0;
		VDC dis = INT_MAX;
		Vector v;

		for(int o = 0; o < s.nObjects; o++)
				if(CanShootAt(s, *s.pObjects[o]))
				{
					if(s.pObjects[o]->GetRelativePos().SqLen() < dis)
					{
						dis = s.pObjects[o]->GetRelativePos().SqLen();
						v = s.pObjects[o]->GetAbsolutePos(time_to_shoot);
					}
					oc++;
				}


		Vector n = Vector(512,512)-s.ship.GetAbsolutePos();
		if(oc == 0 && fabs(n.y) > 250 || fabs(n.x) > 350)
		{					
			int navi = NavigateTo(s,Vector(512,512), false);
			t.left(navi>0);
			t.right(navi<0);
			t.thrust(n.DegreeBetween180(s.ship.GetShot().GetDir()) < 10 && s.ship.GetDir().Len() < 3);
		}
		else if(oc == 0)
		{
			int navi = NavigateTo(s,Vector(512,512), true);
			t.left(navi>0);
			t.right(navi<0);
		}

		static Turn LastTurn;
		Turn turn;

		CheckDeg(s);

		if(oc > 0 && !t.IsHyperspace())
			switch(state)
			{
			case INITL:	if(!SyncWinkelByte(s, t)) break;
			case SCAN: state = SCAN;
					if(1)
					{
						for(int i = 0; turn.o == 0 && i < 4; i++)
							turn = CalcTurn(s, s.ship.deg, t_latenz+i, 0xffffffff);

						t.left (t.IsLeft() || turn.navigate>0);
						t.right(t.IsRight() ||turn.navigate<0);

						t.fire (turn.o && abs(turn.navigate) == 0 && !turned[0].IsFire());
						t.thrust( t.IsThrust() || turn.thrust );

						if(turn.thrust && !s.saucer.IsPresent())
						{
							int navi = NavigateTo(s, v, false);
							
							t.left (!t.IsRight() && (t.IsLeft()  || navi>0));
							t.right(!t.IsRight() && (t.IsRight() || navi<0));
						}
					}

			} // End switch
		else if(s.nObjects > 0)
		{
			int navi = NavigateTo(s, v, false);		
			t.left (!t.IsRight() && (t.IsLeft()  || navi>0));
			t.right(!t.IsRight() && (t.IsRight() || navi<0));
		}

		if(!turned[0].IsFire() && time_to_shoot <= abs(turn.navigate))
		{
			Object* tar = NULL;
			unsigned ts_max = TSMAX; 


			if(abs(turn.navigate) && time_to_shoot)
				ts_max = abs(turn.navigate)+t_latenz;

			Shot S = s.ship.GetShot();

			for(int i = s.nshots; i < MAX_SHOTS; i++)
				s.shots[i] = S;

			for(int a = 0; a < s.nObjects; a++)
			{
				if(!CanShootAt(s, *s.pObjects[a]))
					continue;

				unsigned ts = S.GetCollideTime(*s.pObjects[a], 0);

				//for(int i = 0; i != turn.navigate; i+=(turn.navigate/abs(turn.navigate)))
				//{
				//	Shot shot = s.ship.GetShot((s.ship.deg+i*3)%256);
				//	unsigned shot_t = shot.GetCollideTime(*s.pObjects[a], abs(i));

				//	if(shot_t < ts)
				//		ts = INT_MAX;
				//}

				if(ts < ts_max)
				{
					ts_max = ts;
					tar = s.pObjects[a];
					t.fire(true);
				}
			}
					
			if(tar == NULL)
				t.fire(false);
			else if(s.t - tar->s_start > 8)
				tar->s_start = s.t;
		}
		else
			t.fire(false);

		
		t.thrust(t.IsThrust() && time_to_shoot < 8);
		
		if(t.IsHyperspace() && !turned[0].IsHyperspace())
		{
			printf("H");
			t.left (false);
			t.right(false);
			t.fire(false);
			t.thrust(false);
		}
		else
			t.hyperspace(false);

		t.thrust(t.IsThrust() || (turned[0].IsThrust() && !turned[1].IsThrust()));



	}
	else if(s.score > 1000) // Ship is not present
	{
		if(ship_is_present)
		{
			if(turned[0].IsLeft()) s.ship.deg-=3;
			if(turned[0].IsRight()) s.ship.deg+=3;
		}
		ship_is_present = false;
	}
	else 
	{
		//srand(time(NULL));
		t.start(true);
	}

	turned[2] = turned[1];
	turned[1] = turned[0];
	turned[0] = t;

	if(turned[0].IsLeft())	s.ship.deg+=3;
	if(turned[0].IsRight()) s.ship.deg-=3;

	if(print && t.IsFire()) printf("F");
	if(print && t.IsLeft()) printf("L");
	if(print && t.IsRight()) printf("R");
}

Turn Player::CalcTurn(GameStatus& s, byte curr_deg, unsigned t_offset, unsigned mask)
{
	Object** objects = s.pObjects;
	int nobjects = s.nObjects;

	////////////////////////////////////////////////////////////////////
	unsigned time_toL = INT_MAX;
	unsigned time_toR = INT_MAX;

	Turn retL = Turn::Thrust();
	Turn retR = Turn::Thrust();
	int countL = 0;
	int countR = 0;
	if(nobjects==0)
		return retL;

	///////////////////////////////////////////////////////////////////

	for(int k = 0; k < nobjects; k++)
	{
		Asteroid* A = dynamic_cast<Asteroid*>(objects[k]);

		if(!CanShootAt(s, *objects[k]))
			continue;
			
		unsigned nmax = 42;
		unsigned wait = 1;

		if(nobjects < 4)
			wait = 4;

		for(unsigned do_navigate = 0; do_navigate <= nmax; do_navigate++)
		{
			Shot shotL = s.ship.GetShot((curr_deg+do_navigate*3)%256);
			Shot shotR = s.ship.GetShot((curr_deg-do_navigate*3)%256);

			unsigned tsL = INT_MAX;
			
			for(unsigned w = 0; w < wait && tsL == INT_MAX ; w++)
				tsL = shotL.GetCollideTime(*objects[k], do_navigate+t_offset+w) + w;

			unsigned tsR = INT_MAX;

			for(unsigned w = 0; w < wait && tsR == INT_MAX ; w++)
				tsR = shotR.GetCollideTime(*objects[k], do_navigate+t_offset+w) + w;

			unsigned tiL =  do_navigate+tsL;
			unsigned tiR =  do_navigate+tsR;

			if(A && A->IsBig())
			{
				tiL = do_navigate+tsL + tsL/2; 
				tiR =  do_navigate+tsR + tsR/2;
			}

			objects[k]->collide = objects[k]->GetCollideTime(s.ship);

			if(tsL < TSMAX && tiL < time_toL)
			{
					time_toL = tiL;
					retL = Turn::Fire(do_navigate, t_offset-t_latenz, objects[k], tiL);
					countL++;
					if(A && A->IsBig())
						countL+=4;
					if(A && A->IsMiddle())
						countL+=2;

					//if(objects[k]->collide < 70  && objects[k]->collide > tiL)
					//	return retL;
			}

			if(tsR < TSMAX && tiR < time_toR)
			{
					time_toR = tiR;
					retR = Turn::Fire(do_navigate*-1, t_offset-t_latenz, objects[k], tiR);
					countR++;
					if(A && A->IsBig())
						countR+=4;
					if(A && A->IsMiddle())
						countR+=2;

					//if(objects[k]->collide < 70 && objects[k]->collide > tiR)
					//	return retR;
			}
		}
	}

	if(abs(retL.ts - retR.ts) < 2)
		if(countL > countR)
			return retL;
		else
			return retR;
	else
		return retL.ts < retR.ts ? retL:retR;
}

void Player::CheckDeg(GameStatus &s)
{
	if(1)
	{
		byte d = s.ship.deg;
		if(turned[0].IsLeft()) d-=3;
		if(turned[0].IsRight()) d+=3;

		if(s.ship.display_degs[d][0] != s.ship.dx && s.ship.display_degs[d][1] != s.ship.dy)
		{
			if(turned[2].IsLeft())
				s.ship.deg-=3;
			else if(turned[2].IsRight())
				s.ship.deg+=3;
			else
			{
				state = INITL;
			}
		}
	}
}

bool Player::SyncWinkelByte(GameStatus& s, KeysPacket &turn)
{
	if(!s.ship.IsPresent())
		return true;

	if(sync > 8+t_latenz)
		sync = m = 0;

	if(sync < 8)
		turn.left(true);

	sync++;
	if(sync > t_latenz && sync <= 8+t_latenz)
	{
		//printf("\n%d [%d %d]",t_latenz, s.ship.dx, s.ship.dy); 
		memxy[m][0] = s.ship.dx; 
		memxy[m][1] = s.ship.dy; 
		m = (++m)%8;
	}

	if(sync == 8+t_latenz)
	{
		for(int i = 0; i < 256; i++)
		{	
			int ident = 0;
			for(int j = 0; j < 8; j++)
			{
				byte index = ((i+j*3)%256);
				if(s.ship.display_degs[index][0]==memxy[j][0] && s.ship.display_degs[index][1]==memxy[j][1])
					ident++;
				else
					break;
			}

			if(ident == 8)
			{
				s.ship.deg = i + 24;
				printf("S");
				sync = m = 0;
				return true;
			}
		}
	}

	return false;
}

#if 0
bool Player::SyncWinkelByte(GameStatus& s, KeysPacket &turn, bool left)
{
	if(!s.ship.IsPresent())
		return true;

	static int sync = -1;
	static int mem[8][2];

	//printf("\nL: %d", t_latenz);

	if(t_latenz > 2 && sync == -1)
	{
		if(left)
			turn.left(true);
		else
			turn.right(true);

		sync = 0;
		return false;
	}

	switch(sync)
	{
		
	default:
		sync= 0;
	case-1:
	case 0:
		sync++;
		if(left)
			turn.left(true);
		else
			turn.right(true);
		break;
	case 1:
	case 2:
	case 3:
	case 4:
	case 5:
	case 6:
	case 7:
		if(left)
			turn.left(true);
		else
			turn.right(true);
	case 8:
		//printf("%d %d", s.ship.dx, s.ship.dy);
		mem[sync-1][0]=s.ship.dx; mem[sync-1][1] = s.ship.dy;
		sync++;
		break;
	case 9:
		{
			int inc = left?3:-3;
			for(int i = 0; i < 256; i++)
			{	if(s.ship.display_degs[(byte)(i+0*inc)%256][0]==mem[0][0] && s.ship.display_degs[(byte)(i+0*inc)%256][1]==mem[0][1] &&
					s.ship.display_degs[(byte)(i+1*inc)%256][0]==mem[1][0] && s.ship.display_degs[(byte)(i+1*inc)%256][1]==mem[1][1] &&
					s.ship.display_degs[(byte)(i+2*inc)%256][0]==mem[2][0] && s.ship.display_degs[(byte)(i+2*inc)%256][1]==mem[2][1] &&
					s.ship.display_degs[(byte)(i+3*inc)%256][0]==mem[3][0] && s.ship.display_degs[(byte)(i+3*inc)%256][1]==mem[3][1] &&
					s.ship.display_degs[(byte)(i+4*inc)%256][0]==mem[4][0] && s.ship.display_degs[(byte)(i+4*inc)%256][1]==mem[4][1] &&
					s.ship.display_degs[(byte)(i+5*inc)%256][0]==mem[5][0] && s.ship.display_degs[(byte)(i+5*inc)%256][1]==mem[5][1] &&
					s.ship.display_degs[(byte)(i+6*inc)%256][0]==mem[6][0] && s.ship.display_degs[(byte)(i+6*inc)%256][1]==mem[6][1] &&
					s.ship.display_degs[(byte)(i+7*inc)%256][0]==mem[7][0] && s.ship.display_degs[(byte)(i+7*inc)%256][1]==mem[7][1])
				{
					s.ship.deg = i + 8*inc;
					//printf("-> Synced To %d!", s.ship.deg);
					sync = -1;
					return true;
				}
			}
			sync = -1;
		}
		break;
	}

	return false;
}


#endif

