/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid;

import de.caff.asteroid.Asteroid;
import de.caff.asteroid.Bullet;
import de.caff.asteroid.Explosion;
import de.caff.asteroid.GameData;
import de.caff.asteroid.GameObject;
import de.caff.asteroid.MovingGameObject;
import de.caff.asteroid.PingKeyProvider;
import de.caff.asteroid.Property;
import de.caff.asteroid.PropertyProvider;
import de.caff.asteroid.ShipExplosion;
import de.caff.asteroid.SpaceShip;
import de.caff.asteroid.Text;
import de.caff.asteroid.Ufo;
import de.caff.util.Tools;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class FrameInfo
implements GameData,
PropertyProvider {
    private static final Map<Integer, Character> CHAR_MAP = new HashMap<Integer, Character>();
    public static final String GAME_END_STRING;
    public static final String GAME_START_STRING;
    public static final String PLAYER1_STRING;
    private static final int NO_NUMBER = -1;
    private static final int ID_BYTE = 1024;
    private static final int PING_BYTE = 1025;
    private static final int MASK_OPCODE = 240;
    private static final int OPCODE_LABS = 160;
    private static final int OPCODE_HALT = 176;
    private static final int OPCODE_JSRL = 192;
    private static final int OPCODE_RTSL = 208;
    private static final int OPCODE_JMPL = 224;
    private static final int OPCODE_SVEC = 240;
    private static final int OPCODE_SHIP = 96;
    private static final int SUB_ASTEROID_TYPE1 = 2291;
    private static final int SUB_ASTEROID_TYPE2 = 2303;
    private static final int SUB_ASTEROID_TYPE3 = 2317;
    private static final int SUB_ASTEROID_TYPE4 = 2330;
    private static final int SUB_UFO = 2345;
    private static final int SUB_SHIP = 2669;
    private static final int SUB_EXPLOSION_XXL = 2176;
    private static final int SUB_EXPLOSION_XL = 2198;
    private static final int SUB_EXPLOSION_L = 2229;
    private static final int SUB_EXPLOSION_S = 2256;
    private static final int SUB_COPYRIGHT = 2130;
    public static final Direction[] SHOOTING_DIRECTIONS;
    private int index;
    private final byte id;
    private final byte ping;
    private Ufo ufo;
    private List<Asteroid> asteroids = new LinkedList<Asteroid>();
    private SpaceShip spaceShip;
    private ShipExplosion shipExplosion;
    private List<Bullet> bullets = new LinkedList<Bullet>();
    private List<Explosion> explosions = new LinkedList<Explosion>();
    private final long receiveTime;
    private final long pingTime;
    private int score = -1;
    private int highscore = -1;
    private int sonirt = -1;
    private boolean gameStartDisplayed;
    private boolean player1Displayed;
    private boolean gameEndDisplayed;
    private int nrShips;
    private List<Text> texts = new LinkedList<Text>();
    private byte shootingDir;
    private byte nextShootingDir;

    static {
        CHAR_MAP.put(2680, Character.valueOf('A'));
        CHAR_MAP.put(2688, Character.valueOf('B'));
        CHAR_MAP.put(2701, Character.valueOf('C'));
        CHAR_MAP.put(2707, Character.valueOf('D'));
        CHAR_MAP.put(2715, Character.valueOf('E'));
        CHAR_MAP.put(2723, Character.valueOf('F'));
        CHAR_MAP.put(2730, Character.valueOf('G'));
        CHAR_MAP.put(2739, Character.valueOf('H'));
        CHAR_MAP.put(2746, Character.valueOf('I'));
        CHAR_MAP.put(2753, Character.valueOf('J'));
        CHAR_MAP.put(2759, Character.valueOf('K'));
        CHAR_MAP.put(2765, Character.valueOf('L'));
        CHAR_MAP.put(2770, Character.valueOf('M'));
        CHAR_MAP.put(2776, Character.valueOf('N'));
        CHAR_MAP.put(2781, Character.valueOf('0'));
        CHAR_MAP.put(2787, Character.valueOf('P'));
        CHAR_MAP.put(2794, Character.valueOf('Q'));
        CHAR_MAP.put(2803, Character.valueOf('R'));
        CHAR_MAP.put(2811, Character.valueOf('S'));
        CHAR_MAP.put(2818, Character.valueOf('T'));
        CHAR_MAP.put(2824, Character.valueOf('U'));
        CHAR_MAP.put(2830, Character.valueOf('V'));
        CHAR_MAP.put(2835, Character.valueOf('W'));
        CHAR_MAP.put(2842, Character.valueOf('X'));
        CHAR_MAP.put(2847, Character.valueOf('Y'));
        CHAR_MAP.put(2854, Character.valueOf('Z'));
        CHAR_MAP.put(2860, Character.valueOf(' '));
        CHAR_MAP.put(2862, Character.valueOf('1'));
        CHAR_MAP.put(2866, Character.valueOf('2'));
        CHAR_MAP.put(2874, Character.valueOf('3'));
        CHAR_MAP.put(2881, Character.valueOf('4'));
        CHAR_MAP.put(2888, Character.valueOf('5'));
        CHAR_MAP.put(2895, Character.valueOf('6'));
        CHAR_MAP.put(2902, Character.valueOf('7'));
        CHAR_MAP.put(2907, Character.valueOf('8'));
        CHAR_MAP.put(2915, Character.valueOf('9'));
        GAME_END_STRING = FrameInfo.canonize("SPIELENDE");
        GAME_START_STRING = FrameInfo.canonize("STARTKN0EPFE DRUECKEN");
        PLAYER1_STRING = FrameInfo.canonize("SPIELER 1");
        SHOOTING_DIRECTIONS = new Direction[]{new Direction(1536, 0, 7.875, 0.0, 19, 0), new Direction(1536, 0, 7.875, 0.5, 19, 1), new Direction(1528, 152, 7.875, 1.125, 19, 2), new Direction(1504, 296, 7.75, 1.75, 19, 4), new Direction(1472, 440, 7.625, 2.25, 19, 5), new Direction(1472, 440, 7.375, 2.875, 18, 7), new Direction(1416, 584, 7.125, 3.375, 17, 8), new Direction(1360, 720, 6.875, 3.875, 17, 9), new Direction(1280, 856, 6.625, 4.375, 16, 10), new Direction(1280, 856, 6.25, 4.875, 15, 12), new Direction(1192, 976, 5.875, 5.25, 14, 13), new Direction(1088, 1088, 5.5, 5.75, 13, 14), new Direction(976, 1192, 5.0, 6.125, 12, 15), new Direction(976, 1192, 4.5, 6.5, 11, 16), new Direction(856, 1280, 4.0, 6.75, 10, 16), new Direction(720, 1360, 3.5, 7.0, 8, 17), new Direction(584, 1416, 3.0, 7.25, 7, 18), new Direction(584, 1416, 2.5, 7.5, 6, 18), new Direction(440, 1472, 1.875, 7.625, 4, 19), new Direction(296, 1504, 1.375, 7.75, 3, 19), new Direction(152, 1528, 0.75, 7.875, 1, 19), new Direction(152, 1528, 0.125, 7.875, 0, 19), new Direction(-152, 1528, -0.375, 7.875, -1, 19), new Direction(-296, 1504, -1.0, 7.875, -3, 19), new Direction(-296, 1504, -1.625, 7.75, -5, 19), new Direction(-440, 1472, -2.125, 7.625, -6, 19), new Direction(-584, 1416, -2.75, 7.5, -7, 18), new Direction(-720, 1360, -3.25, 7.25, -9, 18), new Direction(-720, 1360, -3.75, 7.0, -10, 17), new Direction(-856, 1280, -4.25, 6.625, -11, 16), new Direction(-976, 1192, -4.75, 6.375, -12, 15), new Direction(-1088, 1088, -5.25, 6.0, -14, 15), new Direction(-1088, 1088, -5.625, 5.625, -15, 14), new Direction(-1192, 976, -6.0, 5.125, -15, 12), new Direction(-1280, 856, -6.375, 4.75, -16, 11), new Direction(-1360, 720, -6.75, 4.25, -17, 10), new Direction(-1360, 720, -7.0, 3.75, -18, 9), new Direction(-1416, 584, -7.25, 3.125, -19, 7), new Direction(-1472, 440, -7.5, 2.625, -19, 6), new Direction(-1504, 296, -7.625, 2.125, -20, 5), new Direction(-1504, 296, -7.875, 1.5, -20, 3), new Direction(-1528, 152, -7.875, 1.0, -20, 2), new Direction(-1536, 0, -8.0, 0.375, -20, 0), new Direction(-1536, 0, -8.0, -0.25, -20, -1), new Direction(-1528, -152, -7.875, -0.75, -20, -2), new Direction(-1528, -152, -7.875, -1.375, -20, -4), new Direction(-1504, -296, -7.75, -2.0, -20, -5), new Direction(-1472, -440, -7.625, -2.5, -20, -7), new Direction(-1416, -584, -7.375, -3.125, -19, -8), new Direction(-1416, -584, -7.125, -3.625, -18, -10), new Direction(-1360, -720, -6.875, -4.125, -18, -11), new Direction(-1280, -856, -6.5, -4.625, -17, -12), new Direction(-1192, -976, -6.125, -5.125, -16, -13), new Direction(-1192, -976, -5.75, -5.5, -15, -14), new Direction(-1088, -1088, -5.375, -5.875, -14, -15), new Direction(-976, -1192, -4.875, -6.25, -13, -16), new Direction(-856, -1280, -4.5, -6.625, -12, -17), new Direction(-856, -1280, -4.0, -7.0, -10, -18), new Direction(-720, -1360, -3.375, -7.25, -9, -19), new Direction(-584, -1416, -2.875, -7.375, -8, -19), new Direction(-440, -1472, -2.375, -7.625, -6, -20), new Direction(-440, -1472, -1.75, -7.75, -5, -20), new Direction(-296, -1504, -1.25, -7.875, -4, -20), new Direction(-152, -1528, -0.625, -8.0, -2, -20), new Direction(0, -1536, 0.0, -8.0, 0, -20), new Direction(152, -1528, 0.5, -8.0, 1, -20), new Direction(296, -1504, 1.125, -7.875, 2, -20), new Direction(440, -1472, 1.75, -7.75, 4, -20), new Direction(440, -1472, 2.25, -7.625, 5, -20), new Direction(584, -1416, 2.875, -7.375, 7, -19), new Direction(720, -1360, 3.375, -7.25, 8, -19), new Direction(856, -1280, 3.875, -7.0, 9, -18), new Direction(856, -1280, 4.375, -6.625, 10, -17), new Direction(976, -1192, 4.875, -6.25, 12, -16), new Direction(1088, -1088, 5.25, -5.875, 13, -15), new Direction(1192, -976, 5.75, -5.5, 14, -14), new Direction(1192, -976, 6.125, -5.125, 15, -13), new Direction(1280, -856, 6.5, -4.625, 16, -12), new Direction(1360, -720, 6.75, -4.125, 16, -11), new Direction(1416, -584, 7.0, -3.625, 17, -10), new Direction(1416, -584, 7.25, -3.125, 18, -8), new Direction(1472, -440, 7.5, -2.5, 18, -7), new Direction(1504, -296, 7.625, -2.0, 19, -5), new Direction(1528, -152, 7.75, -1.375, 19, -4), new Direction(1528, -152, 7.875, -0.75, 19, -2), new Direction(1536, 0, 7.875, -0.25, 19, -1), new Direction(1536, 0, 7.875, 0.375, 19, 0), new Direction(1528, 152, 7.875, 1.0, 19, 2), new Direction(1504, 296, 7.75, 1.5, 19, 3), new Direction(1504, 296, 7.625, 2.125, 19, 5), new Direction(1472, 440, 7.5, 2.625, 18, 6), new Direction(1416, 584, 7.25, 3.125, 18, 7), new Direction(1360, 720, 7.0, 3.75, 17, 9), new Direction(1360, 720, 6.625, 4.25, 16, 10), new Direction(1280, 856, 6.375, 4.75, 15, 11), new Direction(1192, 976, 6.0, 5.125, 15, 12), new Direction(1088, 1088, 5.625, 5.625, 14, 14), new Direction(1088, 1088, 5.125, 6.0, 12, 15), new Direction(976, 1192, 4.75, 6.375, 11, 15), new Direction(856, 1280, 4.25, 6.625, 10, 16), new Direction(720, 1360, 3.75, 7.0, 9, 17), new Direction(720, 1360, 3.125, 7.25, 7, 18), new Direction(584, 1416, 2.625, 7.5, 6, 18), new Direction(440, 1472, 2.125, 7.625, 5, 19), new Direction(296, 1504, 1.5, 7.75, 3, 19), new Direction(296, 1504, 1.0, 7.875, 2, 19), new Direction(152, 1528, 0.375, 7.875, 0, 19), new Direction(-152, 1528, -0.25, 7.875, -1, 19), new Direction(-152, 1528, -0.75, 7.875, -2, 19), new Direction(-296, 1504, -1.375, 7.75, -4, 19), new Direction(-440, 1472, -2.0, 7.625, -5, 19), new Direction(-584, 1416, -2.5, 7.5, -7, 18), new Direction(-584, 1416, -3.125, 7.25, -8, 18), new Direction(-720, 1360, -3.625, 7.0, -10, 17), new Direction(-856, 1280, -4.125, 6.75, -11, 16), new Direction(-976, 1192, -4.625, 6.5, -12, 16), new Direction(-976, 1192, -5.125, 6.125, -13, 15), new Direction(-1088, 1088, -5.5, 5.75, -14, 14), new Direction(-1192, 976, -5.875, 5.25, -15, 13), new Direction(-1280, 856, -6.25, 4.875, -16, 12), new Direction(-1280, 856, -6.625, 4.375, -17, 10), new Direction(-1360, 720, -7.0, 3.875, -18, 9), new Direction(-1416, 584, -7.25, 3.375, -19, 8), new Direction(-1472, 440, -7.375, 2.875, -19, 7), new Direction(-1472, 440, -7.625, 2.25, -20, 5), new Direction(-1504, 296, -7.75, 1.75, -20, 4), new Direction(-1528, 152, -7.875, 1.125, -20, 2), new Direction(-1536, 0, -8.0, 0.5, -20, 1), new Direction(-1536, 0, -8.0, 0.0, -20, 0), new Direction(-1536, 0, -8.0, -0.625, -20, -2), new Direction(-1528, -152, -7.875, -1.25, -20, -4), new Direction(-1504, -296, -7.75, -1.75, -20, -5), new Direction(-1472, -440, -7.625, -2.375, -20, -6), new Direction(-1472, -440, -7.375, -2.875, -19, -8), new Direction(-1416, -584, -7.25, -3.375, -19, -9), new Direction(-1360, -720, -7.0, -4.0, -18, -10), new Direction(-1280, -856, -6.625, -4.5, -17, -12), new Direction(-1280, -856, -6.25, -4.875, -16, -13), new Direction(-1192, -976, -5.875, -5.375, -15, -14), new Direction(-1088, -1088, -5.5, -5.75, -14, -15), new Direction(-976, -1192, -5.125, -6.125, -13, -16), new Direction(-976, -1192, -4.625, -6.5, -12, -17), new Direction(-856, -1280, -4.125, -6.875, -11, -18), new Direction(-720, -1360, -3.625, -7.125, -10, -18), new Direction(-584, -1416, -3.125, -7.375, -8, -19), new Direction(-584, -1416, -2.5, -7.625, -7, -20), new Direction(-440, -1472, -2.0, -7.75, -5, -20), new Direction(-296, -1504, -1.375, -7.875, -4, -20), new Direction(-152, -1528, -0.75, -7.875, -2, -20), new Direction(-152, -1528, -0.25, -8.0, -1, -20), new Direction(152, -1528, 0.375, -8.0, 0, -20), new Direction(296, -1504, 1.0, -7.875, 2, -20), new Direction(296, -1504, 1.5, -7.875, 3, -20), new Direction(440, -1472, 2.125, -7.625, 5, -20), new Direction(584, -1416, 2.625, -7.5, 6, -19), new Direction(720, -1360, 3.125, -7.25, 7, -19), new Direction(720, -1360, 3.75, -7.0, 9, -18), new Direction(856, -1280, 4.25, -6.75, 10, -17), new Direction(976, -1192, 4.75, -6.375, 11, -16), new Direction(1088, -1088, 5.125, -6.0, 12, -15), new Direction(1088, -1088, 5.625, -5.625, 14, -15), new Direction(1192, -976, 6.0, -5.25, 15, -14), new Direction(1280, -856, 6.375, -4.75, 15, -12), new Direction(1360, -720, 6.625, -4.25, 16, -11), new Direction(1360, -720, 7.0, -3.75, 17, -10), new Direction(1416, -584, 7.25, -3.25, 18, -9), new Direction(1472, -440, 7.5, -2.75, 18, -7), new Direction(1504, -296, 7.625, -2.125, 19, -6), new Direction(1504, -296, 7.75, -1.625, 19, -5), new Direction(1528, -152, 7.875, -1.0, 19, -3), new Direction(1536, 0, 7.875, -0.375, 19, -1), new Direction(1536, 0, 7.875, 0.125, 19, 0), new Direction(1528, 152, 7.875, 0.75, 19, 1), new Direction(1528, 152, 7.75, 1.375, 19, 3), new Direction(1504, 296, 7.625, 1.875, 19, 4), new Direction(1472, 440, 7.5, 2.5, 18, 6), new Direction(1416, 584, 7.25, 3.0, 18, 7), new Direction(1416, 584, 7.0, 3.5, 17, 8), new Direction(1360, 720, 6.75, 4.0, 16, 10), new Direction(1280, 856, 6.5, 4.5, 16, 11), new Direction(1192, 976, 6.125, 5.0, 15, 12), new Direction(1192, 976, 5.75, 5.5, 14, 13), new Direction(1088, 1088, 5.25, 5.875, 13, 14), new Direction(976, 1192, 4.875, 6.25, 12, 15), new Direction(856, 1280, 4.375, 6.625, 10, 16), new Direction(856, 1280, 3.875, 6.875, 9, 17), new Direction(720, 1360, 3.375, 7.125, 8, 17), new Direction(584, 1416, 2.875, 7.375, 7, 18), new Direction(440, 1472, 2.25, 7.625, 5, 19), new Direction(440, 1472, 1.75, 7.75, 4, 19), new Direction(296, 1504, 1.125, 7.875, 2, 19), new Direction(152, 1528, 0.5, 7.875, 1, 19), new Direction(0, 1536, 0.0, 7.875, 0, 19), new Direction(-152, 1528, -0.625, 7.875, -2, 19), new Direction(-296, 1504, -1.25, 7.875, -4, 19), new Direction(-440, 1472, -1.75, 7.75, -5, 19), new Direction(-440, 1472, -2.375, 7.625, -6, 19), new Direction(-584, 1416, -2.875, 7.375, -8, 18), new Direction(-720, 1360, -3.375, 7.125, -9, 17), new Direction(-856, 1280, -4.0, 6.875, -10, 17), new Direction(-856, 1280, -4.5, 6.625, -12, 16), new Direction(-976, 1192, -4.875, 6.25, -13, 15), new Direction(-1088, 1088, -5.375, 5.875, -14, 14), new Direction(-1192, 976, -5.75, 5.5, -15, 13), new Direction(-1192, 976, -6.125, 5.0, -16, 12), new Direction(-1280, 856, -6.5, 4.5, -17, 11), new Direction(-1360, 720, -6.875, 4.0, -18, 10), new Direction(-1416, 584, -7.125, 3.5, -18, 8), new Direction(-1416, 584, -7.375, 3.0, -19, 7), new Direction(-1472, 440, -7.625, 2.5, -20, 6), new Direction(-1504, 296, -7.75, 1.875, -20, 4), new Direction(-1528, 152, -7.875, 1.375, -20, 3), new Direction(-1528, 152, -7.875, 0.75, -20, 1), new Direction(-1536, 0, -8.0, 0.125, -20, 0), new Direction(-1536, 0, -8.0, -0.375, -20, -1), new Direction(-1528, -152, -7.875, -1.0, -20, -3), new Direction(-1504, -296, -7.875, -1.625, -20, -5), new Direction(-1504, -296, -7.625, -2.125, -20, -6), new Direction(-1472, -440, -7.5, -2.75, -19, -7), new Direction(-1416, -584, -7.25, -3.25, -19, -9), new Direction(-1360, -720, -7.0, -3.75, -18, -10), new Direction(-1360, -720, -6.75, -4.25, -17, -11), new Direction(-1280, -856, -6.375, -4.75, -16, -12), new Direction(-1192, -976, -6.0, -5.25, -15, -14), new Direction(-1088, -1088, -5.625, -5.625, -15, -15), new Direction(-1088, -1088, -5.25, -6.0, -14, -15), new Direction(-976, -1192, -4.75, -6.375, -12, -16), new Direction(-856, -1280, -4.25, -6.75, -11, -17), new Direction(-720, -1360, -3.75, -7.0, -10, -18), new Direction(-720, -1360, -3.25, -7.25, -9, -19), new Direction(-584, -1416, -2.75, -7.5, -7, -19), new Direction(-440, -1472, -2.125, -7.625, -6, -20), new Direction(-296, -1504, -1.625, -7.875, -5, -20), new Direction(-296, -1504, -1.0, -7.875, -3, -20), new Direction(-152, -1528, -0.375, -8.0, -1, -20), new Direction(152, -1528, 0.125, -8.0, 0, -20), new Direction(152, -1528, 0.75, -7.875, 1, -20), new Direction(296, -1504, 1.375, -7.875, 3, -20), new Direction(440, -1472, 1.875, -7.75, 4, -20), new Direction(584, -1416, 2.5, -7.625, 6, -20), new Direction(584, -1416, 3.0, -7.375, 7, -19), new Direction(720, -1360, 3.5, -7.125, 8, -18), new Direction(856, -1280, 4.0, -6.875, 10, -18), new Direction(976, -1192, 4.5, -6.5, 11, -17), new Direction(976, -1192, 5.0, -6.125, 12, -16), new Direction(1088, -1088, 5.5, -5.75, 13, -15), new Direction(1192, -976, 5.875, -5.375, 14, -14), new Direction(1280, -856, 6.25, -4.875, 15, -13), new Direction(1280, -856, 6.625, -4.5, 16, -12), new Direction(1360, -720, 6.875, -4.0, 17, -10), new Direction(1416, -584, 7.125, -3.375, 17, -9), new Direction(1472, -440, 7.375, -2.875, 18, -8), new Direction(1472, -440, 7.625, -2.375, 19, -6), new Direction(1504, -296, 7.75, -1.75, 19, -5), new Direction(1528, -152, 7.875, -1.25, 19, -4), new Direction(1536, 0, 7.875, -0.625, 19, -2)};
    }

    public FrameInfo(int index, byte[] bytes, PingKeyProvider pinky, long receiveTime) throws IOException {
        this.index = index;
        if (bytes.length != 1026) {
            throw new IOException("Incorrect datagram with size " + bytes.length);
        }
        if ((bytes[1] & 0xF0) != 224) {
            throw new IOException(String.format("Incorrect vector buffer start: %02x%02x", bytes[0], bytes[1]));
        }
        this.receiveTime = receiveTime;
        this.id = bytes[1024];
        this.ping = bytes[1025];
        this.pingTime = this.ping != 0 && pinky != null ? receiveTime - pinky.getTimestampForPing(this.index, Tools.byteToUnsigned(this.ping)) : 0L;
        int vx = 0;
        int vy = 0;
        int vs = 0;
        int v1x = 0;
        int v1y = 0;
        int x1x = 0;
        int x1y = 0;
        int dx = 0;
        int dy = 0;
        int tx = 0;
        int ty = 0;
        int ts = 0;
        int astIdx = 0;
        int bullIdx = 0;
        int cmd = 0;
        int shipCommand = 0;
        boolean possibleShip = false;
        boolean copyrightRead = false;
        boolean possibleShipExplosion = false;
        StringBuilder stringCollect = new StringBuilder();
        int p = 2;
        while (p < 1024) {
            boolean addedLetter = false;
            int highbyte = Tools.byteToUnsigned(bytes[p + 1]);
            int opcode = highbyte & 0xF0;
            switch (opcode) {
                case 160: {
                    if (shipCommand > 0 && this.spaceShip != null) {
                        this.spaceShip.setThrusting(cmd - shipCommand > 3);
                        shipCommand = 0;
                    }
                    vy = (highbyte & 3) << 8 | Tools.byteToUnsigned(bytes[p]);
                    highbyte = Tools.byteToUnsigned(bytes[(p += 2) + 1]);
                    vx = (highbyte & 3) << 8 | Tools.byteToUnsigned(bytes[p]);
                    vs = highbyte >> 4;
                    p += 2;
                    if (vs != 0 || copyrightRead) break;
                    possibleShipExplosion = true;
                    break;
                }
                case 176: {
                    return;
                }
                case 192: {
                    int sub = (highbyte & 0xF) << 8 | Tools.byteToUnsigned(bytes[p]);
                    switch (sub) {
                        case 2291: {
                            this.asteroids.add(new Asteroid(astIdx++, vx, vy, vs, 0));
                            break;
                        }
                        case 2303: {
                            this.asteroids.add(new Asteroid(astIdx++, vx, vy, vs, 1));
                            break;
                        }
                        case 2317: {
                            this.asteroids.add(new Asteroid(astIdx++, vx, vy, vs, 2));
                            break;
                        }
                        case 2330: {
                            this.asteroids.add(new Asteroid(astIdx++, vx, vy, vs, 3));
                            break;
                        }
                        case 2345: {
                            this.ufo = new Ufo(vx, vy, vs);
                            break;
                        }
                        case 2176: {
                            this.explosions.add(new Explosion(vx, vy, vs, Explosion.Type.XXL));
                            possibleShipExplosion = false;
                            break;
                        }
                        case 2198: {
                            this.explosions.add(new Explosion(vx, vy, vs, Explosion.Type.XL));
                            possibleShipExplosion = false;
                            break;
                        }
                        case 2229: {
                            this.explosions.add(new Explosion(vx, vy, vs, Explosion.Type.L));
                            possibleShipExplosion = false;
                            break;
                        }
                        case 2256: {
                            this.explosions.add(new Explosion(vx, vy, vs, Explosion.Type.S));
                            possibleShipExplosion = false;
                            break;
                        }
                        case 2669: {
                            ++this.nrShips;
                            break;
                        }
                        case 2130: {
                            copyrightRead = true;
                            break;
                        }
                        default: {
                            Character ch = CHAR_MAP.get(sub);
                            if (ch == null) break;
                            stringCollect.append(ch);
                            if (addedLetter) break;
                            addedLetter = true;
                            tx = vx;
                            ty = vy;
                            ts = vs;
                        }
                    }
                    p += 2;
                    break;
                }
                case 208: {
                    return;
                }
                case 224: {
                    return;
                }
                case 240: {
                    int lowbyte;
                    int z;
                    if (this.shipExplosion != null && (z = (lowbyte = Tools.byteToUnsigned(bytes[p])) >> 4 & 0xF) != 0) {
                        int y = (highbyte & 3) << 8;
                        if ((highbyte & 4) != 0) {
                            y = -y;
                        }
                        int x = (lowbyte & 3) << 8;
                        if ((lowbyte & 4) != 0) {
                            x = -x;
                        }
                        int scale = highbyte >> 3 & 1 | lowbyte >> 2 & 2;
                        int div = 16 << 3 - scale;
                        this.shipExplosion.addLine(x1x, x1y, x / div, y / div);
                    }
                    p += 2;
                    break;
                }
                default: {
                    if (this.spaceShip == null) {
                        dy = (highbyte & 3) << 8 | Tools.byteToUnsigned(bytes[p]);
                        if ((highbyte & 4) != 0) {
                            dy = -dy;
                        }
                        int scale = highbyte >> 4;
                        highbyte = Tools.byteToUnsigned(bytes[(p += 2) + 1]);
                        dx = (highbyte & 3) << 8 | Tools.byteToUnsigned(bytes[p]);
                        if ((highbyte & 4) != 0) {
                            dx = -dx;
                        }
                        int vz = highbyte >> 4;
                        if (dx == 0 && dy == 0 && vz == 15) {
                            this.bullets.add(new Bullet(bullIdx++, vx, vy));
                            possibleShipExplosion = false;
                            this.shipExplosion = null;
                        }
                        if (dx != 0 && dy != 0) {
                            if (opcode == 96 && vz == 12) {
                                if (possibleShip) {
                                    if (this.spaceShip == null) {
                                        this.spaceShip = new SpaceShip(vx, vy, v1x - dx, v1y - dy);
                                        shipCommand = cmd;
                                    }
                                    possibleShip = false;
                                } else {
                                    v1x = dx;
                                    v1y = dy;
                                    possibleShip = true;
                                }
                            } else if (!possibleShip && possibleShipExplosion) {
                                if (this.shipExplosion == null) {
                                    this.shipExplosion = new ShipExplosion(vx, vy);
                                }
                                int div = 1 << 9 - scale;
                                x1x = dx / div;
                                x1y = dy / div;
                            }
                        } else if (possibleShip) {
                            possibleShip = false;
                        }
                        p += 2;
                        break;
                    }
                    p += 4;
                }
            }
            if (!addedLetter && stringCollect.length() > 0) {
                String str = stringCollect.toString();
                this.texts.add(new Text(str, tx, ty, ts));
                stringCollect.setLength(0);
                if (tx == FrameInfo.SCORE_LOCATION_GAME.x && ty == FrameInfo.SCORE_LOCATION_GAME.y || tx == FrameInfo.SCORE_LOCATION_OTHER.x && ty == FrameInfo.SCORE_LOCATION_OTHER.y) {
                    this.score = FrameInfo.extractNumber(str);
                } else if (tx == FrameInfo.HIGHSCORE_LOCATION.x && ty == FrameInfo.HIGHSCORE_LOCATION.y) {
                    this.highscore = FrameInfo.extractNumber(str);
                } else if (tx == FrameInfo.SONIRT_LOCATION.x && ty == FrameInfo.SONIRT_LOCATION.y) {
                    this.sonirt = FrameInfo.extractNumber(str);
                } else if (GAME_END_STRING.equals(str)) {
                    this.gameEndDisplayed = true;
                } else if (GAME_START_STRING.equals(str)) {
                    this.gameStartDisplayed = true;
                } else if (PLAYER1_STRING.equals(str)) {
                    this.player1Displayed = true;
                }
            }
            ++cmd;
        }
    }

    private static int extractNumber(String str) {
        try {
            return Integer.parseInt(str.trim());
        }
        catch (NumberFormatException x) {
            return -1;
        }
    }

    public void draw(Graphics2D g) {
        for (Asteroid asteroid : this.asteroids) {
            asteroid.draw(g);
        }
        if (this.ufo != null) {
            this.ufo.draw(g);
        }
        if (this.spaceShip != null) {
            this.spaceShip.draw(g);
        }
        if (this.shipExplosion != null) {
            this.shipExplosion.draw(g);
        }
        for (Bullet bullet : this.bullets) {
            bullet.draw(g);
        }
        for (Explosion explode : this.explosions) {
            explode.draw(g);
        }
    }

    public byte getId() {
        return this.id;
    }

    public int getPing() {
        return Tools.byteToUnsigned(this.ping);
    }

    public long getPingTime() {
        return this.pingTime;
    }

    public long getReceiveTime() {
        return this.receiveTime;
    }

    public Ufo getUfo() {
        return this.ufo;
    }

    public int getAsteroidCount() {
        return this.asteroids.size();
    }

    public int getBulletCount() {
        return this.bullets.size();
    }

    public int getTargetCount() {
        return this.ufo != null ? this.getAsteroidCount() + 1 : this.getAsteroidCount();
    }

    public Collection<Asteroid> getAsteroids() {
        return Collections.unmodifiableCollection(this.asteroids);
    }

    public SpaceShip getSpaceShip() {
        return this.spaceShip;
    }

    public boolean isSpaceShipDisplayed() {
        return this.spaceShip != null;
    }

    public Collection<Bullet> getBullets() {
        return Collections.unmodifiableCollection(this.bullets);
    }

    public Collection<Explosion> getExplosions() {
        return Collections.unmodifiableCollection(this.explosions);
    }

    public int getHighscore() {
        return this.highscore;
    }

    public void setHighscore(int highscore) {
        this.highscore = highscore;
    }

    public int getScore() {
        return this.score;
    }

    public void setScore(int score) {
        this.score = score;
    }

    public int getSonirt() {
        return this.sonirt;
    }

    public boolean isGameRunning() {
        return this.sonirt == -1;
    }

    public int getNrShips() {
        return this.nrShips;
    }

    public boolean isGameStartDisplayed() {
        return this.gameStartDisplayed;
    }

    public boolean isGameEndDisplayed() {
        return this.gameEndDisplayed;
    }

    public boolean isPlayer1Displayed() {
        return this.player1Displayed;
    }

    public Collection<Text> getTexts() {
        return Collections.unmodifiableCollection(this.texts);
    }

    public int getIndex() {
        return this.index;
    }

    public static String canonize(String str) {
        if (str != null) {
            str = str.toUpperCase();
            StringBuilder result = new StringBuilder();
            char[] cArray = str.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char ch = cArray[n2];
                if (ch == 'O') {
                    result.append('0');
                } else if (CHAR_MAP.values().contains(Character.valueOf(ch))) {
                    result.append(ch);
                } else {
                    result.append(' ');
                }
                ++n2;
            }
            return result.toString();
        }
        return null;
    }

    public Collection<GameObject> getGameObjects() {
        ArrayList<GameObject> result = new ArrayList<GameObject>(this.asteroids.size() + this.bullets.size() + this.texts.size() + this.explosions.size() + 2);
        if (this.spaceShip != null) {
            result.add(this.spaceShip);
        }
        if (this.shipExplosion != null) {
            result.add(this.shipExplosion);
        }
        if (this.ufo != null) {
            result.add(this.ufo);
        }
        result.addAll(this.asteroids);
        result.addAll(this.bullets);
        result.addAll(this.explosions);
        result.addAll(this.texts);
        return result;
    }

    public Collection<MovingGameObject> getMovingGameObjects() {
        ArrayList<MovingGameObject> result = new ArrayList<MovingGameObject>(this.asteroids.size() + this.bullets.size() + 2);
        if (this.spaceShip != null) {
            result.add(this.spaceShip);
        }
        if (this.ufo != null) {
            result.add(this.ufo);
        }
        result.addAll(this.asteroids);
        result.addAll(this.bullets);
        return result;
    }

    public Collection<GameObject> getOverlappingObjects(Rectangle hitRect) {
        LinkedList<GameObject> result = new LinkedList<GameObject>();
        for (GameObject go : this.getGameObjects()) {
            if (!go.isOverlappingWith(hitRect)) continue;
            result.add(go);
        }
        return result;
    }

    public Direction getShootingDirection() {
        return SHOOTING_DIRECTIONS[Tools.byteToUnsigned(this.shootingDir)];
    }

    public Direction getNextShootingDirection() {
        return SHOOTING_DIRECTIONS[Tools.byteToUnsigned(this.nextShootingDir)];
    }

    public void turnNextShootingDirectionLeft() {
        this.nextShootingDir = (byte)(this.nextShootingDir + 1);
    }

    public void turnNextShootingDirectionRight() {
        this.nextShootingDir = (byte)(this.nextShootingDir - 1);
    }

    public void inheritShootingDirectionsFrom(FrameInfo prevFrame) {
        this.shootingDir = this.nextShootingDir = prevFrame.getNextShootingDirectionLowLevel();
    }

    public void setNextShootingDirectionLowLevel(byte shootingDir) {
        this.nextShootingDir = shootingDir;
    }

    public byte getNextShootingDirectionLowLevel() {
        return this.nextShootingDir;
    }

    public byte getShootingDirectionLowLevel() {
        return this.shootingDir;
    }

    public void setShootingDirectionLowLevel(byte shootingDir) {
        this.shootingDir = shootingDir;
    }

    public void setBothShootingDirectionsLowLevel(byte shootingDir) {
        this.shootingDir = this.nextShootingDir = shootingDir;
    }

    @Override
    public Collection<Property> getProperties() {
        LinkedList<Property> props = new LinkedList<Property>();
        props.add(new Property<String>("Type", "Frame"));
        props.add(new Property<Integer>("Index", this.getIndex()));
        props.add(new Property<Integer>("MAME ID", Tools.byteToUnsigned(this.id)));
        props.add(new Property<Integer>("Ping ID", Tools.byteToUnsigned(this.ping)));
        props.add(new Property<Long>("Receive Time", this.receiveTime));
        props.add(new Property<Long>("Ping Time", this.pingTime));
        props.add(new Property<Integer>("Score", this.score));
        props.add(new Property<Integer>("High Score", this.highscore));
        props.add(new Property<Integer>("Some Other Number In Right Top", this.sonirt));
        props.add(new Property<Boolean>("'Game Start' Displayed?", this.gameStartDisplayed));
        props.add(new Property<Boolean>("'Player 1' Displayed?", this.player1Displayed));
        props.add(new Property<Boolean>("'Game End' Displayed?", this.gameEndDisplayed));
        props.add(new Property<Integer>("Number of Ships in Reserve", this.nrShips));
        props.add(new Property<Integer>("Number of Asteroids", this.asteroids.size()));
        props.add(new Property<Integer>("Number of Bullets", this.bullets.size()));
        props.add(new Property<Integer>("Number of Explosions", this.explosions.size()));
        props.add(new Property<Integer>("Number of Texts", this.texts.size()));
        props.add(new Property<Boolean>("Space Ship displayed?", this.spaceShip != null));
        props.add(new Property<Boolean>("Ufo displayed?", this.ufo != null));
        props.add(new Property<Direction>("Shooting direction", SHOOTING_DIRECTIONS[Tools.byteToUnsigned(this.shootingDir)]));
        props.add(new Property<Object>("Ship direction", (this.spaceShip != null ? this.spaceShip.getDirection() : null)));
        return props;
    }

    public String toString() {
        return "FrameInfo#" + this.getIndex();
    }

    public static void main(String[] args) {
        int i = 0;
        while (i < SHOOTING_DIRECTIONS.length) {
            Direction d = SHOOTING_DIRECTIONS[i];
            double angle = 57.29577951308232 * Math.atan2(d.getBulletVelocity().getY(), d.getBulletVelocity().getX());
            if (angle < 0.0) {
                angle += 360.0;
            }
            System.out.println(String.format("%3d: %3.1f", i, angle));
            ++i;
        }
    }

    public static class Direction {
        private Point shipDirection;
        private Point2D bulletVelocity;
        private Point displacement;

        private Direction(int sx, int sy, double bx, double by, int dx, int dy) {
            this.shipDirection = new Point(sx, sy);
            this.bulletVelocity = new Point2D.Double(bx, by);
            this.displacement = new Point(dx, dy);
        }

        public Point getShipDirection() {
            return this.shipDirection;
        }

        public Point2D getBulletVelocity() {
            return this.bulletVelocity;
        }

        public Point getDisplacement() {
            return this.displacement;
        }

        public String toString() {
            return String.format("Direction(%d, %d, %1.3f, %1.3f, %d, %d)", this.shipDirection.x, this.shipDirection.y, this.bulletVelocity.getX(), this.bulletVelocity.getY(), this.displacement.x, this.displacement.y);
        }
    }
}

