/*
 * Decompiled with CFR 0.152.
 */
package de.caff.i18n.swing;

import de.caff.i18n.I18n;
import de.caff.i18n.Localizable;
import java.awt.IllegalComponentStateException;
import java.util.Locale;
import javax.swing.JFrame;

public class RJFrame
extends JFrame
implements Localizable {
    protected String titleRes = null;

    public RJFrame() {
    }

    public RJFrame(String titleRes, Locale l) {
        super(I18n.getString(titleRes, l));
        this.setLocale(l);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        I18n.addLocalizationChangeListener(this);
    }

    @Override
    public void removeNotify() {
        I18n.removeLocalizationChangeListener(this);
        super.removeNotify();
    }

    public void setTitleTag(String tag) {
        this.titleRes = tag;
        if (tag != null) {
            this.setTitle(I18n.getString(tag, this.getLocale()));
        }
    }

    @Override
    public void setLocale(Locale l) {
        Locale oldLocale = this.getLocale();
        super.setLocale(l);
        if (oldLocale != null && !oldLocale.equals(l)) {
            if (this.titleRes != null) {
                this.setTitle(I18n.getString(this.titleRes, l));
            }
            this.validateTree();
        }
    }

    @Override
    public Locale getLocale() {
        try {
            return super.getLocale();
        }
        catch (IllegalComponentStateException x) {
            return null;
        }
    }
}

