/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.debug;

import de.caff.util.Utility;
import de.caff.util.debug.AnyMessageDebugListener;
import de.caff.util.debug.AssertionFailedError;
import de.caff.util.debug.AssertionMessageDebugListener;
import de.caff.util.debug.CookedMessageDebugListener;
import de.caff.util.debug.DebugConstants;
import de.caff.util.debug.DebugMessageCook;
import de.caff.util.debug.DebuggingOutputStream;
import de.caff.util.debug.ErrorMessageDebugListener;
import de.caff.util.debug.FatalMessageDebugListener;
import de.caff.util.debug.FilteringDebugMessageWindow;
import de.caff.util.debug.Format;
import de.caff.util.debug.LogMessageListener;
import de.caff.util.debug.ObjectInspector;
import de.caff.util.debug.SimpleOutputtingDebugListener;
import de.caff.util.debug.StandardMessageDebugListener;
import de.caff.util.debug.TraceMessageDebugListener;
import de.caff.util.debug.WarningMessageDebugListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.StringCharacterIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JFrame;

public class Debug
implements DebugConstants {
    public static final String PARAM_DEBUG_SHOW_WINDOW = "debug.show.window";
    public static final String PARAM_DEBUG_PRINT_CONSOLE = "debug.print.console";
    public static final String PARAM_DEBUG_MASK = "debug.mask";
    private static long _mask = 0L;
    private static boolean _bufferStreams = false;
    private static DebugMessageCook _cook = new DebugMessageCook();
    private static Collection<TraceMessageDebugListener> _traceList = new LinkedList<TraceMessageDebugListener>();
    private static Collection<StandardMessageDebugListener> _stdList = new LinkedList<StandardMessageDebugListener>();
    private static Collection<WarningMessageDebugListener> _warnList = new LinkedList<WarningMessageDebugListener>();
    private static Collection<ErrorMessageDebugListener> _errorList = new LinkedList<ErrorMessageDebugListener>();
    private static Collection<FatalMessageDebugListener> _fatalList = new LinkedList<FatalMessageDebugListener>();
    private static Collection<AssertionMessageDebugListener> _assertList = new LinkedList<AssertionMessageDebugListener>();
    private static Collection<LogMessageListener> _logList = new LinkedList<LogMessageListener>();
    private static Collection<ModeChangeListener> _modeList = new LinkedList<ModeChangeListener>();
    private static PrintStream _oldStdout = null;
    private static StringBuffer _collectedStdout = null;
    private static PrintStream _oldStderr = null;
    private static StringBuffer _collectedStderr = null;

    static {
        Debug.addAnyMessageDebugListener(_cook);
    }

    public static void addModeChangeListener(ModeChangeListener listener) {
        _modeList.add(listener);
    }

    public static void removeModeChangeListener(ModeChangeListener listener) {
        _modeList.remove(listener);
    }

    private static void informModeChangeListeners(int modeID, boolean state) {
        Iterator<ModeChangeListener> it = _modeList.iterator();
        while (it.hasNext()) {
            it.next().modeChanged(modeID, state);
        }
    }

    private static void informStdoutCaptureModeListeners(boolean state) {
        Iterator<ModeChangeListener> it = _modeList.iterator();
        while (it.hasNext()) {
            it.next().stdoutCaptureChanged(state);
        }
    }

    private static void informStderrCaptureModeListeners(boolean state) {
        Iterator<ModeChangeListener> it = _modeList.iterator();
        while (it.hasNext()) {
            it.next().stderrCaptureChanged(state);
        }
    }

    public static void addTraceMessageDebugListener(TraceMessageDebugListener listener) {
        _traceList.add(listener);
    }

    public static void removeTraceMessageDebugListener(TraceMessageDebugListener listener) {
        _traceList.remove(listener);
    }

    public static void addStandardMessageDebugListener(StandardMessageDebugListener listener) {
        _stdList.add(listener);
    }

    public static void removeStandardMessageDebugListener(StandardMessageDebugListener listener) {
        _stdList.remove(listener);
    }

    public static void addWarningMessageDebugListener(WarningMessageDebugListener listener) {
        _warnList.add(listener);
    }

    public static void removeWarningMessageDebugListener(WarningMessageDebugListener listener) {
        _warnList.remove(listener);
    }

    public static void addErrorMessageDebugListener(ErrorMessageDebugListener listener) {
        _errorList.add(listener);
    }

    public static void removeErrorMessageDebugListener(ErrorMessageDebugListener listener) {
        _errorList.remove(listener);
    }

    public static void addFatalMessageDebugListener(FatalMessageDebugListener listener) {
        _fatalList.add(listener);
    }

    public static void removeFatalMessageDebugListener(FatalMessageDebugListener listener) {
        _fatalList.remove(listener);
    }

    public static void addAssertionMessageDebugListener(AssertionMessageDebugListener listener) {
        _assertList.add(listener);
    }

    public static void removeAssertionMessageDebugListener(AssertionMessageDebugListener listener) {
        _assertList.remove(listener);
    }

    public static void addLogMessageListener(LogMessageListener listener) {
        _logList.add(listener);
    }

    public static void removeLogMessageListener(LogMessageListener listener) {
        _logList.remove(listener);
    }

    public static void addCookedMessageDebugListener(CookedMessageDebugListener listener) {
        _cook.addListener(listener);
    }

    public static void removeCookedMessageDebugListener(CookedMessageDebugListener listener) {
        _cook.removeListener(listener);
    }

    public static void addAnyMessageDebugListener(AnyMessageDebugListener listener) {
        Debug.addTraceMessageDebugListener(listener);
        Debug.addStandardMessageDebugListener(listener);
        Debug.addWarningMessageDebugListener(listener);
        Debug.addErrorMessageDebugListener(listener);
        Debug.addFatalMessageDebugListener(listener);
        Debug.addAssertionMessageDebugListener(listener);
        Debug.addLogMessageListener(listener);
    }

    public static void removeAnyMessageDebugListener(AnyMessageDebugListener listener) {
        Debug.removeTraceMessageDebugListener(listener);
        Debug.removeStandardMessageDebugListener(listener);
        Debug.removeWarningMessageDebugListener(listener);
        Debug.removeErrorMessageDebugListener(listener);
        Debug.removeFatalMessageDebugListener(listener);
        Debug.removeAssertionMessageDebugListener(listener);
        Debug.removeLogMessageListener(listener);
    }

    public static void setMask(long mask) {
        if (mask != _mask) {
            long diff = _mask ^ mask;
            int i = 0;
            while (i < 64) {
                if ((1L << i & diff) != 0L) {
                    Debug.informModeChangeListeners(i, (mask & 1L << i) != 0L);
                }
                ++i;
            }
            _mask = mask;
        }
    }

    public static long getMask() {
        return _mask;
    }

    public static void setTraceMode(boolean mode) {
        if (Debug.getTraceMode() != mode) {
            _mask = mode ? (_mask |= 1L) : (_mask &= 0xFFFFFFFFFFFFFFFEL);
            Debug.informModeChangeListeners(0, mode);
        }
    }

    public static boolean getTraceMode() {
        return (_mask & 1L) != 0L;
    }

    public static void setStandardMode(boolean mode) {
        if (Debug.getStandardMode() != mode) {
            _mask = mode ? (_mask |= 2L) : (_mask &= 0xFFFFFFFFFFFFFFFDL);
            Debug.informModeChangeListeners(1, mode);
        }
    }

    public static boolean getStandardMode() {
        return (_mask & 2L) != 0L;
    }

    public static void setWarningMode(boolean mode) {
        if (Debug.getWarningMode() != mode) {
            _mask = mode ? (_mask |= 4L) : (_mask &= 0xFFFFFFFFFFFFFFFBL);
            Debug.informModeChangeListeners(2, mode);
        }
    }

    public static boolean getWarningMode() {
        return (_mask & 4L) != 0L;
    }

    public static void setErrorMode(boolean mode) {
        if (Debug.getErrorMode() != mode) {
            _mask = mode ? (_mask |= 8L) : (_mask &= 0xFFFFFFFFFFFFFFF7L);
            Debug.informModeChangeListeners(3, mode);
        }
    }

    public static boolean getErrorMode() {
        return (_mask & 8L) != 0L;
    }

    public static void setLogMode(boolean mode) {
        if (Debug.getLogMode() != mode) {
            _mask = mode ? (_mask |= 0x20L) : (_mask &= 0xFFFFFFFFFFFFFFDFL);
            Debug.informModeChangeListeners(5, mode);
        }
    }

    public static boolean getLogMode() {
        return (_mask & 0x20L) != 0L;
    }

    public static void setFatalMode(boolean mode) {
        if (Debug.getFatalMode() != mode) {
            _mask = mode ? (_mask |= 0x10L) : (_mask &= 0xFFFFFFFFFFFFFFEFL);
            Debug.informModeChangeListeners(4, mode);
        }
    }

    public static boolean getFatalMode() {
        return (_mask & 0x10L) != 0L;
    }

    public static void setAssertionMode(boolean mode) {
        if (Debug.getAssertionMode() != mode) {
            _mask = mode ? (_mask |= 0x40L) : (_mask &= 0xFFFFFFFFFFFFFFBFL);
            Debug.informModeChangeListeners(6, mode);
        }
    }

    public static boolean getAssertionMode() {
        return (_mask & 0x40L) != 0L;
    }

    private static void distributeTraceMessage(String msg) {
        Debug.sendCollectedStreams();
        Iterator<TraceMessageDebugListener> it = _traceList.iterator();
        while (it.hasNext()) {
            it.next().receiveTraceMessage(msg, Debug.getCallerPosition());
        }
    }

    private static void distributeStandardMessage(String msg) {
        Debug.sendCollectedStreams();
        Iterator<StandardMessageDebugListener> it = _stdList.iterator();
        while (it.hasNext()) {
            it.next().receiveStandardMessage(msg, Debug.getCallerPosition());
        }
    }

    private static void distributeWarningMessage(String msg) {
        Debug.sendCollectedStreams();
        Iterator<WarningMessageDebugListener> it = _warnList.iterator();
        while (it.hasNext()) {
            it.next().receiveWarningMessage(msg, Debug.getCallerPosition());
        }
    }

    private static void distributeErrorMessage(String msg) {
        Debug.sendCollectedStreams();
        Iterator<ErrorMessageDebugListener> it = _errorList.iterator();
        while (it.hasNext()) {
            it.next().receiveErrorMessage(msg, Debug.getCallerPosition());
        }
    }

    private static void distributeLogMessage(String msg) {
        Debug.sendCollectedStreams();
        Iterator<LogMessageListener> it = _logList.iterator();
        while (it.hasNext()) {
            it.next().receiveLogMessage(msg, Debug.getCallerPosition());
        }
    }

    private static void distributeFatalMessage(String msg) {
        Debug.sendCollectedStreams();
        int ret = 0;
        Iterator<FatalMessageDebugListener> it = _fatalList.iterator();
        while (it.hasNext()) {
            int retVal = it.next().receiveFatalMessage(msg, Debug.getCallerPosition());
            if (ret != 0 || retVal == 0) continue;
            ret = retVal;
        }
        if (ret != 0) {
            System.exit(ret);
        }
    }

    private static boolean distributeAssertionMessage(String msg) {
        Debug.sendCollectedStreams();
        boolean ret = false;
        Iterator<AssertionMessageDebugListener> it = _assertList.iterator();
        while (it.hasNext()) {
            boolean retVal = it.next().receiveFailedAssertionMessage(msg, Debug.getCallerPosition());
            if (ret || !retVal) continue;
            ret = retVal;
        }
        return ret;
    }

    public static void trace(String msg) {
        if ((_mask & 1L) != 0L) {
            Debug.distributeTraceMessage(msg);
        }
    }

    public static void trace(Throwable x) {
        if ((_mask & 1L) != 0L) {
            Debug.distributeTraceMessage(Debug.getStackDump(x));
        }
    }

    public static void trace(Object obj) {
        if ((_mask & 1L) != 0L) {
            Debug.distributeTraceMessage(Format.toString(obj));
        }
    }

    public static void trace(String msg, Object arg1) {
        if ((_mask & 1L) != 0L) {
            Debug.distributeTraceMessage(Format.format((Object)msg, arg1));
        }
    }

    public static void trace(String msg, Object arg1, Object arg2) {
        if ((_mask & 1L) != 0L) {
            Debug.distributeTraceMessage(Format.format((Object)msg, arg1, arg2));
        }
    }

    public static void trace(String msg, Object arg1, Object arg2, Object arg3) {
        if ((_mask & 1L) != 0L) {
            Debug.distributeTraceMessage(Format.format((Object)msg, arg1, arg2, arg3));
        }
    }

    public static void trace(String msg, Object arg1, Object arg2, Object arg3, Object arg4) {
        if ((_mask & 1L) != 0L) {
            Debug.distributeTraceMessage(Format.format((Object)msg, arg1, arg2, arg3, arg4));
        }
    }

    public static void trace(String msg, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        if ((_mask & 1L) != 0L) {
            Debug.distributeTraceMessage(Format.format((Object)msg, arg1, arg2, arg3, arg4, arg5));
        }
    }

    public static void trace(String msg, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) {
        if ((_mask & 1L) != 0L) {
            Debug.distributeTraceMessage(Format.format((Object)msg, arg1, arg2, arg3, arg4, arg5, arg6));
        }
    }

    public static void trace(String msg, Object ... args) {
        if ((_mask & 1L) != 0L) {
            Debug.distributeTraceMessage(Format.format((Object)msg, args));
        }
    }

    public static void message(String msg) {
        if ((_mask & 2L) != 0L) {
            Debug.distributeStandardMessage(msg);
        }
    }

    public static void message(Throwable x) {
        if ((_mask & 1L) != 0L) {
            Debug.distributeStandardMessage(Debug.getStackDump(x));
        }
    }

    public static void message(Object obj) {
        if ((_mask & 2L) != 0L) {
            Debug.distributeStandardMessage(Format.toString(obj));
        }
    }

    public static void message(String msg, Object arg1) {
        if ((_mask & 2L) != 0L) {
            Debug.distributeStandardMessage(Format.format((Object)msg, arg1));
        }
    }

    public static void message(String msg, Object arg1, Object arg2) {
        if ((_mask & 2L) != 0L) {
            Debug.distributeStandardMessage(Format.format((Object)msg, arg1, arg2));
        }
    }

    public static void message(String msg, Object arg1, Object arg2, Object arg3) {
        if ((_mask & 2L) != 0L) {
            Debug.distributeStandardMessage(Format.format((Object)msg, arg1, arg2, arg3));
        }
    }

    public static void message(String msg, Object arg1, Object arg2, Object arg3, Object arg4) {
        if ((_mask & 2L) != 0L) {
            Debug.distributeStandardMessage(Format.format((Object)msg, arg1, arg2, arg3, arg4));
        }
    }

    public static void message(String msg, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        if ((_mask & 2L) != 0L) {
            Debug.distributeStandardMessage(Format.format((Object)msg, arg1, arg2, arg3, arg4, arg5));
        }
    }

    public static void message(String msg, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) {
        if ((_mask & 2L) != 0L) {
            Debug.distributeStandardMessage(Format.format((Object)msg, arg1, arg2, arg3, arg4, arg5, arg6));
        }
    }

    public static void message(String msg, Object ... args) {
        if ((_mask & 2L) != 0L) {
            Debug.distributeStandardMessage(Format.format((Object)msg, args));
        }
    }

    public static void warn(String msg) {
        if ((_mask & 4L) != 0L) {
            Debug.distributeWarningMessage(msg);
        }
    }

    public static void warn(Throwable x) {
        if ((_mask & 4L) != 0L) {
            Debug.distributeWarningMessage(Debug.getStackDump(x));
        }
    }

    public static void warn(Object obj) {
        if ((_mask & 4L) != 0L) {
            Debug.distributeWarningMessage(Format.toString(obj));
        }
    }

    public static void warn(String msg, Object arg1) {
        if ((_mask & 4L) != 0L) {
            Debug.distributeWarningMessage(Format.format((Object)msg, arg1));
        }
    }

    public static void warn(String msg, Object arg1, Object arg2) {
        if ((_mask & 4L) != 0L) {
            Debug.distributeWarningMessage(Format.format((Object)msg, arg1, arg2));
        }
    }

    public static void warn(String msg, Object arg1, Object arg2, Object arg3) {
        if ((_mask & 4L) != 0L) {
            Debug.distributeWarningMessage(Format.format((Object)msg, arg1, arg2, arg3));
        }
    }

    public static void warn(String msg, Object arg1, Object arg2, Object arg3, Object arg4) {
        if ((_mask & 4L) != 0L) {
            Debug.distributeWarningMessage(Format.format((Object)msg, arg1, arg2, arg3, arg4));
        }
    }

    public static void warn(String msg, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        if ((_mask & 4L) != 0L) {
            Debug.distributeWarningMessage(Format.format((Object)msg, arg1, arg2, arg3, arg4, arg5));
        }
    }

    public static void warn(String msg, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) {
        if ((_mask & 4L) != 0L) {
            Debug.distributeWarningMessage(Format.format((Object)msg, arg1, arg2, arg3, arg4, arg5, arg6));
        }
    }

    public static void warn(String msg, Object ... args) {
        if ((_mask & 4L) != 0L) {
            Debug.distributeWarningMessage(Format.format((Object)msg, args));
        }
    }

    public static void error(String msg) {
        if ((_mask & 8L) != 0L) {
            Debug.distributeErrorMessage(msg);
        }
    }

    public static void error(Throwable x) {
        if ((_mask & 8L) != 0L) {
            Debug.distributeErrorMessage(Debug.getStackDump(x));
        }
    }

    public static void error(Object obj) {
        if ((_mask & 8L) != 0L) {
            Debug.distributeErrorMessage(Format.toString(obj));
        }
    }

    public static void error(String msg, Object arg1) {
        if ((_mask & 8L) != 0L) {
            Debug.distributeErrorMessage(Format.format((Object)msg, arg1));
        }
    }

    public static void error(String msg, Object arg1, String arg2) {
        if ((_mask & 8L) != 0L) {
            Debug.distributeErrorMessage(Format.format((Object)msg, arg1, (Object)arg2));
        }
    }

    public static void error(String msg, Object arg1, Object arg2, Object arg3) {
        if ((_mask & 8L) != 0L) {
            Debug.distributeErrorMessage(Format.format((Object)msg, arg1, arg2, arg3));
        }
    }

    public static void error(String msg, Object arg1, Object arg2, Object arg3, Object arg4) {
        if ((_mask & 8L) != 0L) {
            Debug.distributeErrorMessage(Format.format((Object)msg, arg1, arg2, arg3, arg4));
        }
    }

    public static void error(String msg, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        if ((_mask & 8L) != 0L) {
            Debug.distributeErrorMessage(Format.format((Object)msg, arg1, arg2, arg3, arg4, arg5));
        }
    }

    public static void error(String msg, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) {
        if ((_mask & 8L) != 0L) {
            Debug.distributeErrorMessage(Format.format((Object)msg, arg1, arg2, arg3, arg4, arg5, arg6));
        }
    }

    public static void error(String msg, Object ... args) {
        if ((_mask & 8L) != 0L) {
            Debug.distributeErrorMessage(Format.format((Object)msg, args));
        }
    }

    public static void fatal(String msg) {
        if ((_mask & 0x10L) != 0L) {
            Debug.distributeFatalMessage(msg);
        }
    }

    public static void fatal(Throwable x) {
        if ((_mask & 0x10L) != 0L) {
            Debug.distributeFatalMessage(Debug.getStackDump(x));
        }
    }

    public static void fatal(Object obj) {
        if ((_mask & 0x10L) != 0L) {
            Debug.distributeFatalMessage(Format.toString(obj));
        }
    }

    public static void fatal(String msg, Object arg1) {
        if ((_mask & 0x10L) != 0L) {
            Debug.distributeFatalMessage(Format.format((Object)msg, arg1));
        }
    }

    public static void fatal(String msg, Object arg1, Object arg2) {
        if ((_mask & 0x10L) != 0L) {
            Debug.distributeFatalMessage(Format.format((Object)msg, arg1, arg2));
        }
    }

    public static void fatal(String msg, Object arg1, Object arg2, Object arg3) {
        if ((_mask & 0x10L) != 0L) {
            Debug.distributeFatalMessage(Format.format((Object)msg, arg1, arg2, arg3));
        }
    }

    public static void fatal(String msg, Object arg1, Object arg2, Object arg3, Object arg4) {
        if ((_mask & 0x10L) != 0L) {
            Debug.distributeFatalMessage(Format.format((Object)msg, arg1, arg2, arg3, arg4));
        }
    }

    public static void fatal(String msg, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        if ((_mask & 0x10L) != 0L) {
            Debug.distributeFatalMessage(Format.format((Object)msg, arg1, arg2, arg3, arg4, arg5));
        }
    }

    public static void fatal(String msg, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) {
        if ((_mask & 0x10L) != 0L) {
            Debug.distributeFatalMessage(Format.format((Object)msg, arg1, arg2, arg3, arg4, arg5, arg6));
        }
    }

    public static void fatal(String msg, Object ... args) {
        if ((_mask & 0x10L) != 0L) {
            Debug.distributeFatalMessage(Format.format((Object)msg, args));
        }
    }

    public static void log(String msg) {
        if ((_mask & 0x20L) != 0L) {
            Debug.distributeLogMessage(msg);
        }
    }

    public static void log(Throwable x) {
        if ((_mask & 0x20L) != 0L) {
            Debug.distributeLogMessage(Debug.getStackDump(x));
        }
    }

    public static void log(Object obj) {
        if ((_mask & 0x20L) != 0L) {
            Debug.distributeLogMessage(Format.toString(obj));
        }
    }

    public static void log(String msg, Object arg1) {
        if ((_mask & 0x20L) != 0L) {
            Debug.distributeLogMessage(Format.format((Object)msg, arg1));
        }
    }

    public static void log(String msg, Object arg1, Object arg2) {
        if ((_mask & 0x20L) != 0L) {
            Debug.distributeLogMessage(Format.format((Object)msg, arg1, arg2));
        }
    }

    public static void log(String msg, Object arg1, Object arg2, Object arg3) {
        if ((_mask & 0x20L) != 0L) {
            Debug.distributeLogMessage(Format.format((Object)msg, arg1, arg2, arg3));
        }
    }

    public static void log(String msg, Object arg1, Object arg2, Object arg3, Object arg4) {
        if ((_mask & 0x20L) != 0L) {
            Debug.distributeLogMessage(Format.format((Object)msg, arg1, arg2, arg3, arg4));
        }
    }

    public static void log(String msg, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        if ((_mask & 0x20L) != 0L) {
            Debug.distributeLogMessage(Format.format((Object)msg, arg1, arg2, arg3, arg4, arg5));
        }
    }

    public static void log(String msg, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) {
        if ((_mask & 0x20L) != 0L) {
            Debug.distributeLogMessage(Format.format((Object)msg, arg1, arg2, arg3, arg4, arg5, arg6));
        }
    }

    public static void log(String msg, Object ... args) {
        if ((_mask & 0x20L) != 0L) {
            Debug.distributeLogMessage(Format.format((Object)msg, args));
        }
    }

    public static void insist(boolean condition) {
        if (!condition && (_mask & 0x40L) != 0L && Debug.distributeAssertionMessage(null)) {
            throw new AssertionFailedError();
        }
    }

    public static void insist(boolean condition, String msg) {
        if (!condition && (_mask & 0x40L) != 0L && Debug.distributeAssertionMessage(msg)) {
            throw new AssertionFailedError(msg);
        }
    }

    public static String getStackDump(Throwable x) {
        StringWriter writer = new StringWriter();
        x.printStackTrace(new PrintWriter(writer));
        return writer.getBuffer().toString();
    }

    private static String getCallerPositionOld(int up) {
        up += 2;
        String stack = Debug.getStackDump(new Throwable());
        int index = 0;
        while (index != -1 && up-- > 0) {
            index = stack.indexOf(10, index + 1);
        }
        if (index >= 0) {
            int end;
            String ret;
            if (index > 0) {
                ++index;
            }
            if ((ret = (end = stack.indexOf(10, index)) > -1 ? stack.substring(index, end).trim() : stack.substring(index).trim()).startsWith("at ")) {
                ret = ret.substring(3);
            }
            return ret;
        }
        return "???";
    }

    public static String getCallerPosition(int up) {
        try {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            if ((up += 3) >= 0 && up < stackTrace.length) {
                return stackTrace[up + 1].toString();
            }
            return "???";
        }
        catch (SecurityException x) {
            return Debug.getCallerPositionOld(up);
        }
    }

    private static String getCallerPositionOld() {
        String stack = Debug.getStackDump(new Throwable());
        String pack = "at de.caff.util.debug.";
        int start = stack.indexOf(10) + 1;
        int index = stack.indexOf(10, start);
        while (index != -1) {
            String line = stack.substring(start, index);
            if (line.indexOf(pack) == -1) {
                String pos = line.trim();
                if (pos.startsWith("at ")) {
                    pos = pos.substring(3);
                }
                return pos;
            }
            start = index + 1;
            index = stack.indexOf(10, start);
        }
        return "???";
    }

    private static String getCallerPosition() {
        try {
            String debugClassName = Debug.class.getName();
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            int s = 2;
            while (s < stackTrace.length) {
                if (stackTrace[s].getClassName() != debugClassName) {
                    return stackTrace[s].toString();
                }
                ++s;
            }
            return "???";
        }
        catch (SecurityException x) {
            return Debug.getCallerPositionOld();
        }
    }

    public static JFrame createDebugWindow() {
        return Debug.createDebugWindow(false);
    }

    public static JFrame createDebugWindow(boolean exitOnClose) {
        FilteringDebugMessageWindow frame = new FilteringDebugMessageWindow();
        if (exitOnClose) {
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
        }
        return frame;
    }

    static void sendCollectedStdout() {
        if (_collectedStdout != null) {
            String send = _collectedStdout.toString();
            _collectedStdout = null;
            Debug.distributeStandardMessage(send);
        }
    }

    static void sendCollectedStderr() {
        if (_collectedStderr != null) {
            String send = _collectedStderr.toString();
            _collectedStderr = null;
            Debug.distributeErrorMessage(send);
        }
    }

    static void sendCollectedStreams() {
        Debug.sendCollectedStdout();
        Debug.sendCollectedStderr();
    }

    static void writeStdoutMessage(String str) {
        Debug.sendCollectedStderr();
        int length = str.length();
        if (length > 0) {
            if (str.charAt(length - 1) == '\n') {
                str = str.substring(0, length - 1);
            }
            if (_bufferStreams) {
                if (_collectedStdout == null) {
                    _collectedStdout = new StringBuffer();
                    str = "[STDOUT>\n" + str;
                }
                _collectedStdout.append(str).append('\n');
            } else {
                Debug.sendCollectedStdout();
                Debug.distributeStandardMessage("[STDERR>\n" + str);
            }
        }
    }

    static void writeStderrMessage(String str) {
        Debug.sendCollectedStdout();
        int length = str.length();
        if (length > 0) {
            if (str.charAt(length - 1) == '\n') {
                str = str.substring(0, length - 1);
            }
            if (_bufferStreams) {
                if (_collectedStderr == null) {
                    _collectedStderr = new StringBuffer();
                    str = "[STDERR>\n" + str;
                }
                _collectedStderr.append(str).append('\n');
            } else {
                Debug.sendCollectedStderr();
                Debug.distributeErrorMessage("[STDERR>\n" + str);
            }
        }
    }

    public static void setStdoutCaptureMode(boolean capture) {
        if (capture != Debug.getStdoutCaptureMode()) {
            if (capture) {
                if (!Debug.getStdoutCaptureMode()) {
                    _oldStdout = System.out;
                    System.setOut(new PrintStream(new DebuggingOutputStream(0)));
                }
            } else if (Debug.getStdoutCaptureMode()) {
                Debug.sendCollectedStdout();
                System.setOut(_oldStdout);
                _oldStdout = null;
            }
            Debug.informStdoutCaptureModeListeners(capture);
        }
    }

    public static boolean getStdoutCaptureMode() {
        return _oldStdout != null;
    }

    public static PrintStream getConsoleStdout() {
        return Debug.getStdoutCaptureMode() ? _oldStdout : System.out;
    }

    public static void setStderrCaptureMode(boolean capture) {
        if (capture != Debug.getStderrCaptureMode()) {
            if (capture) {
                if (!Debug.getStderrCaptureMode()) {
                    _oldStderr = System.err;
                    System.setErr(new PrintStream(new DebuggingOutputStream(1)));
                }
            } else if (Debug.getStderrCaptureMode()) {
                Debug.sendCollectedStderr();
                System.setErr(_oldStderr);
                _oldStderr = null;
            }
            Debug.informStderrCaptureModeListeners(capture);
        }
    }

    public static boolean getStderrCaptureMode() {
        return _oldStderr != null;
    }

    public static PrintStream getConsoleStderr() {
        return Debug.getStderrCaptureMode() ? _oldStderr : System.err;
    }

    public static void installCookedOutput(OutputStream stream) {
        if (stream != null) {
            Debug.addCookedMessageDebugListener(new SimpleOutputtingDebugListener(stream));
        }
    }

    public static void installCookedOutput() {
        Debug.installCookedOutput(Debug.getConsoleStdout());
    }

    public static String getObjectInfo(Object obj) {
        return ObjectInspector.getInfo(obj);
    }

    public static void initFromProperties(long debugMaskDefault, boolean showWindowDefault, boolean printConsoleDefault) {
        boolean showWindow = Utility.getBooleanParameter(PARAM_DEBUG_SHOW_WINDOW, showWindowDefault);
        boolean printConsole = Utility.getBooleanParameter(PARAM_DEBUG_PRINT_CONSOLE, printConsoleDefault);
        if (showWindow || printConsole) {
            long debugMask = 0L;
            String mask = Utility.getStringParameter(PARAM_DEBUG_MASK, null);
            if (mask != null) {
                StringCharacterIterator it = new StringCharacterIterator(mask);
                while (it.current() != '\uffff') {
                    char ch = it.current();
                    switch (Character.toUpperCase(ch)) {
                        case 'T': {
                            debugMask |= 1L;
                            break;
                        }
                        case 'S': {
                            debugMask |= 2L;
                            break;
                        }
                        case 'W': {
                            debugMask |= 4L;
                            break;
                        }
                        case 'E': {
                            debugMask |= 8L;
                            break;
                        }
                        case 'F': {
                            debugMask |= 0x10L;
                            break;
                        }
                        case 'L': {
                            debugMask |= 0x20L;
                            break;
                        }
                        case 'A': {
                            debugMask |= 0x40L;
                        }
                    }
                    it.next();
                }
            } else {
                debugMask = debugMaskDefault & 0x7FL;
            }
            Debug.setMask(debugMask);
            if (showWindow) {
                Debug.createDebugWindow();
            }
            if (printConsole) {
                Debug.installCookedOutput();
            }
        } else {
            Debug.setMask(0L);
        }
    }

    public static void initFromProperties(long debugMaskDefault) {
        Debug.initFromProperties(debugMaskDefault, false, false);
    }

    public static interface ModeChangeListener {
        public void modeChanged(int var1, boolean var2);

        public void stdoutCaptureChanged(boolean var1);

        public void stderrCaptureChanged(boolean var1);
    }
}

