/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings.swing;

import de.caff.i18n.I18n;
import de.caff.i18n.Localizable;
import de.caff.i18n.swing.RJMenu;
import de.caff.util.settings.EnumPreferenceProperty;
import de.caff.util.settings.EnumValue;
import de.caff.util.settings.swing.AbstractBasicSimpleEditablePreferenceProperty;
import de.caff.util.settings.swing.EditorProvider;
import de.caff.util.settings.swing.EnumEditor;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.prefs.Preferences;
import javax.swing.ButtonGroup;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;

public class SwingEnumPreferenceProperty
extends AbstractBasicSimpleEditablePreferenceProperty
implements EnumPreferenceProperty {
    private final EnumValue[] values;
    private EnumValue selectedValue;

    public SwingEnumPreferenceProperty(String basicName, String baseTag, EnumValue[] values, EnumValue startValue) {
        super(basicName, baseTag);
        this.values = values;
        this.selectedValue = startValue;
    }

    @Override
    public void readFrom(Preferences preferences) {
        int v = 0;
        while (v < this.values.length) {
            if (this.values[v].isEqualTo(preferences, this.getBasicName())) {
                this.setValue(this.values[v]);
                break;
            }
            ++v;
        }
    }

    @Override
    public void storeTo(Preferences preferences) {
        this.selectedValue.storeTo(preferences, this.getBasicName());
    }

    @Override
    public EditorProvider getEditorProvider(Locale l) {
        return new EnumEditor(this, l);
    }

    @Override
    public EnumValue getValue() {
        return this.selectedValue;
    }

    void setValue(EnumValue value) {
        if (!value.equals(this.selectedValue)) {
            EnumValue oldValue = this.selectedValue;
            this.selectedValue = value;
            this.fireValueChange(this.getBasicName(), oldValue, value);
        }
    }

    @Override
    public EnumValue[] getEnumValues(Locale l) {
        return this.values;
    }

    public JMenuItem createMenuItem(Locale l) {
        RJMenu menu = new RJMenu(this.getBaseTag());
        ButtonGroup group = new ButtonGroup();
        int v = 0;
        while (v < this.values.length) {
            SpecialMenuItem menuItem = new SpecialMenuItem(this.values[v], l);
            menu.add(menuItem);
            group.add(menuItem);
            ++v;
        }
        return menu;
    }

    private class SpecialMenuItem
    extends JRadioButtonMenuItem
    implements PropertyChangeListener,
    Localizable {
        private final EnumValue value;

        public SpecialMenuItem(EnumValue enumValue, Locale l) {
            super(enumValue.getShortName(l), enumValue == SwingEnumPreferenceProperty.this.getValue());
            this.setToolTipText(enumValue.getLongName(l));
            SwingEnumPreferenceProperty.this.addValueChangeListener(this);
            this.value = enumValue;
            this.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (SpecialMenuItem.this.isSelected()) {
                        SwingEnumPreferenceProperty.this.setValue(SpecialMenuItem.this.value);
                    }
                }
            });
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.setSelected(this.value == evt.getNewValue());
        }

        @Override
        public void addNotify() {
            I18n.addLocalizationChangeListener(this);
            super.addNotify();
            SwingEnumPreferenceProperty.this.addValueChangeListener(this);
            if (this.value == SwingEnumPreferenceProperty.this.getValue()) {
                this.setSelected(true);
            }
        }

        @Override
        public void removeNotify() {
            I18n.removeLocalizationChangeListener(this);
            super.removeNotify();
            SwingEnumPreferenceProperty.this.removeValueChangeListener(this);
        }

        @Override
        public void setLocale(Locale l) {
            super.setLocale(l);
            this.setText(this.value.getShortName(l));
            this.setToolTipText(this.value.getLongName(l));
        }
    }
}

