/*
 * Decompiled with CFR 0.152.
 */
package de.wens02;

import de.wens02.Debug;
import de.wens02.Log;
import de.wens02.Shot;
import de.wens02.Target;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.Vector;

public class UFO
extends Target {
    private static final GeneralPath SMALL;
    private static final GeneralPath BIG;
    protected boolean visible = false;
    protected boolean small = true;
    protected Shape shape = null;
    protected static Vector<Shot> shots;

    static {
        BIG = new GeneralPath();
        int w = 24;
        int h = 8;
        BIG.moveTo(-w, 0.0f);
        BIG.lineTo(w, 0.0f);
        BIG.lineTo(w / 2, h);
        BIG.lineTo(-w / 2, h);
        BIG.lineTo(-w, 0.0f);
        BIG.lineTo(-w / 2, -h);
        BIG.lineTo(w / 2, -h);
        BIG.lineTo(w, 0.0f);
        BIG.moveTo(-h, -h);
        BIG.lineTo(-2 * h / 3, -2 * h);
        BIG.lineTo(2 * h / 3, -2 * h);
        BIG.lineTo(h, -h);
        SMALL = new GeneralPath(BIG);
        SMALL.transform(AffineTransform.getScaleInstance(0.5, 0.5));
        shots = new Vector();
    }

    public UFO(int x, int y, int s, int type) {
        super(x, y, s, type);
    }

    protected void setAppearance(int x, int y, int s, int type) {
        this.set(x, y, s, type);
        this.small = s != 15;
        this.shape = this.small ? SMALL : BIG;
        this.x0 = this.x_virtual = x;
        this.y0 = this.y_virtual = y;
        this.dx = 0.0;
        this.dy = 0.0;
        this.frames = 1;
        this.framewait = 0;
        this.visible = true;
        this.exploding = false;
        this.pixelSize = this.small ? 20 : 40;
        this.squaredPixelSize = this.pixelSize * this.pixelSize;
    }

    @Override
    public int getPoints() {
        return this.small ? 1000 : 200;
    }

    public int getPixelSize() {
        return this.small ? 20 : 40;
    }

    @Override
    public void update(Point p) {
        if (this instanceof UFO && this.frames > 2) {
            int dx_new = p.x - this.x;
            int dy_new = p.y - this.y;
            if ((double)dx_new != this.dx || (double)dy_new != this.dy) {
                if (Debug.ufo) {
                    Log.debug(String.format("UFO Richtungs\u00e4nderung: dx=%f,dy=%f, neu: dx=%d,dy=%d", this.dx, this.dy, p.x - this.x, p.y - this.y));
                }
                this.x0 = this.x_virtual = p.x;
                this.x = this.x_virtual;
                this.y0 = this.y_virtual = p.y;
                this.y = this.y_virtual;
                this.dx = dx_new;
                this.dy = dy_new;
                this.frames = 1;
                this.framewait = 0;
                return;
            }
        }
        super.update(p);
        if (9 == this.frames && Debug.ufo) {
            Log.debug(String.format("UFO dx=%f,dy=%f", this.dx, this.dy));
        }
    }

    public void paint(Graphics2D g) {
        g.setColor(Color.orange);
        g.draw(AffineTransform.getTranslateInstance(this.x, 1024 - this.y).createTransformedShape(this.shape));
    }
}

