package de.wens02;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.Vector;

public class Asteroid extends Target
{
	public	static final int					SIZE_SMALL		= 1;
	public	static final int					SIZE_MEDIUM		= 2;
	public	static final int					SIZE_LARGE		= 3;
	
	private static final int					NORMAL_SCALE	= 8;

	private static final GeneralPath	PATH0					= new GeneralPath();
	private static final GeneralPath	PATH1					= new GeneralPath();
	private static final GeneralPath	PATH2					= new GeneralPath();
	private static final GeneralPath	PATH3					= new GeneralPath();

	static {
		PATH0.moveTo( 1, 0 );
		PATH0.lineTo( 4, -1 );
		PATH0.lineTo( 4, -2 );
		PATH0.lineTo( 1, -4 );
		PATH0.lineTo( -2, -4 );
		PATH0.lineTo( -1, -3 );
		PATH0.lineTo( -4, -3 );
		PATH0.lineTo( -4, 1 );
		PATH0.lineTo( -2, 4 );
		PATH0.lineTo( 1, 3 );
		PATH0.lineTo( 2, 4 );
		PATH0.lineTo( 4, 2 );
		PATH0.closePath();

		PATH1.moveTo( 3, 0 );
		PATH1.lineTo( 4, -2 );
		PATH1.lineTo( 2, -4 );
		PATH1.lineTo( 0, -2 );
		PATH1.lineTo( -2, -4 );
		PATH1.lineTo( -4, -2 );
		PATH1.lineTo( -4, 2 );
		PATH1.lineTo( -2, 4 );
		PATH1.lineTo( 1, 4 );
		PATH1.lineTo( 4, 2 );
		PATH1.closePath();

		PATH2.moveTo( 4, -1 );
		PATH2.lineTo( 2, -4 );
		PATH2.lineTo( -1, -4 );
		PATH2.lineTo( -4, -1 );
		PATH2.lineTo( -2, 0 );
		PATH2.lineTo( -4, 1 );
		PATH2.lineTo( -2, 4 );
		PATH2.lineTo( 0, 1 );
		PATH2.lineTo( 0, 4 );
		PATH2.lineTo( 2, 4 );
		PATH2.lineTo( 4, 1 );
		PATH2.closePath();

		PATH3.moveTo( 2, -1 );
		PATH3.lineTo( 4, -2 );
		PATH3.lineTo( 2, -4 );
		PATH3.lineTo( 0, -3 );
		PATH3.lineTo( -2, -4 );
		PATH3.lineTo( -4, -2 );
		PATH3.lineTo( -3, 0 );
		PATH3.lineTo( -4, 2 );
		PATH3.lineTo( -2, 4 );
		PATH3.lineTo( -1, 3 );
		PATH3.lineTo( 2, 4 );
		PATH3.lineTo( 4, 1 );
		PATH3.closePath();
	}

	/** The asteroid shapes sorted by type. */
	private static final Shape[]			SHAPES				= new Shape[] { PATH1, PATH3, PATH2, PATH0 };
	private Shape											shape;

	private int												scale;
	protected int											sizeType			= 0;
	
	protected static double						max_speed			= 0.0;

	public Asteroid( int x, int y, int s, int type )
	{
		super( x, y, s, type );

		switch ( s ) {
			case  0: this.scale = NORMAL_SCALE;			sizeType = SIZE_LARGE;  break;
			case 15: this.scale = NORMAL_SCALE / 2; sizeType = SIZE_MEDIUM; break;
			case 14: this.scale = NORMAL_SCALE / 4; sizeType = SIZE_SMALL;  break;

			default:
				System.err.println( "Asteroid: unknown size: " + s );
				break;
		}
		switch ( type ) {
			case 0x8f3: shape = SHAPES[0]; break;
			case 0x8ff: shape = SHAPES[1]; break;
			case 0x90d: shape = SHAPES[2]; break;
			case 0x91a: shape = SHAPES[3]; break;

			default:
				System.err.println( "Asteroid: unknown shape: " + type );
				break;
		}
		pixelSize					= 8 * scale;
		squaredPixelSize	= pixelSize * pixelSize;
	}

	public void paint( Graphics2D g )
	{
		AffineTransform aTr = new AffineTransform( scale, 0, 0, scale, x, 1024 - y );
		Shape s = aTr.createTransformedShape( shape );

		g.fill( s );

		if ( collision ) {
			g.setColor( Color.red );
			g.draw( s );
		}
		g.setColor( Color.gray );

		g.drawString( "#" + id,             x, 1024 - y + 10 );
		g.drawString( "+" + (int)distance,	x, 1024 - y + 20 );
		g.drawString( "L" + leftMinHitInFramesKeys,  x, 1024 - y + 40 );
		g.drawString( "R" + rightMinHitInFramesKeys, x, 1024 - y + 50 );

		if ( dx != 0 || dy != 0 ) {
			// Richtungsvektor, Position in 30 Frames:
			int xn = (int)( x + 30.0 * dx );
			int yn = (int)( y + 30.0 * dy );

			g.setColor( Color.lightGray );
			g.drawLine( x, 1024 - y, xn, 1024 - yn);
		}
		if ( projected_frames > 0 ) {
			aTr = new AffineTransform( scale, 0, 0, scale, projected_x, 1024 - projected_y );
			s = aTr.createTransformedShape( shape );

			g.draw( s );
		}
	}
	
	/** Wird ein Schuss an Position p in #n Frames treffen? */
	public boolean shotWillHit( Point p, int frameHorizon )
	{
		if ( SIZE_SMALL == sizeType ) {
			return getSquaredNormalDistance( p, frameHorizon ) < squaredPixelSize / 4;
		}
		// Bei mittelgroen und groen Asteroiden lassen wir drei bis vier Schsse zu
		switch( shots_fired_at ) {
			default: return getSquaredNormalDistance( p, frameHorizon     ) < squaredPixelSize / 4;
			case	1: return getSquaredNormalDistance( p, frameHorizon + 1 ) < squaredPixelSize /10;
			case	2: return getSquaredNormalDistance( p, frameHorizon + 1 ) < squaredPixelSize /10;
			case	3: return getSquaredNormalDistance( p, frameHorizon + 2 ) < squaredPixelSize /10;
		}
	}
	
	public int maxShots()
	{
		if ( SIZE_SMALL == sizeType ) {
			return 1;
		}
		else if ( SIZE_MEDIUM == sizeType ) {
			return 3;
		}
		// SIZE_LARGE
		return 4;
	}

	/** Anzahl mglicher Punkte fr diesen Asteroiden zurckgeben
	 */
	public int getPoints()
	{
		if ( SIZE_LARGE == sizeType ) {
			return 25 + 2*50 + 4*100;		// gro, 2*mittel, 4*klein
		}
		else if ( SIZE_MEDIUM == sizeType ) {
			return 50 + 2*100;					// mittel + 2*klein
		}
		return 100;										// klein
	}
	
	/**
	 * Gre des Asteroiden als Durchmesser eines gedachten Kreises: 16, 32, 64 Pixel
	 */
	public int getPixelSize()
	{
		return pixelSize;
	}
	
	public int getSquaredPixelSize()
	{
		return squaredPixelSize;
	}

	public void update( Point p )
	{
		super.update( p );

		if ( Debug.asteroid_speed ) {
			double speed = Math.sqrt( dx*dx + dy*dy );
	
			if ( frames > 5 && speed > max_speed ) {
				max_speed = speed;
				Log.debug( String.format(
						"Frame#%5d: Asteroid ID%2d speed=%5f pixel/frame",
						AsteroidApp.frame_cnt, id, max_speed ) );
			}
		}
	}
}
