package de.wens02;

import java.awt.Point;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class MySQL
{
	private boolean			available		= false;
	private Connection	connection;
	private int					game_id;
	
	public MySQL( boolean needed )
	{
		if ( !needed ) {
			return;
		}
		try {
			// Der Aufruf von newInstance() ist ein Workaround
			// fr einige misslungene Java-Implementierungen
			Class.forName( "com.mysql.jdbc.Driver" ).newInstance();
			connection = DriverManager.getConnection( "jdbc:mysql://192.168.0.5/asteroid?user=root&password=" );

			available = true;
		}
		catch ( SQLException ex ) {
			// SQL-Fehler behandeln
			System.err.println( "SQLException: " + ex.getMessage() );
			System.err.println( "SQLState: " + ex.getSQLState() );
			System.err.println( "VendorError: " + ex.getErrorCode() );
		}
		catch ( Exception ex ) {
			// Sonstige Fehler behandeln
			System.err.println( "FEHLER: " + ex );
		}
	}
	
	private void execute( PreparedStatement stmt )
	{
		if ( !available ) return;

		try {
			stmt.execute();
			stmt.close();
		}
		catch ( SQLException ex ) {
			// Fehler behandeln
			System.err.println( "SQLException: " + ex.getMessage() );
			System.err.println( "SQLState: " + ex.getSQLState() );
			System.err.println( "VendorError: " + ex.getErrorCode() );
		}
	}
	
	public int addGame() throws SQLException
	{
		if ( !available ) return -1;

		Statement stmt = connection.createStatement();

		stmt.executeUpdate( "INSERT INTO game SET frames=0, score=0", Statement.RETURN_GENERATED_KEYS );
		ResultSet rs = stmt.getGeneratedKeys();

		if (rs.next()) {
			game_id = rs.getInt(1);
		}
		else {
			System.err.println( "ERROR addGame: Keine ID" );
			System.exit(0);
		}
		return game_id;
	}
	
	public void addUFO( int framecnt, int asteroids, int vx, int vy, int vs ) throws SQLException
	{
		if ( !available ) return;

		PreparedStatement stmt = connection.prepareStatement(
				"INSERT INTO ufo "
			+ "   SET game_id =?, "
			+ "       frame   =?, "
			+ "       asteroids=?, "
			+ "       x       =?, "
			+ "       y       =?, "
			+ "       size    =?" );

		stmt.setInt( 1, game_id );
		stmt.setInt( 2, framecnt );
		stmt.setInt( 3, asteroids );
		stmt.setInt( 4, vx );
		stmt.setInt( 5, vy );
		stmt.setInt( 6, vs );

		execute( stmt );
	}

	/**
	 * Shot, der schon seit #frames bekannt ist, mit dx,dy und Ship sdx,sdy ablegen
	 */
	public void addShot( Shot shot, int shotsOnScreen ) throws SQLException
	{
		if ( !available ) return;

		PreparedStatement stmt = connection.prepareStatement(
				"INSERT INTO shot "
			+ "   SET game_id=?, "
			+ "       shot_id=?, "
			+ "       shots_screen=?, "
			+ "       frame=?, "
			+ "       x=?, "
			+ "       y=?, "
			+ "       dx=?, "
			+ "       dy=?  " );

		stmt.setInt( 1, game_id );
		stmt.setInt( 2, shot.id );
		stmt.setInt( 3, shotsOnScreen );
		stmt.setInt( 4, shot.frames );
		stmt.setInt( 5, shot.x );
		stmt.setInt( 6, shot.y );
		stmt.setDouble( 7, shot.dx );
		stmt.setDouble( 8, shot.dy );

		execute( stmt );
	}

	public void shotAnalysis()
	{
		if ( !available ) return;

		try {
			Statement stmt = connection.createStatement();
			ResultSet rs = stmt.executeQuery(
					"SELECT AVG(dx) AS dx, AVG(dy) AS dy, sdx, sdy "
				+	"  FROM shot "
				+ " WHERE frame > 2 AND frame < 10"
				+ " GROUP BY sdx,sdy ORDER by sdx, sdy"
			);
			while ( rs.next() ) {
				double dx	= rs.getDouble( "dx" );
				double dy	= rs.getDouble( "dy" );
				int		sdx	= rs.getInt( "sdx" );
				int		sdy	= rs.getInt( "sdy" );

				System.err.println( String.format( "sdx,sdy[%5d,%5d] -> dx,dy = [%f,%f], dist=%f",
						sdx, sdy, dx, dy, Math.sqrt( dx * dx + dy * dy ) ) );
			}
			rs.close();

			// Austrittspunkte eines Schusses relativ zum Schiffsmittelpunkt in Abhngigkeit von der Drehung
			rs = stmt.executeQuery(
					"SELECT AVG(x-sx0) AS dx, AVG(y-sy0) AS dy, sdx, sdy "
				+	"  FROM shot "
				+ " WHERE frame = 1 "
				+ " GROUP BY sdx,sdy ORDER by sdx, sdy"
			);
			while ( rs.next() ) {
				double dx = rs.getDouble( "dx" );
				double dy = rs.getDouble( "dy" );
				int		sdx	= rs.getInt( "sdx" );
				int		sdy	= rs.getInt( "sdy" );

				System.err.println( String.format( "sdx,sdy[%5d,%5d] -> dx,dy = [%f,%f], dist=%f",
						sdx, sdy, dx, dy, Math.sqrt( dx * dx + dy * dy ) ) );
			}
			rs.close();
			stmt.close();
		}
		catch( SQLException e ) {
			System.err.println( e );
		}
	}

	public void updateShipVector( int frame, int dx, int dy, String rotation ) throws SQLException
	{
		if ( !available ) return;

		PreparedStatement stmt = connection.prepareStatement(
				"INSERT INTO shipvector "
			+	"   SET game_id=?, frame=?, dx=?, dy=?, rotation=?"
		);
		stmt.setInt( 1, game_id );
		stmt.setInt( 2, frame );
		stmt.setInt( 3, dx );
		stmt.setInt( 4, dy );
		stmt.setString( 5, rotation );

		execute( stmt );
	}

	public Vector<Point> getUFOAppearances()
	{
		if ( !available ) return new Vector<Point>();

		Vector<Point> v = new Vector<Point>();

		try {
			Statement stmt = connection.createStatement();
			ResultSet rs = stmt.executeQuery( "SELECT x,y FROM ufo" );
	
			while ( rs.next() ) {
				v.add( new Point( rs.getInt( "x" ), rs.getInt( "y" ) ) );
			}
			rs.close();
			stmt.close();
		}
		catch( SQLException e ) {
			System.err.println( e );
		}
		return v;
	}
	
	public void setScore( int frame_cnt,
												int realscore,
												int shots_fired,
												int large_ast_hit,
												int medium_ast_hit,
												int small_ast_hit,
												int large_ufo_hit,
												int small_ufo_hit,
												int ships_remain,
												int warp_cnt ) throws SQLException
	{
		if ( !available ) {
			Log.info( String.format(
					"Frame#%5d: shots=%4d,ships=%2d,warp=%2d,large=%3d,medium=%3d,small=%3d,ufo=%2d",
					frame_cnt, shots_fired, ships_remain, warp_cnt,
					large_ast_hit, medium_ast_hit, small_ast_hit, small_ufo_hit ) );
			
			return;
		}
		PreparedStatement stmt = connection.prepareStatement(
				"UPDATE game "
			+ "   SET frames=?,score=?, "
			+ "       shots_fired   =?, "
			+ "       large_ast_hit =?, "
			+ "       medium_ast_hit=?, "
			+ "       small_ast_hit =?, "
			+ "       large_ufo_hit =?, "
			+ "       small_ufo_hit =?, "
			+ "       ships_remain  =?, "
			+ "       warp_cnt      =? "
			+	"   WHERE id=?"
		);
		stmt.setInt( 1, frame_cnt );
		stmt.setInt( 2, realscore );
		stmt.setInt( 3, shots_fired );
		stmt.setInt( 4, large_ast_hit );
		stmt.setInt( 5, medium_ast_hit );
		stmt.setInt( 6, small_ast_hit );
		stmt.setInt( 7, large_ufo_hit );
		stmt.setInt( 8, small_ufo_hit );
		stmt.setInt( 9, ships_remain );
		stmt.setInt(10, warp_cnt );
		stmt.setInt(11, game_id );

		execute( stmt );
	}
	
	public void setScore5min( int score ) throws SQLException
	{
		if ( !available ) return;

		PreparedStatement stmt = connection.prepareStatement(
				"UPDATE game SET score_5min=?, playdate=NOW() WHERE id=?"
		);
		stmt.setInt( 1, score );
		stmt.setInt( 2, game_id );

		execute( stmt );
	}
	public void setScore10min( int score ) throws SQLException
	{
		if ( !available ) return;

		PreparedStatement stmt = connection.prepareStatement(
				"UPDATE game SET score_10min=?, playdate=NOW() WHERE id=?"
		);
		stmt.setInt( 1, score );
		stmt.setInt( 2, game_id );

		execute( stmt );
	}
}
