package de.wens02;

import java.awt.Point;

abstract public class Target extends MovingObject
{
	/** Anzahl Frames warten, bis auf dieses Objekt wieder gefeuert wird */
	protected int			framewait										= 0;

	/** Anzahl Frames, in denen das Objekt getroffen wird */
	protected int			hit_in_frames								= 0;
	
	/** Mit wieviel Drehbewegungen links/rechts ist der Asteroid erreichbar und abschiebar */
	protected int			leftMinHitInFrames					= 0;
	protected int			leftMinHitInFramesKeys			= 0;

	protected int			rightMinHitInFrames					= 0;
	protected int			rightMinHitInFramesKeys			= 0;

	/** Schuss, der dieses Target treffen wird */
	protected Shot		shot												= null;

	/** Wie oft wurde bereits auf dieses Objekt geschossen? */
	protected int			shots_fired_at							= 0;

	/** Objekt ist explodiert, Explosionsanimation luft noch */
	protected boolean	exploding										= false;

	public Target( int x, int y, int s, int type )
	{
		super( x, y, s, type );
	}

	public void update( Point p )
	{
		super.update( p );

		if ( framewait > 0 ) {
			framewait--;
		}
		if ( hit_in_frames > 0 ) {
			hit_in_frames--;

			if ( 0 == hit_in_frames ) {
				if ( Debug.shot_target ) {
					Log.info( String.format( "Frame#%5d: [%4d,%4d], hit_in_frames=0", AsteroidApp.frame_cnt, x, y ) );
				}
				// Schuss ging daneben, erneut versuchen:
				shots_fired_at	= 0;
				shot						= null;
				framewait				= 0;
			}
		}
	}

	abstract public int getPoints();

	/** max. Anzahl Schsse, die auf dieses Ziel abgegeben werden knnen */
	public int maxShots()
	{
		return 1;
	}
	
}
