/*
 *
 * Asteroids Player
 *
 * for the c't Competition 2008 (Creativ '08) 
 *
 * Copyright 2008, Volker Raum, Erlangen, Germany
 *
 */
package de.volkerraum.asteroids.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BaseObject
{
   public static final double          UNSET_VALUE               = 100000;
   public static int                   objectCount               = 0;
   public double                       x;
   public double                       y;
   public double                       rawX;
   public double                       rawY;
   public double                       dx;
   public double                       dy;
   public double                       angleOfDirection;
   public double                       angleToShip;
   public double                       speed;
   public double                       size;
   public double                       angleOfMovement;
   public int                          interpolationSteps        = 0;
   public int                          shotsFiredAt              = 0;
   public int                          shotImpactFrames          = 0;

   public boolean                      highLevelDataPresent      = false;

   public double                       interceptX;
   public double                       interceptY;
   public double                       interceptAngle;
   public int                          interceptAngleByte;
   public double                       interceptDist;
   public double                       interceptScatter;
   public int                          interceptFrames;
   public int                          interceptFramesToReachAngle;

   public double                       impactX;
   public double                       impactY;
   public int                          impactFrames;
   public double                       impactDist;

   public double                       distanceToShip;

   public int                          id;

   public boolean                      impactImminent            = false;
   public boolean                      interceptPossible         = false;
   public int                          futureTargetCountInSector = 0;

   public List<InterceptPoint>         interceptPoints           = new ArrayList<InterceptPoint>();
   public Map<Integer, InterceptPoint> frameToInterceptPoint     = new HashMap<Integer, InterceptPoint>();

   public BaseObject()
   {
      objectCount++;
      id = objectCount;
   }

   public void copyData(BaseObject other)
   {
      this.x = other.x;
      this.y = other.y;
      this.rawX = other.rawX;
      this.rawY = other.rawY;
      this.dx = other.dx;
      this.dy = other.dy;
      this.angleOfDirection = other.angleOfDirection;
      this.angleToShip = other.angleToShip;
      this.speed = other.speed;
      this.size = other.size;
      this.angleOfMovement = other.angleOfMovement;
      this.interpolationSteps = other.interpolationSteps;
      this.shotsFiredAt = other.shotsFiredAt;
      this.shotImpactFrames = other.shotImpactFrames;

      this.interceptX = other.interceptX;
      this.interceptY = other.interceptY;
      this.interceptAngle = other.interceptAngle;
      this.interceptAngleByte = other.interceptAngleByte;
      this.interceptDist = other.interceptDist;
      this.interceptFrames = other.interceptFrames;
      this.interceptFramesToReachAngle = other.interceptFramesToReachAngle;

      this.impactX = other.impactX;
      this.impactY = other.impactY;
      this.impactFrames = other.impactFrames;
      this.impactDist = other.impactDist;
      this.interceptScatter = other.interceptScatter;

      this.impactImminent = other.impactImminent;
      this.interceptPossible = other.interceptPossible;
      this.distanceToShip = other.distanceToShip;
      this.futureTargetCountInSector = other.futureTargetCountInSector;

   }

   public void clearValue()
   {
      x = 0;
      y = 0;
      rawX = 0;
      rawY = 0;
      dx = 0;
      dy = 0;
      angleOfDirection = 0;
      angleToShip = 0;
      speed = 0;
      size = 0;
      angleOfMovement = 0;
      interpolationSteps = 0;

      clearHighLevelValues();
   }

   public void clearHighLevelValues()
   {
      highLevelDataPresent = false;
      distanceToShip = UNSET_VALUE;
      interceptX = -1;
      interceptY = -1;
      interceptAngle = -100000;
      interceptAngleByte = -100000;
      interceptDist = UNSET_VALUE;
      interceptFrames = (int) UNSET_VALUE;
      interceptFramesToReachAngle = (int) UNSET_VALUE;
      impactX = -1;
      impactY = -1;
      impactFrames = (int) UNSET_VALUE;
      impactDist = UNSET_VALUE;
      interceptScatter = 0;

      impactImminent = false;
      interceptPossible = false;
      futureTargetCountInSector = 0;
   }

   public boolean equals(Object other)
   {
      if (!other.getClass().equals(this.getClass()))
         return false;
      BaseObject otherBase = (BaseObject) other;

      // x,y and dx,dy must be identical
      return (this.x == otherBase.x && this.y == otherBase.y && this.dx == otherBase.dx && this.dy == otherBase.dy);

   }

   public int hashCode()
   {
      return new Double(x + y + dx + dy).hashCode();
   }

}
