/*
 *
 * Asteroids Player
 *
 * for the c't Competition 2008 (Creativ '08) 
 *
 * Copyright 2008, Volker Raum, Erlangen, Germany
 *
 */
package de.volkerraum.asteroids.model;

/**
 * @author  Volker Raum  (C) 2007
 */
public class Command
{
   public static final byte ACTION_HYPERSPACE = 0x1;
   public static final byte ACTION_FIRE       = 0x2;
   public static final byte ACTION_THRUST     = 0x4;
   public static final byte ACTION_RIGHT      = 0x8;
   public static final byte ACTION_LEFT       = 0x10;
   public static final byte ACTION_DEBUG      = 0x20;

   /**
    * @uml.property  name="command"
    */
   byte                     command           = '@';

   public Command addAction(byte action)
   {
      command |= action;
      return this;
   }

   public Command removeAction(byte action)
   {
      command &= 0xFF - action;
      return this;
   }

   public Command clearCommand()
   {
      command = '@' & 0x0ff;
      return this;
   }

   public boolean shootActionGiven()
   {
      return (command & ACTION_FIRE) != 0;
   }

   public void printCommand()
   {
      System.err.println(command);
   }

   /**
    * @return
    * @uml.property  name="command"
    */
   public byte getCommand()
   {
      return command;
   }

   /**
    * @param command
    * @uml.property  name="command"
    */
   public void setCommand(byte command)
   {
      this.command = command;
   }
}
