/*
 *
 * Asteroids Player
 *
 * for the c't Competition 2008 (Creativ '08) 
 *
 * Copyright 2008, Volker Raum, Erlangen, Germany
 *
 */
package de.volkerraum.asteroids.model;

/**
 * @author   Volker Raum  (C) 2007
 */
public class Target
{
   public double     angle;
   public int        angleByte;
   public BaseObject targetRef;
   public boolean    targetValid     = false;
   public int        interceptFrames = 0;

   public double     interceptX;
   public double     interceptY;

   public int        impactFrames    = 0;
   public boolean    isThreat        = false;

   public Target()
   {

   }

   public Target(BaseObject targetObject)
   {
      angle = targetObject.interceptAngle;
      angleByte = targetObject.interceptAngleByte;
      targetRef = targetObject;
      targetValid = true;
      interceptFrames = targetObject.interceptFrames;

      interceptX = targetObject.interceptX;
      interceptY = targetObject.interceptY;

   }

   public Target(BaseObject targetObject, int impactFrames)
   {
      this(targetObject);
      isThreat = true;
      this.impactFrames = impactFrames;
   }

}
