/*
 *
 * Asteroids Player
 *
 * for the c't Competition 2008 (Creativ '08) 
 *
 * Copyright 2008, Volker Raum, Erlangen, Germany
 *
 */
package de.volkerraum.asteroids.tools;

import de.volkerraum.asteroids.configs.TargetRating1;

public class Calculator
{
   public static final double TwoPI = Math.PI * 2;
   public static final double internalAngleStep = TwoPI * 3 / 256;

   public static void main(String[] args)
   {
      TargetRating1 t = new TargetRating1();

      for (int i = 0; i < 20; ++i)
      {
         t.setConfig();
         t.printConfig();
      }

   }

   public static void printDiff(double angleA, double angleB)
   {
      double diff = (angleA - angleB);

      if (Math.abs(diff) > Math.PI)
         diff = -diff;

      System.err.println(angleA + " - " + angleB + " = " + diff + " " + (diff < 0 ? "LEFT" : "RIGHT"));

   }

   public static double findBestFittingAngle(double wantedAngle)
   {
      long ratio = Math.round(wantedAngle / internalAngleStep);
      System.err.println("Ratio " + ratio);

      double angle = ((double) Math.round(wantedAngle / internalAngleStep)) * internalAngleStep;
      angle = ((double) Math.round(angle * 1000)) / 1000;
      // System.err.println("INcoming " + wantedAngle + " nomed = " + angle);
      return angle;
   }
}
