/*
 *
 * Asteroids Player
 *
 * for the c't Competition 2008 (Creativ '08) 
 *
 * Copyright 2008, Volker Raum, Erlangen, Germany
 *
 */
package de.volkerraum.asteroids.ui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;

import de.volkerraum.asteroids.model.AsteroidsModel;
import de.volkerraum.asteroids.player.Player;

/**
 * @author   Volker Raum  (C) 2007
 */
public class VisualizationFrame extends JFrame
{
   GameArea area = null;
   JCheckBox showTrajectories = null ;
   
   public VisualizationFrame(AsteroidsModel model, Player player)
   {
      super("VISUALIZATION");
      area = new GameArea(model, player);
      
      JPanel mainPanel  = new JPanel() ;
      showTrajectories = new JCheckBox("Trajectories") ;
      
      showTrajectories.addActionListener(new ActionListener(){

         public void actionPerformed(ActionEvent e)
         {
            updateTrajectory() ;
            
         }}) ;
      
      mainPanel.setLayout(new GridBagLayout()) ;
      
      
      mainPanel.add( area, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0)) ;
      mainPanel.add( showTrajectories, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0)) ;
      
      this.setContentPane(mainPanel);
      this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
   }
   public void updateTrajectory()
   {
      area.setShowTrajectories(showTrajectories.isSelected()) ;
   }
}
