/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid;

import de.caff.asteroid.Buttons;
import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.FrameListener;
import de.caff.asteroid.FramePreparer;
import de.caff.asteroid.GameData;
import de.caff.asteroid.PingKeyProvider;
import de.caff.asteroid.server.DatagramListener;
import de.caff.asteroid.server.DatagramSender;
import de.caff.util.Tools;
import de.dkn.asteroids.DknStatistics;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class Communication
implements Runnable,
GameData,
DatagramSender,
PingKeyProvider {
    public static final int MAX_FRAMES_KEPT = 256;
    private DatagramSocket socket;
    private LinkedList<FrameInfo> pendingFrames = new LinkedList();
    private byte[] keyFrame = new byte[8];
    private DatagramPacket keyDatagram;
    private DatagramPacket mameDatagram;
    private List<FrameListener> frameListeners;
    private List<DatagramListener> datagramListeners;
    private List<ServerStateListener> serverStateListeners;
    private int ping;
    private int latestPing;
    private SendInfo[] sendInfos;
    private InetSocketAddress mameAddr;
    private FramePreparer framePreparer;
    private Buttons buttons;
    private boolean bridgeMode;
    private ServerState serverState;
    private DatagramPacket nameDatagram;

    public Communication(String hostname, boolean bridgeMode) throws IOException {
        this(hostname, bridgeMode, null);
    }

    public Communication(String hostname, boolean bridgeMode, String playerName) throws IOException {
        System.arraycopy(KEY_PACKET_INTRO, 0, this.keyFrame, 0, KEY_PACKET_INTRO.length);
        this.keyDatagram = new DatagramPacket(this.keyFrame, this.keyFrame.length);
        this.mameDatagram = new DatagramPacket(new byte[1026], 1026);
        this.frameListeners = new LinkedList<FrameListener>();
        this.datagramListeners = new LinkedList<DatagramListener>();
        this.serverStateListeners = new LinkedList<ServerStateListener>();
        this.ping = 1;
        this.latestPing = 0;
        this.sendInfos = new SendInfo[256];
        this.buttons = new Buttons();
        this.serverState = ServerState.UNKNOWN;
        this.bridgeMode = bridgeMode;
        int port = 1979;
        String[] parts = hostname.split(":");
        if (parts.length == 2) {
            try {
                port = Integer.parseInt(parts[1]);
                hostname = parts[0];
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        this.socket = new DatagramSocket();
        this.mameAddr = new InetSocketAddress(hostname, port);
        this.socket.connect(this.mameAddr);
        if (playerName != null) {
            byte[] nameData = new byte[38];
            System.arraycopy(NAME_PACKET_INTRO, 0, nameData, 0, NAME_PACKET_INTRO.length);
            byte[] nameBytes = playerName.getBytes("utf-8");
            System.arraycopy(nameBytes, 0, nameData, NAME_PACKET_INTRO.length, Math.min(nameBytes.length, nameData.length - NAME_PACKET_INTRO.length));
            this.nameDatagram = new DatagramPacket(nameData, nameData.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setServerState(ServerState state) throws IOException {
        if (state != this.serverState) {
            ServerState oldState;
            if (state == ServerState.IN_GAME && this.serverState == ServerState.UNKNOWN && this.nameDatagram != null) {
                this.socket.send(this.nameDatagram);
            }
            Communication communication = this;
            synchronized (communication) {
                oldState = state;
                this.serverState = state;
            }
            this.informServerStateListeners(oldState, state);
        }
    }

    public synchronized void restart() {
        try {
            this.setServerState(ServerState.UNKNOWN);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static boolean startsWith(byte[] array, byte[] prefix) {
        if (array.length >= prefix.length) {
            int l = 0;
            while (l < prefix.length) {
                if (array[l] != prefix[l]) {
                    return false;
                }
                ++l;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long receiveTime = 0L;
        DknStatistics statistics = DknStatistics.getInstance();
        try {
            int index = 0;
            while (true) {
                if (this.serverState != ServerState.GAME_OVER) {
                    if (!this.bridgeMode) {
                        this.sendKeys();
                    }
                    if (receiveTime > 0L) {
                        statistics.addValue((int)(System.currentTimeMillis() - receiveTime));
                    }
                    this.socket.receive(this.mameDatagram);
                    receiveTime = System.currentTimeMillis();
                    if (this.mameDatagram.getLength() != 1026) {
                        byte[] data = this.mameDatagram.getData();
                        if (Communication.startsWith(data, MAME_BUSY_PREFIX)) {
                            String str = new String(data, MAME_BUSY_PREFIX.length, data.length - MAME_BUSY_PREFIX.length, "utf-8").trim();
                            int frames = 0;
                            try {
                                frames = Integer.parseInt(str);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            this.setServerState(ServerState.SERVER_BUSY);
                            this.informServerStateListeners(frames);
                            if (frames > 180) {
                                frames = frames * 63 / 100;
                            }
                            frames += 120;
                            try {
                                Thread.sleep(frames * 1000 / 60);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            this.setServerState(ServerState.UNKNOWN);
                            continue;
                        }
                        if (!Communication.startsWith(data, MAME_GAME_OVER_DATA)) continue;
                        System.out.println(statistics.toString());
                        this.setServerState(ServerState.GAME_OVER);
                        continue;
                    }
                    this.setServerState(ServerState.IN_GAME);
                    this.informDatagramListeners(this.mameDatagram);
                    FrameInfo fi = new FrameInfo(index++, this.mameDatagram.getData(), this, receiveTime);
                    LinkedList<FrameInfo> linkedList = this.pendingFrames;
                    synchronized (linkedList) {
                        if (!this.pendingFrames.isEmpty()) {
                            if (this.pendingFrames.size() >= 256) {
                                this.pendingFrames.removeFirst();
                            }
                            byte lastId = this.pendingFrames.getLast().getId();
                            byte id = fi.getId();
                            if ((byte)(id - lastId) != 1) {
                                System.err.println("Frame dropped? last=" + lastId + ", current=" + id);
                            }
                        }
                        this.pendingFrames.add(fi);
                        if (this.framePreparer != null) {
                            this.framePreparer.prepareFrames(this.pendingFrames);
                        }
                    }
                    this.informFrameListeners(fi);
                    continue;
                }
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendKeys() throws IOException {
        DatagramPacket datagramPacket = this.keyDatagram;
        synchronized (datagramPacket) {
            this.keyFrame[Communication.KEY_MASK_INDEX] = this.buttons.extractKeys();
            this.keyFrame[Communication.KEY_PING_INDEX] = (byte)this.ping;
            this.keyDatagram.setData(this.keyFrame);
            this.sendInfos[this.ping] = new SendInfo(this.keyFrame[KEY_MASK_INDEX], this.keyFrame[KEY_PING_INDEX]);
            this.socket.send(this.keyDatagram);
            this.informDatagramListeners(this.keyDatagram);
            this.latestPing = this.ping++;
            if (this.ping >= 256) {
                this.ping = 1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setButton(int button, boolean down) {
        this.buttons.setKey(button, down);
        DatagramPacket datagramPacket = this.keyDatagram;
        synchronized (datagramPacket) {
            return this.ping;
        }
    }

    public int pushButton(int button) {
        return this.setButton(button, true);
    }

    public byte getButtons() {
        return this.buttons.getKeys();
    }

    public void setButtons(int mask) {
        this.buttons.setKeys(mask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFrameListener(FrameListener listener) {
        List<FrameListener> list = this.frameListeners;
        synchronized (list) {
            this.frameListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeFrameListener(FrameListener listener) {
        List<FrameListener> list = this.frameListeners;
        synchronized (list) {
            return this.frameListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDatagramListener(DatagramListener listener) {
        List<DatagramListener> list = this.datagramListeners;
        synchronized (list) {
            this.datagramListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeDatagramListener(DatagramListener listener) {
        List<DatagramListener> list = this.datagramListeners;
        synchronized (list) {
            return this.datagramListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServerStateListener(ServerStateListener listener) {
        List<ServerStateListener> list = this.serverStateListeners;
        synchronized (list) {
            this.serverStateListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeServerStateListener(ServerStateListener listener) {
        List<ServerStateListener> list = this.serverStateListeners;
        synchronized (list) {
            return this.serverStateListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void informFrameListeners(FrameInfo frameInfo) {
        ArrayList<FrameListener> tmp;
        List<FrameListener> list = this.frameListeners;
        synchronized (list) {
            if (this.frameListeners.isEmpty()) {
                return;
            }
            tmp = new ArrayList<FrameListener>(this.frameListeners);
        }
        for (FrameListener listener : tmp) {
            listener.frameReceived(frameInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void informDatagramListeners(DatagramPacket datagram) {
        ArrayList<DatagramListener> tmp;
        List<DatagramListener> list = this.datagramListeners;
        synchronized (list) {
            if (this.datagramListeners.isEmpty()) {
                return;
            }
            tmp = new ArrayList<DatagramListener>(this.datagramListeners);
        }
        if (datagram.getLength() == 1026) {
            for (DatagramListener listener : tmp) {
                listener.datagramReceived(datagram, this);
            }
        } else {
            for (DatagramListener listener : tmp) {
                listener.datagramSent(datagram);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void informServerStateListeners(ServerState oldState, ServerState newState) {
        ArrayList<ServerStateListener> tmp;
        System.out.println("New server state: " + (Object)((Object)newState));
        List<ServerStateListener> list = this.serverStateListeners;
        synchronized (list) {
            if (this.serverStateListeners.isEmpty()) {
                return;
            }
            tmp = new ArrayList<ServerStateListener>(this.serverStateListeners);
        }
        for (ServerStateListener listener : tmp) {
            listener.serverStateChanged(oldState, newState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void informServerStateListeners(int waitFrames) {
        ArrayList<ServerStateListener> tmp;
        System.out.println("waitFrames " + waitFrames);
        List<ServerStateListener> list = this.serverStateListeners;
        synchronized (list) {
            if (this.serverStateListeners.isEmpty()) {
                return;
            }
            tmp = new ArrayList<ServerStateListener>(this.serverStateListeners);
        }
        for (ServerStateListener listener : tmp) {
            listener.framesToWaitUpdate(waitFrames);
        }
    }

    @Override
    public void sendDatagram(DatagramPacket packet) throws IOException {
        packet.setSocketAddress(this.mameAddr);
        this.socket.send(packet);
        this.informDatagramListeners(packet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<FrameInfo> getFrames() {
        LinkedList<FrameInfo> linkedList = this.pendingFrames;
        synchronized (linkedList) {
            return new ArrayList<FrameInfo>(this.pendingFrames);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<FrameInfo> getFramesAfter(long timestamp) {
        ArrayList<FrameInfo> tmpFrames;
        LinkedList<FrameInfo> linkedList = this.pendingFrames;
        synchronized (linkedList) {
            if (this.pendingFrames.isEmpty() || this.pendingFrames.getFirst().getReceiveTime() > timestamp) {
                return this.getFrames();
            }
            tmpFrames = new ArrayList<FrameInfo>(this.pendingFrames);
        }
        LinkedList<FrameInfo> result = new LinkedList<FrameInfo>();
        int f = tmpFrames.size() - 1;
        while (f >= 0) {
            FrameInfo info = tmpFrames.remove(f);
            if (info.getReceiveTime() <= timestamp) break;
            result.add(0, info);
            --f;
        }
        return result;
    }

    public FramePreparer getFramePreparer() {
        return this.framePreparer;
    }

    public void setFramePreparer(FramePreparer framePreparer) {
        this.framePreparer = framePreparer;
    }

    public int getLatestPing() {
        return this.latestPing;
    }

    @Override
    public int getKeysForPing(int frameNr, int ping) {
        return this.isStillKnown(frameNr, ping) ? this.sendInfos[ping].getKeys() : 0;
    }

    @Override
    public long getTimestampForPing(int frameNr, int ping) {
        return this.isStillKnown(frameNr, ping) ? this.sendInfos[ping].getTimestamp() : 0L;
    }

    @Override
    public boolean isStillKnown(int frameNr, int ping) {
        if (!this.pendingFrames.isEmpty()) {
            int firstFrame = this.pendingFrames.getFirst().getIndex();
            int lastFrame = this.pendingFrames.getLast().getIndex();
            try {
                return frameNr >= firstFrame && frameNr <= lastFrame + 1 && ping != 0 && this.sendInfos[ping] != null;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return false;
    }

    public ServerState getServerState() {
        return this.serverState;
    }

    private static class SendInfo {
        private final long timestamp = System.currentTimeMillis();
        private final byte keys;
        private final byte ping;

        public SendInfo(byte keys, byte ping) {
            this.keys = keys;
            this.ping = ping;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public int getKeys() {
            return Tools.byteToUnsigned(this.keys);
        }

        public int getPing() {
            return Tools.byteToUnsigned(this.ping);
        }
    }

    public static enum ServerState {
        UNKNOWN,
        SERVER_BUSY,
        IN_GAME,
        GAME_OVER;

    }

    public static interface ServerStateListener {
        public void serverStateChanged(ServerState var1, ServerState var2);

        public void framesToWaitUpdate(int var1);
    }
}

