/*
 * Decompiled with CFR 0.152.
 */
package de.caff.i18n.java2;

import de.caff.i18n.I18n;
import de.caff.i18n.Localizable;
import de.caff.i18n.ResourceBundleCollection;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;

public class I18n4Java2
extends I18n {
    protected Map resourceBundles = new HashMap();
    protected Set appResourceBases = new HashSet();
    protected Locale defaultLocale = Locale.getDefault();
    protected List localizables = new ArrayList();

    @Override
    protected void _addAppResourceBase(String base) {
        if (!this.appResourceBases.contains(base)) {
            this.appResourceBases.add(base);
            this.resourceBundles.clear();
        }
    }

    private static ResourceBundle getFallbackResourceBundle(String name) {
        ResourceBundle bundle;
        Class<?> resClass;
        try {
            resClass = Class.forName(name);
        }
        catch (ClassNotFoundException e1) {
            throw new MissingResourceException("Can't load fallback resources " + name, name, "");
        }
        try {
            bundle = (ResourceBundle)resClass.newInstance();
        }
        catch (Exception e1) {
            throw new RuntimeException("Cannot create ResourceBundle " + name);
        }
        return bundle;
    }

    @Override
    protected void _setDefaultLocale(Locale l) {
        if (l == null) {
            l = Locale.getDefault();
        }
        this.defaultLocale = l;
        this._fireLocaleChanged(l);
    }

    @Override
    protected Locale _getDefaultLocale() {
        return this.defaultLocale;
    }

    @Override
    protected ResourceBundle _getBundle(Locale l) {
        ResourceBundle res;
        if (l == null) {
            l = this.defaultLocale;
        }
        if ((res = (ResourceBundle)this.resourceBundles.get(l)) == null) {
            if (this.appResourceBases.size() == 0) {
                throw new MissingResourceException("No application specific resource base defined", "<unknown>", "");
            }
            ResourceBundleCollection collect = new ResourceBundleCollection();
            for (String baseName : this.appResourceBases) {
                try {
                    collect.addResourceBundle(ResourceBundle.getBundle(baseName, l));
                }
                catch (MissingResourceException e1) {
                    collect.addResourceBundle(I18n4Java2.getFallbackResourceBundle(baseName));
                }
            }
            this.resourceBundles.put(l, collect);
            return collect;
        }
        return res;
    }

    @Override
    protected void _addLocalizationChangeListener(Localizable localizable) {
        this.localizables.add(new WeakReference<Localizable>(localizable));
        localizable.setLocale(this._getDefaultLocale());
    }

    @Override
    protected void _removeLocalizationChangeListener(Localizable localizable) {
        this.localizables.remove(localizable);
    }

    @Override
    protected void _fireLocaleChanged(Locale locale) {
        ListIterator it = this.localizables.listIterator();
        while (it.hasNext()) {
            WeakReference ref = (WeakReference)it.next();
            Localizable loc = (Localizable)ref.get();
            if (loc != null) {
                loc.setLocale(locale);
                continue;
            }
            it.remove();
        }
    }
}

