/*
 * Decompiled with CFR 0.152.
 */
package de.caff.i18n.swing;

import de.caff.i18n.I18n;
import de.caff.i18n.Localizable;
import de.caff.i18n.swing.I18nHelper;
import java.awt.IllegalComponentStateException;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JButton;

public class RJButton
extends JButton
implements Localizable {
    protected String resTag;

    public RJButton(String tag) {
        this.setTag(tag);
    }

    public RJButton(String tag, Icon icon) {
        this.setTag(tag);
        this.setIcon(icon);
    }

    protected void setTag(String baseTag) {
        this.resTag = baseTag;
        I18nHelper.setProperties(this, baseTag, this.getLocale());
    }

    @Override
    public void addNotify() {
        super.addNotify();
        I18n.addLocalizationChangeListener(this);
    }

    @Override
    public void removeNotify() {
        I18n.removeLocalizationChangeListener(this);
        super.removeNotify();
    }

    @Override
    public void setLocale(Locale l) {
        Locale oldLocale = this.getLocale();
        super.setLocale(l);
        if (oldLocale != null && !oldLocale.equals(l) && this.resTag != null) {
            this.setTag(this.resTag);
            this.invalidate();
        }
    }

    @Override
    public Locale getLocale() {
        try {
            return super.getLocale();
        }
        catch (IllegalComponentStateException x) {
            return null;
        }
    }
}

