/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings;

import de.caff.util.settings.PreferenceProperty;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;

public abstract class AbstractBasicPreferenceProperty
implements PreferenceProperty {
    private final String basicName;
    private final PropertyChangeSupport propertyChangeSupport;

    protected AbstractBasicPreferenceProperty(String basicName) {
        this.basicName = basicName;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    protected String getBasicName() {
        return this.basicName;
    }

    protected void firePropertyChange(PropertyChangeEvent evt) {
        this.propertyChangeSupport.firePropertyChange(evt);
    }

    @Override
    public void addValueChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addValueChangeListenerWeakly(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(new WeakPropertyChangeListenerProxy(listener));
    }

    @Override
    public void removeValueChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removeValueChangeListenerWeakly(PropertyChangeListener listener) {
        PropertyChangeListener[] listeners = this.propertyChangeSupport.getPropertyChangeListeners();
        int l = listeners.length - 1;
        while (l >= 0) {
            WeakPropertyChangeListenerProxy proxy;
            PropertyChangeListener wrapped;
            if (listeners[l] instanceof WeakPropertyChangeListenerProxy && ((wrapped = (proxy = (WeakPropertyChangeListenerProxy)listeners[l]).getWrapped()) == null || listener.equals(wrapped))) {
                this.propertyChangeSupport.removePropertyChangeListener(proxy);
            }
            --l;
        }
    }

    protected void fireValueChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void fireValueChange(String propertyName, boolean oldValue, boolean newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void fireValueChange(String propertyName, int oldValue, int newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public String getPropertyName() {
        return this.getBasicName();
    }

    private class WeakPropertyChangeListenerProxy
    implements PropertyChangeListener {
        private final WeakReference wrapped;

        WeakPropertyChangeListenerProxy(PropertyChangeListener listener) {
            this.wrapped = new WeakReference<PropertyChangeListener>(listener);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            PropertyChangeListener listener = (PropertyChangeListener)this.wrapped.get();
            if (listener != null) {
                listener.propertyChange(evt);
            } else {
                AbstractBasicPreferenceProperty.this.propertyChangeSupport.removePropertyChangeListener(this);
            }
        }

        PropertyChangeListener getWrapped() {
            return (PropertyChangeListener)this.wrapped.get();
        }
    }
}

