/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings.swing;

import de.caff.i18n.swing.RJMenu;
import de.caff.util.settings.AbstractBasicLocalizablePreferenceProperty;
import de.caff.util.settings.StringListPreferenceProperty;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.prefs.Preferences;
import javax.swing.JMenuItem;

public class SwingRecentFilesPreferenceProperty
extends AbstractBasicLocalizablePreferenceProperty
implements StringListPreferenceProperty {
    private static final String PREF_KEY_SUFFIX_NR = "NR";
    public static int MAXIMUM_STORE_SIZE = 10;
    private final int maxSize;
    private List files = new LinkedList();

    public SwingRecentFilesPreferenceProperty(String basicName, String baseTag) {
        this(basicName, baseTag, MAXIMUM_STORE_SIZE);
    }

    public SwingRecentFilesPreferenceProperty(String basicName, String baseTag, int maxSize) {
        super(basicName, baseTag);
        if (maxSize > MAXIMUM_STORE_SIZE) {
            throw new IllegalArgumentException("maxSize parameter is too large");
        }
        this.maxSize = maxSize;
    }

    public void addEntry(String filepath) {
        ArrayList oldFiles = new ArrayList(this.files);
        ListIterator lit = this.files.listIterator();
        while (lit.hasNext()) {
            if (!filepath.equals(lit.next())) continue;
            lit.remove();
            break;
        }
        if (this.files.size() == this.maxSize) {
            this.files.remove(this.maxSize - 1);
        }
        this.files.add(0, filepath);
        this.fireValueChange(this.getBasicName(), Collections.unmodifiableCollection(oldFiles), Collections.unmodifiableCollection(this.files));
    }

    @Override
    public void readFrom(Preferences preferences) {
        String tagPrefix = this.getBasicName();
        int size = preferences.getInt(String.valueOf(tagPrefix) + PREF_KEY_SUFFIX_NR, -1);
        if (size != -1) {
            boolean changed;
            if (size > this.maxSize) {
                size = this.maxSize;
            }
            ArrayList oldList = new ArrayList(this.files);
            this.files = new ArrayList(size);
            int index = 0;
            while (index < size) {
                String path = preferences.get(String.valueOf(tagPrefix) + index, null);
                if (path != null) {
                    this.files.add(path);
                }
                ++index;
            }
            if (oldList.size() != this.files.size()) {
                changed = true;
            } else {
                Iterator itOld = oldList.iterator();
                Iterator itNew = this.files.iterator();
                changed = false;
                while (itOld.hasNext() && itNew.hasNext()) {
                    if (itOld.next().equals(itNew.next())) continue;
                    changed = true;
                    break;
                }
                boolean bl = changed = changed || itOld.hasNext() ^ itNew.hasNext();
            }
            if (changed) {
                this.fireValueChange(this.getBasicName(), Collections.unmodifiableCollection(oldList), Collections.unmodifiableCollection(this.files));
            }
        }
    }

    @Override
    public void storeTo(Preferences preferences) {
        String tagPrefix = this.getBasicName();
        preferences.putInt(String.valueOf(tagPrefix) + PREF_KEY_SUFFIX_NR, this.files.size());
        int index = 0;
        for (String url : this.files) {
            preferences.put(String.valueOf(tagPrefix) + index, url);
            ++index;
        }
    }

    @Override
    public Collection getStringList() {
        return Collections.unmodifiableCollection(this.files);
    }

    public String getLatestEntry() {
        return this.files.isEmpty() ? null : (String)this.files.get(0);
    }

    public JMenuItem getMenuItem(RecentFileLoader loader, Locale l) {
        SpecialMenu item = new SpecialMenu(loader, this.getBaseTag());
        item.setLocale(l);
        item.propertyChange(new PropertyChangeEvent(this, this.getBasicName(), null, this.files));
        this.addValueChangeListener(item);
        return item;
    }

    public static interface RecentFileLoader {
        public void loadRecentFile(String var1);
    }

    private static class SpecialMenu
    extends RJMenu
    implements PropertyChangeListener {
        private final RecentFileLoader loader;

        public SpecialMenu(RecentFileLoader loader, String baseTag) {
            super(baseTag);
            this.loader = loader;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.removeAll();
            Collection files = (Collection)evt.getNewValue();
            int nr = 1;
            for (String file : files) {
                String number = Integer.toString(nr % 10);
                this.add(new FileMenuItem(number, file));
                ++nr;
            }
            this.setEnabled(files.size() > 0);
        }

        private class FileMenuItem
        extends JMenuItem
        implements ActionListener {
            private final String filename;

            public FileMenuItem(String number, String filename) {
                super(String.valueOf(number) + " " + filename);
                this.filename = filename;
                this.addActionListener(this);
                this.setMnemonic(number.charAt(0));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                SpecialMenu.this.loader.loadRecentFile(this.filename);
            }
        }
    }
}

