/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid;

import de.caff.asteroid.Glyph;
import de.caff.asteroid.MovingGameObject;
import de.caff.asteroid.Property;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.Collection;

public class Ufo
extends MovingGameObject {
    public static final int BIG_SIZE = 16;
    public static final int SMALL_SIZE = 8;
    private static final Color[] UFO_COLOR = new Color[]{new Color(192, 192, 192), new Color(48, 48, 48), new Color(240, 0, 0), new Color(96, 0, 96)};
    public static final Glyph UFO_GLYPH;
    private static final Shape BIG;
    private static final Shape SMALL;
    private final boolean big;
    private int colorCode;

    static {
        byte[] byArray = new byte[36];
        byArray[0] = 16;
        byArray[1] = -8;
        byArray[3] = -16;
        byArray[4] = -8;
        byArray[5] = 12;
        byArray[6] = -40;
        byArray[7] = 8;
        byArray[9] = 40;
        byArray[10] = 8;
        byArray[11] = 13;
        byArray[12] = 16;
        byArray[13] = 24;
        byArray[14] = 13;
        byArray[15] = -16;
        byArray[16] = 24;
        byArray[17] = 12;
        byArray[18] = -40;
        byArray[19] = 8;
        byArray[20] = 13;
        byArray[21] = -16;
        byArray[22] = -8;
        byArray[23] = 13;
        byArray[24] = -8;
        byArray[25] = -24;
        byArray[26] = 12;
        byArray[27] = 8;
        byArray[28] = -24;
        byArray[29] = 12;
        byArray[30] = 16;
        byArray[31] = -8;
        byArray[32] = 12;
        byArray[33] = 40;
        byArray[34] = 8;
        byArray[35] = 13;
        UFO_GLYPH = new Glyph(byArray);
        BIG = AffineTransform.getScaleInstance(0.5, 0.5).createTransformedShape(UFO_GLYPH.getPath());
        SMALL = AffineTransform.getScaleInstance(0.5, 0.5).createTransformedShape(BIG);
    }

    public Ufo(int x, int y, int size) {
        super(x, y);
        this.big = size == 15;
    }

    @Override
    public int getSize() {
        return this.big ? 16 : 8;
    }

    @Override
    public void draw(Graphics2D g) {
        g.setColor(UFO_COLOR[this.colorCode]);
        g.draw(AffineTransform.getTranslateInstance(this.x, this.y).createTransformedShape(this.big ? BIG : SMALL));
        this.drawVelocityVector(g, Color.red);
    }

    public String toString() {
        return String.format("Ufo(%s)@(%d,%d)*%d", this.getIdentity() == null ? "" : this.getIdentity().toString(), this.x, this.y, this.getSize());
    }

    @Override
    public Collection<Property> getProperties() {
        Collection<Property> props = super.getProperties();
        props.add(new Property<String>("Ufo Size", this.big ? "BIG" : "small"));
        return props;
    }

    @Override
    public String getObjectType() {
        return "Ufo";
    }

    @Override
    public int getScore() {
        return this.big ? 200 : 1000;
    }

    public void setColor(int color) {
        this.colorCode = color;
    }
}

