/*
 * Decompiled with CFR 0.152.
 */
package de.caff.i18n;

import de.caff.i18n.I18n4Java1;
import de.caff.i18n.Localizable;
import de.caff.util.Utility;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class I18n {
    static boolean DEBUG;
    private static final I18n i18n;
    public static final String SUFFIX_TEXT = "-TEXT";
    public static final String SUFFIX_TOOLTIP = "-TTT";
    public static final String SUFFIX_DESCRIPTION = "-DESCR";
    public static final String SUFFIX_ACCELERATOR = "-ACCEL";
    public static final String SUFFIX_MNEMONIC = "-MNEMO";
    public static final String SUFFIX_ICON = "-ICON";
    public static final String SUFFIX_DISABLED_ICON = "-ICON-DIS";
    public static final String SUFFIX_INACTIVE_ICON = "-ICON-INACT";

    static {
        String vmversion;
        DEBUG = false;
        try {
            vmversion = System.getProperty("java.vm.version");
        }
        catch (Throwable x) {
            vmversion = null;
        }
        I18n tmp = new I18n4Java1();
        if (vmversion != null && !vmversion.startsWith("1.1")) {
            try {
                tmp = (I18n)Class.forName("de.caff.i18n.java2.I18n4Java2").newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        i18n = tmp;
    }

    public static void addAppResourceBase(String base) {
        if (i18n != null) {
            i18n._addAppResourceBase(base);
        }
    }

    protected abstract void _addAppResourceBase(String var1);

    public static void setDefaultLocale(Locale l) {
        i18n._setDefaultLocale(l);
    }

    protected abstract void _setDefaultLocale(Locale var1);

    public static Locale getDefaultLocale() {
        return i18n._getDefaultLocale();
    }

    protected abstract Locale _getDefaultLocale();

    private static final ResourceBundle getBundle(Locale l) throws MissingResourceException {
        return i18n._getBundle(l);
    }

    protected abstract ResourceBundle _getBundle(Locale var1) throws MissingResourceException;

    public static String getString(String tag) throws MissingResourceException {
        return I18n.getString(tag, null);
    }

    public static String getString(String tag, Locale l) throws MissingResourceException {
        return I18n.getBundle(l).getString(tag);
    }

    public static String format(String tag, Object[] args) throws MissingResourceException {
        return I18n.format(tag, args, null);
    }

    public static String format(String tag, Object arg) throws MissingResourceException {
        return I18n.format(tag, new Object[]{arg});
    }

    public static String format(String tag, Object arg1, Object arg2) throws MissingResourceException {
        return I18n.format(tag, new Object[]{arg1, arg2});
    }

    public static String format(String tag, Object arg1, Object arg2, Object arg3) throws MissingResourceException {
        return I18n.format(tag, new Object[]{arg1, arg2, arg3});
    }

    public static String format(String tag, Object[] args, Locale l) throws MissingResourceException {
        return Utility.compileString(tag, args, I18n.getBundle(l));
    }

    public static String format(String tag, Object arg, Locale l) throws MissingResourceException {
        return I18n.format(tag, new Object[]{arg}, l);
    }

    public static String format(String tag, Object arg1, Object arg2, Locale l) throws MissingResourceException {
        return I18n.format(tag, new Object[]{arg1, arg2}, l);
    }

    public static String format(String tag, Object arg1, Object arg2, Object arg3, Locale l) throws MissingResourceException {
        return I18n.format(tag, new Object[]{arg1, arg2, arg3}, l);
    }

    public static void addLocalizationChangeListener(Localizable localizable) {
        i18n._addLocalizationChangeListener(localizable);
    }

    protected abstract void _addLocalizationChangeListener(Localizable var1);

    public static void removeLocalizationChangeListener(Localizable localizable) {
        i18n._removeLocalizationChangeListener(localizable);
    }

    protected abstract void _removeLocalizationChangeListener(Localizable var1);

    protected abstract void _fireLocaleChanged(Locale var1);
}

