/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings.swing;

import de.caff.util.settings.swing.AbstractBasicEditorProvider;
import de.caff.util.settings.swing.SwingBooleanPreferenceProperty;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

class BooleanEditor
extends AbstractBasicEditorProvider
implements PropertyChangeListener {
    private final SwingBooleanPreferenceProperty property;
    private final JCheckBox checkBox;

    public BooleanEditor(SwingBooleanPreferenceProperty property, Locale l) {
        super(property, l);
        this.property = property;
        this.checkBox = new JCheckBox(null, property.getValue());
        property.addValueChangeListener(this);
    }

    @Override
    public JComponent getEditor() {
        return this.checkBox;
    }

    @Override
    public void reset() {
        this.checkBox.setSelected(this.property.getValue());
    }

    @Override
    public void save() {
        this.property.setValue(this.checkBox.isSelected());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        boolean newValue = (Boolean)evt.getNewValue();
        if (newValue != this.checkBox.isSelected()) {
            this.checkBox.setSelected(newValue);
        }
    }

    @Override
    public void goodBye() {
        this.property.removeValueChangeListener(this);
    }
}

