/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings.swing;

import de.caff.util.settings.DoublePreferenceProperty;
import de.caff.util.settings.swing.AbstractBasicSimpleEditablePreferenceProperty;
import de.caff.util.settings.swing.DoubleEditor;
import de.caff.util.settings.swing.EditorProvider;
import java.util.Locale;
import java.util.prefs.Preferences;

public class SwingDoublePreferenceProperty
extends AbstractBasicSimpleEditablePreferenceProperty
implements DoublePreferenceProperty {
    private final double minValue;
    private final double maxValue;
    private final double step;
    private double value;

    public SwingDoublePreferenceProperty(String basicName, String baseTag, double value) {
        this(basicName, baseTag, value, 1.0);
    }

    public SwingDoublePreferenceProperty(String basicName, String baseTag, double value, double step) {
        this(basicName, baseTag, value, -1.7976931348623157E308, Double.MAX_VALUE, step);
    }

    public SwingDoublePreferenceProperty(String basicName, String baseTag, double value, double minValue, double maxValue) {
        this(basicName, baseTag, value, minValue, maxValue, 1.0);
    }

    public SwingDoublePreferenceProperty(String basicName, String baseTag, double value, double minValue, double maxValue, double step) {
        super(basicName, baseTag);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.step = step;
        this.value = value;
    }

    @Override
    public void readFrom(Preferences preferences) {
        this.setValue(preferences.getDouble(this.getBasicName(), this.value));
    }

    @Override
    public void storeTo(Preferences preferences) {
        preferences.putDouble(this.getBasicName(), this.value);
    }

    @Override
    public EditorProvider getEditorProvider(Locale l) {
        return new DoubleEditor(this, l);
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public double getStep() {
        return this.step;
    }

    @Override
    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        double oldValue = this.value;
        this.value = value > this.maxValue ? this.maxValue : (value < this.minValue ? this.minValue : value);
        if (oldValue != this.value) {
            this.fireValueChange(this.getBasicName(), new Double(oldValue), new Double(this.value));
        }
    }
}

