// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2005  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.util.settings.swing;

import javax.swing.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Locale;

/**
 *  Editor provider for directory properties.
 *
 *  @author <a href="mailto:rammi@caff.de">Rammi</a>
 *  @version $Revision$
 */
class DirectoryEditor
        extends AbstractBasicEditorProvider
        implements PropertyChangeListener
{
  /** The associated preference property. */
  private final SwingDirectoryPreferenceProperty property;
  /** Box with label and button. */
  private final Box box = Box.createHorizontalBox();
  /** Label displaying the current selection. */
  private final JLabel label;
  /** Button which starts a color chooser dialog. */
  private final JButton button;
  /** The locally changed color. */
  private File directory;

  /**
   * Constructor.
   * @param prop property to edit
   * @param l    locale to use
   */
  public DirectoryEditor(SwingDirectoryPreferenceProperty prop, final Locale l)
  {
    super(prop, l);
    this.property = prop;
    directory = property.getDirectory();
    label = new JLabel(directory.getPath());
    button = new JButton("...");
    button.addActionListener(new ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        JFileChooser chooser = new JFileChooser(directory);
        chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        chooser.setDialogTitle(property.getName(l));
        if (chooser.showSaveDialog(button) == JFileChooser.APPROVE_OPTION) {
          setDirectory(chooser.getSelectedFile());
        }
      }
    });
    box.add(label);
    box.add(Box.createHorizontalGlue());
    box.add(button);
    property.addValueChangeListener(this);
  }

  private void setDirectory(File dir)
  {
    directory = dir;
    label.setText(dir == null  ?   ""  :  dir.getPath());
  }

  /**
   * Get an component for editing .
   *
   * @return editor component
   */
  public JComponent getEditor()
  {
    return box;
  }

  /**
   * Reset the value in the editor to the basic value.
   */
  public void reset()
  {
    setDirectory(property.getDirectory());
  }

  /**
   * Set the basic value from the editor.
   */
  public void save()
  {
    property.setDirectory(directory);
  }

  /**
   * Called when the editor provider is no longer used.
   */
  public void goodBye()
  {
    property.removeValueChangeListener(this);
  }

  /**
   * This method gets called when a bound property is changed.
   *
   * @param evt A PropertyChangeEvent object describing the event source
   *            and the property that has changed.
   */

  public void propertyChange(PropertyChangeEvent evt)
  {
    setDirectory((File)evt.getNewValue());
  }

}
