/*
 * Copyright (C) 2008 Henning Faber
 * 
 * This file is part of Sitting Duck Asteroids Bot project.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. 
 */
package de.hfaber.asteroids.bot.research;


import de.hfaber.asteroids.bot.IAsteroidsBot;
import de.hfaber.asteroids.client.Commands;
import de.hfaber.asteroids.client.GameStatusEvent;
import de.hfaber.asteroids.game.objects.Ship;
import de.hfaber.asteroids.game.state.GameStatus;

/**
 * @author Henning Faber
 */
public class ShipMotionAnalyzer implements IAsteroidsBot {

    private GameStatus m_gameStatus;

    private int m_counter = 0;
    
    /* (non-Javadoc)
     * @see de.hfaber.asteroids.asteroids.bot.IAsteroidsBot#compute()
     */
    public Commands compute() {
        Commands c = new Commands();
        Ship ship = m_gameStatus.getShip();
        if (ship != null) {
            if ((m_counter == 0) || (m_counter == 2)) {
                if (m_gameStatus.isEvenFrame()) {
                    c.pressThrust(true);
                } else {
                    return c;
                }
            } 
            System.out.println("Frame " + m_counter + ": " + ship);
            m_counter++;
        }
        return c;
    }

    /* (non-Javadoc)
     * @see de.hfaber.asteroids.asteroids.client.IGameStatusListener#gameStatusUpdated(de.hfaber.asteroids.asteroids.client.GameStatusEvent)
     */
    public void gameStatusUpdated(GameStatusEvent e) {
        m_gameStatus = e.getGameStatus();
    }
}
