/*
 * Copyright (C) 2008 Henning Faber
 * 
 * This file is part of Sitting Duck Asteroids Bot project.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. 
 */
package de.hfaber.asteroids.client;

/**
 * ServerBusyException indicates that the mame server currently serves
 * a different client.
 * 
 * @author Henning Faber
 */
public class ServerBusyException extends Exception {

    /**
     * Serial version uid for serialization API.
     */
    private static final long serialVersionUID = -7645578510403241987L;

    /**
     * Creates a server busy exception with an empty message. 
     */
    public ServerBusyException() {
        this("");
    }
    
    /**
     * Creates a server busy exception with the given message.
     * 
     * @param message the message
     */
    public ServerBusyException(String message) {
        super(message);
    }
}
