/*
 * Copyright (C) 2008 Henning Faber
 * 
 * This file is part of Sitting Duck Asteroids Bot project.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. 
 */

package de.hfaber.asteroids.game.objects;

/**
 * Interface for a game object that can be tracked over several successive
 * frames.
 * 
 * @author Henning Faber
 */
public interface ITrackableGameObject {

    /**
     * Implementing classes must use this method to perform the 
     * actual tracking. 
     * 
     * @param prev the game object that represented the trackable game
     *  object in a previous frame 
     * @param frameGap the difference between the frame numbers of the
     *  frame where the trackable game object belongs to and the frame 
     *  from where the given previous trackable game object orginates 
     */
    public void track(GameObject prev, int frameGap);
    
}
