/*
 * Copyright (C) 2008 Henning Faber
 * 
 * This file is part of Sitting Duck Asteroids Bot project.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. 
 */
package de.hfaber.asteroids.gui;

import java.util.ArrayList;
import java.util.List;

import javax.swing.table.DefaultTableModel;

/**
 * @author Henning Faber
 */
public class RoundDurationTableModel extends DefaultTableModel {

    /**
     * Serial version UID for serialization API.
     */
    private static final long serialVersionUID = -1821695453490188988L;

    private static final String[] HEADER_NAMES = {
        "Round",
        "Duration (frames)"
    };

    private final List<Integer> m_durations;

    public RoundDurationTableModel() {
        super();
        m_durations = new ArrayList<Integer>();
    }
    
    /* (non-Javadoc)
     * @see javax.swing.table.TableModel#getColumnCount()
     */
    @Override
    public int getColumnCount() {
        return HEADER_NAMES.length;
    }

    /* (non-Javadoc)
     * @see javax.swing.table.AbstractTableModel#getColumnName(int)
     */
    @Override
    public String getColumnName(int column) {
        return HEADER_NAMES[column];
    }

    /* (non-Javadoc)
     * @see javax.swing.table.TableModel#getRowCount()
     */
    @Override
    public int getRowCount() {
        if (m_durations != null) {
            return m_durations.size();
        } else {
            return 0;
        }
    }

    /* (non-Javadoc)
     * @see javax.swing.table.TableModel#getValueAt(int, int)
     */
    @Override 
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0:
                return String.valueOf(rowIndex + 1);
            case 1:
                if ((rowIndex >= 0) && (rowIndex < m_durations.size())) {
                    int duration = m_durations.get(rowIndex);
                    return duration;
                } else {
                    return "";
                }
            default:
                return "";
        }
    }

    public final void setDuration(int roundNo, int duration) {
        
        if (roundNo > 0) {
            
            // ensure that table has enough lines
            boolean tableDataChanged = false;
            while (m_durations.size() < roundNo) {
                m_durations.add(Integer.valueOf(0));
                tableDataChanged = true;
            }
            
            // update duration
            m_durations.set(roundNo - 1, duration);
    
            // fire data change event
            if (tableDataChanged) {
                fireTableDataChanged();
            } else {
                fireTableRowsUpdated(roundNo - 1, roundNo - 1);
            }
        }
    }
    
    public final void reset() {
        m_durations.clear();
        fireTableDataChanged();
    }
}
