/*
 * Copyright (C) 2008 Henning Faber
 * 
 * This file is part of Sitting Duck Asteroids Bot project.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. 
 */
package de.hfaber.asteroids.bot.simplebot;


/**
 * @author Henning Faber
 */
public final class MinDist {
    
    private final double m_t;
    
    private final double m_minDist;

    /**
     * @param t
     * @param minDist
     */
    public MinDist(double t, double minDist) {
        super();
        m_t = t;
        m_minDist = minDist;
    }

    /**
     * @return the minDist
     */
    public final double getMinDist() {
        return m_minDist;
    }

    /**
     * @return the t
     */
    public final double getT() {
        return m_t;
    }
}
