/*
 * Copyright (C) 2008 Henning Faber
 * 
 * This file is part of Sitting Duck Asteroids Bot project.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. 
 */
package de.hfaber.asteroids.game.field;

/**
 * Provides constants about the playing field.
 * 
 * @author Henning Faber
 */
public final class Screen {

    /**
     * The internal precision used by the asteroids application for
     * the co-ordinates of objects.
     */
    public static final int INTERNAL_PRECISION = 8;
    
    /**
     * The width of the playing field.
     */
    public static final int WIDTH = 1024 * INTERNAL_PRECISION;

    /**
     * The height of the playing field.
     */
    public static final int HEIGHT = 768 * INTERNAL_PRECISION;
    
}
