// player.cpp: Beispielspieler fr Asteroids
// Harald Bgeholz / c't  
// verndert durch Bernd Rass

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <math.h>
#include <iostream>
#include <fstream>

using namespace std;

#if defined(WINDOWS)
#include <winsock2.h>
#else
// 2 Includes fr socket()
#include <sys/types.h>
#include <sys/socket.h>
// 2 Includes fr inet_addr()
#include <netinet/in.h>
#include <arpa/inet.h>
// 2 Includes fr fcntl()
#include <unistd.h>
#include <fcntl.h>
// fr memset()
#define INVALID_SOCKET -1
#define WSAGetLastError() errno
#endif

#include "player.h"

void Player::Run(void)
{
	const int ANZAHL_PREVGAMES = 4;
	const double PI = 3.1415926;
	const double DELTA_ANGLE = 6 * PI / 256;
	int numberOfPrevGames = 0;
	FramePacket frame;
	KeysPacket keys;
	NamePacket ctName;
	GameStatus game;
	GameStatus prevGame[ANZAHL_PREVGAMES+1];
	bool firstframe = true;
	bool fire = false;
	int framesUntilDestruction[MAX_ASTEROIDS];
	int destruction_dist = 28*28;  // Quadrat der Zerstrungsentfernung
	char prevframe = 0;
	int t = 0;
	int asteroidsTargetCounter[MAX_ASTEROIDS];
	bool fireButtonRelease = false;
	bool prevkey_left = false;
	bool prevkey_right = false;
	int angle_byte = 0;
	double angle_ship = 0.0;
	int angle_ship_dx = 1000;
	int angle_ship_dy = 0;
	ShipOrientation shipOrientation[256];
	fstream f;
	f.open("Winkelbyte-2.dat", ios::in);  /* d:\\Downloads\\ct\\2008-09_Asteroids\\ */
	if (!f)
	{
		cout << "Konnte Winkelbyte-Datei nicht oeffnen!" << endl;
		exit(3);
	}
	for (int i1 = 0; i1 < 256; i1++)
	{
		f >> shipOrientation[i1].index;
		f >> shipOrientation[i1].s_dx;
		f >> shipOrientation[i1].s_dy;
		f >> shipOrientation[i1].s_angle;
		//cout << shipOrientation[i1].index << " " << shipOrientation[i1].s_dx << " " << shipOrientation[i1].s_dy << " " << shipOrientation[i1].s_angle << endl;
	}
	f.close();

	for (int i1 = 0; i1 < MAX_ASTEROIDS; i1++)
	{
		asteroidsTargetCounter[i1] = 0;
	}

	for (;;)
	{
		++t;         // Zeit
		++keys.ping; // jedes gesendete Pckchen erhlt eine individuelle Nummer zur Latenzmessung

		
		SendPacket(keys);
		ReceivePacket(frame);

		int latenz = keys.ping - frame.ping;
		if (latenz < 0) latenz += 256;

		if (frame.frameno != ++prevframe || frame.ping != keys.ping)
		{
			printf("Latenz %d. %d Frames verloren.\n", latenz, frame.frameno - prevframe);
			prevframe = frame.frameno;
		}

		InterpretScreen(frame, game);

		keys.clear();   // alle Tasten loslassen
		int min_dist = 0x7fffffff;
		int minFramesUntilHit = 100000;
		int target_dx = 0;
		int target_dy = 0;
		int target_Asteroid = 0;
		bool target_saucer = false;

		if (prevkey_left)
		{
			for (int i1 = 1; i1 < 256; i1++)   // Winkelbyte bestimmen
			{
				if (game.ship_dx == shipOrientation[i1].s_dx && game.ship_dy == shipOrientation[i1].s_dy 
					&& prevGame[1].ship_dx == shipOrientation[i1-1].s_dx && prevGame[1].ship_dy == shipOrientation[i1-1].s_dy)
				{
					angle_byte = i1;
					i1 = 256;
				}
			}
			angle_byte += 1;
		}
		if (prevkey_right)
		{
			for (int i1 = 0; i1 < 255; i1++)   // Winkelbyte bestimmen
			{
				if (game.ship_dx == shipOrientation[i1].s_dx && game.ship_dy == shipOrientation[i1].s_dy 
					&& prevGame[1].ship_dx == shipOrientation[i1+1].s_dx && prevGame[1].ship_dy == shipOrientation[i1+1].s_dy)
				{
					angle_byte = i1;
					i1 = 256;
				}
			}
			angle_byte -= 1;
		}
		if (angle_byte < 0) angle_byte += 256;
		if (angle_byte > 255) angle_byte -= 256;
		//angle_ship = angle_byte * 6 * PI / 256;   Winkelbyte ohne Tabelle
		angle_ship = shipOrientation[angle_byte].s_angle * PI / 180;
		angle_ship_dx = (int) (1000 * cos(angle_ship));
		angle_ship_dy = (int) (1000 * sin(angle_ship));
		prevkey_left = false;
		prevkey_right = false;

	
		if (firstframe)
		{
			for (int i1 = 1; i1 <= ANZAHL_PREVGAMES; i1++)
			{
				prevGame[i1] = game;
			}
			if (server_ip != inet_addr("127.0.0.1"))
			{
				for (int i1 = 0; i1 < 10; i1++)
				{
					cout << ctName.dispname << "    " << server_ip << "     " << inet_addr("127.0.0.1") << endl;
					SendName(ctName);
				}
			}
			firstframe = false;
		}
		else
		{
			if ((prevGame[1].nasteroids != game.nasteroids) || (frame.frameno != prevframe))
			{
				numberOfPrevGames = 0;
				for (int i1 = 0; i1 < MAX_ASTEROIDS; i1++)
				{
					asteroidsTargetCounter[i1] = 0;
				}
			}
			if (numberOfPrevGames < ANZAHL_PREVGAMES)
			{
				numberOfPrevGames++;
			}
	
			if (game.ship_present)
			{
				int minFramesUntilDestruction = 1000;
				int mostDangerousAsteroid = 1000;
				int t1_dx = 1000;
				int t1_dy = 1000;
				int t2_dx = 1000;
				int t2_dy = 1000;
				int t1_Asteroid = 0;
				int t2_Asteroid = 0;

				for (int i=0; i<game.nasteroids; ++i)
				{
					int dx1 = game.asteroids[i].x - game.ship_x;
					while (dx1 < -512) dx1 += 1024; // dx1 normalisieren auf -512 ... 511
					while (dx1 > 511) dx1 -= 1024;
					int dy1 = game.asteroids[i].y - game.ship_y;
					while (dy1 < -384) dy1 += 768;  // dy1 normalisieren auf -384 ... 383
					while (dy1 > 383) dy1 -= 768;
					int dx2 = prevGame[numberOfPrevGames].asteroids[i].x - game.ship_x;
					while (dx2 < -512) dx2 += 1024; // dx2 normalisieren auf -512 ... 511
					while (dx2 > 511) dx2 -= 1024;
					int dy2 = prevGame[numberOfPrevGames].asteroids[i].y - game.ship_y;
					while (dy2 < -384) dy2 += 768;  // dy2 normalisieren auf -384 ... 383
					while (dy2 > 383) dy2 -= 768;

					int ddx = dx1 - dx2;	 // X-Koordinaten-Zuwachs fr numberOfPrevGames Frames
					int ddy = dy1 - dy2;	 // Y-Koordinaten-Zuwachs fr numberOfPrevGames Frames

					if (ddx < -512) ddx += 1024;
					if (ddx > 512) ddx -= 1024;
					if (ddy < -384) ddy += 768;
					if (ddy > 384) ddy -= 768;

					int dx = dx1;
					int dy = dy1;
					int dist = dx*dx+dy*dy;  // Quadrat des Abstands zu diesem Asteroiden
					switch (game.asteroids[i].sf)
					{	// Abstand um den ungefhren Radius des Asteroiden korrigieren
						case 0:  // groer Asteroid
							dist -= 40*40;
							break;
						case 15: // mittlerer Asteroid
							dist -= 20*20;
							break;
						case 14: // kleiner Asteroid
							dist -= 8*8;
							break;
					}
					if (dist < min_dist)
					{
						min_dist = dist;
					}

					if (asteroidsTargetCounter[i] > 0)
					{
						asteroidsTargetCounter[i]--;
					}
					else
					{
						double a = dx1;
						double b = dx1 * ddy / numberOfPrevGames;
						double c = dy1;
						double d = dy1 * ddx / numberOfPrevGames;
						double k1 = 1.0 + pow((a / c),2);
						double k2 = -(2 * a * (b - d))/pow(c,2);
						double k3 = 64.0 - pow((b - d) / c,2);
						k2 /= k1;
						k3 /= k1;
						double vyshot;
						if (c > 0) vyshot = sqrt(k3 + pow((k2 / 2.0),2)) - (k2 / 2.0);
						else vyshot = -sqrt(k3 + pow((k2 / 2.0),2)) - (k2 / 2.0);  // - vor sqrt => 2.Lsung der quadratischen Gleichung
						double vxshot = (a * vyshot - b + d) / c;

						double angleShip = atan2((double)game.ship_dy,(double)game.ship_dx);
						double angleAst = atan2(vyshot,vxshot);
						double angleDelta = abs(angleShip - angleAst);
						if (angleDelta > PI) angleDelta = 2 * PI - angleDelta;
						int framesUntilHit = int(sqrt((double)dist) / 8 + angleDelta / (6 * PI / 256));
						int dx3 = dx1 + framesUntilHit * ddx / numberOfPrevGames;
						int dy3 = dy1 + framesUntilHit * ddy / numberOfPrevGames;
						int dist3 = dx3*dx3 + dy3*dy3;
						framesUntilHit = int(sqrt((double)dist3) / 8 + angleDelta / (6 * PI / 256));
						if (framesUntilHit < minFramesUntilHit)
						{
							minFramesUntilHit = framesUntilHit;
							t1_dx = (int)(100 * vxshot);
							t1_dy = (int)(100 * vyshot);
							t1_Asteroid = i;
						}

						for (int j = 0; j < 120; j++)   // Abstnde fr die folgenen Frames hochrechnen
						{
							int dist = dx*dx+dy*dy;  // Quadrat des Abstands zu diesem Asteroiden
							switch (game.asteroids[i].sf)
							{	// Abstand um den ungefhren Radius des Asteroiden korrigieren
								case 0:  // groer Asteroid
									dist -= 40*40;
									break;
								case 15: // mittlerer Asteroid
									dist -= 20*20;
									break;
								case 14: // kleiner Asteroid
									dist -= 8*8;
									break;
							}
							if (dist < destruction_dist)
							{
								framesUntilDestruction[i] = j;
								if (j < minFramesUntilDestruction)
								{
									minFramesUntilDestruction = j;
									mostDangerousAsteroid = i;
									t2_dx = (int)(100 * vxshot);
									t2_dy = (int)(100 * vyshot);
									t2_Asteroid = i;
								}
								j = 1000;
							}
							dx = dx1 + ((j + 1) * ddx) / numberOfPrevGames;
							dy = dy1 + ((j + 1) * ddy) / numberOfPrevGames;
						}
					}
				}
				if (mostDangerousAsteroid < MAX_ASTEROIDS)
				{
					target_dx = t2_dx;
					target_dy = t2_dy;
					target_Asteroid = t2_Asteroid;
					//printf("%d %d \n", mostDangerousAsteroid,minFramesUntilDestruction);
				}
				else
				{
					target_dx = t1_dx;
					target_dy = t1_dy;
					target_Asteroid = t1_Asteroid;
				}


				if (game.saucer_present)
				{
					if (mostDangerousAsteroid > MAX_ASTEROIDS)
					{
						int dxs1 = game.saucer_x - game.ship_x;
						while (dxs1 < -512) dxs1 += 1024;
						while (dxs1 > 511) dxs1 -= 1024;
						int dys1 = game.saucer_y - game.ship_y;
						while (dys1 < -384) dys1 += 768;
						while (dys1 > 383) dys1 -= 768;
						int dxs2 = prevGame[numberOfPrevGames].saucer_x - game.ship_x;
						while (dxs2 < -512) dxs2 += 1024;
						while (dxs2 > 511) dxs2 -= 1024;
						int dys2 = prevGame[numberOfPrevGames].saucer_y - game.ship_y;
						while (dys2 < -384) dys2 += 768;
						while (dys2 > 383) dys2 -= 768;
						int dxs = dxs1;
						int dys = dys1;
						int dist = dxs*dxs+dys*dys;
						switch (game.saucer_size)
						{	// Abstand um den ungefhren Radius des UFOs korrigieren
						case 15: // groes UFO
							dist -= 20*12;
							break;
						case 14: // kleines UFO
							dist -= 10*6;
							break;
						}
						int ddxs = dxs1 - dxs2;	 // X-Koordinaten-Zuwachs fr numberOfPrevGames Frames
						int ddys = dys1 - dys2;	 // Y-Koordinaten-Zuwachs fr numberOfPrevGames Frames
						
						if (ddxs < -512) ddxs += 1024;
						if (ddxs > 512) ddxs -= 1024;
						if (ddys < -384) ddys += 768;
						if (ddys > 384) ddys -= 768;

						double a = dxs1;
						double b = dxs1 * ddys / numberOfPrevGames;
						double c = dys1;
						double d = dys1 * ddxs / numberOfPrevGames;
						double k1 = 1.0 + pow((a / c),2);
						double k2 = -(2 * a * (b - d))/pow(c,2);
						double k3 = 64.0 - pow((b - d) / c,2);
						k2 /= k1;
						k3 /= k1;
						double vyshot;
						if (c > 0) vyshot = sqrt(k3 + pow((k2 / 2.0),2)) - (k2 / 2.0);
						else vyshot = -sqrt(k3 + pow((k2 / 2.0),2)) - (k2 / 2.0);  // - vor sqrt => 2.Lsung der quadratischen Gleichung
						double vxshot = (a * vyshot - b + d) / c;

						target_dx = (int)(100 * vxshot);
						target_dy = (int)(100 * vyshot);
						target_saucer = true;
					}
				}

				// Schiff in Richtung auf das nchstgelegene Objekt drehen
				// mathematisch wird hier das Kreuzprodukt aus den Vektoren 
				// ship_dx/y/0 und min_dx/y/0 berechnet
				if (angle_ship_dx * target_dy - angle_ship_dy * target_dx > 0)
				{
					keys.left(true);
					prevkey_left = true;
				}
				else
				{
					keys.right(true);
					prevkey_right = true;
				}

				fire = false;
				if (fireButtonRelease == true)
				{
					fireButtonRelease = false;
				}
				else
				{
					if (numberOfPrevGames > 2)
					{
						int dx1, dy1, dx2, dy2, radius_square;
						if (target_saucer)
						{
							dx1 = game.saucer_x - game.ship_x;
							dy1 = game.saucer_y - game.ship_y;
							dx2 = prevGame[numberOfPrevGames].saucer_x - game.ship_x;
							dy2 = prevGame[numberOfPrevGames].saucer_y - game.ship_y;
						}
						else
						{
							dx1 = game.asteroids[target_Asteroid].x - game.ship_x;
							dy1 = game.asteroids[target_Asteroid].y - game.ship_y;
							dx2 = prevGame[numberOfPrevGames].asteroids[target_Asteroid].x - game.ship_x;
							dy2 = prevGame[numberOfPrevGames].asteroids[target_Asteroid].y - game.ship_y;
						}
						while (dx1 < -512) dx1 += 1024; // dx1 normalisieren auf -512 ... 511
						while (dx1 > 511) dx1 -= 1024;
						while (dy1 < -384) dy1 += 768;  // dy1 normalisieren auf -384 ... 383
						while (dy1 > 383) dy1 -= 768;
						while (dx2 < -512) dx2 += 1024; // dx2 normalisieren auf -512 ... 511
						while (dx2 > 511) dx2 -= 1024;
						while (dy2 < -384) dy2 += 768;  // dy2 normalisieren auf -384 ... 383
						while (dy2 > 383) dy2 -= 768;

						int dx = dx1;
						int dy = dy1;
						
						int ddx = dx1 - dx2;	 // X-Koordinaten-Zuwachs fr numberOfPrevGames Frames
						int ddy = dy1 - dy2;	 // Y-Koordinaten-Zuwachs fr numberOfPrevGames Frames

						if (ddx < -512) ddx += 1024;
						if (ddx > 512) ddx -= 1024;
						if (ddy < -384) ddy += 768;
						if (ddy > 384) ddy -= 768;

						if (target_saucer)
						{
							switch (game.saucer_size)
							{	// ungefhrer Radius des UFOs
							case 15: // groes UFO
								radius_square = 10*10;
								break;
							case 14: // kleines UFO
								radius_square = 5*5;
								break;
							}
							for (int j = 1; j < 70; j++)
							{
								int dist = dx*dx+dy*dy;  // Quadrat des Abstands zum Ufo
								if (dist < radius_square)
								{
									fire = true;
									fireButtonRelease = true;
									j = 1000;
								}
								dx = (int) (dx1 + j * (double)ddx / numberOfPrevGames - (j - 1) * 8 * cos(angle_ship) - 4 * cos(angle_ship));
								dy = (int) (dy1 + j * (double)ddy / numberOfPrevGames - (j - 1) * 8 * sin(angle_ship) - 4 * sin(angle_ship));
							}
						}
						else
						{
							for (int i3 = 0; i3 < game.nasteroids; i3++)
							{
								//if (asteroidsTargetCounter[i3] == 0)
								/* if (((game.asteroids[i3].sf == 14) && (asteroidsTargetCounter[i3] == 0))
									|| ((game.asteroids[i3].sf == 15) && (asteroidsTargetCounter[i3] == 0))
									|| (game.asteroids[i3].sf == 0)) */
								if (asteroidsTargetCounter[i3] <= 0)
								{
									int dx3 = game.asteroids[i3].x - game.ship_x;
									while (dx3 < -512) dx3 += 1024; // dx3 normalisieren auf -512 ... 511
									while (dx3 > 511) dx3 -= 1024;
									int dy3 = game.asteroids[i3].y - game.ship_y;
									while (dy3 < -384) dy3 += 768;  // dy3 normalisieren auf -384 ... 383
									while (dy3 > 383) dy3 -= 768;
									int dx4 = prevGame[numberOfPrevGames].asteroids[i3].x - game.ship_x;
									while (dx4 < -512) dx4 += 1024; // dx4 normalisieren auf -512 ... 511
									while (dx4 > 511) dx4 -= 1024;
									int dy4 = prevGame[numberOfPrevGames].asteroids[i3].y - game.ship_y;
									while (dy4 < -384) dy4 += 768;  // dy4 normalisieren auf -384 ... 383
									while (dy4 > 383) dy4 -= 768;

									int ddx = dx3 - dx4;	 // X-Koordinaten-Zuwachs fr numberOfPrevGames Frames
									int ddy = dy3 - dy4;	 // Y-Koordinaten-Zuwachs fr numberOfPrevGames Frames

									if (ddx < -512) ddx += 1024;
									if (ddx > 512) ddx -= 1024;
									if (ddy < -384) ddy += 768;
									if (ddy > 384) ddy -= 768;

									dx = dx3;
									dy = dy3;

									switch (game.asteroids[i3].sf)
									{	// ungefhrer Radius des Asteroiden
										case 0:  // groer Asteroid
											radius_square = 24*24;  // 24
											break;
										case 15: // mittlerer Asteroid
											radius_square = 12*12;  // 12
											break;
										case 14: // kleiner Asteroid
											radius_square = 6*6;  // 6
											break;
									}
									for (int j = 1; j < 70; j++)
									{
										int dist = dx*dx+dy*dy;  // Quadrat des Abstands zu diesem Asteroiden
										
										if (dist < radius_square)
										{
											fire = true;
											fireButtonRelease = true;
											if (game.nasteroids > 1)
											{
												if (game.asteroids[i3].sf == 0 || game.asteroids[i3].sf == 15) // ==0
												{
													if (asteroidsTargetCounter[i3] == 0)
													{
														asteroidsTargetCounter[i3] = -1;
													}
													else
													{
														asteroidsTargetCounter[i3] = (int)(sqrt((double)(dx3*dx3 + dy3*dy3)) / 8);
													}
												}
												else
												{
													asteroidsTargetCounter[i3] = (int)(sqrt((double)(dx3*dx3 + dy3*dy3)) / 8);
												}
											}
											j = 1000;
										}
										dx = (int) (dx3 + j * (double)ddx / numberOfPrevGames - (j - 1) * 8 * cos(angle_ship) - 4 * cos(angle_ship));
										dy = (int) (dy3 + j * (double)ddy / numberOfPrevGames - (j - 1) * 8 * sin(angle_ship) - 4 * sin(angle_ship));
									}
								}
							}
						}
					}
				}
				bool shotHit = false;				
				if (game.nshots > 0)
				{
					for (int i = 4; i < 6; i++)
					{
						int dx = game.shots[i].x - game.ship_x;
						while (dx < -512) dx += 1024; // dx normalisieren auf -512 ... 511
						while (dx > 511) dx -= 1024;
						int dy = game.shots[i].y - game.ship_y;
						while (dy < -384) dy += 768;  // dy normalisieren auf -384 ... 383
						while (dy > 383) dy -= 768;
						int dist = dx*dx+dy*dy;  // Quadrat des Abstands zu diesem Schuss
						if (dist < 30*30) shotHit = true;
					}
				}
				
				if ((min_dist < destruction_dist) || shotHit)  // Flucht
					keys.hyperspace(true);

				if (((game.nasteroids > 0) || (game.saucer_present)) && fire)  // Feuerknopf drcken   && (t % 2 == 0) 
				  keys.fire(true);
			}
		}

		for (int i1 = ANZAHL_PREVGAMES; i1 > 1; i1--)
		{
			prevGame[i1] = prevGame[i1-1];
		}
		prevGame[1] = game;
	}
}

void Player::InterpretScreen(FramePacket &packet, GameStatus& game)
{
	unsigned short *vector_ram = (unsigned short *)packet.vectorram;
	int dx, dy, sf, vx, vy, vz, vs;
	int v1x = 0;
	int v1y = 0;
	int shipdetect = 0;

	game.clear();
	if ((unsigned char)packet.vectorram[1] != 0xe0 && (unsigned char)packet.vectorram[1] != 0xe2)
		return; // sollte nicht vorkommen; erster Befehl ist immer ein JMPL

	int pc = 1;
	for (;;)
	{
		int op = vector_ram[pc] >> 12;
		switch (op)
		{
		case 0xa: // LABS
			vy = vector_ram[pc] & 0x3ff;
			vx = vector_ram[pc+1] & 0x3ff;
			vs = vector_ram[pc+1] >> 12;
			break;
		case 0xb: // HALT
			return;
		case 0xc: // JSRL
			switch (vector_ram[pc] & 0xfff)
			{
			case 0x8f3:
				game.asteroids[game.nasteroids++].set(vx, vy, 1, vs);
				break;
			case 0x8ff:
				game.asteroids[game.nasteroids++].set(vx, vy, 2, vs);
				break;
			case 0x90d:
				game.asteroids[game.nasteroids++].set(vx, vy, 3, vs);
				break;
			case 0x91a:
				game.asteroids[game.nasteroids++].set(vx, vy, 4, vs);
				break;
			case 0x929:
				game.saucer_present = true;
				game.saucer_x = vx;
				game.saucer_y = vy;
				game.saucer_size = vs;
				break;
			}  
			break;
		case 0xd: // RTSL
			return;
		case 0xe: // JMPL
			/*
			pc = vector_ram[pc] & 0xfff;
			break;
			*/
			return;
		case 0xf: // SVEC
			/*
			dy = vector_ram[pc] & 0x300;
			if ((vector_ram[pc] & 0x400) != 0)
				dy = -dy;
			dx = (vector_ram[pc] & 3) << 8;
			if ((vector_ram[pc] & 4) != 0)
				dx = -dx;
			sf = (((vector_ram[pc] & 8) >> 2) | ((vector_ram[pc] & 0x800) >> 11)) + 2;
			vz = (vector_ram[pc] & 0xf0) >> 4;
			*/
			break;
		default:
			dy = vector_ram[pc] & 0x3ff;
			if ((vector_ram[pc] & 0x400) != 0)
				dy = -dy;
			dx = vector_ram[pc+1] & 0x3ff;
			if ((vector_ram[pc+1] & 0x400) != 0)
				dx = -dx;
			sf = op;
			vz = vector_ram[pc+1] >> 12;
			if (dx == 0 && dy == 0 && vz == 15)
				game.shots[game.nshots++].set(vx, vy);
			if (op == 6 && vz == 12 && dx != 0 && dy != 0)
			{
				switch (shipdetect)
				{
				case 0:
					v1x = dx;
					v1y = dy;
					++shipdetect;
					break;
				case 1:
					game.ship_present = true;
					game.ship_x = vx;
					game.ship_y = vy;
					game.ship_dx = v1x - dx;
					game.ship_dy = v1y - dy;
					++shipdetect;
					break;
				}
			}
			else if (shipdetect == 1)
				shipdetect = 0;

			break;
		}
		if (op <= 0xa)
			++pc;
		if (op != 0xe) // JMPL
			++pc;
	}   

}


void Asteroid::set(int x, int y, int type, int sf)
{
	this->x = x;
	this->y = y;
	this->type = type;
	this->sf = sf;
}

void Shot::set(int x, int y)
{
	this->x = x;
	this->y = y;
}

void GameStatus::clear(void)
{
	ship_present = false;
	saucer_present = false;
	nasteroids = 0;
	nshots = 0;
}

KeysPacket::KeysPacket(void)
{
	signature[0] = 'c';
	signature[1] = 't';
	signature[2] = 'm';
	signature[3] = 'a';
	signature[4] = 'm';
	signature[5] = 'e';
	keys = '@';
	ping = 0;
}

void KeysPacket::clear(void)
{
	keys = '@';
}

void KeysPacket::hyperspace(bool b)
{
	if (b)
		keys |= KEY_HYPERSPACE;
	else
		keys &= ~KEY_HYPERSPACE;
}

void KeysPacket::fire(bool b)
{
	if (b)
		keys |= KEY_FIRE;
	else
		keys &= ~KEY_FIRE;
}

void KeysPacket::thrust(bool b)
{
	if (b)
		keys |= KEY_THRUST;
	else
		keys &= ~KEY_THRUST;
}

void KeysPacket::left(bool b)
{
	if (b)
	{
		keys |= KEY_LEFT;
		right(false);
	}
	else
		keys &= ~KEY_LEFT;
}

void KeysPacket::right(bool b)
{
	if (b)
	{
		keys |= KEY_RIGHT;
		left(false);
	}
	else
		keys &= ~KEY_RIGHT;
}

NamePacket::NamePacket(void)
{
	signature[0] = 'c';
	signature[1] = 't';
	signature[2] = 'n';
	signature[3] = 'a';
	signature[4] = 'm';
	signature[5] = 'e';
	sprintf(dispname, "brass");
}

void Player::ReceivePacket(FramePacket &packet)
{
	sockaddr_in sender;
	int sender_size = sizeof sender;
	fd_set readfds, writefds, exceptfds;

	do
	{
		FD_ZERO(&readfds);
		FD_ZERO(&writefds);
		FD_ZERO(&exceptfds);
		FD_SET(sd, &readfds);
		FD_SET(sd, &exceptfds);
		select(sd+1, &readfds, &writefds, &exceptfds, NULL);
		int bytes_received = recv(sd, (char *)&packet, sizeof packet, 0);
		if (bytes_received != sizeof packet)
		{
			int err = WSAGetLastError();
			fprintf(stderr, "Fehler %d bei recvfrom().\n", err);
			exit(1);
		}
		FD_ZERO(&readfds);
		FD_ZERO(&writefds);
		FD_ZERO(&exceptfds);
		FD_SET(sd, &readfds);
		timeval zero;
		zero.tv_sec = zero.tv_usec = 0;
		select(sd+1, &readfds, &writefds, &exceptfds, &zero);
	} while(FD_ISSET(sd, &readfds));
}

void Player::SendPacket(KeysPacket &packet)
{
	sockaddr_in server;
	memset(&server, 0, sizeof server);
	server.sin_family = AF_INET;
	server.sin_port = htons(1979);
	server.sin_addr.s_addr = server_ip;
	if (sizeof packet != sendto(sd, (char *)&packet, sizeof packet, 0, (sockaddr*)&server, sizeof server))
	{
#if defined(WINDOWS)
		int err = WSAGetLastError();
		if (err != WSAEWOULDBLOCK)
		{
			fprintf(stderr, "Fehler %d bei sendto().\n", err);
			exit(1);
		}
#else
		if (errno != EAGAIN)
		{
			perror("Fehler bei sendto()");
			exit(1);
		}
#endif
	}
}

void Player::SendName(NamePacket &packet)
{
	sockaddr_in server;
	memset(&server, 0, sizeof server);
	server.sin_family = AF_INET;
	server.sin_port = htons(1979);
	server.sin_addr.s_addr = server_ip;
	if (sizeof packet != sendto(sd, (char *)&packet, sizeof packet, 0, (sockaddr*)&server, sizeof server))
	{
#if defined(WINDOWS)
		int err = WSAGetLastError();
		if (err != WSAEWOULDBLOCK)
		{
			fprintf(stderr, "Fehler %d bei sendto().\n", err);
			exit(1);
		}
#else
		if (errno != EAGAIN)
		{
			perror("Fehler bei sendto()");
			exit(1);
		}
#endif
	}
}
