﻿/*
 * Asteroids Player Client 
 * 2008 ct-Wettbewerb
 * 
 * by Stefc (stefan.boether@gmail.com) */

using System;

namespace stefc.asteroids
{
    /// <summary>
    /// Repräsentiert einen Frame der von MAME gekommen ist
    /// </summary>
    class FramePacket
    {
        private byte[] buffer;
        
        public FramePacket(byte[] receivedBytes)
        {
            buffer = receivedBytes;
        }

        public byte[] Buffer
        {
            get { return buffer; }
        }

        public byte Ping
        {
            get { return buffer[1025]; }
        }

        public byte FrameNo
        {
            get { return buffer[1024]; }
        }

        public int GetChecksum()
        { 
            int result = 0;
            for (int index= 0; index<1023; index++)
                result += buffer[index];
            return result;
        }
        
    
    }
}
