﻿/*
 * Asteroids Player Client 
 * 2008 ct-Wettbewerb
 * 
 * by Stefc (stefan.boether@gmail.com) */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace stefc.asteroids.strategy
{
    /// <summary>
    /// Strategy fürs Runden Ende
    /// </summary>
    class EndStrategy : AbstractStrategy
    {
        public EndStrategy(IController controler)
            : base(controler)
        { }

        public override AbstractStrategy Run(GameFrame currentGame)
        {
            if (DoRun(currentGame))
            {
                if (currentGame.GameState.WinkelByte != -1)
                {
                    Target target = null;   
                    {
                        target = currentGame.SearchNearest(true);
                    }

                    if (target != null)
                        GetInTarget(currentGame, target,true);

                    //if (currentGame.Velocity < Const.MAX_VELOCITY)
                    //    Controller.Thrust();                    
                }
            }

            if (!currentGame.HasAsteroids && currentGame.Ufo == null)
            {
                //if (currentGame.Ship != null)
                //{
                //    Vector center = GetCenter(currentGame.Ship.X, currentGame.Ship.Y);
                //    if ((center.Length > 300))
                //        Controller.Hyperspace();
                //}
                Console.WriteLine("[End] Strategy finish at {0} {1}", 
                    currentGame.GameState.Time, currentGame.Score);
                return Next;
            }

            return this;
        }

        private Vector GetCenter(int x, int y)
        {
            int dx = Const.WIDTH/2 - x; ;
            while (dx < -(Const.WIDTH / 2)) dx += Const.WIDTH; // dx normalisieren auf -512 ... 511
            while (dx >= (Const.WIDTH / 2)) dx -= Const.WIDTH;

            int dy = Const.HEIGHT/2 - y;
            while (dy < -(Const.HEIGHT / 2)) dy += Const.HEIGHT;  // dy normalisieren auf -384 ... 383
            while (dy >= (Const.HEIGHT / 2)) dy -= Const.HEIGHT;

            return Vector.CreateCartesian(dx, dy);
        }
    }
}
