﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace stefc.asteroids.strategy
{

    class WinkelByteStrategy: AbstractStrategy
    {

        private int startTime;

        public WinkelByteStrategy(IController controler)
            : base(controler)
        {
            startTime = -1;
        }

        public override AbstractStrategy Run(GameFrame currentGame)
        {
            if (DoRun(currentGame))
            {
                Controller.Right();

                int winkel = currentGame.GameState.WinkelByte;
                if ((winkel == 0) || (winkel == 128) || (winkel == 64) || (winkel == 192))
                    Controller.Fire();
            }
            // if (currentGame.GameState.WinkelByte != -1)
                //if (currentGame.IsOutOfSync)
                //{
                //    Console.WriteLine("Out of Sync:" + currentGame.GameState.WinkelByte.ToString());
                //    currentGame.GameState.ResetWinkelByte();

                //}


            //Controller.Left();

            //if (startTime >= 0 && startTime < 256)
            //    Console.WriteLine(String.Format("fireAngles[{0}] = new Point({1}, {2});", startTime, currentGame.Ship.Dx, currentGame.Ship.Dy));
            //startTime++;

            
            return this;
        }
    }
}
