﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows;
using System.Collections;

namespace ct.Asteroid
{
    class TOrbit
    {
        const int CMaxShots = 10;
        const int CMaxAsteroids = 100;
        
        const int CMaxLifeTime = 40;

        public const int CMaxShotDist = 560;
        public const int CMaxX =  768;
        public const int CMaxY = 1024;
        
        public const int DistCloser  = 100 * 100;
        public const int DistClose   = 200 * 200;
        public const int DistFar     = 300 * 300;
        public const int DistFarther = 400 * 400;
        
        public TShip Ship = new TShip();
        public TUfo Ufo = new TUfo();

        public List<TAsteroid> Asteroids = new List<TAsteroid>(CMaxAsteroids);
        public int AsteroidsCnt { get { return Asteroids.Count; } }  // Actuell number of Asteroids

        public List<TShot> Shots = new List<TShot>(CMaxShots);
        public int ShotsCnt { get { return Shots.Count; } }          // Actuell number of Shots

        public int Latenz = 0;

        public double ShipAngle = 0.0;
        
        private double[] LastShipAngle = new double[2] {0.0, 0.0};
        
        private int[] LastTurnDirection = new int[2] {1, 1};
        
        public int ShipViewIdx = 0;

        public double[] ShipViewArray = new double[] {  0.0,   3.6,   8.2,  12.7,  16.5,  21.2,  25.2,  29.5,  33.5,  37.8,
                                                41.7,  46.2,  50.8,  55.3,  59.4,  63.4,  67.5,  71.6,  76.1,  79.9,
                                                84.5,  89.1,  92.8,  97.2, 101.8, 105.5, 110.2, 114.1, 118.1, 122.8,
                                               126.7, 131.1, 135.0, 139.4, 143.3, 147.9, 151.9, 156.6, 160.7, 164.5,
                                               169.2, 172.8, 177.3, 181.9, 185.5, 189.9, 194.5, 198.2, 203.0, 206.9,
                                               211.0, 215.4, 220.0, 223.8, 227.5, 232.2, 235.9, 240.3, 245.1, 248.8,
                                               252.7, 257.3, 261.1, 265.6, 270.0, 273.6, 278.2, 282.7, 286.5, 291.2,
                                               295.0, 299.0, 303.5, 307.8, 311.7, 316.2, 320.0, 324.5, 328.6, 332.7,
                                               336.6, 341.6, 345.3, 349.9, 354.5, 358.1,   2.8,   7.2,  11.0,  15.5,
                                                19.3,  23.4,  28.1,  32.8,  36.7,  40.6,  45.0,  49.4,  53.3,  57.2,
                                                61.9,  66.6,  70.7,  74.5,  79.0,  82.8,  87.2,  91.9,  95.5, 100.1,
                                               104.7, 108.4, 113.4, 117.3, 121.4, 125.6, 130.0, 133.8, 138.3, 142.2,
                                               146.5, 151.0, 155.0, 158.8, 163.6, 167.3, 171.8, 176.6, 180.0, 184.4,
                                               188.9, 192.7, 197.3, 201.2, 205.0, 209.7, 214.2, 217.8, 222.5, 226.2,
                                               230.0, 234.6, 239.0, 243.1, 247.0, 251.8, 255.5, 260.1, 264.5, 268.1,
                                               272.7, 277.2, 280.8, 285.5, 289.3, 293.4, 298.1, 302.2, 306.7, 310.6,
                                               315.0, 318.9, 323.3, 327.2, 331.9, 335.9, 339.8, 344.5, 348.2, 352.8,
                                               357.2,   0.9,   5.5,  10.1,  13.9,  18.4,  22.5,  26.6,  30.6,  34.7,
                                                39.2,  43.8,  48.3,  52.2,  56.5,  60.5,  64.7,  68.8,  73.5,  77.3,
                                                81.8,  86.4,  90.0,  94.5,  98.9, 102.7, 107.3, 111.2, 115.3, 120.2,
                                               124.2, 127.8, 132.5, 136.1, 140.8, 145.3, 149.8, 153.9, 157.9, 161.8,
                                               166.3, 170.1, 174.3, 179.1, 182.9, 187.2, 191.5, 195.6, 200.3, 204.1,
                                               208.1, 212.1, 216.6, 221.0, 225.0, 228.9, 233.3, 237.8, 241.9, 245.9,
                                               249.8, 254.5, 258.4, 262.8, 267.3, 270.9, 275.5, 279.9, 283.7, 288.2,
                                               292.1, 296.1, 300.2, 304.7, 309.2, 313.8, 317.5, 322.2, 325.8, 329.8,
                                               334.7, 338.8, 342.7, 347.2, 351.1, 355.5 };
                                               
        public int ShotsCntOf (TOrb aOrb)
        {
            int cnt = 0;
            for (int i = 0; i < Shots.Count; i++)
                if (Shots[i].Source == aOrb)
                    ++cnt;
            return cnt;
        }

        public double ShotSpeed = 8.0;

        public class TAngleItem
        {
            double fAngle = 0.0;
            double fMinus = 0.0;
            double fPlus = 0.0;

            public TAngleItem(double aMinus, double aAngle, double aPlus)
            {
                fAngle = aAngle;
                fMinus = aMinus;
                fPlus = aPlus;
            }

            public TAngleItem(double aAngle)
            {
                fAngle = aAngle;
                fMinus = aAngle - 2.0;
                fPlus = aAngle + 2.0;
            }

            public double Angle { get { return fAngle; } }
            public double Minus { get { return fMinus; } }
            public double Plus { get { return fPlus; } }
        }

        public Dictionary<String, TAngleItem> ShipAngles = new Dictionary<String, TAngleItem>();

        public TOrbit()
        {
            Ship.Visible = false;
            Ufo.Visible = false;

            ShipAngles.Add("1536,0",      new TAngleItem(356.10,   0.00,   2.60));
            ShipAngles.Add("1528,152",    new TAngleItem(  5.20,   7.80,   9.47));
            ShipAngles.Add("1504,296", 	  new TAngleItem( 11.13,  12.80,  14.82));
            ShipAngles.Add("1472,440", 	  new TAngleItem( 16.83,  18.85,  20.75));
            ShipAngles.Add("1416,584",    new TAngleItem( 22.65,  24.55,  26.52 ));
            ShipAngles.Add("1360,720",    new TAngleItem( 28.48,  30.45,  32.18));
            ShipAngles.Add("1280,856",    new TAngleItem( 33.92,  35.65,  37.60));
            ShipAngles.Add("1192,976",    new TAngleItem( 39.55,  41.50,  43.40));
            ShipAngles.Add("1088,1088",   new TAngleItem( 45.30,  47.20,  49.15));
            ShipAngles.Add("976,1192",    new TAngleItem( 51.10,  53.05,  54.87));
            ShipAngles.Add("856,1280",    new TAngleItem( 56.68,  58.50,  60.42));
            ShipAngles.Add("720,1360",    new TAngleItem( 62.33,  64.25,  66.02));
            ShipAngles.Add("584,1416",    new TAngleItem( 67.78,  69.55,  71.50));
            ShipAngles.Add("440,1472",    new TAngleItem( 73.45,  75.40,  77.23));
            ShipAngles.Add("296,1504",    new TAngleItem( 79.07,  80.90,  82.87));
            ShipAngles.Add("152,1528",    new TAngleItem( 84.83,  86.80,  88.40));
            ShipAngles.Add("0,1536",      new TAngleItem( 90.00,  90.00,  90.00));
            ShipAngles.Add("-152,1528",   new TAngleItem( 91.85,  93.70,  95.63));
            ShipAngles.Add("-296,1504",   new TAngleItem( 97.57,  99.50, 101.33));
            ShipAngles.Add("-440,1472",   new TAngleItem(103.17, 105.00, 106.97));
            ShipAngles.Add("-584,1416",   new TAngleItem(108.93, 110.90, 112.63));
            ShipAngles.Add("-720,1360",   new TAngleItem(114.37, 116.10, 118.13));
            ShipAngles.Add("-856,1280",   new TAngleItem(120.17, 122.20, 124.07));
            ShipAngles.Add("-976,1192",   new TAngleItem(125.93, 127.80, 129.55));
            ShipAngles.Add("-1088,1088",  new TAngleItem(131.30, 133.05, 134.85));
            ShipAngles.Add("-1192,976",   new TAngleItem(136.65, 138.45, 140.42));
            ShipAngles.Add("-1280,856",   new TAngleItem(142.38, 144.35, 146.20));
            ShipAngles.Add("-1360,720",   new TAngleItem(148.05, 149.90, 151.90));
            ShipAngles.Add("-1416,584",   new TAngleItem(153.90, 155.90, 157.67));
            ShipAngles.Add("-1472,440",   new TAngleItem(159.43, 161.20, 163.08));
            ShipAngles.Add("-1504,296",   new TAngleItem(164.97, 166.85, 168.63));
            ShipAngles.Add("-1528,152",   new TAngleItem(170.42, 172.20, 174.97));
            ShipAngles.Add("-1536,0",     new TAngleItem(177.73, 180.00, 182.90));
            ShipAngles.Add("-1528,-152",  new TAngleItem(185.30, 187.70, 189.65));
            ShipAngles.Add("-1504,-296",  new TAngleItem(191.60, 193.55, 195.45));
            ShipAngles.Add("-1472,-440",  new TAngleItem(197.35, 199.25, 201.15));
            ShipAngles.Add("-1416,-584",  new TAngleItem(203.05, 204.95, 206.67));
            ShipAngles.Add("-1360,-720",  new TAngleItem(208.38, 210.10, 212.07));
            ShipAngles.Add("-1280,-856",  new TAngleItem(214.03, 216.00, 217.97));
            ShipAngles.Add("-1192,-976",  new TAngleItem(219.93, 221.90, 223.58));
            ShipAngles.Add("-1088,-1088", new TAngleItem(225.27, 226.95, 228.73));
            ShipAngles.Add("-976,-1192",  new TAngleItem(230.52, 232.30, 234.23));
            ShipAngles.Add("-856,-1280",  new TAngleItem(236.17, 238.10, 240.03));
            ShipAngles.Add("-720,-1360",  new TAngleItem(241.97, 243.90, 245.73));
            ShipAngles.Add("-584,-1416",  new TAngleItem(247.57, 249.40, 251.27));
            ShipAngles.Add("-440,-1472",  new TAngleItem(253.13, 255.00, 256.87));
            ShipAngles.Add("-296,-1504",  new TAngleItem(258.73, 260.60, 262.50));
            ShipAngles.Add("-152,-1528",  new TAngleItem(264.40, 266.30, 268.15));
            ShipAngles.Add("0,-1536",     new TAngleItem(270.00, 270.00, 270.00));
            ShipAngles.Add("152,-1528",   new TAngleItem(271.60, 273.20, 275.13));
            ShipAngles.Add("296,-1504",   new TAngleItem(277.07, 279.00, 280.87));
            ShipAngles.Add("440,-1472",   new TAngleItem(282.73, 284.60, 286.45));
            ShipAngles.Add("584,-1416",   new TAngleItem(288.30, 290.15, 292.02));
            ShipAngles.Add("720,-1360",   new TAngleItem(293.88, 295.75, 297.58));
            ShipAngles.Add("856,-1280",   new TAngleItem(299.42, 301.25, 303.15));
            ShipAngles.Add("976,-1192",   new TAngleItem(305.05, 306.95, 308.90));
            ShipAngles.Add("1088,-1088",  new TAngleItem(310.85, 312.80, 314.57));
            ShipAngles.Add("1192,-976",   new TAngleItem(316.33, 318.10, 320.07));
            ShipAngles.Add("1280,-856",   new TAngleItem(322.03, 324.00, 325.85));
            ShipAngles.Add("1360,-720",   new TAngleItem(327.70, 329.55, 331.25));
            ShipAngles.Add("1416,-584",   new TAngleItem(332.95, 334.65, 336.68));
            ShipAngles.Add("1472,-440",   new TAngleItem(338.72, 340.75, 342.62));
            ShipAngles.Add("1504,-296",   new TAngleItem(344.48, 346.35, 348.30));
            ShipAngles.Add("1528,-152",   new TAngleItem(350.25, 352.20, 354.80));
        }
        
        public override string ToString()
        {
            StringBuilder sho = new StringBuilder("");
            for (int i = 0; i < ShotsCnt; i++)
              sho.Append("  " + Shots[i].ToString() + "\n");    

            StringBuilder ast = new StringBuilder("");
            for (int i = 0; i < AsteroidsCnt; i++)
              ast.Append("  " + Asteroids[i].ToString() + "\n");               
              
            return String.Format("Ship:\n  {0}\n" +
                                 "UFO:\n  {1}\n" +
                                 "Shots: {2}, Speed={3:F}\n" + sho +
                                 "Asteroids: {4}\n" + ast,
                                 Ship.ToString(), Ufo.ToString(), ShotsCnt, ShotSpeed, AsteroidsCnt);
        }
        
        public void Clear()
        {
            Ship.Visible = false;
            Ufo.Visible = false;

            Asteroids.Clear();
            Shots.Clear();
        }
        
        public void BeginUpdate()
        {
            Ship.NeedUpdate = true;
            Ufo.NeedUpdate = true;
            for (int i = 0; i < AsteroidsCnt; i++)
                Asteroids[i].NeedUpdate = true;        
        }
        
        public void EndUpdate()
        {
            if ( Ship.NeedUpdate )
              Ship.Visible = false;
              
            if ( Ufo.NeedUpdate )
              Ufo.Visible = false;
              
            if ( !Ship.Visible && !Ufo.Visible ) 
              Shots.Clear();

            for (int i = AsteroidsCnt - 1; i >= 0; i--)
            {
                if (Asteroids[i].NeedUpdate)
                    Asteroids.RemoveAt(i);     // Remove not updated asteroids...
                else
                    Asteroids[i].LifeTime++;   // Increas LifeTime for each frame counter...
            }

            int cntUfoShots = 0;
            int cntShipShots = 0;
            
            for (int i = ShotsCnt - 1; i >= 0; i--)
            {
                if ((Shots[i].NeedUpdate) || (Shots[i].LifeTime > CMaxLifeTime))
                    Shots.RemoveAt(i);
                else {
                    Shots[i].LifeTime++;       // Increas LifeTime for each frame counter...
                    if ( Shots[i].Source.OrbType == TOrb.TOrbType.otShip )
                        ++cntShipShots;
                    else
                        ++cntUfoShots;
                    //if ( (cntShipShots >= 5) || (cntUfoShots >= 3) ) 
                    //    Shots.RemoveAt(i);
                }   
            }
        }

        public void UpdateUfo(Vector aPos, int aOrbSize, bool aVisible)
        {
             // Increas LifeTime for each frame counter...
             Ufo.LifeTime++;
             
             // Ufo found, update it and exit method...
             Ufo.Set (aPos, aOrbSize, aVisible);
        }

        public void UpdateShip(Vector aPos, int aOrbSize, bool aVisible, Vector aDirection)
        {
             // Increas LifeTime for each frame counter...
             Ship.LifeTime++;
             
             // Ufo found, update it and exit method...
             Ship.Set (aPos, aOrbSize, aVisible, aDirection);
        }
        
        public void UpdateAsteroid(Vector aPos, int aOrbSize, int aType)
        {
            bool found = false;
            
            foreach(var astroid in Asteroids)
            {                
                // Asteroid found, update it and exit method...
                if ( (!found) && (astroid.Match (aPos, aOrbSize, aType)) )
                {
                  astroid.Set (aPos, aOrbSize, aType);
                  found = true;
                }
            }
            // Not found, add new asteroid...
            if (!found)
            {
                Asteroids.Add(new TAsteroid(aPos, aOrbSize, aType));
            }
        }
        
        public void UpdateShot(Vector aPos)
        {
            bool found = false;
            
            foreach(var shot in Shots)
            {
                // Calc actual speed of ship shots...
                if (shot.Source.OrbType == TOrb.TOrbType.otShip) 
                {
                    if (shot.Speed.Length > 0)
                        ShotSpeed = (2 * ShotSpeed + shot.Speed.Length) / 3;
                }                 
                // Shot found, update it and exit method...
                if ( (!found) && (shot.Match (aPos)) )
                {
                  shot.Set(aPos);
                  found = true;
                }
            }
            // Not found, add new shot...
            if ( !found ) 
            {
              // Shot from Ufo or from Ship?
              if ( Ship.Visible && Ufo.Visible )
                Shots.Add(new TShot(aPos, Ship, Ufo));
              else if ( Ship.Visible )
                Shots.Add(new TShot(aPos, Ship));                
              else if ( Ufo.Visible )
                Shots.Add(new TShot(aPos, Ufo));
               
              if ( ShotsCnt > 0 ) { 
                double vs = 0;
                Ship.DistanceTo(Shots[ShotsCnt-1], ref vs);
              }
            }
        }
        
        public Vector TargetVector(TOrb aOrb)
        {
            Vector shipHead = new Vector(Ship.X + Ship.Direction.X/85, Ship.Y + Ship.Direction.Y/85);
            Vector zi = new Vector(0,0);
            if ( aOrb == null ) return zi;

            if ( aOrb.Visible ) 
            {
                double ni = 0;
                Vector di = new Vector(0,0);

                di = aOrb.VirtualPosition - Ship.Position;
                double diL = di.Length;
                while ((diL > ShotSpeed) && (diL > 0) && (ni <= 96))
                {
                    ++ni;
                    di = (aOrb.VirtualPosition + (ni) * aOrb.Speed) - Ship.Position;
                    diL = di.Length - (ni) * ShotSpeed;
                }
                zi = (aOrb.VirtualPosition + (ni + (diL / ShotSpeed) - 2) * aOrb.Speed) - Ship.Position;
//                zi = (aOrb.VirtualPosition + (ni + (diL / ShotSpeed) - (2 + (Latenz - 1))) * aOrb.Speed) - Ship.Position;
            }
            return zi;
        }

        public double TargetAngle(TOrb aOrb)
        {
            Vector vt = TargetVector(aOrb);

            double wt = Math.Atan2(Math.Abs(vt.Y), Math.Abs(vt.X)) * (180 / Math.PI);
            if (vt.X < 0 && vt.Y >= 0)
                wt = 180 - wt;
            else if (vt.X < 0 && vt.Y < 0)
                wt = 180 + wt;
            else if (vt.X >= 0 && vt.Y < 0)
                wt = 360 - wt;

            return wt;
        }
        
        public bool DangerShot()
        {
            double vs = 0;
            for (int i = 0; i < ShotsCnt; ++i)
            {
                Ship.DistanceTo(Shots[i], ref vs);
            }

            for (int i = 0; i < ShotsCnt; ++i)
            {
                double oldDist = ((Ship.Position - Ship.Speed) - (Shots[i].Position - Shots[i].Speed)).Length;
                double newDist = (Ship.Position - Shots[i].Position).Length;

                if ((newDist <= oldDist) && (newDist < (Ship.Size()/2 + 2*Shots[i].Speed.Length)))
                    return true;
            }
            return false;
        
        }

        public bool CheckDangerShots(TOrb aTargetOrb)
        {
            int step = 0;
            double oldDist = 0;
            double newDist = 0;

            for (int i = 0; i < ShotsCnt; ++i)
            {
                if ((Shots[i].Position.Length > 0) && (Shots[i].Speed.Length > 0)) 
                {
                    step = 1;
                    oldDist = (Shots[i].Position - aTargetOrb.Position).Length;
                    newDist = oldDist - 1;
                    while ((newDist < oldDist) && (step <= (CMaxX/ShotSpeed)))
                    {
                        ++step;
                        oldDist = newDist;
                        newDist = ((Shots[i].Position + step * Shots[i].Speed) - 
                                   (aTargetOrb.Position + step * aTargetOrb.Speed)).Length;
                        if (newDist <= aTargetOrb.Size())
                            return true;
                    }
                    if ((step > 1) && (newDist <= 0.7*aTargetOrb.Size()))
                        return true;
                }
            }
            return false;
        }

        public bool CheckVirtualDangerShots(TOrb aTargetOrb)
        {
            int step = 0;
            double oldDist = 0;
            double newDist = 0;

            for (int i = 0; i < ShotsCnt; ++i)
            {
                if ((Shots[i].Position.Length > 0) && (Shots[i].Speed.Length > 0))
                {
                    step = 1;
                    oldDist = (Shots[i].Position - aTargetOrb.VirtualPosition).Length;
                    newDist = oldDist - 1;
                    while ((newDist < oldDist) && (step <= (CMaxX / ShotSpeed)))
                    {
                        ++step;
                        oldDist = newDist;
                        newDist = ((Shots[i].VirtualPosition + step * Shots[i].Speed) -
                                   (aTargetOrb.Position + step * aTargetOrb.Speed)).Length;
                        if (newDist <= aTargetOrb.Size())
                            return true;
                    }
                    if ((step > 1) && (newDist <= 0.7 * aTargetOrb.Size()))
                        return true;
                }
            }
            return false;
        }

        public int TurnDirection(double aAngle, ref double aDiff)
        {
            double sa = ShipAngles[Ship.Direction.ToString()].Angle;

            if (sa == LastShipAngle[1])
            {
                if (LastShipAngle[0] == LastShipAngle[1])
                {
                    if (LastTurnDirection[0] == 1 && LastTurnDirection[1] == 1)
                        sa = ShipAngles[Ship.Direction.ToString()].Plus;
                    if (LastTurnDirection[0] == -1 && LastTurnDirection[1] == -1)
                        sa = ShipAngles[Ship.Direction.ToString()].Minus;
                }
                else
                {
                    LastShipAngle[0] = LastShipAngle[1];

                }
                if (LastTurnDirection[1] == 1)
                {
                }
                else
                {
                }
            }
            else
            {
                LastShipAngle[0] = LastShipAngle[1];
                LastShipAngle[1] = sa;
                if (LastTurnDirection[1] == 1)
                    sa = ShipAngles[Ship.Direction.ToString()].Minus;
                else
                    sa = ShipAngles[Ship.Direction.ToString()].Plus;
            }

            LastTurnDirection[0] = LastTurnDirection[1];

            ShipAngle = sa;
            if (sa > aAngle) // turn to right
            {
                aDiff = Math.Min(sa - aAngle, aAngle + (360.0 - sa)); 
                if ((sa - aAngle) < (aAngle + (360.0 - sa)))
                    LastTurnDirection[1] = -1;
                else
                    LastTurnDirection[1] = 1;
            }
            else                                     // turn to left
            {
                aDiff = Math.Min(aAngle - sa, sa + (360.0 - aAngle));
                if ((aAngle - sa) < (sa + (360.0 - aAngle)))
                    LastTurnDirection[1] = 1;
                else
                    LastTurnDirection[1] = -1;
            }
            return LastTurnDirection[1];
        }

        public void TurnShipViewIdx(int aDirection)  // +1: left, -1: right
        {
            if (aDirection > 0) // left
            {
                if (ShipViewIdx >= 256)
                    ShipViewIdx = 3;
                else
                    ShipViewIdx = ShipViewIdx + 3;
            }
            else                // right
            {
                if (ShipViewIdx <= 3)
                    ShipViewIdx = 256;
                else
                    ShipViewIdx = ShipViewIdx - 3;
            }
            
            ShipAngle = 360 * (ShipViewIdx / 256);
        }

    }
}
