﻿using System;
using System.Collections.Generic;
using System.Text;

namespace ct.Asteroid
{
    public class TFramePacket
    {
        public byte[] vectorram = new byte[1026];
        public UInt16[] vectorram2 = new UInt16[513];
        public char FrameNo;  // wird bei jedem Frame inkrementiert
        public char PingNo;   // Der Server schickt das letzte empfangene ping-Byte zurück

        public static TFramePacket FromByteArray(byte[] array)
        {
            TFramePacket np = new TFramePacket();
            try
            {
                for (int i = 0; i < 513; i++)
                {
                    // Damit ich später nicht über einen Pointer auf das Vector-Ram zugreifen
                    // muss, kopiere ich die Daten in ein ushort Array um.
                    np.vectorram2[i] = (ushort)(array[2 * i] + array[(2 * i) + 1] * 256);
                    np.vectorram[i] = array[i];
                }

                np.FrameNo = (char)array[1024];
                np.PingNo = (char)array[1025];
            }
            catch
            {
                return np;
            }

            return np;
        }
    }

    public class TKeysPacket
    {
        const int KEY_HYPERSPACE =  1;
        const int KEY_FIRE       =  2;
        const int KEY_THRUST     =  4;
        const int KEY_RIGHT      =  8;
        const int KEY_LEFT       = 16;

        public int Keys;

        public char PingNo;     // wird vom Server bei nächster Gelegenheit zurückgeschickt. Für Latenzmessung.

        public TKeysPacket()
        {
            Keys = '@';
            PingNo = (char)0;
        }

        public void IncPingNo()
        {
            ++PingNo; // jedes gesendete Päckchen erhält eine individuelle Nummer zur Latenzmessung
            if (PingNo > 255)
                PingNo = (char)0;
        }

        public byte[] ToByteArray()
        {
            byte[] byts = new byte[8];

            byts[0] = (byte)'c';
            byts[1] = (byte)'t';
            byts[2] = (byte)'m';
            byts[3] = (byte)'a';
            byts[4] = (byte)'m';
            byts[5] = (byte)'e';
            byts[6] = (byte)Keys;
            byts[7] = (byte)PingNo;

            return byts;
        }

        public void Clear()
        {
            Keys = '@';
        }

        public void Hyperspace(bool b)
        {
            if (b)
                Keys |= KEY_HYPERSPACE;
            else
                Keys &= ~KEY_HYPERSPACE;
        }

        public void Fire(bool b)
        {
            if (b)
                Keys |= KEY_FIRE;
            else
                Keys &= ~KEY_FIRE;
        }

        public void Thrust(bool b)
        {
            if (b)
                Keys |= KEY_THRUST;
            else
                Keys &= ~KEY_THRUST;
        }

        public void Left(bool b)
        {
            if (b)
            {
                Keys |= KEY_LEFT;
                Right(false);
            }
            else
                Keys &= ~KEY_LEFT;
        }

        public void Right(bool b)
        {
            if (b)
            {
                Keys |= KEY_RIGHT;
                Left(false);
            }
            else
                Keys &= ~KEY_RIGHT;
        }
    }
}
