#include "Frame.h"
#include <iostream>
#include <math.h>

using namespace std;

void CAsteroidList::AddAsteroid(Vector vPos, int iGSF, int iType)
{
	iNumAsteroids++;
	SAsteroid tempAsteroid;
	switch (iGSF)
	{
		case 0:	tempAsteroid.dSize=32; break;
		case 15: tempAsteroid.dSize=16; break;
		case 14: tempAsteroid.dSize=8; break;
	}
	tempAsteroid.vPos=vPos;
	tempAsteroid.iType=iType;
	tempAsteroid.iStatus=STAT_ASTEROID;
	tempList.push_back(tempAsteroid);
}

void CAsteroidList::AddExplosion()
{
	SAsteroid tempAsteroid;
	tempAsteroid.dSize=0;
	tempAsteroid.iType=0;
	tempAsteroid.iStatus=STAT_EXPLOSION;
	//tempList.push_back(tempAsteroid);
}

int CAsteroidList::GetNumEntries()
{
	int result=0;
	for (int i=0;i<MAX_ASTEROID;i++) if (Asteroids[i].iStatus==STAT_ASTEROID) result++;
	return result;
}

int CAsteroidList::GetNextEntry(int LastEntry)
{
	for (int i=LastEntry;i<MAX_ASTEROID;i++)
	{
		if (Asteroids[i].iStatus!=STAT_FREE) return i;
	}
}

int CAsteroidList::GetNextAsteroidNumber(int LastAsteroid)
{
	for (int i=LastAsteroid;i<MAX_ASTEROID;i++)
	{
		if (Asteroids[i].iStatus==STAT_ASTEROID) return i;
	}
}

int CAsteroidList::GetNextFreeField(int LastField)
{
	for (int i=LastField;i<MAX_ASTEROID;i++)
	{
		if (Asteroids[i].iStatus==STAT_FREE) return i;		
	}
}

void CAsteroidList::DeleteExplosions()
{
	for (int i=0;i<MAX_ASTEROID;i++)
	{
		if (Asteroids[i].iStatus==STAT_EXPLOSION)
		{
			//Eine Explosion dauert 36 Frames
			if ( (iMomFrame-Asteroids[i].iFrameCreated)>36 ) Asteroids[i].iStatus=STAT_FREE;
		}
	}
}

void CAsteroidList::DeleteDuplicates()
{
	int momAsteroid=GetNextAsteroidNumber(0);
	for (int i=0; i<tempList.size();i++)
	{
		switch (tempList[i].iStatus)
		{
		case STAT_EXPLOSION:
			break;
		case STAT_ASTEROID:
			if (CompareAsteroids(tempList[i],Asteroids[momAsteroid]))
			{
				tempList[i].iStatus=STAT_FREE;
				momAsteroid=GetNextAsteroidNumber(momAsteroid+1);
			}			
			break;
		}
	}
}

bool CAsteroidList::CompareAsteroids(SAsteroid s1, SAsteroid s2)
{
	if (	(s1.iType==s2.iType) &&
			(abs(s1.dSize-s2.dSize)<0.1) &&
			((s1.vPos+s1.vDir-s2.vPos).GetLength()<100)	)
	{
		return true;
	}	
	return false;
}

void CAsteroidList::EndTurn()
{
	int momAsteroid=0;
	DeleteExplosions();
	int iNewEntries=tempList.size()-GetNumEntries();
	if (iNewEntries==0)
	{
		momAsteroid=GetNextAsteroidNumber(0);
		//Es hat sich nichts gendert - Nur Positionen updaten
		for (int i=0; i<tempList.size(); i++)
		{
			if (tempList[i].iStatus==STAT_ASTEROID) 
			{
				if (((iMomFrame-Asteroids[momAsteroid].iFrameCreated)<=8)&&((iMomFrame-Asteroids[momAsteroid].iFrameCreated)%2==0))
				{
					Asteroids[momAsteroid].vDir=(tempList[i].vPos-Asteroids[momAsteroid].vTempPos)/(iMomFrame-Asteroids[momAsteroid].iFrameCreated);
					if (Asteroids[momAsteroid].vDir.GetLength()>50) 
					{
						Asteroids[momAsteroid].vDir.Set(0,0);
						Asteroids[momAsteroid].vPos=tempList[i].vPos;
						Asteroids[momAsteroid].vTempPos=tempList[i].vPos;
						Asteroids[momAsteroid].iFrameCreated=iMomFrame;
					}
				} 
				Asteroids[momAsteroid].iFramesAlive=iMomFrame-Asteroids[momAsteroid].iFrameCreated;
				Asteroids[momAsteroid].vPos=tempList[i].vPos;
				Asteroids[momAsteroid].reset=false;
				momAsteroid=GetNextAsteroidNumber(momAsteroid+1);	
			}
		}
	} 
	else
	{
		//Am Anfang ist noch garnichts in die Asteroidenliste eingetragen
		//Deshalb kann die tempList einfach kopiert werden
		/*if (GetNumEntries()==0)
		{
			momAsteroid=GetNextFreeField(0);
			for (int i=0;i<tempList.size();i++)
			{
				if (tempList[i].iStatus==STAT_ASTEROID)
				{
					Asteroids[momAsteroid].iFrameCreated=iMomFrame;
					Asteroids[momAsteroid].iStatus=tempList[i].iStatus;
					Asteroids[momAsteroid].iType=tempList[i].iType;
					Asteroids[momAsteroid].dSize=tempList[i].dSize;
					Asteroids[momAsteroid].vPos=tempList[i].vPos;
					Asteroids[momAsteroid].vDir.Set(0,0);
					momAsteroid=GetNextFreeField(momAsteroid+1);
				}
			}
			return;
		}
		//Es hat sich was gendert und die Liste war nicht leer
		bool found=false;

		for (int j=0; j<tempList.size(); j++)
		{
			if (tempList[j].iStatus==STAT_ASTEROID)
			{
				//Suche tempList[j] in der Asteroids-Liste
				for (int k=0; k<MAX_ASTEROID; k++)
				{
					if (Asteroids[k].iStatus==STAT_ASTEROID)
					{
						if (CompareAsteroids(Asteroids[k],tempList[j])) found=true;
					}
				}
				//Neuen Asteroiden gefunden
				if (!found)
				{
					momAsteroid=GetNextFreeField(0);
					Asteroids[momAsteroid].iFrameCreated=iMomFrame;
					Asteroids[momAsteroid].iStatus=tempList[j].iStatus;
					Asteroids[momAsteroid].iType=tempList[j].iType;
					Asteroids[momAsteroid].dSize=tempList[j].dSize;
					Asteroids[momAsteroid].vPos=tempList[j].vPos;
					Asteroids[momAsteroid].vDir.Set(0,0);
				}
			}
		}
	}
	else if (iNewEntries<0)
	{
		for (int j=0; j<tempList.size(); j++)
		if (tempList[j].iStatus==STAT_EXPLOSION)
		{
			for (int k=0; k<MAX_ASTEROID; k++)
			{
				if (Asteroids[k].iStatus==STAT_ASTEROID)
				{
					if (CompareAsteroids(tempList[j],Asteroids[k]))
					{
						Asteroids[k].iStatus=STAT_FREE;
					}
				}
			}
		}
	}*/
		
		for (int i=0;i<MAX_ASTEROID;i++)
		{
			if (i<tempList.size())
			{
				if (tempList[i].iStatus==STAT_ASTEROID)
				{
					Asteroids[i].iFrameCreated=iMomFrame;
					Asteroids[i].iStatus=STAT_ASTEROID;
					Asteroids[i].iType=tempList[i].iType;
					Asteroids[i].dSize=tempList[i].dSize;
					Asteroids[i].vPos=tempList[i].vPos;
					Asteroids[i].vTempPos=tempList[i].vPos;
					Asteroids[i].vDir.Set(0,0);
					Asteroids[i].reset=true;
				} 
			} else	Asteroids[i].iStatus=STAT_FREE;
		}
		return;
	}
}

CFrame::CFrame(void)
{
	iLives=0;
	iNumFrames=0;
	OutFile.open("Frame.txt");
}

CFrame::~CFrame(void)
{
	OutFile.close();
}

CFrameInfo CFrameInfo::NextFrame(char cFrames)
{
	CFrameInfo FrameInfo=*this;
	//FrameInfo.Ship.vPos+=FrameInfo.Ship.vDir*(1+FrameInfo.cLatenz);
	for (int i=0;i<=MAX_ASTEROID;i++)
	{
		FrameInfo.Asteroids[i].vPos+=FrameInfo.Asteroids[i].vDir*cFrames;
		if (i<FrameInfo.iNumShots)
		{
			FrameInfo.Shots[i].vPos+=FrameInfo.Shots[i].vDir*cFrames;
		}
	}

	return FrameInfo;
}

void CFrameInfo::Normalize()
{
	for (int i=0;i<=MAX_ASTEROID;i++)
	{
		if (Asteroids[i].iStatus==STAT_ASTEROID)
		{
			Asteroids[i].vPos-=Ship.vPos;
			while (Asteroids[i].vPos.x<-512) Asteroids[i].vPos.x+=1024;
			while (Asteroids[i].vPos.x>512) Asteroids[i].vPos.x-=1024;
			while (Asteroids[i].vPos.y<-384) Asteroids[i].vPos.y+=768;
			while (Asteroids[i].vPos.y>384) Asteroids[i].vPos.y-=768;
		}
		if (i<iNumShots)
		{
			Shots[i].vPos-=Ship.vPos;
			while (Shots[i].vPos.x<-512) Shots[i].vPos.x+=1024;
			while (Shots[i].vPos.x>512) Shots[i].vPos.x-=1024;
			while (Shots[i].vPos.y<-384) Shots[i].vPos.y+=768;
			while (Shots[i].vPos.y>384) Shots[i].vPos.y-=768;
		}
	}
	Ship.vPos=Vector(0,0);
}

void CFrame::GetInfosFromVectorRam(char cFramesGone, char aVectorRam[1024])
{
	unsigned short *VectorRam = (unsigned short *)aVectorRam;
	iNumFrames+=cFramesGone;

	//Temporre Variablen initialisieren
	int iX=0, iY=0;
	int iDirX, iDirY;
	int iShipPeakX, iShipPeakY;
	int iIntensity;
	int iGSF;
	SShot TempShots[6];
	iNumShots=0;

	isAlive=false;
	int shipdetect = 0;
	iLives=0;

	//iProgramCounter
	int iProgramCounter = 1;
	int iOperator;

	UfoPresent = false;

	iPoints = 0;

	AsteroidList.NewTurn(iNumFrames);
	//Durchlaufe den Vectorram und extrahiere hieraus die Spielinformationen:
	for (;;)
	{
		//Ein Befehl im VektorRam hat 16 Bit, wobei die ersten 4 Bit den Operator darstellen
		//Also verschiebt man um 12 Bit nach rechts, sodass nur der Operator brig bleibt
		iOperator = VectorRam[iProgramCounter] >> 12;
		switch (iOperator)
		{
		case 0xa: // LABS - Strahl positionieren
			iY = ((unsigned short)VectorRam[iProgramCounter] & 0x3ff);
			iX = ((unsigned short)VectorRam[iProgramCounter+1] & 0x3ff);
			iGSF = VectorRam[iProgramCounter+1] >> 12;
			break;
		case 0xb: // HALT - Programmende
			return;
		case 0xc: // JSRL - Subroutine aufrufen (mom. Adresse auf Stack schreiben)
			switch (VectorRam[iProgramCounter] & 0xfff)
			{
			case 0x852:	//Copyrightmeldung(kommt direkt nach Asteroidenliste)
				AsteroidList.EndTurn();
				for (int i=0; i<iNumShots; i++) //Gehe TempShots durch
				{
					if (this->iNumFrames%SHOT_FREQ==0)
					{
						Shots[i].vDir=(TempShots[i].vPos-Shots[i].vPos)/SHOT_FREQ;
						if (Shots[i].vDir.GetLength()>15) Shots[i].vDir.Set(0,0);
						Shots[i].vPos=TempShots[i].vPos;
					}
				}
				break;
			case 0x8f3:	//Asteroid Typ 1
				AsteroidList.AddAsteroid(Vector(iX,iY),iGSF,0);
				break;
			case 0x8ff:	//Asteroid Typ 2
				AsteroidList.AddAsteroid(Vector(iX,iY),iGSF,1);
				break;
			case 0x90d:	//Asteroid Typ 3
				AsteroidList.AddAsteroid(Vector(iX,iY),iGSF,2);
				break;
			case 0x91a:	//Asteroid Typ 4
				AsteroidList.AddAsteroid(Vector(iX,iY),iGSF,3);
				break;
			case 0x929:	//UFO
				if (this->iNumFrames%8==0)
				{
					Ufo.vDir=(Vector(iX,iY)-Ufo.vPos)/8;
					Ufo.vPos.Set(iX,iY);
				}
				switch (iGSF)
				{
					case 0:	Ufo.dSize=32; break;
					case 15: Ufo.dSize=16; break;
					case 14: Ufo.dSize=8; break;
				}
				UfoPresent = true;
				break;
			case 0xA6D: //Leben
				iLives++;
				break;
			case 0xAFB: //'S'
				break;
			case 0x880: //Expl gro 3
				AsteroidList.AddExplosion();
				break;
			case 0x896: //Expl 2
				AsteroidList.AddExplosion();
				break;
			case 0x8B5: //Expl 1
				AsteroidList.AddExplosion();
				break;
			case 0x8D0: //Explosion klein 0
				AsteroidList.AddExplosion();
				break;
			} 
			if (iX == 100)
			switch (VectorRam[iProgramCounter] & 0xfff)
			{
			case 0xB2E: //1
				iPoints=iPoints*10+1;
				break;
			case 0xB32: //2
				iPoints=iPoints*10+2;
				break;
			case 0xB3A: //3
				iPoints=iPoints*10+3;
				break;
			case 0xB41: //4
				iPoints=iPoints*10+4;
				break;
			case 0xB48: //5
				iPoints=iPoints*10+5;
				break;
			case 0xB4F: //6
				iPoints=iPoints*10+6;
				break;
			case 0xB56: //7
				iPoints=iPoints*10+7;
				break;
			case 0xB5B: //8
				iPoints=iPoints*10+8;
				break;
			case 0xB63: //9
				iPoints=iPoints*10+9;
				break;
			case 0xADD: //0
				iPoints=iPoints*10+0;
				break;
			}  
			break;
		case 0xd: // RTSL - Rckkehr aus Subroutine
			return;
		case 0xe: // JMPL - unbedingter Sprung an angegebene Adresse (ohne Stack)
			/*
			pc = vector_ram[pc] & 0xfff;
			break;
			*/
			return;
		case 0xf: // SVEC - kurzer Vector
			
			/*vDir.y = VectorRam[iProgramCounter] & 0x300;
			if ((VectorRam[iProgramCounter] & 0x400) != 0)
				vDir.y = -vDir.y;
			vDir.x = (VectorRam[iProgramCounter] & 3) << 8;
			if ((VectorRam[iProgramCounter] & 4) != 0)
				vDir.x = -vDir.x;
			//int iScaling = (((VectorRam[iProgramCounter] & 8) >> 2) | ((VectorRam[iProgramCounter] & 0x800) >> 11)) + 2;
			iIntensity = (VectorRam[iProgramCounter] & 0xf0) >> 4;
			graphics.LineTo(vDir*3);*/
			break;
		default:	//VCTR - langer Vektor
			//Relative Richtung bestimmen
			iDirY = VectorRam[iProgramCounter] & 0x3ff;
			if ((VectorRam[iProgramCounter] & 0x400) != 0)
				iDirY = -iDirY;
			iDirX = VectorRam[iProgramCounter+1] & 0x3ff;
			if ((VectorRam[iProgramCounter+1] & 0x400) != 0)
				iDirX = -iDirX;
			iIntensity = VectorRam[iProgramCounter+1] >> 12;
			
			int iScaling=9-((iOperator+iGSF)%16);
			pow(2.0,(iScaling));

			//Schsse
			if ((iDirX== 0) && (iDirY == 0) && (iIntensity == 15)) 
			{
				TempShots[iNumShots++].vPos.Set(iX,iY);
			}

			if ((iOperator == 6) && (iIntensity == 12) && (iDirX != 0) && (iDirY != 0))
			{
				isAlive=true;
				switch (shipdetect)
				{
				case 0:
					shipdetect++;
					iShipPeakX=iX+iDirX;
					iShipPeakY=iY+iDirY;
					break;
				case 1:
//					if (iNumFrames%8==0)
//					{
//						Ship.vDir=(Vector(iX,iY)-Ship.vPos)/8;
						Ship.vPos.Set(iX,iY);
						Ship.vRealPos.Set(iX,iY);
//					}
					Ship.iDirX=iShipPeakX-(iX+iDirX);
					Ship.iDirY=iShipPeakY-(iY+iDirY);
					break;
				}
			}
			else if (shipdetect == 1)
				shipdetect = 0;
			break;
		}

		//ProgramCounter inkrementieren
		//bis 0xA muss dieser 2 Mal inkrementiert werden, da es sich hierbei um Doppelwortbefehle handelt!
		if (iOperator <= 0xa)
			iProgramCounter++;
		if (iOperator != 0xe) // JMPL
			iProgramCounter++;
	}   
}
