#pragma once

#include "lib/vector.h"
#include <vector>
#include <fstream>

#define MAX_ASTEROID 27
static int SHOT_FREQ = 2;

static const int STAT_FREE = 0;
static const int STAT_ASTEROID = 1;
static const int STAT_EXPLOSION = 2;

struct SShip {
	Vector vPos;
	Vector vRealPos;
	Vector vDir;
	int iDirX;
	int iDirY;
};

struct SAsteroid {
	int iFramesAlive;
	int iNumShotAt;
	Vector vPos, vTempPos;
	Vector vDir;
	double dSize;
	double dDistToShip;
	double dDistToWhereToShoot;
	double dPriority;
	double dAngleToShip;
	double dDistToShipRay;
	bool isAttacking;
	int iType;
	int iFrameCreated;
	int iStatus;
	bool bInFrontOfShip;

	bool reset;
	SAsteroid() {
		iStatus=STAT_FREE;
		dSize=0; iType=0;
		reset=true;
	}
};

struct SShot {
	Vector vPos;
	Vector vDir;
	int iFrameCreated;
	SShot() { vPos.Set(0,0); vDir.Set(0,0); }
};

class CAsteroidList
{
private:
	std::vector<SAsteroid> tempList;
	int iMomFrame;
	int GetNumEntries();
	int GetNextAsteroidNumber(int LastAsteroid);
	void DeleteExplosions();
	int GetNextFreeField(int LastField);
	void DeleteDuplicates();
	int GetNextEntry(int LastEntry);

	bool CompareAsteroids(SAsteroid s1, SAsteroid s2);

	int iNumAsteroids;

	void PrintTempList();
	void PrintAsteroidList();
public:
	SAsteroid Asteroids[MAX_ASTEROID];
	void NewTurn(int aMomFrame){ iMomFrame=aMomFrame; tempList.clear(); iNumAsteroids=0; }
	void EndTurn();
	int GetNumAsteroids() { return iNumAsteroids; }
	void AddAsteroid(Vector vPos, int iGSF, int iType);
	void AddExplosion();
	CAsteroidList(void) {}
};

class CFrameInfo 
{
public:
	unsigned char cWinkelByte;
	int iFrameNo;
	bool Alive;
	char iLives;
	bool UfoPresent;
	char iNumShots;
	char cFramesGone;
	char cLatenz;
	double dInternalShipAngle;
	double dShipAngleLeft;
	double dShipAngleRight;
	Vector vShipDir;
	SAsteroid Asteroids[MAX_ASTEROID+1]; //Letzter "asteroid" ist UFO
	int iNumAsteroids;
	SShip Ship;
	SShot Shots[6];
	int iPoints;
	void Normalize();
	CFrameInfo NextFrame(char cFrames);
};

class CFrame
{
private:
	int iLives;
	bool isAlive;
	int iNumFrames;
	CAsteroidList AsteroidList;
	SShot Shots[6];
	SAsteroid Ufo;
	bool UfoPresent;
	int iNumShots;
	int iPoints;

	std::ofstream OutFile;
public:
	SShip Ship;
	void GetInfosFromVectorRam(char cFramesGone, char aVectorRam[1024]);
	void GetFrameInfo(CFrameInfo &FrameInfo)
	{
		FrameInfo.Alive=isAlive;
		FrameInfo.iLives=iLives;
		FrameInfo.iNumAsteroids=AsteroidList.GetNumAsteroids();
		memcpy(FrameInfo.Asteroids,AsteroidList.Asteroids,sizeof(SAsteroid)*MAX_ASTEROID);
		memcpy(FrameInfo.Shots,Shots,sizeof(SShot)*6);
		FrameInfo.Ship=this->Ship;
		FrameInfo.Asteroids[MAX_ASTEROID]=this->Ufo;
		if (UfoPresent) FrameInfo.Asteroids[MAX_ASTEROID].iStatus=STAT_ASTEROID;
		else FrameInfo.Asteroids[MAX_ASTEROID].iStatus=STAT_EXPLOSION;
		FrameInfo.UfoPresent=UfoPresent;
		FrameInfo.iNumShots=iNumShots;
		FrameInfo.iPoints=iPoints;
	};
	bool Alive() { return isAlive; }
	CFrame(void);
	~CFrame(void);
};
