#ifndef MYSYNTAX_H
#define MYSYNTAX_H

#include <vector>
#include <algorithm>
#define PI 3.141592653589793 

static double SHOOTING_DIRECTIONS[256*6]= {
           1536, 0, 7.875, 0.000, 19, 0,
           1536, 0, 7.875, 0.500, 19, 1,
           1528, 152, 7.875, 1.125, 19, 2,
           1504, 296, 7.750, 1.750, 19, 4,
           1472, 440, 7.625, 2.250, 19, 5,
           1472, 440, 7.375, 2.875, 18, 7,
           1416, 584, 7.125, 3.375, 17, 8,
           1360, 720, 6.875, 3.875, 17, 9,
           1280, 856, 6.625, 4.375, 16, 10,
           1280, 856, 6.250, 4.875, 15, 12,
           1192, 976, 5.875, 5.250, 14, 13,
           1088, 1088, 5.500, 5.750, 13, 14,
           976, 1192, 5.000, 6.125, 12, 15,
           976, 1192, 4.500, 6.500, 11, 16,
           856, 1280, 4.000, 6.750, 10, 16,
           720, 1360, 3.500, 7.000, 8, 17,
           584, 1416, 3.000, 7.250, 7, 18,
           584, 1416, 2.500, 7.500, 6, 18,
           440, 1472, 1.875, 7.625, 4, 19,
           296, 1504, 1.375, 7.750, 3, 19,
           152, 1528, 0.750, 7.875, 1, 19,
           152, 1528, 0.125, 7.875, 0, 19,
           -152, 1528, -0.375, 7.875, -1, 19,
           -296, 1504, -1.000, 7.875, -3, 19,
           -296, 1504, -1.625, 7.750, -5, 19,
           -440, 1472, -2.125, 7.625, -6, 19,
           -584, 1416, -2.750, 7.500, -7, 18,
           -720, 1360, -3.250, 7.250, -9, 18,
           -720, 1360, -3.750, 7.000, -10, 17,
           -856, 1280, -4.250, 6.625, -11, 16,
           -976, 1192, -4.750, 6.375, -12, 15,
           -1088, 1088, -5.250, 6.000, -14, 15,
           -1088, 1088, -5.625, 5.625, -15, 14,
           -1192, 976, -6.000, 5.125, -15, 12,
           -1280, 856, -6.375, 4.750, -16, 11,
           -1360, 720, -6.750, 4.250, -17, 10,
           -1360, 720, -7.000, 3.750, -18, 9,
           -1416, 584, -7.250, 3.125, -19, 7,
           -1472, 440, -7.500, 2.625, -19, 6,
           -1504, 296, -7.625, 2.125, -20, 5,
           -1504, 296, -7.875, 1.500, -20, 3,
           -1528, 152, -7.875, 1.000, -20, 2,
           -1536, 0, -8.000, 0.375, -20, 0,
           -1536, 0, -8.000, -0.250, -20, -1,
           -1528, -152, -7.875, -0.750, -20, -2,
           -1528, -152, -7.875, -1.375, -20, -4,
           -1504, -296, -7.750, -2.000, -20, -5,
           -1472, -440, -7.625, -2.500, -20, -7,
           -1416, -584, -7.375, -3.125, -19, -8,
           -1416, -584, -7.125, -3.625, -18, -10,
           -1360, -720, -6.875, -4.125, -18, -11,
           -1280, -856, -6.500, -4.625, -17, -12,
           -1192, -976, -6.125, -5.125, -16, -13,
           -1192, -976, -5.750, -5.500, -15, -14,
           -1088, -1088, -5.375, -5.875, -14, -15,
           -976, -1192, -4.875, -6.250, -13, -16,
           -856, -1280, -4.500, -6.625, -12, -17,
           -856, -1280, -4.000, -7.000, -10, -18,
           -720, -1360, -3.375, -7.250, -9, -19,
           -584, -1416, -2.875, -7.375, -8, -19,
           -440, -1472, -2.375, -7.625, -6, -20,
           -440, -1472, -1.750, -7.750, -5, -20,
           -296, -1504, -1.250, -7.875, -4, -20,
           -152, -1528, -0.625, -8.000, -2, -20,
           0, -1536, 0.000, -8.000, 0, -20,
           152, -1528, 0.500, -8.000, 1, -20,
           296, -1504, 1.125, -7.875, 2, -20,
           440, -1472, 1.750, -7.750, 4, -20,
           440, -1472, 2.250, -7.625, 5, -20,
           584, -1416, 2.875, -7.375, 7, -19,
           720, -1360, 3.375, -7.250, 8, -19,
           856, -1280, 3.875, -7.000, 9, -18,
           856, -1280, 4.375, -6.625, 10, -17,
           976, -1192, 4.875, -6.250, 12, -16,
           1088, -1088, 5.250, -5.875, 13, -15,
           1192, -976, 5.750, -5.500, 14, -14,
           1192, -976, 6.125, -5.125, 15, -13,
           1280, -856, 6.500, -4.625, 16, -12,
           1360, -720, 6.750, -4.125, 16, -11,
           1416, -584, 7.000, -3.625, 17, -10,
           1416, -584, 7.250, -3.125, 18, -8,
           1472, -440, 7.500, -2.500, 18, -7,
           1504, -296, 7.625, -2.000, 19, -5,
           1528, -152, 7.750, -1.375, 19, -4,
           1528, -152, 7.875, -0.750, 19, -2,
           1536, 0, 7.875, -0.250, 19, -1,
           1536, 0, 7.875, 0.375, 19, 0,
           1528, 152, 7.875, 1.000, 19, 2,
           1504, 296, 7.750, 1.500, 19, 3,
           1504, 296, 7.625, 2.125, 19, 5,
           1472, 440, 7.500, 2.625, 18, 6,
           1416, 584, 7.250, 3.125, 18, 7,
           1360, 720, 7.000, 3.750, 17, 9,
           1360, 720, 6.625, 4.250, 16, 10,
           1280, 856, 6.375, 4.750, 15, 11,
           1192, 976, 6.000, 5.125, 15, 12,
           1088, 1088, 5.625, 5.625, 14, 14,
           1088, 1088, 5.125, 6.000, 12, 15,
           976, 1192, 4.750, 6.375, 11, 15,
           856, 1280, 4.250, 6.625, 10, 16,
           720, 1360, 3.750, 7.000, 9, 17,
           720, 1360, 3.125, 7.250, 7, 18,
           584, 1416, 2.625, 7.500, 6, 18,
           440, 1472, 2.125, 7.625, 5, 19,
           296, 1504, 1.500, 7.750, 3, 19,
           296, 1504, 1.000, 7.875, 2, 19,
           152, 1528, 0.375, 7.875, 0, 19,
           -152, 1528, -0.250, 7.875, -1, 19,
           -152, 1528, -0.750, 7.875, -2, 19,
           -296, 1504, -1.375, 7.750, -4, 19,
           -440, 1472, -2.000, 7.625, -5, 19,
           -584, 1416, -2.500, 7.500, -7, 18,
           -584, 1416, -3.125, 7.250, -8, 18,
           -720, 1360, -3.625, 7.000, -10, 17,
           -856, 1280, -4.125, 6.750, -11, 16,
           -976, 1192, -4.625, 6.500, -12, 16,
           -976, 1192, -5.125, 6.125, -13, 15,
           -1088, 1088, -5.500, 5.750, -14, 14,
           -1192, 976, -5.875, 5.250, -15, 13,
           -1280, 856, -6.250, 4.875, -16, 12,
           -1280, 856, -6.625, 4.375, -17, 10,
           -1360, 720, -7.000, 3.875, -18, 9,
           -1416, 584, -7.250, 3.375, -19, 8,
           -1472, 440, -7.375, 2.875, -19, 7,
           -1472, 440, -7.625, 2.250, -20, 5,
           -1504, 296, -7.750, 1.750, -20, 4,
           -1528, 152, -7.875, 1.125, -20, 2,
           -1536, 0, -8.000, 0.500, -20, 1,
           -1536, 0, -8.000, 0.000, -20, 0,
           -1536, 0, -8.000, -0.625, -20, -2,
           -1528, -152, -7.875, -1.250, -20, -4,
           -1504, -296, -7.750, -1.750, -20, -5,
           -1472, -440, -7.625, -2.375, -20, -6,
           -1472, -440, -7.375, -2.875, -19, -8,
           -1416, -584, -7.250, -3.375, -19, -9,
           -1360, -720, -7.000, -4.000, -18, -10,
           -1280, -856, -6.625, -4.500, -17, -12,
           -1280, -856, -6.250, -4.875, -16, -13,
           -1192, -976, -5.875, -5.375, -15, -14,
           -1088, -1088, -5.500, -5.750, -14, -15,
           -976, -1192, -5.125, -6.125, -13, -16,
           -976, -1192, -4.625, -6.500, -12, -17,
           -856, -1280, -4.125, -6.875, -11, -18,
           -720, -1360, -3.625, -7.125, -10, -18,
           -584, -1416, -3.125, -7.375, -8, -19,
           -584, -1416, -2.500, -7.625, -7, -20,
           -440, -1472, -2.000, -7.750, -5, -20,
           -296, -1504, -1.375, -7.875, -4, -20,
           -152, -1528, -0.750, -7.875, -2, -20,
           -152, -1528, -0.250, -8.000, -1, -20,
           152, -1528, 0.375, -8.000, 0, -20,
           296, -1504, 1.000, -7.875, 2, -20,
           296, -1504, 1.500, -7.875, 3, -20,
           440, -1472, 2.125, -7.625, 5, -20,
           584, -1416, 2.625, -7.500, 6, -19,
           720, -1360, 3.125, -7.250, 7, -19,
           720, -1360, 3.750, -7.000, 9, -18,
           856, -1280, 4.250, -6.750, 10, -17,
           976, -1192, 4.750, -6.375, 11, -16,
           1088, -1088, 5.125, -6.000, 12, -15,
           1088, -1088, 5.625, -5.625, 14, -15,
           1192, -976, 6.000, -5.250, 15, -14,
           1280, -856, 6.375, -4.750, 15, -12,
           1360, -720, 6.625, -4.250, 16, -11,
           1360, -720, 7.000, -3.750, 17, -10,
           1416, -584, 7.250, -3.250, 18, -9,
           1472, -440, 7.500, -2.750, 18, -7,
           1504, -296, 7.625, -2.125, 19, -6,
           1504, -296, 7.750, -1.625, 19, -5,
           1528, -152, 7.875, -1.000, 19, -3,
           1536, 0, 7.875, -0.375, 19, -1,
           1536, 0, 7.875, 0.125, 19, 0,
           1528, 152, 7.875, 0.750, 19, 1,
           1528, 152, 7.750, 1.375, 19, 3,
           1504, 296, 7.625, 1.875, 19, 4,
           1472, 440, 7.500, 2.500, 18, 6,
           1416, 584, 7.250, 3.000, 18, 7,
           1416, 584, 7.000, 3.500, 17, 8,
           1360, 720, 6.750, 4.000, 16, 10,
           1280, 856, 6.500, 4.500, 16, 11,
           1192, 976, 6.125, 5.000, 15, 12,
           1192, 976, 5.750, 5.500, 14, 13,
           1088, 1088, 5.250, 5.875, 13, 14,
           976, 1192, 4.875, 6.250, 12, 15,
           856, 1280, 4.375, 6.625, 10, 16,
           856, 1280, 3.875, 6.875, 9, 17,
           720, 1360, 3.375, 7.125, 8, 17,
           584, 1416, 2.875, 7.375, 7, 18,
           440, 1472, 2.250, 7.625, 5, 19,
           440, 1472, 1.750, 7.750, 4, 19,
           296, 1504, 1.125, 7.875, 2, 19,
           152, 1528, 0.500, 7.875, 1, 19,
           0, 1536, 0.000, 7.875, 0, 19,
           -152, 1528, -0.625, 7.875, -2, 19,
           -296, 1504, -1.250, 7.875, -4, 19,
           -440, 1472, -1.750, 7.750, -5, 19,
           -440, 1472, -2.375, 7.625, -6, 19,
           -584, 1416, -2.875, 7.375, -8, 18,
           -720, 1360, -3.375, 7.125, -9, 17,
           -856, 1280, -4.000, 6.875, -10, 17,
           -856, 1280, -4.500, 6.625, -12, 16,
           -976, 1192, -4.875, 6.250, -13, 15,
           -1088, 1088, -5.375, 5.875, -14, 14,
           -1192, 976, -5.750, 5.500, -15, 13,
           -1192, 976, -6.125, 5.000, -16, 12,
           -1280, 856, -6.500, 4.500, -17, 11,
           -1360, 720, -6.875, 4.000, -18, 10,
           -1416, 584, -7.125, 3.500, -18, 8,
           -1416, 584, -7.375, 3.000, -19, 7,
           -1472, 440, -7.625, 2.500, -20, 6,
           -1504, 296, -7.750, 1.875, -20, 4,
           -1528, 152, -7.875, 1.375, -20, 3,
           -1528, 152, -7.875, 0.750, -20, 1,
           -1536, 0, -8.000, 0.125, -20, 0,
           -1536, 0, -8.000, -0.375, -20, -1,
           -1528, -152, -7.875, -1.000, -20, -3,
           -1504, -296, -7.875, -1.625, -20, -5,
           -1504, -296, -7.625, -2.125, -20, -6,
           -1472, -440, -7.500, -2.750, -19, -7,
           -1416, -584, -7.250, -3.250, -19, -9,
           -1360, -720, -7.000, -3.750, -18, -10,
           -1360, -720, -6.750, -4.250, -17, -11,
           -1280, -856, -6.375, -4.750, -16, -12,
           -1192, -976, -6.000, -5.250, -15, -14,
           -1088, -1088, -5.625, -5.625, -15, -15,
           -1088, -1088, -5.250, -6.000, -14, -15,
           -976, -1192, -4.750, -6.375, -12, -16,
           -856, -1280, -4.250, -6.750, -11, -17,
           -720, -1360, -3.750, -7.000, -10, -18,
           -720, -1360, -3.250, -7.250, -9, -19,
           -584, -1416, -2.750, -7.500, -7, -19,
           -440, -1472, -2.125, -7.625, -6, -20,
           -296, -1504, -1.625, -7.875, -5, -20,
           -296, -1504, -1.000, -7.875, -3, -20,
           -152, -1528, -0.375, -8.000, -1, -20,
           152, -1528, 0.125, -8.000, 0, -20,
           152, -1528, 0.750, -7.875, 1, -20,
           296, -1504, 1.375, -7.875, 3, -20,
           440, -1472, 1.875, -7.750, 4, -20,
           584, -1416, 2.500, -7.625, 6, -20,
           584, -1416, 3.000, -7.375, 7, -19,
           720, -1360, 3.500, -7.125, 8, -18,
           856, -1280, 4.000, -6.875, 10, -18,
           976, -1192, 4.500, -6.500, 11, -17,
           976, -1192, 5.000, -6.125, 12, -16,
           1088, -1088, 5.500, -5.750, 13, -15,
           1192, -976, 5.875, -5.375, 14, -14,
           1280, -856, 6.250, -4.875, 15, -13,
           1280, -856, 6.625, -4.500, 16, -12,
           1360, -720, 6.875, -4.000, 17, -10,
           1416, -584, 7.125, -3.375, 17, -9,
           1472, -440, 7.375, -2.875, 18, -8,
           1472, -440, 7.625, -2.375, 19, -6,
           1504, -296, 7.750, -1.750, 19, -5,
           1528, -152, 7.875, -1.250, 19, -4,
           1536, 0, 7.875, -0.625, 19, -2
  };

static int WinkelBytes[256*3]= { 
0,1536,0,
3,1536,0,
6,1536,0,
9,1528,152,
12,1504,296,
15,1472,440,
18,1472,440,
21,1416,584,
24,1360,720,
27,1280,856,
30,1280,856,
33,1192,976,
36,1088,1088,
39,976,1192,
42,976,1192,
45,856,1280,
48,720,1360,
51,584,1416,
54,584,1416,
57,440,1472,
60,296,1504,
63,152,1528,
66,152,1528,
69,-152,1528,
72,-296,1504,
75,-296,1504,
78,-440,1472,
81,-584,1416,
84,-720,1360,
87,-720,1360,
90,-856,1280,
93,-976,1192,
96,-1088,1088,
99,-1088,1088,
102,-1192,976,
105,-1280,856,
108,-1360,720,
111,-1360,720,
114,-1416,584,
117,-1472,440,
120,-1504,296,
123,-1504,296,
126,-1528,152,
-127,-1536,0,
-124,-1536,0,
-121,-1528,-152,
-118,-1528,-152,
-115,-1504,-296,
-112,-1472,-440,
-109,-1416,-584,
-106,-1416,-584,
-103,-1360,-720,
-100,-1280,-856,
-97,-1192,-976,
-94,-1192,-976,
-91,-1088,-1088,
-88,-976,-1192,
-85,-856,-1280,
-82,-856,-1280,
-79,-720,-1360,
-76,-584,-1416,
-73,-440,-1472,
-70,-440,-1472,
-67,-296,-1504,
-64,-152,-1528,
-61,0,-1536,
-58,152,-1528,
-55,296,-1504,
-52,440,-1472,
-49,440,-1472,
-46,584,-1416,
-43,720,-1360,
-40,856,-1280,
-37,856,-1280,
-34,976,-1192,
-31,1088,-1088,
-28,1192,-976,
-25,1192,-976,
-22,1280,-856,
-19,1360,-720,
-16,1416,-584,
-13,1416,-584,
-10,1472,-440,
-7,1504,-296,
-4,1528,-152,
-1,1528,-152,
2,1536,0,
5,1536,0,
8,1528,152,
11,1504,296,
14,1504,296,
17,1472,440,
20,1416,584,
23,1360,720,
26,1360,720,
29,1280,856,
32,1192,976,
35,1088,1088,
38,1088,1088,
41,976,1192,
44,856,1280,
47,720,1360,
50,720,1360,
53,584,1416,
56,440,1472,
59,296,1504,
62,296,1504,
65,152,1528,
68,-152,1528,
71,-152,1528,
74,-296,1504,
77,-440,1472,
80,-584,1416,
83,-584,1416,
86,-720,1360,
89,-856,1280,
92,-976,1192,
95,-976,1192,
98,-1088,1088,
101,-1192,976,
104,-1280,856,
107,-1280,856,
110,-1360,720,
113,-1416,584,
116,-1472,440,
119,-1472,440,
122,-1504,296,
125,-1528,152,
-128,-1536,0,
-125,-1536,0,
-122,-1536,0,
-119,-1528,-152,
-116,-1504,-296,
-113,-1472,-440,
-110,-1472,-440,
-107,-1416,-584,
-104,-1360,-720,
-101,-1280,-856,
-98,-1280,-856,
-95,-1192,-976,
-92,-1088,-1088,
-89,-976,-1192,
-86,-976,-1192,
-83,-856,-1280,
-80,-720,-1360,
-77,-584,-1416,
-74,-584,-1416,
-71,-440,-1472,
-68,-296,-1504,
-65,-152,-1528,
-62,-152,-1528,
-59,152,-1528,
-56,296,-1504,
-53,296,-1504,
-50,440,-1472,
-47,584,-1416,
-44,720,-1360,
-41,720,-1360,
-38,856,-1280,
-35,976,-1192,
-32,1088,-1088,
-29,1088,-1088,
-26,1192,-976,
-23,1280,-856,
-20,1360,-720,
-17,1360,-720,
-14,1416,-584,
-11,1472,-440,
-8,1504,-296,
-5,1504,-296,
-2,1528,-152,
1,1536,0,
4,1536,0,
7,1528,152,
10,1528,152,
13,1504,296,
16,1472,440,
19,1416,584,
22,1416,584,
25,1360,720,
28,1280,856,
31,1192,976,
34,1192,976,
37,1088,1088,
40,976,1192,
43,856,1280,
46,856,1280,
49,720,1360,
52,584,1416,
55,440,1472,
58,440,1472,
61,296,1504,
64,152,1528,
67,0,1536,
70,-152,1528,
73,-296,1504,
76,-440,1472,
79,-440,1472,
82,-584,1416,
85,-720,1360,
88,-856,1280,
91,-856,1280,
94,-976,1192,
97,-1088,1088,
100,-1192,976,
103,-1192,976,
106,-1280,856,
109,-1360,720,
112,-1416,584,
115,-1416,584,
118,-1472,440,
121,-1504,296,
124,-1528,152,
127,-1528,152,
-126,-1536,0,
-123,-1536,0,
-120,-1528,-152,
-117,-1504,-296,
-114,-1504,-296,
-111,-1472,-440,
-108,-1416,-584,
-105,-1360,-720,
-102,-1360,-720,
-99,-1280,-856,
-96,-1192,-976,
-93,-1088,-1088,
-90,-1088,-1088,
-87,-976,-1192,
-84,-856,-1280,
-81,-720,-1360,
-78,-720,-1360,
-75,-584,-1416,
-72,-440,-1472,
-69,-296,-1504,
-66,-296,-1504,
-63,-152,-1528,
-60,152,-1528,
-57,152,-1528,
-54,296,-1504,
-51,440,-1472,
-48,584,-1416,
-45,584,-1416,
-42,720,-1360,
-39,856,-1280,
-36,976,-1192,
-33,976,-1192,
-30,1088,-1088,
-27,1192,-976,
-24,1280,-856,
-21,1280,-856,
-18,1360,-720,
-15,1416,-584,
-12,1472,-440,
-9,1472,-440,
-6,1504,-296,
-3,1528,-152};

static const double TURN_PER_FRAME = 4.21875/180*PI;

static double WinkelListe[256] = {0.0,3.6,8.2,12.7,16.5,21.2,25.2,29.5,33.5,37.8,41.7,46.2,50.8,55.3,59.4,63.4,67.5,71.6,76.1,79.9,84.5,89.1,92.8,97.2,101.8,105.5,110.2,114.1,118.1,122.8,126.7,131.1,135.0,139.4,143.3,147.9,151.9,156.6,160.7,164.5,169.2,172.8,177.3,181.9,185.5,189.9,194.5,198.2,203.0,206.9,211.0,215.4,220.0,223.8,227.5,232.2,235.9,240.3,245.1,248.8,252.7,257.3,261.1,265.6,270.0,273.6,278.2,282.7,286.5,291.2,295.0,299.0,303.5,307.8,311.7,316.2,320.0,324.5,328.6,332.7,336.6,341.6,345.3,349.9,354.5,358.1,2.8,7.2,11.0,15.5,19.3,23.4,28.1,32.8,36.7,40.6,45.0,49.4,53.3,57.2,61.9,66.6,70.7,74.5,79.0,82.8,87.2,91.9,95.5,100.1,104.7,108.4,113.4,117.3,121.4,125.6,130.0,133.8,138.3,142.2,146.5,151.0,155.0,158.8,163.6,167.3,171.8,176.6,180.0,184.4,188.9,192.7,197.3,201.2,205.0,209.7,214.2,217.8,222.5,226.2,230.0,234.6,239.0,243.1,247.0,251.8,255.5,260.1,264.5,268.1,272.7,277.2,280.8,285.5,289.3,293.4,298.1,302.2,306.7,310.6,315.0,318.9,323.3,327.2,331.9,335.9,339.8,344.5,348.2,352.8,357.2,0.9,5.5,10.1,13.9,18.4,22.5,26.6,30.6,34.7,39.2,43.8,48.3,52.2,56.5,60.5,64.7,68.8,73.5,77.3,81.8,86.4,90.0,94.5,98.9,102.7,107.3,111.2,115.3,120.2,124.2,127.8,132.5,136.1,140.8,145.3,149.8,153.9,157.9,161.8,166.3,170.1,174.3,179.1,182.9,187.2,191.5,195.6,200.3,204.1,208.1,212.1,216.6,221.0,225.0,228.9,233.3,237.8,241.9,245.9,249.8,254.5,258.4,262.8,267.3,270.9,275.5,279.9,283.7,288.2,292.1,296.1,300.2,304.7,309.2,313.8,317.5,322.2,325.8,329.8,334.7,338.8,342.7,347.2,351.1,355.5};

typedef std::vector<unsigned char> vWinkelBytes;

static double WinkelByteToAngle(unsigned char cWinkelByte)
{
	cWinkelByte-=0;
	return ((double)(WinkelListe[cWinkelByte])/360.0)*2*PI;
	//return ((double)(cWinkelByte*3)/256.0)*2*PI;
}

static vWinkelBytes GetWinkelBytesByDir(int iDirX, int iDirY)
{
	vWinkelBytes results;
	for (int i=0; i<256; i++)
	{
		if ((WinkelBytes[i*3+1]==iDirX)&&(WinkelBytes[i*3+2]==iDirY))
			results.push_back(WinkelBytes[i*3]);
	}
	return results;
}

static Vector GetClosestShootingDir(Vector vDir)
{
	Vector vResult;
	double min=99999;
	double dDist=0;
	for (int i=0;i<256;i++)
	{
		dDist=(Vector(SHOOTING_DIRECTIONS[i*6+2],SHOOTING_DIRECTIONS[i*6+3])-vDir).GetSqrLength();
		if (dDist<min) 
		{
			min=dDist;
			vResult.Set(SHOOTING_DIRECTIONS[i*6+2],SHOOTING_DIRECTIONS[i*6+3]);
		}
	}
	return vResult;
}

static vWinkelBytes Schnittmenge(vWinkelBytes& _1, vWinkelBytes& _2)
{
	vWinkelBytes results;
	bool found=false;
	// FOR-Schleife fr jedes Element der 1. Menge
	for (unsigned int i=0; i<_1.size(); i++)
	{
		//Suche es in der 2. Menge
		found = false;
		for (unsigned int j=0; j<_2.size(); j++)
		{
			if (_2[j]==_1[i]) found=true; // In 2. Menge gefunden
		}
		//Fge es zu den Ergebnissen hinzu
		if (found) results.push_back(_1[i]);
	}
	return results;
}

#endif /*MYSYNTAX_H*/